/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material.channel;

import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.GLSLVolumeFunction;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.shading.Mandel;
import de.grogra.math.ChannelMap;

public class GLSLMandel
extends GLSLVolumeFunction {
    static final String mandelFuncSig = "float mandel(vec3 pos, float iterations)";
    static final String mandelFunc = "float x = ((pos.x > 0.0) ? pos.x - floor(pos.x) : pos.x + (1.0 + floor(-pos.x)) ) * 4.0 - 2.0;\nfloat y = ((pos.y > 0.0) ? pos.y - floor(pos.y) : pos.y + (1.0 + floor(-pos.y)) ) * 4.0 - 2.0;\nfloat a = x;\nfloat b = y;\nfloat a2 = a * a;\nfloat b2 = b * b;\nfloat dist2;\nfloat i;\nfor (i = 0.0; i < iterations; i+=1.0)\n{\nb = 2.0 * a * b + y;\na = a2 - b2 + x;\na2 = a * a;\nb2 = b * b;\ndist2 = a2 + b2;\nif (dist2 > 4.0)\n{\nbreak;\n}\n}\nreturn (2.0 * i - iterations) / iterations;";

    public Class instanceFor() {
        return Mandel.class;
    }

    public Result generateVolumeData(ChannelMap channelMap, MaterialConfiguration materialConfiguration, GLSLChannelMap gLSLChannelMap, int n) {
        assert (channelMap instanceof Mandel);
        Mandel mandel = (Mandel)channelMap;
        GLSLChannelMap gLSLChannelMap2 = GLSLChannelMap.getGLSLObject(mandel.getInput());
        Result result = gLSLChannelMap2 != null ? gLSLChannelMap2.generate(mandel.getInput(), materialConfiguration, gLSLChannelMap, 20) : gLSLChannelMap.generate(null, materialConfiguration, null, 20);
        int n2 = Math.max(Math.min(mandel.getIterations(), 200), 1);
        materialConfiguration.registerFunc(mandelFuncSig, mandelFunc);
        String string = result.convert(2);
        return new Result("mandel(" + string + "," + (float)n2 + ")", 0);
    }
}

