/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.material;

import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.material.GLSLSphereTracedInput;
import de.grogra.imp3d.glsl.material.GLSLSphereTracedInputParallel;
import de.grogra.imp3d.glsl.material.MaterialConfiguration;
import de.grogra.imp3d.glsl.material.channel.GLSLChannelMap;
import de.grogra.imp3d.glsl.material.channel.Result;
import de.grogra.imp3d.glsl.utility.ShaderConfiguration;
import de.grogra.vecmath.Math2;
import java.util.Iterator;
import javax.media.opengl.GL;

public class SkyMaterialConfiguration
extends MaterialConfiguration {
    boolean isPerspective = true;
    int rpLoc = -1;

    public String[] completeShader(Result[] resultArray) {
        int n;
        String string = "#version " + this.version + "\n";
        string = string + "#extension GL_ARB_texture_rectangle : enable\n";
        for (n = 0; n < this.uniform.size(); ++n) {
            string = string + (String)this.uniform.elementAt(n);
        }
        if (this.uniform.size() > 0) {
            string = string + "\n";
        }
        for (n = 0; n < this.sampler.size(); ++n) {
            string = string + (String)this.sampler.elementAt(n);
        }
        string = string + "uniform sampler2DRect inputTex;\n";
        string = string + "uniform sampler2DRect alphaTex;\n";
        string = string + "\n";
        for (n = 0; n < this.customSampler.size(); ++n) {
            string = string + (String)this.customSampler.elementAt(n);
        }
        string = string + "uniform float powerDensity;\n";
        if (this.customSampler.size() > 0) {
            string = string + "\n";
        }
        string = string + "varying vec2 TexUnit2;\n";
        string = string + "varying vec3 normal;\n";
        string = string + "varying float depth;\n";
        string = string + "varying vec4 pos;\n";
        string = string + "varying vec3 n_pos;\n\n";
        for (n = 0; n < this.constVar.size(); ++n) {
            string = string + (String)this.constVar.elementAt(n);
        }
        if (this.constVar.size() > 0) {
            string = string + "\n";
        }
        Iterator iterator = this.funcMap.values().iterator();
        while (iterator.hasNext()) {
            string = string + (String)iterator.next();
        }
        if (this.funcMap.size() > 0) {
            string = string + "\n";
        }
        string = string + "void main() {\n";
        for (int i = 0; i < this.var.size(); ++i) {
            string = string + " " + (String)this.var.elementAt(i);
        }
        if (this.var.size() > 0) {
            string = string + "\n";
        }
        string = string + resultArray[10] + "\n";
        string = string + " vec4 alpha = texture2DRect(alphaTex, gl_FragCoord.st);\n";
        string = string + " vec4 lastCol = texture2DRect(inputTex, gl_FragCoord.st);\n";
        string = string + " vec3 col = " + resultArray[3].convert(2) + ";\n";
        string = string + " col *= powerDensity;\n";
        string = string + " gl_FragColor = vec4(alpha.rgb, 1.0) * vec4(col, 0.0) + lastCol;\n";
        string = string + "}";
        String[] stringArray = new String[]{string};
        return stringArray;
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, int n) {
        this.bindTextures(gL, gLSLDisplay, n, 2);
        gL.glUniform1f(this.rpLoc, 0.5f * Math2.M_1_2PI * gLSLDisplay.getCurrentGLState().getBgPowerDensity());
    }

    public void setupShader(GL gL, GLSLDisplay gLSLDisplay, int n) {
        int n2 = gL.glGetUniformLocation(n, "inputTex");
        gL.glUniform1i(n2, 0);
        int n3 = gL.glGetUniformLocation(n, "alphaTex");
        gL.glUniform1i(n3, 1);
        this.setupTextures(gL, gLSLDisplay, n, 2);
        this.rpLoc = gL.glGetUniformLocation(n, "powerDensity");
    }

    public GLSLChannelMap getDefaultInputChannel() {
        return this.isPerspective ? new GLSLSphereTracedInput() : new GLSLSphereTracedInputParallel();
    }

    public void set(OpenGLState openGLState, GLSLDisplay gLSLDisplay, Object object) {
        super.set(openGLState, gLSLDisplay, object);
        this.isPerspective = !(gLSLDisplay.getView3D().getCamera().getProjection() instanceof ParallelProjection);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + (this.isPerspective ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SkyMaterialConfiguration skyMaterialConfiguration = (SkyMaterialConfiguration)object;
        return this.isPerspective == skyMaterialConfiguration.isPerspective;
    }

    protected void setThisToOther(ShaderConfiguration shaderConfiguration) {
        super.setThisToOther(shaderConfiguration);
        assert (shaderConfiguration instanceof SkyMaterialConfiguration);
        this.isPerspective = ((SkyMaterialConfiguration)shaderConfiguration).isPerspective;
    }

    public ShaderConfiguration clone() {
        SkyMaterialConfiguration skyMaterialConfiguration = new SkyMaterialConfiguration();
        skyMaterialConfiguration.setThisToOther(this);
        return skyMaterialConfiguration;
    }
}

