/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light.shadow;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.OpenGLState;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.light.shadow.GLSLShadowMap;
import de.grogra.imp3d.objects.PointLight;
import javax.media.opengl.GL;
import javax.vecmath.Matrix4d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLSLShadowCube
extends GLSLShadowMap {
    private static final int DEFAULT_SIZE = 512;

    void getProjectionMatrix(Matrix4d matrix4d, float f, float f2) {
        double d = f - f2;
        matrix4d.setZero();
        matrix4d.m00 = 1.0;
        matrix4d.m11 = 1.0;
        matrix4d.m22 = (double)(f2 + f) / d;
        matrix4d.m32 = -1.0;
        matrix4d.m23 = (double)(2.0f * (f * f2)) / d;
    }

    @Override
    public boolean create(GL gL) {
        return this.create(gL, 512, 512);
    }

    @Override
    public boolean create(GL gL, int n, int n2) {
        if (this.index != 0) {
            if (this.width == n && this.height == n2) {
                return true;
            }
            this.delete(gL, false);
        }
        int[] nArray = new int[1];
        gL.glGenTextures(1, nArray, 0);
        this.index = nArray[0];
        gL.glBindTexture(34067, this.index);
        for (int i = 0; i < 6; ++i) {
            gL.glTexImage2D(34069 + i, 0, 33190, n, n2, 0, 6402, 5121, null);
        }
        gL.glTexParameterf(34067, 10242, 33071.0f);
        gL.glTexParameterf(34067, 10243, 33071.0f);
        gL.glTexParameteri(34067, 32882, 33071);
        gL.glTexParameteri(34067, 10240, 9729);
        gL.glTexParameteri(34067, 10241, 9729);
        this.type = 5121;
        this.width = n;
        this.height = n2;
        this.type = 6402;
        this.internalFormat = 6402;
        this.texType = 34067;
        return gL.glGetError() != 0;
    }

    @Override
    public void fill(GLSLDisplay gLSLDisplay, OpenGLState openGLState) {
        int n = gLSLDisplay.getView().getGraph().getStamp();
        if (n == this.GRAPH_STAMP) {
            return;
        }
        if (!this.invalid) {
            return;
        }
        GL gL = openGLState.getGL();
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        this.getProjectionMatrix(this.ViewToClip, 0.01f, 2000.0f);
        openGLState.loadMatrixd(this.getViewToClip());
        gL.glMatrixMode(5888);
        gL.glPolygonOffset(1.1f, 4.0f);
        gL.glEnable(32823);
        for (int i = 0; i < 6; ++i) {
            Matrix4d matrix4d = this.getLightToView(i);
            gL.glFramebufferTexture2DEXT(36160, 36096, 34069 + i, this.getIndex(), 0);
            gL.glClear(256);
            this.renderCachedScene(gLSLDisplay, openGLState, matrix4d);
        }
        this.GRAPH_STAMP = n;
        gL.glPolygonOffset(0.0f, 0.0f);
        gL.glDisable(32823);
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
    }

    @Override
    public Matrix4d getLightToView() {
        Matrix4d matrix4d = new Matrix4d(this.LightTransf);
        matrix4d.m00 = 1.0;
        matrix4d.m01 = 0.0;
        matrix4d.m02 = 0.0;
        matrix4d.m10 = 0.0;
        matrix4d.m11 = -1.0;
        matrix4d.m12 = 0.0;
        matrix4d.m20 = 0.0;
        matrix4d.m21 = 0.0;
        matrix4d.m22 = -1.0;
        matrix4d.m30 *= 1.0;
        matrix4d.m31 *= -1.0;
        matrix4d.m32 *= -1.0;
        matrix4d.invert();
        return matrix4d;
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public GLSLShadowMap getInstance() {
        return new GLSLShadowCube();
    }

    @Override
    public void setupTextureMatrices(OpenGLState openGLState, Matrix4d matrix4d, LightPos lightPos) {
        GL gL = openGLState.getGL();
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setIdentity();
        matrix4d2.mul(this.getLightToView());
        matrix4d2.mul(matrix4d);
        gL.glActiveTexture(33991);
        gL.glBindTexture(34067, this.getIndex());
        gL.glMatrixMode(5890);
        gL.glActiveTexture(33986);
        openGLState.loadMatrixd(matrix4d2);
        gL.glMatrixMode(5888);
    }

    @Override
    public Class<?> getDefaultLightType() {
        return PointLight.class;
    }
}

