/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl.light;

import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.glsl.light.GLSLLightShader;
import de.grogra.imp3d.glsl.light.LightPos;
import de.grogra.imp3d.glsl.utility.GLSLShader;
import de.grogra.imp3d.objects.Sky;
import de.grogra.imp3d.shading.Light;
import de.grogra.vecmath.Math2;
import javax.media.opengl.GL;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;

public class GLSLSkyReflectionLight
extends GLSLLightShader {
    static final String LightPrologue = "void SkyReflect(in vec3 normal,\nin vec3 ecPosition3,\nin float shininess,\nin float radientPower,\nin float diffuseRadientPower,\ninout vec3 diffuse,\ninout vec3 specular)";
    static final String LightPerspective = " vec3 reflVec = normalize((gl_TextureMatrix[2] * vec4(reflect(ecPosition3, normal), 1.0))).xyz;\n";
    static final String LightParallel = " vec3 reflVec = normalize((gl_TextureMatrix[2] * vec4(reflect(vec3(0.0, 0.0, ecPosition3.z), normal), 1.0))).xyz;\n";
    protected String radientPower;
    protected String diffuseRadientPower;
    protected String skyCube;
    protected String skyDiffCube;
    protected String invNormalMat;
    Matrix3f invNormal = new Matrix3f();
    int rpLoc = -1;
    int drpLoc = -1;
    int invMatLoc = -1;

    public String getLightFunction() {
        String string = " vec3 normal = getEyeNormal(norm);\n SkyReflect(normal, pos, shininess, " + this.radientPower + ", " + this.diffuseRadientPower + ", " + "diff, spec);";
        return string;
    }

    public String[] getFragmentShader(Object object) {
        this.config.clearTmpVariables();
        this.radientPower = this.config.registerNewUniform(0);
        this.diffuseRadientPower = this.config.registerNewUniform(0);
        this.skyCube = this.config.registerNewUniform(8);
        this.skyDiffCube = this.config.registerNewUniform(8);
        this.invNormalMat = this.config.registerNewUniform(9);
        this.config.registerFunc("vec3 getEyeNormal(vec2 encNorm)", " encNorm = encNorm*4.0-2.0;\n float f = dot(encNorm,encNorm);\n float g = sqrt(1.0-f*0.25);\n return vec3(encNorm*g,1.0-f*0.5);\n");
        String string = " vec3 world_Normal = " + this.invNormalMat + " * normal;\n" + " vec3 sampler = textureCube(" + this.skyCube + ", reflVec).rgb;\n" + " vec3 samplerDiff = textureCube(" + this.skyDiffCube + ", world_Normal).rgb;\n" + " diffuse  += samplerDiff * diffuseRadientPower;\n" + " specular += sampler * radientPower;\n";
        this.config.registerFunc(LightPrologue, (this.getLightShaderConfig().isPerspective() ? LightPerspective : LightParallel) + string);
        return this.getLightShaderConfig().completeShader(this.getLightFunction());
    }

    public boolean needsRecompilation(Object object) {
        return false;
    }

    public Class instanceFor() {
        return Sky.class;
    }

    protected void setupShader(GL gL, GLSLDisplay gLSLDisplay, Object object) {
        super.setupShader(gL, gLSLDisplay, object);
        int n = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.skyCube);
        gL.glUniform1i(n, 6);
        n = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.skyDiffCube);
        gL.glUniform1i(n, 7);
        this.rpLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.radientPower);
        this.drpLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.diffuseRadientPower);
        this.invMatLoc = gL.glGetUniformLocation(this.getShaderProgramNumber(), this.invNormalMat);
    }

    public void setupDynamicUniforms(GL gL, GLSLDisplay gLSLDisplay, Object object, int n) {
        super.setupDynamicUniforms(gL, gLSLDisplay, object, n);
        assert (object instanceof LightPos);
        LightPos lightPos = (LightPos)object;
        assert (lightPos.getLight() instanceof Sky);
        Sky sky = (Sky)lightPos.getLight();
        float f = 0.5f * Math2.M_1_2PI * gLSLDisplay.getCurrentGLState().getBgPowerDensity();
        gL.glUniform1f(this.rpLoc, f);
        f = sky.getShader() instanceof Light ? (f *= 6.768234f) : (float)((double)f * 2.0);
        gL.glUniform1f(this.drpLoc, f);
        Matrix4d matrix4d = gLSLDisplay.getCurrentGLState().getWorldToView();
        matrix4d.getRotationScale(this.invNormal);
        this.invNormal.invert();
        gL.glUniformMatrix3fv(this.invMatLoc, 1, false, gLSLDisplay.getCurrentGLState().toGLMatrix3f(this.invNormal), 0);
    }

    public GLSLShader getInstance() {
        return new GLSLSkyReflectionLight();
    }
}

