/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.glsl;

import de.grogra.graph.GraphState;
import de.grogra.imp3d.PolygonArray;
import de.grogra.imp3d.Polygonizable;
import de.grogra.imp3d.PolygonizationCache;
import de.grogra.imp3d.RenderState;
import de.grogra.imp3d.glsl.GLDisplay;
import de.grogra.imp3d.glsl.GLSLDisplay;
import de.grogra.imp3d.shading.Shader;
import de.grogra.math.Pool;
import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.Cone;
import de.grogra.vecmath.geom.Cube;
import de.grogra.vecmath.geom.Cylinder;
import de.grogra.vecmath.geom.Frustum;
import de.grogra.vecmath.geom.Sphere;
import de.grogra.vecmath.geom.Square;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4d;

public class GLSLVolumeBuilder
implements RenderState {
    private GLDisplay disp = null;
    private final Vector3d minPoint = new Vector3d();
    private final Vector3d maxPoint = new Vector3d();
    private final Matrix4d mat = new Matrix4d();
    private final Matrix3d rot = new Matrix3d();
    private final Matrix3d rotInv = new Matrix3d();
    private final Vector3d trans = new Vector3d();
    boolean needUpdate = true;
    private int cur_Stamp = -1;
    private int old_Stamp = -2;
    private boolean radiusUpToDate = false;
    private double cachedRadius = 0.0;
    private boolean centerUpToDate = false;
    private Vector3d cachedCenter = new Vector3d();
    private final Vector3d tmpVec1 = new Vector3d();
    private final Vector3d tmpVec2 = new Vector3d();
    private final Vector3d radiusVec = new Vector3d();
    private final Vector4d tmpVec4 = new Vector4d();
    Variables tmp = new Variables();
    TransformableVolume vol;
    private final Matrix4d squareXform = new Matrix4d();
    private final Matrix4d frustumXform = new Matrix4d();
    private final float epsilon = 1.0E-5f;
    float radius = -1.0f;
    private boolean needData = true;

    private void setInvTransformation(Matrix4d matrix4d, double d) {
        matrix4d.getRotationScale(this.rot);
        this.rotInv.invert(this.rot);
        matrix4d.get(this.trans);
        this.trans.x += d * matrix4d.m02;
        this.trans.y += d * matrix4d.m12;
        this.trans.z += d * matrix4d.m22;
    }

    private boolean needUpdate() {
        return this.old_Stamp != this.cur_Stamp;
    }

    public void finish() {
        this.needData = false;
    }

    public void initSceneExtent(GLDisplay gLDisplay) {
        if (this.disp == null) {
            this.disp = gLDisplay;
        }
        this.old_Stamp = this.cur_Stamp;
        this.cur_Stamp = gLDisplay.getView().getGraph().getStamp();
        if (!this.needUpdate()) {
            GLSLDisplay.printDebugInfoN("Szene extend will not be updated!");
            return;
        }
        this.needData = true;
        GLSLDisplay.printDebugInfoN("Szene extend will be updated!");
        this.minPoint.set(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.maxPoint.set(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
        this.radiusUpToDate = false;
        this.centerUpToDate = false;
        this.vol = null;
    }

    public double getRadius() {
        if (!this.radiusUpToDate) {
            this.tmpVec1.sub((Tuple3d)this.maxPoint, (Tuple3d)this.minPoint);
            this.cachedRadius = this.tmpVec1.length() * 0.5;
            this.radiusUpToDate = true;
        }
        return this.cachedRadius;
    }

    public Vector3d getCenter() {
        if (!this.centerUpToDate) {
            this.tmpVec1.add((Tuple3d)this.minPoint, (Tuple3d)this.maxPoint);
            this.tmpVec1.scale(0.5);
            this.tmpVec4.set((Tuple3d)this.tmpVec1);
            this.tmpVec4.w = 1.0;
            this.mat.invert(this.disp.getView3D().getCamera().getWorldToViewTransformation());
            this.mat.transform((Tuple4d)this.tmpVec4);
            this.cachedCenter.set(this.tmpVec4.x, this.tmpVec4.y, this.tmpVec4.z);
            this.centerUpToDate = true;
        }
        return this.cachedCenter;
    }

    private void updateMin(Vector3d vector3d) {
        this.minPoint.x = Math.min(this.minPoint.x, vector3d.x);
        this.minPoint.y = Math.min(this.minPoint.y, vector3d.y);
        this.minPoint.z = Math.min(this.minPoint.z, vector3d.z);
    }

    private void updateMax(Vector3d vector3d) {
        this.maxPoint.x = Math.max(this.maxPoint.x, vector3d.x);
        this.maxPoint.y = Math.max(this.maxPoint.y, vector3d.y);
        this.maxPoint.z = Math.max(this.maxPoint.z, vector3d.z);
    }

    public void drawParallelogram(float f, Vector3f vector3f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.disp.getTransformation(matrix4d);
        this.squareXform.m03 = -vector3f.x;
        this.squareXform.m13 = -vector3f.y;
        this.squareXform.m23 = -vector3f.z;
        this.squareXform.m33 = 1.0;
        this.squareXform.m00 = vector3f.x * 2.0f;
        this.squareXform.m10 = vector3f.y * 2.0f;
        this.squareXform.m20 = vector3f.z * 2.0f;
        this.squareXform.m01 = 0.0;
        this.squareXform.m11 = 0.0;
        this.squareXform.m21 = f;
        if (Math.abs(vector3f.x) < Math.abs(vector3f.y)) {
            this.squareXform.m02 = 1.0;
            this.squareXform.m12 = 0.0;
            this.squareXform.m22 = 0.0;
        } else {
            this.squareXform.m02 = 0.0;
            this.squareXform.m12 = 1.0;
            this.squareXform.m22 = 0.0;
        }
        Math2.mulAffine((Matrix4d)this.squareXform, (Matrix4d)matrix4d, (Matrix4d)this.squareXform);
        this.setInvTransformation(this.squareXform, 0.0);
        Square square = new Square();
        square.setTransformation(this.rotInv, (Tuple3d)this.trans);
        this.vol = square;
        this.vol.getExtent((Tuple3d)this.tmpVec1, (Tuple3d)this.tmpVec2, this.tmp);
        this.setRadius(this.tmpVec1, this.tmpVec2);
        this.updateMin(this.tmpVec1);
        this.updateMax(this.tmpVec2);
    }

    public void drawSphere(float f, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.disp.getTransformation(matrix4d);
        this.setInvTransformation(matrix4d, 0.0);
        Sphere sphere = new Sphere();
        sphere.setTransformation(this.rotInv, (Tuple3d)this.trans);
        f = 1.0f / f;
        sphere.scale((double)f, (double)f, (double)f);
        this.vol = sphere;
        this.vol.getExtent((Tuple3d)this.tmpVec1, (Tuple3d)this.tmpVec2, this.tmp);
        this.setRadius(this.tmpVec1, this.tmpVec2);
        this.updateMin(this.tmpVec1);
        this.updateMax(this.tmpVec2);
    }

    public void drawSupershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Shader shader, int n, Matrix4d matrix4d) {
    }

    public void drawBox(float f, float f2, float f3, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.disp.getTransformation(matrix4d);
        this.setInvTransformation(matrix4d, 0.0);
        Cube cube = new Cube();
        cube.setTransformation(this.rotInv, (Tuple3d)this.trans);
        cube.scale((double)(1.0f / f), (double)(1.0f / f2), (double)(2.0f / f3));
        this.vol = cube;
        this.vol.getExtent((Tuple3d)this.tmpVec1, (Tuple3d)this.tmpVec2, this.tmp);
        this.setRadius(this.tmpVec1, this.tmpVec2);
        this.updateMin(this.tmpVec1);
        this.updateMax(this.tmpVec2);
    }

    public void drawFrustum(float f, float f2, float f3, boolean bl, boolean bl2, float f4, Shader shader, int n, Matrix4d matrix4d) {
        boolean bl3;
        if (f2 < 0.0f) {
            f2 = -f2;
        }
        if (f3 < 0.0f) {
            f3 = -f3;
        }
        if (Math.abs(f) < 1.0E-5f || f2 + f3 < 1.0E-5f) {
            return;
        }
        matrix4d = this.disp.getTransformation(matrix4d);
        boolean bl4 = bl3 = f2 < 0.999f * f3;
        if (bl3) {
            this.frustumXform.setIdentity();
            this.frustumXform.m22 = -1.0;
            this.frustumXform.m11 = -1.0;
            this.frustumXform.m23 = f;
            this.frustumXform.mul(matrix4d, this.frustumXform);
            matrix4d = this.frustumXform;
            float f5 = f2;
            f2 = f3;
            f3 = f5;
            boolean bl5 = bl;
            bl = bl2;
            bl2 = bl5;
        }
        if (f3 < 0.001f * f2) {
            this.setInvTransformation(matrix4d, f);
            Cone cone = new Cone();
            cone.setTransformation(this.rotInv, (Tuple3d)this.trans);
            cone.base = 1.0;
            cone.scale((double)(1.0f / f2), (double)(-1.0f / f2), (double)(-1.0f / f));
            cone.baseOpen = !bl;
            cone.rotateUV = bl3;
            cone.scaleV = f4;
            this.vol = cone;
        } else if (f3 < 0.999f * f2) {
            Frustum frustum = new Frustum();
            frustum.base = f2 / f3;
            this.setInvTransformation(matrix4d, (double)f * frustum.base / (frustum.base - 1.0));
            frustum.setTransformation(this.rotInv, (Tuple3d)this.trans);
            frustum.scale((double)(1.0f / f3), (double)(-1.0f / f3), (1.0 - frustum.base) / (double)f);
            frustum.baseOpen = !bl;
            frustum.topOpen = !bl2;
            frustum.rotateUV = bl3;
            frustum.scaleV = f4;
            this.vol = frustum;
        } else {
            this.setInvTransformation(matrix4d, f / 2.0f);
            Cylinder cylinder = new Cylinder();
            cylinder.setTransformation(this.rotInv, (Tuple3d)this.trans);
            cylinder.scale((double)(1.0f / f2), (double)(1.0f / f2), (double)(2.0f / f));
            cylinder.baseOpen = !bl;
            cylinder.topOpen = !bl2;
            cylinder.scaleV = f4;
            this.vol = cylinder;
        }
        this.vol.getExtent((Tuple3d)this.tmpVec1, (Tuple3d)this.tmpVec2, this.tmp);
        this.setRadius(this.tmpVec1, this.tmpVec2);
        this.updateMin(this.tmpVec1);
        this.updateMax(this.tmpVec2);
    }

    public void drawPolygons(Polygonizable polygonizable, Object object, boolean bl, Shader shader, int n, Matrix4d matrix4d) {
        matrix4d = this.disp.getTransformation(matrix4d);
        this.setInvTransformation(matrix4d, 0.0);
        if (this.disp.polyCache != null && this.disp.polyCache.getGraphState() != this.getRenderGraphState()) {
            this.disp.polyCache.clear();
            this.disp.polyCache = null;
        }
        if (this.disp.polyCache == null) {
            this.disp.polyCache = new PolygonizationCache(this.getRenderGraphState(), 3, 10.0f, true);
        }
        PolygonArray polygonArray = this.disp.polyCache.get(object, bl, polygonizable);
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        vector3d2.z = Double.POSITIVE_INFINITY;
        vector3d2.y = Double.POSITIVE_INFINITY;
        vector3d2.x = Double.POSITIVE_INFINITY;
        vector3d3.z = Double.NEGATIVE_INFINITY;
        vector3d3.y = Double.NEGATIVE_INFINITY;
        vector3d3.x = Double.NEGATIVE_INFINITY;
        for (int i = polygonArray.getVertexCount() - 1; i >= 0; --i) {
            polygonArray.getVertex(i, (Tuple3d)vector3d);
            this.rot.transform((Tuple3d)vector3d);
            this.tmpVec1.add((Tuple3d)this.trans, (Tuple3d)vector3d);
            Math2.min((Tuple3d)vector3d2, (Tuple3d)this.tmpVec1);
            Math2.max((Tuple3d)vector3d3, (Tuple3d)this.tmpVec1);
        }
        this.vol = null;
        this.setRadius(vector3d2, vector3d3);
        this.updateMin(vector3d2);
        this.updateMax(vector3d3);
    }

    public boolean needsData() {
        return this.needData;
    }

    private void setRadius(Vector3d vector3d, Vector3d vector3d2) {
        this.radiusVec.sub((Tuple3d)this.maxPoint, (Tuple3d)this.minPoint);
        this.radiusVec.scale(0.5);
        this.radius = (float)this.radiusVec.length();
    }

    public float getCurrentRadius() {
        return this.radius;
    }

    public TransformableVolume getCurrentVolume() {
        TransformableVolume transformableVolume = this.vol;
        this.vol = null;
        this.radius = -1.0f;
        return transformableVolume;
    }

    public void drawLine(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3, int n, Matrix4d matrix4d) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public void drawPlane(Shader shader, int n, Matrix4d matrix4d) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public void drawPoint(Tuple3f tuple3f, int n, Tuple3f tuple3f2, int n2, Matrix4d matrix4d) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public void drawPointCloud(float[] fArray, float f, Tuple3f tuple3f, int n, Matrix4d matrix4d) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public void drawRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public void drawString(int n, int n2, String string, Font font, Tuple3f tuple3f) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public float estimateScaleAt(Tuple3f tuple3f) {
        return this.disp.estimateScaleAt(tuple3f);
    }

    public void fillRectangle(int n, int n2, int n3, int n4, Tuple3f tuple3f) {
        this.vol = null;
        this.radius = -1.0f;
    }

    public int getCurrentHighlight() {
        return this.disp.getCurrentHighlight();
    }

    public Shader getCurrentShader() {
        return this.disp.getCurrentShader();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.disp.getFontMetrics(font);
    }

    public Pool getPool() {
        return this.disp.getPool();
    }

    public GraphState getRenderGraphState() {
        return this.disp.getRenderGraphState();
    }

    public boolean getWindowPos(Tuple3f tuple3f, Tuple2f tuple2f) {
        return this.disp.getWindowPos(tuple3f, tuple2f);
    }
}

