/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20ResourceShader;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragment;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragmentBlend;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragmentGraytone;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragmentRGBColor;
import de.grogra.imp3d.gl20.GL20ResourceShaderPhong;
import de.grogra.imp3d.gl20.GL20ResourceShaderRGBA;
import de.grogra.imp3d.shading.ChannelBlend;
import de.grogra.imp3d.shading.ChannelMapNode;
import de.grogra.imp3d.shading.Material;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SwitchShader;
import de.grogra.math.ChannelMap;
import de.grogra.math.ColorMap;
import de.grogra.math.Graytone;
import de.grogra.math.RGBColor;
import java.util.Stack;

public class GL20ShaderServer {
    private static GL20ShaderServer singleton = null;
    private Stack<GL20ResourceShader> shaderStack = new Stack();
    private Stack<GL20ResourceShaderFragment> fragmentStack = new Stack();

    private GL20ShaderServer() {
        if (singleton == null) {
            singleton = this;
        }
    }

    public static GL20ResourceShader getShader(Shader shader) {
        int n;
        if (singleton == null) {
            new GL20ShaderServer();
        }
        GL20ResourceShader gL20ResourceShader = null;
        int n2 = GL20ShaderServer.singleton.shaderStack.size();
        for (n = 0; n < n2 && ((GL20ResourceShader)GL20ShaderServer.singleton.shaderStack.get(n)).getShader() != shader; ++n) {
        }
        if (n >= n2) {
            GL20ResourceShader gL20ResourceShader2 = null;
            if (shader instanceof Material) {
                if (shader instanceof Phong) {
                    gL20ResourceShader2 = new GL20ResourceShaderPhong();
                }
            } else if (shader instanceof RGBAShader) {
                gL20ResourceShader2 = new GL20ResourceShaderRGBA();
            } else if (shader instanceof SwitchShader) {
                // empty if block
            }
            if (gL20ResourceShader2 != null) {
                gL20ResourceShader2.setShader(shader);
                gL20ResourceShader2.update();
                gL20ResourceShader = gL20ResourceShader2;
                GL20ShaderServer.singleton.shaderStack.add(gL20ResourceShader2);
            }
        } else {
            gL20ResourceShader = (GL20ResourceShader)GL20ShaderServer.singleton.shaderStack.get(n);
        }
        return gL20ResourceShader;
    }

    public static GL20ResourceShaderFragment getShaderFragment(ChannelMap channelMap) {
        int n;
        if (channelMap == null) {
            return null;
        }
        if (singleton == null) {
            new GL20ShaderServer();
        }
        GL20ResourceShaderFragment gL20ResourceShaderFragment = null;
        int n2 = GL20ShaderServer.singleton.fragmentStack.size();
        for (n = 0; n < n2 && ((GL20ResourceShaderFragment)GL20ShaderServer.singleton.fragmentStack.get(n)).getChannelMap() != channelMap; ++n) {
        }
        if (n >= n2) {
            GL20ResourceShaderFragment gL20ResourceShaderFragment2 = null;
            if (channelMap instanceof ColorMap) {
                if (channelMap instanceof Graytone) {
                    gL20ResourceShaderFragment2 = new GL20ResourceShaderFragmentGraytone();
                } else if (channelMap instanceof RGBColor) {
                    gL20ResourceShaderFragment2 = new GL20ResourceShaderFragmentRGBColor();
                }
            } else if (channelMap instanceof ChannelMapNode && channelMap instanceof ChannelBlend) {
                gL20ResourceShaderFragment2 = new GL20ResourceShaderFragmentBlend();
            }
            if (gL20ResourceShaderFragment2 != null) {
                gL20ResourceShaderFragment2.setChannelMap(channelMap);
                gL20ResourceShaderFragment2.update();
                gL20ResourceShaderFragment = gL20ResourceShaderFragment2;
                GL20ShaderServer.singleton.fragmentStack.add(gL20ResourceShaderFragment2);
            }
        } else {
            gL20ResourceShaderFragment = (GL20ResourceShaderFragment)GL20ShaderServer.singleton.fragmentStack.get(n);
        }
        return gL20ResourceShaderFragment;
    }

    public static void removeShader(GL20ResourceShader gL20ResourceShader) {
        if (singleton != null && gL20ResourceShader != null) {
            int n;
            int n2 = GL20ShaderServer.singleton.shaderStack.size();
            for (n = 0; n < n2 && GL20ShaderServer.singleton.shaderStack.get(n) != gL20ResourceShader; ++n) {
            }
            if (n < n2) {
                GL20ShaderServer.singleton.shaderStack.remove(n);
            }
        }
    }
}

