/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20GLSLCode;
import de.grogra.imp3d.gl20.GL20ResourceShader;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.imp3d.shading.Shader;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;

public class GL20ResourceShaderRGBA
extends GL20ResourceShader {
    private static final int COLOR = 1;
    private int changeMask = -1;
    private Vector4f color = new Vector4f();

    public GL20ResourceShaderRGBA() {
        super(262146);
        this.color.set(0.5f, 0.5f, 0.5f, 1.0f);
    }

    public GL20ResourceShaderRGBA(float f, float f2, float f3) {
        super(262146);
        this.color.set(f, f2, f3, 1.0f);
    }

    public int getEnvironmentDependencies() {
        return this.color.w < 1.0f ? 1 : 0;
    }

    public boolean setShader(Shader shader) {
        boolean bl = false;
        if (shader instanceof RGBAShader) {
            RGBAShader rGBAShader = (RGBAShader)shader;
            this.setColor(new Vector4f(rGBAShader.x, rGBAShader.y, rGBAShader.z, rGBAShader.w));
            bl = super.setShader(shader);
        }
        return bl;
    }

    public void setColor(Vector4f vector4f) {
        if (!this.color.equals((Tuple4f)vector4f)) {
            this.color.set((Tuple4f)vector4f);
            this.changeMask |= 1;
        }
    }

    public Vector4f getColor() {
        return this.color;
    }

    public int getScalarFromShader(GL20GLSLCode gL20GLSLCode, int n) {
        int n2 = -1;
        if (n < 8 || n > 14) {
            int n3 = -1;
            switch (n & 3) {
                case 0: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.x);
                    break;
                }
                case 1: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.y);
                    break;
                }
                case 2: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.z);
                    break;
                }
                case 3: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.w);
                }
            }
            n2 = n3 | 0x8000;
        }
        return n2;
    }

    public int getVector3FromShader(GL20GLSLCode gL20GLSLCode, int n) {
        int n2 = -1;
        if ((n + 2 < 8 || n > 14) && (n2 = gL20GLSLCode.allocateTemporaryVector3()) != -1) {
            String string = new String(gL20GLSLCode.getTemporaryVector3Name(n2) + " = vec3(");
            for (int i = 0; i < 3; ++i) {
                switch (n + i & 3) {
                    case 0: {
                        string = string + Float.valueOf(this.color.x).toString();
                        break;
                    }
                    case 1: {
                        string = string + Float.valueOf(this.color.y).toString();
                        break;
                    }
                    case 2: {
                        string = string + Float.valueOf(this.color.z).toString();
                        break;
                    }
                    case 3: {
                        string = string + Float.valueOf(this.color.w).toString();
                    }
                }
                string = i < 2 ? string + "," : string + ");\n";
            }
            gL20GLSLCode.appendCode(string);
        }
        return n2;
    }

    public int getVector4FromShader(GL20GLSLCode gL20GLSLCode, int n) {
        int n2 = -1;
        if ((n + 3 < 8 || n > 14) && (n2 = gL20GLSLCode.allocateTemporaryVector4()) != -1) {
            String string = new String(gL20GLSLCode.getTemporaryVector4Name(n2) + " = vec4(");
            for (int i = 0; i < 4; ++i) {
                switch (n + i & 3) {
                    case 0: {
                        string = string + Float.valueOf(this.color.x).toString();
                        break;
                    }
                    case 1: {
                        string = string + Float.valueOf(this.color.y).toString();
                        break;
                    }
                    case 2: {
                        string = string + Float.valueOf(this.color.z).toString();
                        break;
                    }
                    case 3: {
                        string = string + Float.valueOf(this.color.w).toString();
                    }
                }
                string = i < 3 ? string + "," : string + ");\n";
            }
            gL20GLSLCode.appendCode(string);
        }
        return n2;
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        RGBAShader rGBAShader = (RGBAShader)this.getShader();
        this.setColor(new Vector4f(rGBAShader.x, rGBAShader.y, rGBAShader.z, rGBAShader.w));
        if (this.changeMask != 0) {
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        super.destroy();
    }
}

