/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20GLSLCode;
import de.grogra.imp3d.gl20.GL20ResourceShader;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragment;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragmentGraytone;
import de.grogra.imp3d.gl20.GL20ShaderServer;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.Shader;

public class GL20ResourceShaderPhong
extends GL20ResourceShader {
    private static final int DIFFUSE_MAP = 1;
    private static final int SPECULAR_MAP = 2;
    private static final int TRANSPARENCY_MAP = 4;
    private static final int TRANSPARENCY_SHININESS_MAP = 8;
    private static final int TRANSPARENCY_DIFFUSE_MAP = 16;
    private static final int AMBIENT_MAP = 32;
    private static final int EMISSIVE_MAP = 64;
    private static final int SHININESS_MAP = 128;
    private int changeMask = -1;
    GL20ResourceShaderFragment diffuseMap = null;
    GL20ResourceShaderFragment specularMap = null;
    GL20ResourceShaderFragment transparencyMap = null;
    GL20ResourceShaderFragment transparencyShininessMap = null;
    GL20ResourceShaderFragment transparencyDiffuseMap = null;
    GL20ResourceShaderFragment ambientMap = null;
    GL20ResourceShaderFragment emissiveMap = null;
    GL20ResourceShaderFragment shininessMap = null;
    private static GL20ResourceShaderFragment DEFAULT_DIFFUSE_MAP = new GL20ResourceShaderFragmentGraytone(0.5f);
    private static GL20ResourceShaderFragment DEFAULT_SPECULAR_MAP = new GL20ResourceShaderFragmentGraytone(0.0f);
    private static GL20ResourceShaderFragment DEFAULT_TRANSPARENCY_MAP = new GL20ResourceShaderFragmentGraytone(0.0f);
    private static GL20ResourceShaderFragment DEFAULT_TRANSPARENCY_SHININESS_MAP = new GL20ResourceShaderFragmentGraytone(0.0f);
    private static GL20ResourceShaderFragment DEFAULT_TRANSPARENCY_DIFFUSE_MAP = new GL20ResourceShaderFragmentGraytone(0.0f);
    private static GL20ResourceShaderFragment DEFAULT_AMBIENT_MAP = new GL20ResourceShaderFragmentGraytone(0.0f);
    private static GL20ResourceShaderFragment DEFAULT_EMISSIVE_MAP = new GL20ResourceShaderFragmentGraytone(0.0f);
    private static GL20ResourceShaderFragment DEFAULT_SHININESS_MAP = new GL20ResourceShaderFragmentGraytone(0.5f);

    public GL20ResourceShaderPhong() {
        super(262145);
    }

    public boolean fragmentAffectOnAlpha() {
        boolean bl = false;
        if (this.getDiffuseMap().fragmentAffectOnAlpha()) {
            bl = true;
        } else if (this.getTransparencyMap().fragmentAffectOnAlpha()) {
            bl = true;
        }
        return bl;
    }

    public boolean setShader(Shader shader) {
        boolean bl = false;
        if (shader instanceof Phong) {
            Phong phong = (Phong)shader;
            this.setDiffuseMap(GL20ShaderServer.getShaderFragment(phong.getDiffuse()));
            this.setSpecularMap(GL20ShaderServer.getShaderFragment(phong.getSpecular()));
            this.setTransparencyMap(GL20ShaderServer.getShaderFragment(phong.getTransparency()));
            this.setTransparencyShininessMap(GL20ShaderServer.getShaderFragment(phong.getTransparencyShininess()));
            this.setTransparencyDiffuseMap(GL20ShaderServer.getShaderFragment(phong.getDiffuseTransparency()));
            this.setAmbientMap(GL20ShaderServer.getShaderFragment(phong.getAmbient()));
            this.setEmissiveMap(GL20ShaderServer.getShaderFragment(phong.getEmissive()));
            this.setShininessMap(GL20ShaderServer.getShaderFragment(phong.getShininess()));
            bl = super.setShader(shader);
        }
        return bl;
    }

    public int getEnvironmentDependencies() {
        return 26;
    }

    private int createPhongCode(GL20GLSLCode gL20GLSLCode) {
        int n;
        int n2 = -1;
        int n3 = this.getAmbientMap().getVector4Index(gL20GLSLCode, 24);
        int n4 = this.getDiffuseMap().getVector4Index(gL20GLSLCode, 24);
        int n5 = this.getSpecularMap().getVector4Index(gL20GLSLCode, 24);
        int n6 = this.getShininessMap().getScalarIndex(gL20GLSLCode, 24);
        if (n3 != -1 && n4 != -1 && n5 != -1 && (n = gL20GLSLCode.allocateTemporaryVector4()) != -1) {
            String string = new String();
            gL20GLSLCode.setDependency(7);
            string = string + gL20GLSLCode.getVector4Name(n) + " = " + gL20GLSLCode.getVector4Name(n3) + ";\n";
            int n7 = gL20GLSLCode.allocateTemporaryVector3();
            string = string + gL20GLSLCode.getVector3Name(n7) + " = normalize(" + GL20GLSLCode.getDependencyName(4) + ");\n";
            int n8 = gL20GLSLCode.allocateTemporaryVector3();
            int n9 = gL20GLSLCode.allocateTemporaryVector3();
            string = string + gL20GLSLCode.getVector3Name(n8) + " = vec3(gl_LightSource[0].position);\n";
            string = string + gL20GLSLCode.getVector3Name(n9) + " = vec3(gl_LightSource[0].constantAttenuation,gl_LightSource[0].linearAttenuation,gl_LightSource[0].quadraticAttenuation);\n";
            int n10 = gL20GLSLCode.allocateTemporaryVector3();
            string = string + gL20GLSLCode.getVector3Name(n10) + " = " + gL20GLSLCode.getVector3Name(n8) + " - " + GL20GLSLCode.getDependencyName(2) + ";\n";
            int n11 = gL20GLSLCode.allocateTemporaryScalar();
            string = string + gL20GLSLCode.getScalarName(n11) + " = length(" + gL20GLSLCode.getVector3Name(n10) + ");\n";
            string = string + gL20GLSLCode.getVector3Name(n10) + " /= " + gL20GLSLCode.getScalarName(n11) + ";\n";
            int n12 = gL20GLSLCode.allocateTemporaryScalar();
            string = string + gL20GLSLCode.getScalarName(n12) + " = max(dot(" + GL20GLSLCode.getDependencyName(1) + "," + gL20GLSLCode.getVector3Name(n10) + "),0.0);\n";
            string = string + "if (" + gL20GLSLCode.getScalarName(n12) + " > 0.0) {\n";
            int n13 = gL20GLSLCode.allocateTemporaryScalar();
            string = string + "\t" + gL20GLSLCode.getScalarName(n13) + " = 1.0 / (" + gL20GLSLCode.getVector3Name(n9) + ".x + " + gL20GLSLCode.getVector3Name(n9) + ".y * " + gL20GLSLCode.getScalarName(n11) + " + " + gL20GLSLCode.getVector3Name(n9) + ".z * " + gL20GLSLCode.getScalarName(n11) + " * " + gL20GLSLCode.getScalarName(n11) + ");\n";
            string = string + "\t" + gL20GLSLCode.getVector4Name(n) + " += " + gL20GLSLCode.getScalarName(n13) + " * (" + gL20GLSLCode.getVector4Name(n4) + " * " + gL20GLSLCode.getScalarName(n12) + ");\n";
            int n14 = n11;
            string = string + "\t" + gL20GLSLCode.getScalarName(n14) + " = max(dot(" + GL20GLSLCode.getDependencyName(1) + ",normalize(" + gL20GLSLCode.getVector3Name(n10) + " + " + gL20GLSLCode.getVector3Name(n7) + ")),0.0);\n";
            string = string + "\t" + gL20GLSLCode.getVector4Name(n) + " += " + gL20GLSLCode.getScalarName(n13) + " * " + gL20GLSLCode.getVector4Name(n5) + " * pow(" + gL20GLSLCode.getScalarName(n14) + "," + gL20GLSLCode.getScalarName(n6) + " * 128.0);\n";
            string = string + "}\n";
            gL20GLSLCode.freeVector3(n9);
            gL20GLSLCode.freeVector3(n8);
            gL20GLSLCode.freeVector3(n7);
            gL20GLSLCode.freeVector3(n10);
            gL20GLSLCode.freeScalar(n11);
            gL20GLSLCode.freeScalar(n12);
            gL20GLSLCode.appendCode(string);
            n2 = n;
        }
        gL20GLSLCode.freeScalar(n6);
        gL20GLSLCode.freeVector4(n3);
        gL20GLSLCode.freeVector4(n4);
        gL20GLSLCode.freeVector4(n5);
        return n2;
    }

    public int getScalarFromShader(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n < 8 || n > 14) && (n2 = this.createPhongCode(gL20GLSLCode)) != -1) {
            int n4 = gL20GLSLCode.allocateTemporaryScalar();
            if (n4 != -1) {
                String string = new String(gL20GLSLCode.getScalarName(n4) + " = " + gL20GLSLCode.getVector4Name(n2) + ".");
                switch (n & 3) {
                    case 0: {
                        string = string + "x;\n";
                        break;
                    }
                    case 1: {
                        string = string + "y;\n";
                        break;
                    }
                    case 2: {
                        string = string + "z;\n";
                        break;
                    }
                    case 3: {
                        string = string + "w;\n";
                    }
                }
                gL20GLSLCode.appendCode(string);
                n3 = n4;
            }
            gL20GLSLCode.freeVector4(n2);
        }
        return n3;
    }

    public int getVector3FromShader(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n + 2 < 8 || n > 14) && (n2 = this.createPhongCode(gL20GLSLCode)) != -1) {
            int n4 = gL20GLSLCode.allocateTemporaryVector3();
            if (n4 != -1) {
                String string = new String(gL20GLSLCode.getVector3Name(n4) + " = " + gL20GLSLCode.getVector4Name(n2) + ".");
                block6: for (int i = 0; i < 3; ++i) {
                    switch (n + i & 3) {
                        case 0: {
                            string = string + "x";
                            continue block6;
                        }
                        case 1: {
                            string = string + "y";
                            continue block6;
                        }
                        case 2: {
                            string = string + "z";
                            continue block6;
                        }
                        case 3: {
                            string = string + "w";
                        }
                    }
                }
                string = string + ";\n";
                gL20GLSLCode.appendCode(string);
                n3 = n4;
            }
            gL20GLSLCode.freeVector4(n4);
        }
        return n3;
    }

    public int getVector4FromShader(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n + 3 < 8 || n > 14) && (n2 = this.createPhongCode(gL20GLSLCode)) != -1) {
            int n4 = n2;
            if (gL20GLSLCode.isConstant(n2)) {
                n4 = gL20GLSLCode.allocateTemporaryVector4();
            }
            if (n4 != -1) {
                String string = new String(gL20GLSLCode.getVector4Name(n4) + " = " + gL20GLSLCode.getVector4Name(n2) + ".");
                block6: for (int i = 0; i < 4; ++i) {
                    switch (n + i & 3) {
                        case 0: {
                            string = string + "x";
                            continue block6;
                        }
                        case 1: {
                            string = string + "y";
                            continue block6;
                        }
                        case 2: {
                            string = string + "z";
                            continue block6;
                        }
                        case 3: {
                            string = string + "w";
                        }
                    }
                }
                string = string + ";\n";
                gL20GLSLCode.appendCode(string);
                n3 = n4;
            }
        }
        return n3;
    }

    public final GL20ResourceShaderFragment getDiffuseMap() {
        return this.diffuseMap != null ? this.diffuseMap : DEFAULT_DIFFUSE_MAP;
    }

    public final GL20ResourceShaderFragment getSpecularMap() {
        return this.specularMap != null ? this.specularMap : DEFAULT_SPECULAR_MAP;
    }

    public final GL20ResourceShaderFragment getTransparencyMap() {
        return this.transparencyMap != null ? this.transparencyMap : DEFAULT_TRANSPARENCY_MAP;
    }

    public final GL20ResourceShaderFragment getTransparencyShininessMap() {
        return this.transparencyShininessMap != null ? this.transparencyShininessMap : DEFAULT_TRANSPARENCY_SHININESS_MAP;
    }

    public final GL20ResourceShaderFragment getTransparencyDiffuseMap() {
        return this.transparencyDiffuseMap != null ? this.transparencyDiffuseMap : DEFAULT_TRANSPARENCY_DIFFUSE_MAP;
    }

    public final GL20ResourceShaderFragment getAmbientMap() {
        return this.ambientMap != null ? this.ambientMap : DEFAULT_AMBIENT_MAP;
    }

    public final GL20ResourceShaderFragment getEmissiveMap() {
        return this.emissiveMap != null ? this.emissiveMap : DEFAULT_EMISSIVE_MAP;
    }

    public final GL20ResourceShaderFragment getShininessMap() {
        return this.shininessMap != null ? this.shininessMap : DEFAULT_SHININESS_MAP;
    }

    public final void setDiffuseMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.diffuseMap != gL20ResourceShaderFragment) {
            if (this.diffuseMap != null) {
                this.diffuseMap.unregisterUser();
            }
            this.diffuseMap = gL20ResourceShaderFragment;
            if (this.diffuseMap != null) {
                this.diffuseMap.registerUser();
            }
            this.changeMask |= 1;
        }
    }

    public final void setSpecularMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.specularMap != gL20ResourceShaderFragment) {
            if (this.specularMap != null) {
                this.specularMap.unregisterUser();
            }
            this.specularMap = gL20ResourceShaderFragment;
            if (this.specularMap != null) {
                this.specularMap.registerUser();
            }
            this.changeMask |= 2;
        }
    }

    public final void setTransparencyMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.transparencyMap != gL20ResourceShaderFragment) {
            if (this.transparencyMap != null) {
                this.transparencyMap.unregisterUser();
            }
            this.transparencyMap = gL20ResourceShaderFragment;
            if (this.transparencyMap != null) {
                this.transparencyMap.registerUser();
            }
            this.changeMask |= 4;
        }
    }

    public final void setTransparencyShininessMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.transparencyShininessMap != gL20ResourceShaderFragment) {
            if (this.transparencyShininessMap != null) {
                this.transparencyShininessMap.unregisterUser();
            }
            this.transparencyShininessMap = gL20ResourceShaderFragment;
            if (this.transparencyShininessMap != null) {
                this.transparencyShininessMap.registerUser();
            }
            this.changeMask |= 8;
        }
    }

    public final void setTransparencyDiffuseMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.transparencyDiffuseMap != gL20ResourceShaderFragment) {
            if (this.transparencyDiffuseMap != null) {
                this.transparencyDiffuseMap.unregisterUser();
            }
            this.transparencyDiffuseMap = gL20ResourceShaderFragment;
            if (this.transparencyDiffuseMap != null) {
                this.transparencyDiffuseMap.registerUser();
            }
            this.changeMask |= 0x10;
        }
    }

    public final void setAmbientMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.ambientMap != gL20ResourceShaderFragment) {
            if (this.ambientMap != null) {
                this.ambientMap.unregisterUser();
            }
            this.ambientMap = gL20ResourceShaderFragment;
            if (this.ambientMap != null) {
                this.ambientMap.registerUser();
            }
            this.changeMask |= 0x20;
        }
    }

    public final void setEmissiveMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.emissiveMap != gL20ResourceShaderFragment) {
            if (this.emissiveMap != null) {
                this.emissiveMap.unregisterUser();
            }
            this.emissiveMap = gL20ResourceShaderFragment;
            if (this.emissiveMap != null) {
                this.emissiveMap.registerUser();
            }
            this.changeMask |= 0x40;
        }
    }

    public final void setShininessMap(GL20ResourceShaderFragment gL20ResourceShaderFragment) {
        if (this.shininessMap != gL20ResourceShaderFragment) {
            if (this.shininessMap != null) {
                this.shininessMap.unregisterUser();
            }
            this.shininessMap = gL20ResourceShaderFragment;
            if (this.shininessMap != null) {
                this.shininessMap.registerUser();
            }
            this.changeMask |= 0x80;
        }
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        if (!super.isUpToDate()) {
            return false;
        }
        if (!this.getDiffuseMap().isUpToDate()) {
            return false;
        }
        if (!this.getSpecularMap().isUpToDate()) {
            return false;
        }
        if (!this.getTransparencyMap().isUpToDate()) {
            return false;
        }
        if (!this.getTransparencyShininessMap().isUpToDate()) {
            return false;
        }
        if (!this.getTransparencyDiffuseMap().isUpToDate()) {
            return false;
        }
        if (!this.getAmbientMap().isUpToDate()) {
            return false;
        }
        if (!this.getEmissiveMap().isUpToDate()) {
            return false;
        }
        return this.getShininessMap().isUpToDate();
    }

    public void update() {
        this.setShader(this.getShader());
        this.getDiffuseMap().update();
        this.getSpecularMap().update();
        this.getTransparencyMap().update();
        this.getTransparencyShininessMap().update();
        this.getTransparencyDiffuseMap().update();
        this.getAmbientMap().update();
        this.getEmissiveMap().update();
        this.getShininessMap().update();
        if (this.changeMask != 0) {
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        this.setDiffuseMap(null);
        this.setSpecularMap(null);
        this.setTransparencyMap(null);
        this.setTransparencyShininessMap(null);
        this.setTransparencyDiffuseMap(null);
        this.setAmbientMap(null);
        this.setEmissiveMap(null);
        this.setShininessMap(null);
    }
}

