/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20GLSLCode;
import de.grogra.imp3d.gl20.GL20ResourceShaderFragment;
import de.grogra.math.ChannelMap;
import de.grogra.math.RGBColor;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;

class GL20ResourceShaderFragmentRGBColor
extends GL20ResourceShaderFragment {
    private static final int COLOR = 1;
    private int changeMask = -1;
    private Vector4f color = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);

    public GL20ResourceShaderFragmentRGBColor() {
        super(327682);
    }

    public boolean setChannelMap(ChannelMap channelMap) {
        boolean bl = false;
        if (channelMap instanceof RGBColor) {
            RGBColor rGBColor = (RGBColor)channelMap;
            this.setColor(new Vector4f(rGBColor.x, rGBColor.y, rGBColor.z, 1.0f));
            bl = super.setChannelMap(channelMap);
        }
        return bl;
    }

    public boolean fragmentAffectOnAlpha() {
        return false;
    }

    public final Vector4f getColor() {
        return this.color;
    }

    public final void setColor(Vector4f vector4f) {
        if (!this.color.equals((Tuple4f)vector4f)) {
            this.color.set((Tuple4f)vector4f);
            this.changeMask |= 1;
        }
    }

    public int getScalarIndex(GL20GLSLCode gL20GLSLCode, int n) {
        int n2 = -1;
        if (n < 8 || n > 14) {
            int n3 = -1;
            switch (n & 3) {
                case 0: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.x);
                    break;
                }
                case 1: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.y);
                    break;
                }
                case 2: {
                    n3 = gL20GLSLCode.createConstScalar(this.color.z);
                    break;
                }
                case 3: {
                    n3 = gL20GLSLCode.createConstScalar(1.0f);
                }
            }
            n2 = n3 | 0x8000;
        }
        return n2;
    }

    public int getVector3Index(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n + 2 < 8 || n > 14) && (n2 = gL20GLSLCode.allocateTemporaryVector3()) != -1) {
            String string = new String(gL20GLSLCode.getVector3Name(n2) + " = vec(");
            for (int i = 0; i < 3; ++i) {
                switch (n + i & 3) {
                    case 0: {
                        string = string + Float.valueOf(this.color.x).toString();
                        break;
                    }
                    case 1: {
                        string = string + Float.valueOf(this.color.y).toString();
                        break;
                    }
                    case 2: {
                        string = string + Float.valueOf(this.color.z).toString();
                        break;
                    }
                    case 3: {
                        string = string + "1.0";
                    }
                }
                string = i < 2 ? string + "," : string + ");\n";
            }
            gL20GLSLCode.appendCode(string);
            n3 = n2;
        }
        return n3;
    }

    public int getVector4Index(GL20GLSLCode gL20GLSLCode, int n) {
        int n2;
        int n3 = -1;
        if ((n + 3 < 8 || n > 14) && (n2 = gL20GLSLCode.allocateTemporaryVector4()) != -1) {
            String string = new String(gL20GLSLCode.getVector4Name(n2) + " = vec4(");
            for (int i = 0; i < 4; ++i) {
                switch (n + i & 3) {
                    case 0: {
                        string = string + Float.valueOf(this.color.x).toString();
                        break;
                    }
                    case 1: {
                        string = string + Float.valueOf(this.color.y).toString();
                        break;
                    }
                    case 2: {
                        string = string + Float.valueOf(this.color.z).toString();
                        break;
                    }
                    case 3: {
                        string = string + "1.0";
                    }
                }
                string = i < 3 ? string + "," : string + ");\n";
            }
            gL20GLSLCode.appendCode(string);
            n3 = n2;
        }
        return n3;
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        this.setChannelMap(this.getChannelMap());
        if (this.changeMask != 0) {
            this.changeMask = 0;
        }
        super.update();
    }

    public void destroy() {
        super.destroy();
    }
}

