/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.gl20;

import de.grogra.imp3d.gl20.GL20Const;
import de.grogra.imp3d.gl20.GL20Resource;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class GL20ResourceLight
extends GL20Resource {
    private static final ArrayList<GL20ResourceLight> lights = new ArrayList();
    private static final int COLOR = 1;
    private static final int WORLD_MATRIX = 2;
    private int changeMask = -1;
    private Vector3f color = new Vector3f();
    private Matrix4d worldMatrix = new Matrix4d(GL20Const.identityMatrix4d);

    public static final void registerLight(GL20ResourceLight gL20ResourceLight) {
        if (!lights.contains(gL20ResourceLight)) {
            lights.add(gL20ResourceLight);
        }
    }

    public static final void unregisterLight(GL20ResourceLight gL20ResourceLight) {
        lights.remove(gL20ResourceLight);
    }

    protected GL20ResourceLight(int n) {
        super(n);
        assert ((n & 0xFFFF0000) == 131072);
        GL20ResourceLight.registerLight(this);
    }

    public final void setColor(Vector3f vector3f) {
        if (!this.color.equals((Tuple3f)vector3f)) {
            this.color.set((Tuple3f)vector3f);
            this.changeMask |= 1;
        }
    }

    public final Vector3f getColor() {
        return this.color;
    }

    public final void setWorldTransformationMatrix(Matrix4d matrix4d) {
        if (!this.worldMatrix.equals(matrix4d)) {
            this.worldMatrix.set(matrix4d);
            this.changeMask |= 2;
        }
    }

    public final Matrix4d getWorldTransformationMatrix() {
        return this.worldMatrix;
    }

    public boolean isUpToDate() {
        if (this.changeMask != 0) {
            return false;
        }
        return super.isUpToDate();
    }

    public void update() {
        if (this.changeMask != 0) {
            this.changeMask = 0;
        }
        super.update();
    }

    public void destory() {
        GL20ResourceLight.unregisterLight(this);
        super.destroy();
    }

    public static void setupLights() {
    }
}

