/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.edit;

import de.grogra.graph.impl.Node;
import de.grogra.imp.PickList;
import de.grogra.imp3d.DragEvent3D;
import de.grogra.imp3d.edit.TransformTool;
import de.grogra.imp3d.objects.Cone;
import de.grogra.imp3d.objects.Line;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.math.TMatrix4d;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.util.EventListener;
import de.grogra.vecmath.Math2;
import java.util.EventObject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class Translate
extends TransformTool {
    TranslateCone[] cones = new TranslateCone[3];
    private static final float DIV = 0.85f;
    private static final float AXIS_LENGTH = 0.14999998f;
    public static final Node.NType $TYPE = new Node.NType((Node)new Translate());

    void setHighlight(int n, boolean bl) {
        for (int i = 0; i < 3; ++i) {
            this.cones[i].setHighlight(i == n != bl);
        }
    }

    public Translate() {
        this.addEdgeBitsTo(this.createArrow(0, 1, 0, 0, RGBAShader.RED), 512, null);
        this.addEdgeBitsTo(this.createArrow(1, 0, 1, 0, RGBAShader.BLUE), 512, null);
        this.addEdgeBitsTo(this.createArrow(2, 0, 0, 1, RGBAShader.GREEN), 512, null);
    }

    private Node createArrow(int n, int n2, int n3, int n4, RGBAShader rGBAShader) {
        Line line = new Line((float)n2 * 0.85f, (float)n3 * 0.85f, (float)n4 * 0.85f);
        line.setColor(rGBAShader.x, rGBAShader.y, rGBAShader.z);
        line.addEdgeBitsTo(new TranslateCone(n, n2, n3, n4, line, rGBAShader), 256, null);
        return line;
    }

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Translate();
    }

    static {
        $TYPE.validate();
    }

    private class TranslateCone
    extends Cone
    implements EventListener,
    Command {
        final int id;
        private final RGBAShader color;
        private final Line line;
        private final Vector3d contactPoint = new Vector3d();
        private final Vector3d fixed = new Vector3d();
        private boolean usePlane;
        private boolean disabled;
        private final Point3d p = new Point3d();
        private final Vector3d v = new Vector3d();
        private final Vector3d w = new Vector3d();
        private final Vector3d axisTmp = new Vector3d();
        private final Matrix3d m3d = new Matrix3d();
        private final double[] lambda = new double[2];
        private final Vector3d handleAxis = new Vector3d();
        private final Vector3f axis = new Vector3f();

        TranslateCone(int n, int n2, int n3, int n4, Line line, RGBAShader rGBAShader) {
            TMatrix4d tMatrix4d = new TMatrix4d();
            tMatrix4d.setIdentity();
            if (n2 != 0) {
                tMatrix4d.rotY(1.5707963267948966);
            } else if (n3 != 0) {
                tMatrix4d.rotX(-1.5707963267948966);
            }
            this.handleAxis.set((double)((float)n2 * 0.85f), (double)((float)n3 * 0.85f), (double)((float)n4 * 0.85f));
            tMatrix4d.setTranslation(this.handleAxis);
            this.setTransform(tMatrix4d);
            this.setLength(0.14999998f);
            this.axis.set((float)n2 * 0.14999998f, (float)n3 * 0.14999998f, (float)n4 * 0.14999998f);
            this.setRadius(0.044999994f);
            this.setShader(rGBAShader);
            this.color = rGBAShader;
            this.id = n;
            this.line = line;
            Translate.this.cones[n] = this;
        }

        public void pick(Object object, boolean bl, Point3d point3d, Vector3d vector3d, Matrix4d matrix4d, PickList pickList) {
            pickList.p3d0.set((Tuple3d)point3d);
            pickList.p3d1.set(0.0, 0.0, (double)this.getLength());
            point3d.add((Tuple3d)pickList.p3d1);
            TranslateCone.pick(3.0f * this.getLength(), 3.0f * this.getRadius(), 2.0f * this.getRadius(), true, true, point3d, vector3d, pickList);
            point3d.set((Tuple3d)pickList.p3d0);
        }

        public void eventOccured(EventObject eventObject) {
            if (eventObject instanceof DragEvent3D) {
                Translate.this.executeWithWriteLock(this, (EditEvent)((DragEvent3D)((Object)eventObject)));
            }
        }

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            DragEvent3D dragEvent3D = (DragEvent3D)context;
            if (dragEvent3D.draggingFinished()) {
                Translate.this.setHighlight(-1, false);
            } else if (dragEvent3D.draggingStarted()) {
                this.usePlane = dragEvent3D.isAltDown();
                Translate.this.setHighlight(this.id, this.usePlane);
                this.disabled = false;
                Matrix4d matrix4d = Translate.this.getToolTransformation();
                this.p.set((Tuple3d)dragEvent3D.origin);
                Math2.invTransformPoint((Matrix4d)matrix4d, (Tuple3d)this.p);
                this.v.set((Tuple3d)dragEvent3D.direction);
                Math2.invTransformVector((Matrix4d)matrix4d, (Tuple3d)this.v);
                this.v.normalize();
                this.axisTmp.set((Tuple3f)this.axis);
                if (Math.abs(Math.abs(this.v.dot(this.axisTmp) / 0.1499999761581421) - 1.0) < 0.02) {
                    this.disabled = true;
                    return;
                }
                Math2.shortestConnection((Tuple3d)this.p, (Vector3d)this.v, (Tuple3d)this.handleAxis, (Vector3d)this.axisTmp, (double[])this.lambda);
                this.v.scaleAdd(this.lambda[1], (Tuple3d)this.axisTmp, (Tuple3d)this.handleAxis);
                Math2.transformPoint((Matrix4d)Translate.this.getAdjustment(), (Tuple3d)this.v);
                this.contactPoint.set((Tuple3d)this.v);
                Translate.this.local.get(this.v);
                Math2.invTransformVector((Matrix4d)Translate.this.local, (Tuple3d)this.v);
                Math2.invTransformVector((Matrix4d)Translate.this.getAdjustment(), (Tuple3d)this.v);
                this.w.scale(this.v.dot(this.axisTmp) / this.axisTmp.lengthSquared(), (Tuple3d)this.axisTmp);
                if (!this.usePlane) {
                    this.w.sub((Tuple3d)this.v, (Tuple3d)this.w);
                }
                Translate.this.getAdjustment().transform(this.w, this.fixed);
            } else {
                if (this.disabled) {
                    return;
                }
                this.p.add((Tuple3d)this.contactPoint, (Tuple3d)this.fixed);
                Math2.transformVector((Matrix4d)Translate.this.local, (Tuple3d)this.p);
                Translate.this.getParentTransformation().transform(this.p);
                this.p.scaleAdd(-1.0, (Tuple3d)dragEvent3D.origin);
                Matrix4d matrix4d = Translate.this.getToolTransformation();
                Math2.invTransformVector((Matrix4d)matrix4d, (Tuple3d)this.p);
                this.v.set((Tuple3d)dragEvent3D.direction);
                Math2.invTransformVector((Matrix4d)matrix4d, (Tuple3d)this.v);
                this.v.normalize();
                if (this.usePlane) {
                    this.m3d.setColumn(0, this.v);
                    this.axisTmp.set((Tuple3f)Translate.this.cones[(this.id + 1) % 3].axis);
                    this.m3d.setColumn(1, this.axisTmp);
                    this.axisTmp.set((Tuple3f)Translate.this.cones[(this.id + 2) % 3].axis);
                    this.m3d.setColumn(2, this.axisTmp);
                    if (Math.abs(this.m3d.determinant()) < 4.499998569488639E-4) {
                        this.disabled = true;
                        return;
                    }
                    Math2.invMul((Matrix3d)this.m3d, (Tuple3d)this.p);
                    this.axisTmp.set((Tuple3f)Translate.this.cones[(this.id + 1) % 3].axis);
                    this.v.scale(this.p.y, (Tuple3d)this.axisTmp);
                    this.axisTmp.set((Tuple3f)Translate.this.cones[(this.id + 2) % 3].axis);
                    this.v.scaleAdd(this.p.z, (Tuple3d)this.axisTmp, (Tuple3d)this.v);
                } else {
                    this.axisTmp.set((Tuple3f)this.axis);
                    if (Math.abs(Math.abs(this.v.dot(this.axisTmp) / 0.1499999761581421) - 1.0) < 0.02) {
                        this.disabled = true;
                        return;
                    }
                    Math2.shortestConnection((Tuple3d)this.p, (Vector3d)this.v, (Tuple3d)this.handleAxis, (Vector3d)this.axisTmp, (double[])this.lambda);
                    this.v.scaleAdd(this.lambda[1], (Tuple3d)this.axisTmp, (Tuple3d)this.handleAxis);
                }
                Translate.this.getAdjustment().transform(this.v);
                this.v.add((Tuple3d)this.fixed);
                Translate.this.local.transform(this.v);
                matrix4d = new Matrix4d(Translate.this.local);
                matrix4d.setTranslation(this.v);
                Translate.this.setTargetTransform(matrix4d);
            }
            dragEvent3D.consume();
        }

        void setHighlight(boolean bl) {
            RGBAShader rGBAShader = bl ? RGBAShader.YELLOW : this.color;
            this.setShader(rGBAShader);
            this.line.setColor(rGBAShader.x, rGBAShader.y, rGBAShader.z);
        }
    }
}

