/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d.edit;

import de.grogra.graph.impl.Node;
import de.grogra.imp3d.CameraBase;
import de.grogra.imp3d.DragEvent3D;
import de.grogra.imp3d.edit.TransformTool;
import de.grogra.imp3d.objects.Box;
import de.grogra.imp3d.objects.Line;
import de.grogra.imp3d.shading.RGBAShader;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.event.EditEvent;
import de.grogra.util.EventListener;
import de.grogra.vecmath.Math2;
import java.util.EventObject;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class Scale
extends TransformTool {
    public static final Node.NType $TYPE = new Node.NType((Node)new Scale());
    private static final float DIV = 0.95f;
    private static final float AXIS_LENGTH = 0.100000024f;
    private ScaleBox[] boxes = new ScaleBox[4];
    private Matrix4d adjustTransformation = null;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new Scale();
    }

    public Scale() {
        this.addEdgeBitsTo(this.createHandle(0, 1, 0, 0, RGBAShader.RED), 512, null);
        this.addEdgeBitsTo(this.createHandle(1, 0, 1, 0, RGBAShader.BLUE), 512, null);
        this.addEdgeBitsTo(this.createHandle(2, 0, 0, 1, RGBAShader.GREEN), 512, null);
        this.addEdgeBitsTo(new CenterScaleBox(3, null, RGBAShader.LIGHT_GRAY), 512, null);
    }

    private Node createHandle(int n, int n2, int n3, int n4, RGBAShader rGBAShader) {
        Line line = new Line((float)n2 * 0.95f, (float)n3 * 0.95f, (float)n4 * 0.95f);
        line.setColor(rGBAShader.x, rGBAShader.y, rGBAShader.z);
        line.addEdgeBitsTo(new ScaleBox(n, n2, n3, n4, line, rGBAShader), 256, null);
        return line;
    }

    void setHighlight(int n, boolean bl) {
        for (int i = 0; i < this.boxes.length; ++i) {
            if (this.boxes[i] == null) continue;
            this.boxes[i].setHighlight(i == n);
        }
    }

    protected void adjustToolTransformation(Matrix4d matrix4d, CameraBase cameraBase) {
        if (this.adjustTransformation == null) {
            Scale.adjustScale(matrix4d, cameraBase, 150.0f);
            this.adjustTransformation = new Matrix4d(matrix4d);
        } else {
            matrix4d.set(this.adjustTransformation);
        }
    }

    static {
        $TYPE.validate();
    }

    private class CenterScaleBox
    extends ScaleBox {
        static final double SCALE_AMOUNT = 0.01;

        CenterScaleBox(int n, Line line, RGBAShader rGBAShader) {
            super(n, 0, 0, 0, line, rGBAShader);
        }

        protected void draggingStarted(DragEvent3D dragEvent3D) {
            this.disabled = false;
            this.currentScale = 1.0;
            this.originalLocal.set(Scale.this.local);
        }

        protected void dragging(DragEvent3D dragEvent3D) {
            int n = dragEvent3D.getDeltaX();
            int n2 = dragEvent3D.getDeltaY();
            int n3 = n - n2;
            this.currentScale += 0.01 * (double)n3;
            this.currentScale = Math.max(this.currentScale, 0.01);
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.set(this.currentScale);
            matrix4d.mul(this.originalLocal, matrix4d);
            Scale.this.setTargetTransform(matrix4d);
        }
    }

    private class ScaleBox
    extends Box
    implements EventListener,
    Command {
        static final double MIN_SCALE = 0.01;
        final int id;
        protected final RGBAShader color;
        protected final Line line;
        protected final Point3d p = new Point3d();
        protected final Vector3d v = new Vector3d();
        protected final Vector3d axis = new Vector3d();
        protected final double[] lambda = new double[2];
        protected boolean usePlane;
        protected boolean disabled;
        protected double initialScale;
        protected double currentScale;
        protected final Matrix4d originalLocal = new Matrix4d();
        protected final Matrix4d toolTransformation = new Matrix4d();

        ScaleBox(int n, int n2, int n3, int n4, Line line, RGBAShader rGBAShader) {
            this.setStartPosition(-0.5f);
            this.setTransform(n2, n3, n4);
            this.setLength(0.100000024f);
            this.setWidth(0.100000024f);
            this.setHeight(0.100000024f);
            this.axis.set((double)n2, (double)n3, (double)n4);
            this.axis.normalize();
            this.color = rGBAShader;
            this.setShader(this.color);
            this.id = n;
            this.line = line;
            ((Scale)Scale.this).boxes[n] = this;
        }

        public void eventOccured(EventObject eventObject) {
            if (eventObject instanceof DragEvent3D) {
                Scale.this.executeWithWriteLock(this, (EditEvent)((DragEvent3D)((Object)eventObject)));
            }
        }

        public String getCommandName() {
            return null;
        }

        public void run(Object object, Context context) {
            DragEvent3D dragEvent3D = (DragEvent3D)context;
            if (dragEvent3D.draggingFinished()) {
                this.draggingFinished(dragEvent3D);
            } else if (dragEvent3D.draggingStarted()) {
                this.draggingStarted(dragEvent3D);
            } else if (!this.disabled) {
                this.dragging(dragEvent3D);
            }
            dragEvent3D.consume();
        }

        protected void draggingFinished(DragEvent3D dragEvent3D) {
            Scale.this.setHighlight(-1, false);
            Scale.this.adjustTransformation = null;
        }

        protected void draggingStarted(DragEvent3D dragEvent3D) {
            Scale.this.setHighlight(this.id, this.usePlane);
            this.disabled = false;
            this.toolTransformation.set(Scale.this.getToolTransformation());
            this.p.set((Tuple3d)dragEvent3D.origin);
            Math2.invTransformPoint((Matrix4d)this.toolTransformation, (Tuple3d)this.p);
            this.v.set((Tuple3d)dragEvent3D.direction);
            Math2.invTransformVector((Matrix4d)this.toolTransformation, (Tuple3d)this.v);
            this.v.normalize();
            if (Math.abs(this.v.dot(this.axis)) > 0.95) {
                this.disabled = true;
            }
            Math2.shortestConnection((Tuple3d)this.p, (Vector3d)this.v, (Tuple3d)new Point3d(), (Vector3d)this.axis, (double[])this.lambda);
            this.initialScale = this.lambda[1];
            this.initialScale = Math.max(this.initialScale, Double.MIN_VALUE);
            this.originalLocal.set(Scale.this.local);
        }

        protected void dragging(DragEvent3D dragEvent3D) {
            this.p.set((Tuple3d)dragEvent3D.origin);
            Math2.invTransformPoint((Matrix4d)this.toolTransformation, (Tuple3d)this.p);
            this.v.set((Tuple3d)dragEvent3D.direction);
            Math2.invTransformVector((Matrix4d)this.toolTransformation, (Tuple3d)this.v);
            this.v.normalize();
            Math2.shortestConnection((Tuple3d)this.p, (Vector3d)this.v, (Tuple3d)new Point3d(), (Vector3d)this.axis, (double[])this.lambda);
            this.currentScale = this.lambda[1];
            this.currentScale = Math.max(this.currentScale, Double.MIN_VALUE);
            double d = this.currentScale / this.initialScale;
            d = Math.max(d, 0.01);
            Matrix4d matrix4d = new Matrix4d(Scale.this.local);
            matrix4d.setIdentity();
            matrix4d.setElement(0, 0, 1.0 + this.axis.x * (d -= 1.0));
            matrix4d.setElement(1, 1, 1.0 + this.axis.y * d);
            matrix4d.setElement(2, 2, 1.0 + this.axis.z * d);
            matrix4d.mul(this.originalLocal, matrix4d);
            Scale.this.setTargetTransform(matrix4d);
        }

        void setHighlight(boolean bl) {
            RGBAShader rGBAShader = bl ? RGBAShader.YELLOW : this.color;
            this.setShader(rGBAShader);
            if (this.line != null) {
                this.line.setColor(rGBAShader.x, rGBAShader.y, rGBAShader.z);
            }
        }
    }
}

