/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.GraphUtils;
import de.grogra.graph.Path;
import de.grogra.graph.impl.GraphManager;
import de.grogra.graph.impl.SharedObjectNode;
import de.grogra.imp.NavigatorFactory;
import de.grogra.imp.PickList;
import de.grogra.imp.View;
import de.grogra.imp.ViewEventHandler;
import de.grogra.imp.edit.ViewSelection;
import de.grogra.imp.registry.ViewComponentFactory;
import de.grogra.imp3d.Camera;
import de.grogra.imp3d.CanvasCamera;
import de.grogra.imp3d.DragEvent3D;
import de.grogra.imp3d.Navigator3DFactory;
import de.grogra.imp3d.ParallelProjection;
import de.grogra.imp3d.PerspectiveProjection;
import de.grogra.imp3d.PickRayVisitor;
import de.grogra.imp3d.Projection;
import de.grogra.imp3d.ViewConfig3D;
import de.grogra.imp3d.WireframeCanvas;
import de.grogra.imp3d.objects.DirectionalLight;
import de.grogra.imp3d.objects.GlobalTransformation;
import de.grogra.imp3d.shading.Light;
import de.grogra.persistence.IndirectField;
import de.grogra.persistence.ManageableType;
import de.grogra.persistence.PersistenceField;
import de.grogra.persistence.SCOType;
import de.grogra.persistence.Shareable;
import de.grogra.persistence.SharedObjectProvider;
import de.grogra.persistence.SharedObjectReference;
import de.grogra.persistence.Transaction;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ItemCriterion;
import de.grogra.pf.registry.Option;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.edit.ObjectSelection;
import de.grogra.pf.ui.edit.Selectable;
import de.grogra.pf.ui.edit.Selection;
import de.grogra.pf.ui.event.ClickEvent;
import de.grogra.pf.ui.event.DragEvent;
import de.grogra.pf.ui.event.UIPropertyEditEvent;
import de.grogra.pf.ui.registry.PanelFactory;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.FieldChain;
import de.grogra.util.EventListener;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.vecmath.Math2;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.EventObject;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class View3D
extends View
implements SharedObjectReference,
ViewConfig3D {
    public static final String INITIAL_CAMERA = "initial-camera";
    public static final IOFlavor FLAVOR = IOFlavor.valueOf(View3D.class);
    static final String DISPLAY_PATH = "/ui/viewcomponent3dselection";
    static final String TOOL_PATH = "/ui/tools/3d";
    public static final UIProperty DISPLAY = UIProperty.getOrCreate((String)"/ui/viewcomponent3dselection", (int)2);
    public static final UIProperty TOOL = UIProperty.getOrCreate((String)"/ui/tools/3d", (int)0);
    Camera camera;
    Navigator3DFactory navigator;
    protected CanvasCamera canvasCam = new CanvasCamera();
    private PickRayVisitor pickVisitor;
    private Vector3f extentCenter = new Vector3f();
    private float extentRadius = 1.0f;
    private final View.SceneListener sceneListener = new View.SceneListener((View)this);
    private final Point3d pickOrigin = new Point3d();
    private final Vector3d pickDirection = new Vector3d();
    private static final Command CAMERA_CHANGED = new Command(){

        public void run(Object object, Context context) {
            ((View3D)context).fireCameraChangedImpl();
        }

        public String getCommandName() {
            return null;
        }
    };
    public static final Type $TYPE = new Type(View3D.class);
    public static final SCOType.Field camera$FIELD = Type._addManagedField($TYPE, "camera", 0x200000, (de.grogra.reflect.Type)Camera.$TYPE, null, 6);
    public static final SCOType.Field navigator$FIELD = Type._addManagedField($TYPE, "navigator", 0x200000, (de.grogra.reflect.Type)ClassAdapter.wrap(Navigator3DFactory.class), null, 7);

    public static Selectable getSelectableCamera(Context context) {
        final View3D view3D = (View3D)View3D.get((Context)context);
        return new Selectable(){

            public Selection toSelection(Context context) {
                return new ObjectSelection(context, view3D, new PersistenceField[]{camera$FIELD}, null, null, null, null){

                    protected Object replaceValue(PersistenceField persistenceField, Object object) {
                        SharedObjectProvider sharedObjectProvider;
                        if (persistenceField == camera$FIELD && (sharedObjectProvider = ((Camera)object).getProvider()) != null) {
                            if (sharedObjectProvider instanceof SharedObjectNode) {
                                return object;
                            }
                            try {
                                return ManageableType.cloneObject(null, (Object)object, (boolean)true, (boolean)true);
                            }
                            catch (CloneNotSupportedException cloneNotSupportedException) {
                                cloneNotSupportedException.printStackTrace();
                                return Camera.createPerspective();
                            }
                        }
                        return object;
                    }

                    protected void valueChanged(PersistenceField persistenceField, Object object) {
                        if (persistenceField.overlaps(null, (FieldChain)camera$FIELD, null)) {
                            view3D.fireCameraChanged();
                        }
                    }
                };
            }
        };
    }

    public View3D() {
        this.setCamera(Camera.createPerspective());
    }

    public IOFlavor getFlavor() {
        return FLAVOR;
    }

    protected UIProperty getToolProperty() {
        return TOOL;
    }

    protected ViewEventHandler createEventHandler() {
        return new ViewEventHandler(this, false){
            private final Point3d origin;
            private final Vector3d direction;
            {
                this.origin = new Point3d();
                this.direction = new Vector3d();
            }

            private void getPoint(MouseEvent mouseEvent) {
                View3D.this.getCanvasCamera().getRay(mouseEvent.getX(), mouseEvent.getY(), this.origin, this.direction);
            }

            protected ClickEvent createClickEvent(MouseEvent mouseEvent) {
                return new ClickEvent();
            }

            protected DragEvent createDragEvent(MouseEvent mouseEvent) {
                this.getPoint(mouseEvent);
                return new DragEvent3D(this.origin, this.direction);
            }

            protected NavigatorFactory getNavigatorFactory() {
                return View3D.this.navigator;
            }
        };
    }

    protected void initialize(Panel panel, Map map) {
        super.initialize(panel, map);
        Object object = map.get((Object)INITIAL_CAMERA, null);
        if (object instanceof Camera) {
            this.setCamera((Camera)object);
        }
    }

    protected void installImpl() {
        this.pickVisitor = new PickRayVisitor();
        this.sceneListener.install(this.getGraph());
        if (this.getViewComponent() == null) {
            ViewComponentFactory viewComponentFactory = ViewComponentFactory.get((View)this, (String)DISPLAY_PATH);
            if (viewComponentFactory != null) {
                this.setViewComponent(viewComponentFactory.createViewComponent((Context)this));
            }
            DISPLAY.setValue((Context)this, (Object)viewComponentFactory);
            DISPLAY.addPropertyListener((Context)this, (EventListener)this);
        } else {
            this.repaint(15);
        }
    }

    protected void uninstallImpl() {
        DISPLAY.removePropertyListener((Context)this, (EventListener)this);
        this.setCamera(null);
        this.sceneListener.remove(this.getGraph());
    }

    public final void pick(int n, int n2, PickList pickList) {
        this.canvasCam.getRay(n, n2, this.pickOrigin, this.pickDirection);
        this.pickVisitor.pick(this, n, n2, this.pickOrigin, this.pickDirection, pickList);
    }

    public boolean isToolGraph(Graph graph) {
        return graph == GraphManager.STATIC;
    }

    public float estimateScaleAt(float f, float f2, float f3, Matrix4d matrix4d) {
        return this.canvasCam.getScaleAt((float)matrix4d.m20 * f + (float)matrix4d.m21 * f2 + (float)matrix4d.m22 * f3 + (float)matrix4d.m23) * (float)Math.sqrt(Math2.estimateScaleSquared((Matrix4d)matrix4d));
    }

    public float estimateScaleAt(Tuple3d tuple3d, Matrix4d matrix4d) {
        return this.canvasCam.getScaleAt((float)(matrix4d.m20 * tuple3d.x + matrix4d.m21 * tuple3d.y + matrix4d.m22 * tuple3d.z + matrix4d.m23)) * (float)Math.sqrt(Math2.estimateScaleSquared((Matrix4d)matrix4d));
    }

    public float estimateScaleAt(Tuple3f tuple3f, Matrix4d matrix4d) {
        return this.canvasCam.getScaleAt((float)matrix4d.m20 * tuple3f.x + (float)matrix4d.m21 * tuple3f.y + (float)matrix4d.m22 * tuple3f.z + (float)matrix4d.m23) * (float)Math.sqrt(Math2.estimateScaleSquared((Matrix4d)matrix4d));
    }

    public CanvasCamera getCanvasCamera() {
        return this.canvasCam;
    }

    public void eventOccured(EventObject eventObject) {
        if (eventObject instanceof UIPropertyEditEvent) {
            UIPropertyEditEvent uIPropertyEditEvent = (UIPropertyEditEvent)eventObject;
            Object object = uIPropertyEditEvent.getNewValue();
            if (uIPropertyEditEvent.getProperty() == DISPLAY) {
                if (object instanceof ViewComponentFactory) {
                    this.setViewComponent(((ViewComponentFactory)object).createViewComponent((Context)this));
                }
                return;
            }
        }
        super.eventOccured(eventObject);
    }

    public void dollyOrZoom(int n, int n2) {
        Camera camera = this.getCamera();
        if (camera.getProjection() instanceof ParallelProjection) {
            this.zoom(n, n2);
        } else {
            this.dolly(n, n2);
        }
    }

    public void dolly(int n, int n2) {
        Camera camera = this.getCamera();
        Matrix4d matrix4d = new Matrix4d(camera.getWorldToViewTransformation());
        double d = Math.max((double)(2.0f * this.getVisualEpsilon()), 5.0E-4 * Math.abs(matrix4d.m23));
        matrix4d.m23 += (double)(n + n2) * d;
        this.setCameraTransformation(matrix4d);
    }

    public void move(int n, int n2) {
        Camera camera = this.getCamera();
        Matrix4d matrix4d = new Matrix4d(camera.getWorldToViewTransformation());
        double d = Math.max((double)(2.0f * this.getVisualEpsilon()), 5.0E-4 * Math.abs(matrix4d.m23));
        matrix4d.m03 += (double)n * d;
        matrix4d.m13 -= (double)n2 * d;
        this.setCameraTransformation(matrix4d);
    }

    public void rotate(int n, int n2) {
        Point3d point3d;
        Matrix4d matrix4d;
        int n3;
        ViewSelection.Entry[] entryArray;
        ViewSelection viewSelection = ViewSelection.get((Context)this);
        Vector3d vector3d = new Vector3d();
        if (viewSelection != null && (entryArray = viewSelection.getAll(4)) != null && entryArray.length > 0 && (n3 = GraphUtils.lastIndexOfTree((Path)(matrix4d = entryArray[0].getPath()), (GraphState)this.getWorkbenchGraphState())) >= 0) {
            point3d = GlobalTransformation.get(matrix4d.getObject(n3), (n3 & 1) == 0, this.getWorkbenchGraphState(), false);
            point3d.get(vector3d);
        }
        entryArray = this.getCamera();
        matrix4d = new Matrix4d(entryArray.getWorldToViewTransformation());
        Matrix4d matrix4d2 = new Matrix4d();
        point3d = new Point3d((Tuple3d)vector3d);
        matrix4d.transform(point3d);
        matrix4d2.rotZ((double)n * -0.005);
        matrix4d.mul(matrix4d2);
        matrix4d2.rotX((double)n2 * -0.005);
        matrix4d.mul(matrix4d2, matrix4d);
        matrix4d.transform(vector3d);
        vector3d.sub((Tuple3d)point3d, (Tuple3d)vector3d);
        matrix4d.setTranslation(vector3d);
        this.setCameraTransformation(matrix4d);
    }

    void zoom(int n, int n2) {
        Camera camera = this.getCamera();
        if (camera instanceof Camera) {
            Projection projection;
            try {
                projection = (Projection)((Object)ManageableType.cloneObject(null, (Object)((Object)camera.getProjection()), (boolean)true, (boolean)true));
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
                return;
            }
            if (projection instanceof ParallelProjection) {
                ParallelProjection parallelProjection = (ParallelProjection)projection;
                parallelProjection.setWidth(parallelProjection.getWidth() * (float)Math.exp(-0.005f * (float)(n2 + n)));
            } else if (projection instanceof PerspectiveProjection) {
                PerspectiveProjection perspectiveProjection = (PerspectiveProjection)projection;
                perspectiveProjection.setFieldOfView(Math.min(3.1101768f, perspectiveProjection.getFieldOfView() * (float)Math.exp(-0.01f * (float)(n2 + n))));
            } else {
                return;
            }
            this.setCameraField((PersistenceField)Camera.projection$FIELD, (Object)projection);
        }
    }

    void fitCamera() {
        if (this.extentRadius != this.extentRadius) {
            WireframeCanvas.fitCamera(this);
        } else {
            this.fitCamera(this.extentCenter, this.extentRadius);
        }
    }

    void fitCamera(Vector3f vector3f, float f) {
        if (!(f > 0.0f) || !(f < 1.7014117E38f)) {
            return;
        }
        if (!(vector3f.lengthSquared() < 1.7014117E38f)) {
            return;
        }
        Camera camera = this.getCamera();
        Projection projection = camera.getProjection();
        Vector3d vector3d = new Vector3d(vector3f);
        if (projection instanceof PerspectiveProjection) {
            this.setCameraField((PersistenceField)Camera.projection$FIELD.concat((PersistenceField)PerspectiveProjection.fieldOfView$FIELD), new Float(1.0471976f));
            vector3d.z += (double)(2.0f * f);
        } else if (projection instanceof ParallelProjection) {
            this.setCameraField((PersistenceField)Camera.projection$FIELD.concat((PersistenceField)ParallelProjection.width$FIELD), new Float(2.0f * f));
            vector3d.z += (double)(2.0f * f);
        } else {
            return;
        }
        vector3d.negate();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.set(vector3d);
        matrix4d.mul(camera.getTransformation());
        this.setCameraField((PersistenceField)Camera.transformation$FIELD, matrix4d);
    }

    private void setCamera(Camera camera) {
        this.camera = camera;
        this.canvasCam.camera = camera;
    }

    public void repaint() {
        this.repaint(15);
    }

    void fireCameraChangedImpl() {
        this.listeners.eventOccured((EventObject)new PropertyChangeEvent(this, "camera", null, this.camera));
        this.repaint(15);
    }

    void fireCameraChanged() {
        this.getWorkbench().getJobManager().runLater(CAMERA_CHANGED, null, (Context)this, 5000);
    }

    public void sharedObjectModified(Shareable shareable, Transaction transaction) {
        if (shareable == this.camera) {
            this.fireCameraChanged();
        }
    }

    public void setCameraTransformation(Matrix4d matrix4d) {
        this.setCameraField((PersistenceField)Camera.transformation$FIELD, matrix4d);
    }

    void setCameraField(final PersistenceField persistenceField, final Object object) {
        SharedObjectProvider sharedObjectProvider = this.camera.getProvider();
        if (sharedObjectProvider == null) {
            persistenceField.set((Object)this.camera, null, object, null);
            this.fireCameraChanged();
        } else if (sharedObjectProvider instanceof SharedObjectNode) {
            final SharedObjectNode sharedObjectNode = (SharedObjectNode)sharedObjectProvider;
            UI.executeLockedly((Lockable)sharedObjectNode.getGraph(), (boolean)true, (Command)new Command(){

                public String getCommandName() {
                    return null;
                }

                public void run(Object object2, Context context) {
                    IndirectField.concat((PersistenceField)SharedObjectNode.object$FIELD, (PersistenceField)persistenceField).set((Object)sharedObjectNode, null, object, sharedObjectNode.getGraph().getActiveTransaction());
                }
            }, null, (Context)this, (int)10000);
        }
    }

    public static View3D getDefaultView(Context context) {
        Window window = context.getWindow();
        return window != null ? (View3D)window.getPanel("/ui/panels/3d/defaultview") : null;
    }

    public static ViewConfig3D withCamera(final ViewConfig3D viewConfig3D, final Camera camera) {
        return new ViewConfig3D(){

            public Camera getCamera() {
                return camera;
            }

            public Light getDefaultLight(Matrix4d matrix4d) {
                return viewConfig3D.getDefaultLight(matrix4d);
            }

            public float getEpsilon() {
                return viewConfig3D.getEpsilon();
            }

            public Graph getGraph() {
                return viewConfig3D.getGraph();
            }

            public Workbench getWorkbench() {
                return viewConfig3D.getWorkbench();
            }

            public boolean isInVisibleLayer(Object object, boolean bl, GraphState graphState) {
                return viewConfig3D.isInVisibleLayer(object, bl, graphState);
            }
        };
    }

    public static ViewConfig3D getDefaultViewConfig(Context context) {
        View3D view3D = View3D.getDefaultView(context);
        if (view3D != null) {
            return view3D;
        }
        Workbench workbench = context.getWorkbench();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Helper
        implements ViewConfig3D,
        ItemCriterion {
            private View3D view;
            final /* synthetic */ Workbench val$w;

            Helper(Workbench workbench) {
                this.val$w = workbench;
            }

            @Override
            public Camera getCamera() {
                return this.view.getCamera();
            }

            @Override
            public Light getDefaultLight(Matrix4d matrix4d) {
                return View3D.getDefaultLight(this.getCamera(), matrix4d);
            }

            @Override
            public float getEpsilon() {
                return this.view.getEpsilon();
            }

            @Override
            public Graph getGraph() {
                return this.val$w.getRegistry().getProjectGraph();
            }

            @Override
            public Workbench getWorkbench() {
                return this.val$w;
            }

            @Override
            public boolean isInVisibleLayer(Object object, boolean bl, GraphState graphState) {
                return this.view.isInVisibleLayer(object, bl, graphState);
            }

            public String getRootDirectory() {
                return null;
            }

            public boolean isFulfilled(Item item, Object object) {
                return item instanceof Option && item.hasName("view") && item.getAxisParent() instanceof PanelFactory && "/ui/panels/3d/defaultview".equals(((PanelFactory)item.getAxisParent()).getFactorySource());
            }
        }
        Helper helper = new Helper(workbench);
        Item item = Item.findFirst((RegistryContext)context.getWorkbench(), (String)"/workbench/state", (ItemCriterion)helper, null, (boolean)false);
        if (item == null) {
            return null;
        }
        helper.view = (View3D)((Option)item).getObject();
        return helper;
    }

    public Light getDefaultLight(Matrix4d matrix4d) {
        return View3D.getDefaultLight(this.getCamera(), matrix4d);
    }

    public static Light getDefaultLight(Camera camera, Matrix4d matrix4d) {
        Math2.makeAffine((Matrix4d)matrix4d);
        Math2.invertAffine((Matrix4d)camera.getWorldToViewTransformation(), (Matrix4d)matrix4d);
        Point3d point3d = new Point3d(-3000.0, 3000.0, 10000.0);
        Vector3d vector3d = new Vector3d((Tuple3d)point3d);
        vector3d.negate();
        matrix4d.transform(point3d);
        matrix4d.transform(vector3d);
        Matrix3d matrix3d = new Matrix3d();
        Math2.getOrthogonalBasis((Tuple3d)vector3d, (Matrix3d)matrix3d, (boolean)true);
        matrix4d.set(matrix3d);
        matrix4d.m03 = point3d.x;
        matrix4d.m13 = point3d.y;
        matrix4d.m23 = point3d.z;
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setShadowless(true);
        directionalLight.getColor().set(1.0f, 1.0f, 1.0f);
        return directionalLight;
    }

    public void setExtent(Tuple3f tuple3f, float f) {
        if (tuple3f != null) {
            this.extentCenter.set(tuple3f);
            this.extentRadius = f;
        } else {
            this.extentRadius = Float.NaN;
        }
    }

    public ManageableType getManageableType() {
        return $TYPE;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public Navigator3DFactory getNavigator() {
        return this.navigator;
    }

    public void setNavigator(Navigator3DFactory navigator3DFactory) {
        navigator$FIELD.setObject((Object)this, (Object)navigator3DFactory);
    }

    static {
        $TYPE.validate();
    }

    public static class Type
    extends View.Type {
        private static final int SUPER_FIELD_COUNT = 6;
        protected static final int FIELD_COUNT = 8;

        public Type(Class clazz, SCOType sCOType) {
            super(clazz, sCOType);
        }

        public Type(View3D view3D, SCOType sCOType) {
            super((View)view3D, sCOType);
        }

        Type(Class clazz) {
            super(clazz, (SCOType)View.$TYPE);
        }

        static SCOType.Field _addManagedField(Type type, String string, int n, de.grogra.reflect.Type type2, de.grogra.reflect.Type type3, int n2) {
            return type.addManagedField(string, n, type2, type3, n2);
        }

        protected void setObject(Object object, int n, Object object2) {
            switch (n) {
                case 6: {
                    ((View3D)object).setCamera((Camera)object2);
                    return;
                }
                case 7: {
                    ((View3D)object).navigator = (Navigator3DFactory)((Object)object2);
                    return;
                }
            }
            super.setObject(object, n, object2);
        }

        protected Object getObject(Object object, int n) {
            switch (n) {
                case 6: {
                    return ((View3D)object).getCamera();
                }
                case 7: {
                    return ((View3D)object).getNavigator();
                }
            }
            return super.getObject(object, n);
        }

        public Object newInstance() {
            return new View3D();
        }
    }
}

