/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.xl.util.FloatList;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;

public abstract class VertexArray {
    public FloatList vertices = new FloatList();
    public int dimension;
    public Object userObject;
    private boolean cleared;

    public void init(int n) {
        this.clear();
        this.dimension = n;
    }

    public void freeArrays() {
        this.vertices.clear();
        this.vertices.trimToSize();
    }

    void clear() {
        this.vertices.clear();
        this.cleared = true;
    }

    public boolean wasCleared() {
        if (this.cleared) {
            this.cleared = false;
            return true;
        }
        return false;
    }

    public void computeNormal(float[] fArray, int n, int n2, int n3) {
        float[] fArray2 = this.vertices.elements;
        fArray[0] = (fArray2[(n2 *= this.dimension) + 1] - fArray2[(n *= this.dimension) + 1]) * (fArray2[(n3 *= this.dimension) + 2] - fArray2[n + 2]) - (fArray2[n2 + 2] - fArray2[n + 2]) * (fArray2[n3 + 1] - fArray2[n + 1]);
        fArray[1] = (fArray2[n2 + 2] - fArray2[n + 2]) * (fArray2[n3] - fArray2[n]) - (fArray2[n2] - fArray2[n]) * (fArray2[n3 + 2] - fArray2[n + 2]);
        fArray[2] = (fArray2[n2] - fArray2[n]) * (fArray2[n3 + 1] - fArray2[n + 1]) - (fArray2[n2 + 1] - fArray2[n + 1]) * (fArray2[n3] - fArray2[n]);
    }

    public int addVertex(float f, float f2, float f3) {
        this.vertices.push(f, f2, f3);
        return this.vertices.size() / 3 - 1;
    }

    public int addVertex(Tuple3f tuple3f) {
        this.vertices.push(tuple3f.x, tuple3f.y, tuple3f.z);
        return this.vertices.size() / 3 - 1;
    }

    public int addVertex(Tuple3d tuple3d) {
        this.vertices.push((float)tuple3d.x, (float)tuple3d.y, (float)tuple3d.z);
        return this.vertices.size() / 3 - 1;
    }
}

