/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.imp3d;

import de.grogra.imp3d.VertexArray;
import de.grogra.vecmath.geom.Mesh;
import de.grogra.xl.util.ByteList;
import de.grogra.xl.util.FloatList;
import de.grogra.xl.util.IntList;
import java.util.Arrays;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PolygonArray
extends VertexArray
implements Mesh {
    public FloatList uv = new FloatList();
    public ByteList normals = new ByteList();
    public IntList polygons = new IntList();
    public IntList polygonNormals = new IntList();
    public boolean usePolygonNormals = false;
    public int edgeCount;
    public boolean planar;
    public int visibleSides = 0;
    public boolean closed;

    public void freeArrays() {
        super.freeArrays();
        this.uv.clear();
        this.uv.trimToSize();
        this.normals.clear();
        this.normals.trimToSize();
        this.polygons.clear();
        this.polygons.trimToSize();
        this.polygonNormals.clear();
        this.polygonNormals.trimToSize();
    }

    void clear() {
        super.clear();
        this.uv.clear();
        this.normals.clear();
        this.polygons.clear();
        this.polygonNormals.clear();
        this.visibleSides = 0;
    }

    private static byte f2b(float f) {
        return f > 0.0f ? (byte)(127.5f * f) : (byte)(127.5f * f - 1.0f);
    }

    public void copyNormal(int n, int n2) {
        n *= 3;
        if (this.normals.size < (n2 *= 3) + 3) {
            this.normals.setSize(n2 + 3);
        }
        byte[] byArray = this.normals.elements;
        byArray[n2] = byArray[n];
        byArray[n2 + 1] = byArray[n + 1];
        byArray[n2 + 2] = byArray[n + 2];
    }

    /*
     * Unable to fully structure code
     */
    public void setNormal(int var1_1, float var2_2, float var3_3, float var4_4) {
        block9: {
            block8: {
                var8_5 = var2_2 * var2_2;
                var9_6 = var3_3 * var3_3;
                if (!(v0 > v1)) break block8;
                if (!(var8_5 > var4_4 * var4_4)) ** GOTO lbl-1000
                if (var2_2 > 0.0f) {
                    var5_7 = 127;
                    var8_5 = 1.0f / var2_2;
                    var6_8 = PolygonArray.f2b(var8_5 * var3_3);
                    var7_9 = PolygonArray.f2b(var8_5 * var4_4);
                } else {
                    var5_7 = -128;
                    var8_5 = -1.0f / var2_2;
                    var6_8 = PolygonArray.f2b(var8_5 * var3_3);
                    var7_9 = PolygonArray.f2b(var8_5 * var4_4);
                }
                break block9;
            }
            if (var9_6 > var4_4 * var4_4) {
                if (var3_3 > 0.0f) {
                    var6_8 = 127;
                    var8_5 = 1.0f / var3_3;
                    var5_7 = PolygonArray.f2b(var8_5 * var2_2);
                    var7_9 = PolygonArray.f2b(var8_5 * var4_4);
                } else {
                    var6_8 = -128;
                    var8_5 = -1.0f / var3_3;
                    var5_7 = PolygonArray.f2b(var8_5 * var2_2);
                    var7_9 = PolygonArray.f2b(var8_5 * var4_4);
                }
            } else if (var4_4 > 0.0f) {
                var7_9 = 127;
                var8_5 = 1.0f / var4_4;
                var5_7 = PolygonArray.f2b(var8_5 * var2_2);
                var6_8 = PolygonArray.f2b(var8_5 * var3_3);
            } else {
                var7_9 = -128;
                var8_5 = -1.0f / var4_4;
                var5_7 = PolygonArray.f2b(var8_5 * var2_2);
                var6_8 = PolygonArray.f2b(var8_5 * var3_3);
            }
        }
        this.normals.set(var1_1 *= 3, var5_7);
        this.normals.set(var1_1 + 1, var6_8);
        this.normals.set(var1_1 + 2, var7_9);
    }

    public void getNormal(float[] fArray, int n) {
        byte[] byArray = this.normals.elements;
        fArray[0] = (float)(2 * byArray[n *= 3] + 1) * 0.003921569f;
        fArray[1] = (float)(2 * byArray[n + 1] + 1) * 0.003921569f;
        fArray[2] = (float)(2 * byArray[n + 2] + 1) * 0.003921569f;
    }

    public int getPolygonCount() {
        return this.polygons.size / this.edgeCount;
    }

    public int getMaxEdgeCount() {
        return this.edgeCount;
    }

    public int getVertexCount() {
        return this.vertices.size / this.dimension;
    }

    public int getNormalCount() {
        return this.normals.size / this.dimension;
    }

    public boolean isPolygonPlanar(int n) {
        return this.planar;
    }

    public int getPolygon(int n, int[] nArray, int[] nArray2) {
        n *= this.edgeCount;
        int[] nArray3 = (this.usePolygonNormals ? this.polygonNormals : this.polygons).elements;
        for (int i = 0; i < this.edgeCount; ++i) {
            nArray[i] = this.polygons.elements[n + i];
            nArray2[i] = nArray3[n + i];
        }
        return this.edgeCount;
    }

    public void getVertex(int n, Tuple3d tuple3d) {
        tuple3d.x = this.vertices.elements[n *= this.dimension];
        tuple3d.y = this.vertices.elements[n + 1];
        tuple3d.z = this.dimension > 2 ? (double)this.vertices.elements[n + 2] : 0.0;
    }

    public void getNormal(int n, Tuple3d tuple3d) {
        byte[] byArray = this.normals.elements;
        tuple3d.x = (double)(2 * byArray[n *= 3] + 1) * 0.00392156862745098;
        tuple3d.y = (double)(2 * byArray[n + 1] + 1) * 0.00392156862745098;
        tuple3d.z = (double)(2 * byArray[n + 2] + 1) * 0.00392156862745098;
    }

    public void getUV(int n, Tuple2d tuple2d) {
        tuple2d.x = this.uv.elements[n <<= 1];
        tuple2d.y = this.uv.elements[n + 1];
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void computeNormals() {
        int n;
        assert (this.dimension == 3);
        assert (this.edgeCount >= 3);
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        float[] fArray = this.vertices.elements;
        int[] nArray = this.polygons.elements;
        float[] fArray2 = new float[this.vertices.size];
        Arrays.fill(fArray2, 0.0f);
        this.normals.clear();
        for (n = 0; n < this.polygons.size; n += this.edgeCount) {
            vector3f.set(fArray[3 * nArray[n + 0] + 0], fArray[3 * nArray[n + 0] + 1], fArray[3 * nArray[n + 0] + 2]);
            vector3f2.set(fArray[3 * nArray[n + 1] + 0], fArray[3 * nArray[n + 1] + 1], fArray[3 * nArray[n + 1] + 2]);
            vector3f3.set(fArray[3 * nArray[n + 2] + 0], fArray[3 * nArray[n + 2] + 1], fArray[3 * nArray[n + 2] + 2]);
            vector3f2.sub((Tuple3f)vector3f);
            vector3f3.sub((Tuple3f)vector3f);
            vector3f.cross(vector3f2, vector3f3);
            vector3f.normalize();
            for (int i = 0; i < this.edgeCount; ++i) {
                int n2 = 3 * nArray[n + i] + 0;
                fArray2[n2] = fArray2[n2] + vector3f.x;
                int n3 = 3 * nArray[n + i] + 1;
                fArray2[n3] = fArray2[n3] + vector3f.y;
                int n4 = 3 * nArray[n + i] + 2;
                fArray2[n4] = fArray2[n4] + vector3f.z;
            }
        }
        for (n = 0; n < fArray2.length; n += 3) {
            vector3f.set(fArray2[n + 0], fArray2[n + 1], fArray2[n + 2]);
            vector3f.normalize();
            vector3f.scale(127.0f);
            this.normals.add((byte)vector3f.x);
            this.normals.add((byte)vector3f.y);
            this.normals.add((byte)vector3f.z);
        }
    }
}

