/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.task;

import de.grogra.task.PartialTask;
import de.grogra.task.Solver;
import java.util.ArrayList;

public abstract class Task {
    private boolean stopped = false;
    private boolean solving = false;
    private final ArrayList<Solver> solvers = new ArrayList();
    private final ArrayList<Solver> idleSolvers = new ArrayList();

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void addSolver(Solver solver) {
        solver.initialize(this);
        this.solvers.add(solver);
        this.idleSolvers.add(solver);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSolver(Solver solver) {
        Task task = this;
        synchronized (task) {
            this.solvers.remove(solver);
            this.idleSolvers.remove(solver);
            PartialTask partialTask = solver.clearCurrentPartialTask();
            if (partialTask != null) {
                this.dispose(partialTask);
            }
            this.notifyAll();
        }
        solver.dispose();
    }

    public synchronized int getSolverCount() {
        return this.solvers.size();
    }

    protected abstract PartialTask nextPartialTask(int var1);

    protected abstract void dispose(PartialTask var1);

    public synchronized void partialTaskDone(Solver solver) {
        if (this.solvers.contains(solver)) {
            this.idleSolvers.add(solver);
        }
        this.dispose(solver.clearCurrentPartialTask());
        this.notifyAll();
    }

    protected abstract boolean done();

    public synchronized boolean isSolving() {
        return this.solving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void solve() {
        Object object = this;
        synchronized (object) {
            this.solving = true;
            this.prepareSolve();
        }
        try {
            while (true) {
                object = null;
                PartialTask partialTask = null;
                Task task = this;
                synchronized (task) {
                    int n;
                    if (this.stopped || this.done()) {
                        break;
                    }
                    if (!this.idleSolvers.isEmpty() && (n = this.solvers.indexOf(object = this.idleSolvers.get(0))) >= 0 && (partialTask = this.nextPartialTask(n)) != null) {
                        this.idleSolvers.remove(0);
                    }
                    if (partialTask == null) {
                        this.wait();
                    }
                }
                if (partialTask == null) continue;
                ((Solver)object).solve(partialTask);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
        finally {
            Task task = this;
            synchronized (task) {
                this.solving = false;
                this.finishSolve();
            }
        }
    }

    protected void prepareSolve() {
    }

    protected void finishSolve() {
    }

    public synchronized Solver[] getSolvers() {
        Solver[] solverArray = new Solver[this.solvers.size()];
        this.solvers.toArray(solverArray);
        return solverArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSolvers() {
        Solver[] solverArray = this.getSolvers();
        for (int i = 0; i < solverArray.length; ++i) {
            solverArray[i].dispose();
        }
        Task task = this;
        synchronized (task) {
            this.idleSolvers.clear();
            this.solvers.clear();
        }
    }
}

