/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing.modular;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import javax.vecmath.Color4f;

public class PathValues {
    public ArrayList<Intersection> intersecList;
    public ArrayList<Environment> envList;
    public ArrayList<Scattering> shaderList;
    public boolean[] specReflectionList;
    public boolean[] specRefractionList;
    public Light[] hitLights;
    public ArrayList<Line> rayListBE;
    public ArrayList<Spectrum> weightListBE;
    public ArrayList<Float> geometryFactorsBE;
    public float pathResultList;
    public Spectrum3d initialSpectrum = new Spectrum3d();
    public int pathLength;
    public Color4f color = new Color4f();
    public int creatorID;

    public void initialize(int n) {
        this.shaderList = new ArrayList(n);
        this.intersecList = new ArrayList(n);
        this.envList = new ArrayList(n);
        this.rayListBE = new ArrayList(n - 1);
        this.weightListBE = new ArrayList(n);
        this.geometryFactorsBE = new ArrayList(n);
        this.pathResultList = 0.0f;
        this.hitLights = new Light[n];
        this.specReflectionList = new boolean[n];
        this.specRefractionList = new boolean[n];
    }

    public void saveValues(int n, Line line, Intersection intersection, Environment environment, Spectrum spectrum, Scattering scattering, boolean bl, boolean bl2) {
        if (this.rayListBE.size() > n) {
            this.rayListBE.set(n, line);
        } else {
            this.rayListBE.add(n, line);
        }
        if (this.intersecList.size() > n) {
            this.intersecList.set(n, intersection);
        } else {
            this.intersecList.add(n, intersection);
        }
        if (this.envList.size() > n) {
            this.envList.set(n, environment);
        } else {
            this.envList.add(n, environment);
        }
        if (this.weightListBE.size() > n) {
            this.weightListBE.set(n, spectrum);
        } else {
            this.weightListBE.add(n, spectrum);
        }
        if (this.shaderList.size() > n) {
            this.shaderList.set(n, scattering);
        } else {
            this.shaderList.add(n, scattering);
        }
        this.specReflectionList[n] = bl;
        this.specRefractionList[n] = bl2;
    }

    public void saveProbabilityDensity(int n, float f) {
    }

    public void saveGeometryFactor(int n, float f) {
        if (this.geometryFactorsBE.size() > n) {
            this.geometryFactorsBE.set(n, new Float(f));
        } else {
            this.geometryFactorsBE.add(n, new Float(f));
        }
    }

    public void saveResult(float f) {
        this.pathResultList = f;
    }

    public void saveHitLight(int n, Light light) {
        this.hitLights[n] = light;
    }

    public String toString() {
        int n;
        String string = super.toString();
        string = string + "   SourceId=" + this.creatorID + "  Pathlength=" + this.pathLength + "\n";
        string = string + "   initialSpectrum=" + this.initialSpectrum + "\n";
        string = string + "   color=" + this.color + "\n";
        for (n = 0; n < this.pathLength; ++n) {
            string = string + "   envList[" + n + "]=" + this.envList.get((int)n).point + " --- " + "SpecularReflection[" + n + "]" + this.specReflectionList[n] + " SpecularRefraction[" + n + "]" + this.specRefractionList[n] + "\n";
        }
        for (n = 0; n < this.pathLength; ++n) {
            string = n < this.pathLength - 1 && n < this.rayListBE.size() - 1 ? string + "   rayListBE[" + n + "].direction=" + this.rayListBE.get((int)n).direction + "   DirDens[" + n + "]=" + this.rayListBE.get((int)n).directionDensity + "  ---  weightBE[" + n + "]=" + this.weightListBE.get(n) + "\n" : (this.pathLength == 1 ? string + "   rayListBE[" + n + "].direction=not set" + "  ---  weightBE[" + n + "]=" + this.weightListBE.get(0) + "\n" : string + "   rayListBE[" + n + "].direction=not set" + "  ---  weightBE[" + n + "]=not set" + "\n");
        }
        return string;
    }

    public void savePathLenght(int n) {
        this.pathLength = n;
    }

    public boolean isSpecular(int n) {
        if (n < 0 || n > this.pathLength - 1) {
            return false;
        }
        return this.specReflectionList[n] || this.specRefractionList[n];
    }
}

