/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray2.Scene;
import de.grogra.ray2.light.DefaultLightProcessor;
import de.grogra.ray2.radiosity.GroupListBuilder;
import de.grogra.ray2.radiosity.HemiCube;
import de.grogra.ray2.radiosity.MyMeshVolume;
import de.grogra.ray2.radiosity.OptionReader;
import de.grogra.ray2.radiosity.PatchGroup;
import de.grogra.ray2.radiosity.RadiosityAlgorithm;
import de.grogra.ray2.radiosity.triangulation.TriangulationException;
import de.grogra.ray2.radiosity.triangulation.Triangulizer;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.RayProcessorBase;
import de.grogra.vecmath.geom.CellIterator;
import de.grogra.vecmath.geom.DefaultCellIterator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.OctreeUnion;
import de.grogra.vecmath.geom.Volume;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class Radiosity
extends RayProcessorBase {
    private static final int OCTREEMAXDEPTH = 5;
    private static final int OCTREEMINOBJECTS = 2;
    private boolean hemiCubeCreated = false;
    private boolean radiosityCalc = false;
    private Vector<PatchGroup> groups = new Vector();
    private Tuple3d sumColor = new Point3d();
    private static OctreeUnion octree = new OctreeUnion();
    private static int groupSize = -1;
    private static int iterations = -1;

    public Radiosity() {
        DefaultLightProcessor defaultLightProcessor = new DefaultLightProcessor();
        this.setLightProcessor(defaultLightProcessor);
    }

    public void getColorFromRay(Line line, Spectrum spectrum, Color4f color4f, Random random) {
        ++this.primaryCount;
        this.ilist.clear();
        color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
        octree.computeIntersections(line, 1, this.ilist, null, null);
        if (this.ilist.size == 0) {
            return;
        }
        this.sumColor.set(0.0, 0.0, 0.0);
        float f = this.traceRay(1, this.ilist.elements[0], spectrum, this.sumColor, this.locals.nextReflected(), random);
        this.sumColor.scale((double)this.getBrightness());
        color4f.x = (float)this.sumColor.x;
        color4f.y = (float)this.sumColor.y;
        color4f.z = (float)this.sumColor.z;
        color4f.w = f < 1.0f ? 1.0f - f : 0.0f;
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        OptionReader optionReader = new OptionReader(pixelwiseRenderer);
        if (optionReader.isHemicubeCalcNeeded()) {
            HemiCube.init(optionReader.getCubeWidth());
            this.hemiCubeCreated = true;
        }
        if (optionReader.isRadiosityCalcNeeded(scene)) {
            HemiCube.setWorldWide(optionReader.getHemiWorldWide());
            this.groups.clear();
            octree = new OctreeUnion();
            this.computePatches(scene);
            RadiosityAlgorithm radiosityAlgorithm = new RadiosityAlgorithm(pixelwiseRenderer);
            radiosityAlgorithm.calculateScene(this.groups, optionReader.getSubdivthreshold(), optionReader.getMaxsubdivdepth(), optionReader.getThreadCount());
            this.createSceneOctree();
            this.radiosityCalc = true;
            groupSize = this.groups.size();
            iterations = radiosityAlgorithm.getSteps();
        }
        optionReader.calcFinished(scene);
        super.initialize(pixelwiseRenderer, scene);
    }

    private void computePatches(Scene scene) {
        ArrayList arrayList = scene.getOctree().volumes;
        GroupListBuilder groupListBuilder = new GroupListBuilder();
        for (Volume volume : arrayList) {
            try {
                Triangulizer.triangulize(groupListBuilder, scene, volume);
            }
            catch (TriangulationException triangulationException) {
                triangulationException.printStackTrace();
            }
        }
        Light[] lightArray = scene.getLights();
        for (int i = 0; i < lightArray.length; ++i) {
            try {
                Triangulizer.triangulize(groupListBuilder, scene, i);
                continue;
            }
            catch (TriangulationException triangulationException) {
                triangulationException.printStackTrace();
            }
        }
        this.groups = groupListBuilder.getGroups();
    }

    private void createSceneOctree() {
        for (PatchGroup patchGroup : this.groups) {
            MyMeshVolume[] myMeshVolumeArray = patchGroup.createMesh();
            if (myMeshVolumeArray == null) continue;
            for (int i = 0; i < myMeshVolumeArray.length; ++i) {
                Radiosity.octree.volumes.add(myMeshVolumeArray[i]);
            }
        }
        octree.initialize(5, 2, (CellIterator)new DefaultCellIterator());
    }

    int getEnvironmentType() {
        return 0;
    }

    float traceRay(int n, Intersection intersection, Spectrum spectrum, Tuple3d tuple3d, RayProcessorBase.Locals locals, Random random) {
        if (!(intersection.volume instanceof MyMeshVolume)) {
            System.err.println("Radiosity.traceRay(): ERROR! no Mesh found");
            return 0.0f;
        }
        MyMeshVolume myMeshVolume = (MyMeshVolume)intersection.volume;
        tuple3d.set((double)myMeshVolume.getMeshColor().x, (double)myMeshVolume.getMeshColor().y, (double)myMeshVolume.getMeshColor().z);
        return 0.0f;
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append("Radiosity Statistics\n");
        stringBuffer.append("    HemiCube created        : " + (this.hemiCubeCreated ? "yes" : "no") + "\n");
        stringBuffer.append("    Radiosity calculated    : " + (this.radiosityCalc ? "yes" : "no") + "\n");
        stringBuffer.append("    Number of PatchGroups   : " + groupSize + "\n");
        stringBuffer.append("    Number of Triangles     : " + groupSize * 4 + "\n");
        stringBuffer.append("    Number of Iterations    : " + iterations + "\n");
    }
}

