/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.tracing;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.BidirectionalRenderer;
import de.grogra.ray2.tracing.PathTracer;
import de.grogra.ray2.tracing.PixelwiseRenderer;
import de.grogra.ray2.tracing.RayProcessor;
import de.grogra.ray2.tracing.modular.CausticMap;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.ray2.tracing.modular.ComplementTracer;
import de.grogra.ray2.tracing.modular.LineTracer;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.ray2.tracing.modular.TracingMediator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.Random;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class BiDirectionalProcessor
extends PathTracer {
    public static final String EYEPATH_DEPTH = "BidirectionalPathTracer/eyeDepth";
    public static final String LIGHTPATH_DEPTH = "BidirectionalPathTracer/lightDepth";
    public static final String HEURISTIC_FACTOR = "BidirectionalPathTracer/heuristicFactor";
    public TracingMediator tracingMediator;
    public CausticMap loacalCausticMap = null;
    public boolean isMetropolis = false;
    static final double EPSILON = 1.0E-4;
    static final int ERROR = -1;
    static final float DELTA_FACTOR = 1.0E10f;
    static final float maxVal = 3.4028235E37f;
    static final float minVal = 1.4E-44f;
    boolean debugOutput = false;
    boolean lastDebugOutput = false;
    boolean wasWrong = false;
    RayList tmpRayList;
    Environment tmpEnv;
    int heuristicExponent = 0;
    int eyePathDepth = 0;
    int lightPathDepth = 0;
    int totalLightCount;
    int lightIndex;
    public LineTracer lineTracer;
    ComplementTracer complementTracer;
    double[] probDensArray;
    Random random;
    Random rand;
    PathValues eyePathValues;
    PathValues[] lightPathValues;
    CombinedPathValues combinedPath;
    float combinedProbDensEL = 0.0f;
    float combinedProbDensLE = 0.0f;
    Color3f sumColor = new Color3f();
    Color3f tmpColor1 = new Color3f();
    Color3f tmpColor2 = new Color3f();
    Vector3f tmpVector1 = new Vector3f();
    Vector3f tmpVector2 = new Vector3f();
    Vector3f tmpVector3 = new Vector3f();
    Vector3f tmpVector4 = new Vector3f();
    Line tmpLine = new Line();
    Vector3d tmpVectorD1 = new Vector3d();
    Point3d tmpPoint1 = new Point3d();
    RayList tmpRays = new RayList();
    int loopIndex1;
    int loopIndex2;
    private float transparency;
    private int pathLength;
    private int indexS;
    private int indexT;
    private Point3d combinedBSDFSpectrum = new Point3d();
    private Spectrum bsdfL_Spec;
    private Spectrum bsdfE_Spec;
    private float combinedBSDFSpec_Distsq;
    private int tmpSize;
    private double p_pre;
    private double next;
    private float prob;
    private float geomFac;
    public int bestS;
    public int bestT;
    public int bestLight;
    private Tuple3d maxWeight;

    public RayProcessor dup(Scene scene) {
        BiDirectionalProcessor biDirectionalProcessor = (BiDirectionalProcessor)this.clone();
        biDirectionalProcessor.lightProcessor = this.lightProcessor.dup(scene);
        biDirectionalProcessor.scene = scene;
        biDirectionalProcessor.initLocals();
        biDirectionalProcessor.initialize(this.renderer, scene);
        return biDirectionalProcessor;
    }

    public void initialize(PixelwiseRenderer pixelwiseRenderer, Scene scene) {
        super.initialize(pixelwiseRenderer, scene);
        this.rand = new Random(100L);
        this.maxWeight = new Spectrum3d();
        this.lineTracer = new LineTracer(this);
        this.lineTracer.initialize(pixelwiseRenderer, scene);
        this.complementTracer = new ComplementTracer(scene, this.random);
        Light[] lightArray = scene.getLights();
        this.totalLightCount = lightArray.length;
        this.lightPathValues = new PathValues[this.totalLightCount];
        this.eyePathDepth = pixelwiseRenderer.getNumericOption(EYEPATH_DEPTH, 10).intValue();
        assert (this.eyePathDepth > 1);
        this.lightPathDepth = pixelwiseRenderer.getNumericOption(LIGHTPATH_DEPTH, 10).intValue();
        assert (this.lightPathDepth > 1);
        this.heuristicExponent = pixelwiseRenderer.getNumericOption(HEURISTIC_FACTOR, 2).intValue();
        assert (this.heuristicExponent >= 0);
        System.err.println(" BdiPoc: initialize: heuristicExponent=" + this.heuristicExponent);
        this.eyePathValues = new PathValues();
        this.eyePathValues.initialize(this.eyePathDepth);
        this.eyePathValues.creatorID = -1;
        for (int i = 0; i < this.totalLightCount; ++i) {
            this.lightPathValues[i] = new PathValues();
            this.lightPathValues[i].initialize(this.lightPathDepth);
            this.lightPathValues[i].creatorID = i;
        }
        this.combinedPath = new CombinedPathValues();
        this.combinedPath.initialize(this.eyePathDepth + this.lightPathDepth);
        this.probDensArray = new double[this.eyePathDepth + this.lightPathDepth + 1];
        this.tracingMediator = new TracingMediator();
        this.tracingMediator.setRenderer(pixelwiseRenderer);
        this.tracingMediator.setAntialiser(pixelwiseRenderer.antialiasing);
        this.tracingMediator.setComplementTracer(this.complementTracer);
        this.tracingMediator.setLinetracer(this.lineTracer);
        this.tracingMediator.setProcessor(this);
        this.bsdfL_Spec = scene.createSpectrum();
        this.bsdfE_Spec = scene.createSpectrum();
        this.tmpRayList = new RayList();
        this.tmpEnv = new Environment(scene.getBoundingBox(), scene.createSpectrum(), this.getEnvironmentType());
    }

    public void initializeBeforeTracing(Random random) {
        this.lineTracer.setRandom(random);
        this.random = random;
        this.lineTracer.setSafeMemoryMode(null);
        Light[] lightArray = this.scene.getLights();
        this.totalLightCount = lightArray.length;
    }

    public void getColorFromRay(Line line, Spectrum spectrum, Color4f color4f, Random random) {
        this.bestS = -1;
        this.bestT = -1;
        this.bestLight = -1;
        this.maxWeight.set(-1.0, -2.0, -3.0);
        this.lineTracer.setSafeMemoryMode(null);
        this.lastDebugOutput = this.debugOutput;
        this.debugOutput = PixelwiseRenderer.DEBUG_SUBPIXEL;
        this.ilist.clear();
        this.sumColor.set(0.0f, 0.0f, 0.0f);
        this.traceEyePath(line, spectrum);
        Light[] lightArray = this.scene.getLights();
        if (this.eyePathValues.pathLength >= 1) {
            this.lightIndex = 0;
            while (this.lightIndex < lightArray.length) {
                this.tmpRayList.clear();
                this.tmpRayList.setSize(1);
                this.tmpEnv.localToGlobal.set(this.scene.getLightTransformation(this.lightIndex));
                this.tmpEnv.globalToLocal.set(this.scene.getInverseLightTransformation(this.lightIndex));
                Light light = lightArray[this.lightIndex];
                if (light.getLightType() != 0) {
                    light.generateRandomOrigins(this.tmpEnv, this.tmpRayList, random);
                    light.generateRandomRays(this.tmpEnv, null, this.tmpRayList.rays[0].spectrum, this.tmpRayList, false, random);
                    Line line2 = this.tmpRayList.rays[0].convert2Line();
                    Spectrum spectrum2 = this.tmpRayList.rays[0].spectrum;
                    this.traceLightPath(line2, this.lightIndex, spectrum2);
                    if (this.lightPathValues[this.lightIndex].pathLength >= 1) {
                        this.sumColor.add((Tuple3f)this.combineEyeAndLightPath());
                    }
                }
                ++this.lightIndex;
            }
        }
        this.sumColor.scale(this.getBrightness());
        color4f.x = this.sumColor.x;
        color4f.y = this.sumColor.y;
        color4f.z = this.sumColor.z;
        this.transparency = this.eyePathValues.pathResultList;
        float f = color4f.w = this.transparency < 1.0f ? 1.0f - this.transparency : 0.0f;
        if (this.loacalCausticMap != null) {
            int n = (int)this.eyePathValues.rayListBE.get((int)0).x;
            int n2 = (int)this.eyePathValues.rayListBE.get((int)0).y;
            this.loacalCausticMap.saveColor(null, n, n2);
        }
    }

    PathValues traceEyePath(Line line, Spectrum spectrum) {
        this.pathLength = this.determinePathLengthRandomly(this.eyePathDepth);
        return this.lineTracer.traceLine(this.pathLength, this.eyePathValues, line, spectrum, 0, false, this.random);
    }

    PathValues traceLightPath(Line line, int n, Spectrum spectrum) {
        this.pathLength = this.determinePathLengthRandomly(this.lightPathDepth);
        return this.lineTracer.traceLine(this.pathLength, this.lightPathValues[n], line, spectrum, n, true, this.random);
    }

    Color3f combineEyeAndLightPath() {
        this.tmpColor1.set(0.0f, 0.0f, 0.0f);
        this.indexS = -1;
        while (this.indexS < this.lightPathValues[this.lightIndex].pathLength) {
            Environment environment = null;
            Intersection intersection = null;
            if (this.indexS >= 0) {
                environment = this.lightPathValues[this.lightIndex].envList.get(this.indexS);
                intersection = this.lightPathValues[this.lightIndex].intersecList.get(this.indexS);
            }
            this.indexT = 0;
            while (this.indexT < this.eyePathValues.pathLength) {
                Light light;
                Environment environment2 = this.eyePathValues.envList.get(this.indexT);
                Intersection intersection2 = this.eyePathValues.intersecList.get(this.indexT);
                if (this.indexS < 0 && (light = this.eyePathValues.hitLights[this.indexT]) != null && !light.isIgnoredWhenHit() && light.getLightType() != 0) {
                    Point3d point3d = this.lightSourceWasDirectlyHit(this.indexT, light);
                    double d = 1.0f / (float)(this.indexT + 1);
                    point3d.scale(d);
                    this.tmpColor1.x = (float)((double)this.tmpColor1.x + point3d.x);
                    this.tmpColor1.y = (float)((double)this.tmpColor1.y + point3d.y);
                    this.tmpColor1.z = (float)((double)this.tmpColor1.z + point3d.z);
                }
                if (this.indexS >= 0 && (this.isVisible(environment2, intersection2, environment, intersection, this.indexS, this.indexT) || this.indexT == 0 && this.isVisible(environment, null, environment2, null, this.indexT, this.indexS))) {
                    if (this.debugOutput) {
                        System.err.println("BiDiProcessor: combineEyeAndLightPath: Visble at s: " + this.indexS + " -- t:" + this.indexT + "  total = s+t+2=" + (this.indexS + this.indexT + 2));
                    }
                    this.complementTracer.complement2Paths(this.lightPathValues[this.lightIndex], this.indexS, this.eyePathValues, this.indexT, false, this.combinedPath);
                    if (this.combinedPath.isValid()) {
                        if (this.debugOutput) {
                            System.err.println("BiDiProcessor: combineE&LPath: after Complementing!");
                            System.err.println("  lightPath:" + this.lightPathValues[this.lightIndex]);
                            System.err.println("*****************************************************");
                            System.err.println("  eyePath:" + this.eyePathValues);
                            System.err.println("*****************************************************");
                            System.err.println("  combinedPath:" + this.combinedPath);
                        }
                        light = this.combine2Paths(this.indexS, this.indexT);
                        if (((Tuple3d)light).x + ((Tuple3d)light).y + ((Tuple3d)light).z > (double)1.0E-4f) {
                            if (this.debugOutput) {
                                System.err.println("BiDiProcessor: combineE&LPath: unWeightedSpec=" + light);
                            }
                            if (this.isMetropolis) {
                                this.chooseBestPathCombination(this.indexS, this.indexT, this.lightIndex, (Tuple3d)light);
                            } else {
                                float f = this.calcWeighteningFactor(this.indexS, this.indexT);
                                if (this.debugOutput) {
                                    System.err.println("BiDiProcessor: combineE&LPath: w_st=" + f + "    w_st_reciprocal=" + 1.0f / f);
                                }
                                light.scale(f);
                                if (this.indexT == 0 && this.loacalCausticMap != null && !this.combinedPath.isSpecular(this.indexS)) {
                                    Color4f color4f = new Color4f();
                                    color4f.x = (float)((Tuple3d)light).x;
                                    color4f.y = (float)((Tuple3d)light).y;
                                    color4f.z = (float)((Tuple3d)light).z;
                                    color4f.scale(this.getBrightness());
                                    float f2 = 1.0E-4f;
                                    color4f.w = f2 < 1.0f ? 1.0f - f2 : 0.0f;
                                    float[] fArray = ((BidirectionalRenderer)this.renderer).getPixelsForLine2Vertex(this.eyePathValues.envList.get(0), new Point3d(this.lightPathValues[this.lightIndex].envList.get((int)this.indexS).point));
                                    if (fArray[0] >= 0.0f && fArray[1] >= 0.0f) {
                                        this.loacalCausticMap.saveColor(color4f, (int)fArray[0], (int)fArray[1]);
                                    }
                                } else {
                                    this.tmpColor1.x = (float)((double)this.tmpColor1.x + ((Tuple3d)light).x);
                                    this.tmpColor1.y = (float)((double)this.tmpColor1.y + ((Tuple3d)light).y);
                                    this.tmpColor1.z = (float)((double)this.tmpColor1.z + ((Tuple3d)light).z);
                                }
                            }
                        } else if (this.debugOutput) {
                            System.err.println("BiDiProcessor: combineE&LPath: Combine Color is ZERO!!!!!!! s=" + this.indexS + "   t=" + this.indexT);
                        }
                    }
                }
                ++this.indexT;
            }
            ++this.indexS;
        }
        return this.tmpColor1;
    }

    boolean isVisible(Environment environment, Intersection intersection, Environment environment2, Intersection intersection2, int n, int n2) {
        this.tmpVector1.sub((Tuple3f)environment.point, (Tuple3f)environment2.point);
        this.tmpLine.origin.set((Tuple3f)environment2.point);
        this.tmpLine.setLineAttributes(0.0, Double.POSITIVE_INFINITY);
        this.tmpVector1.normalize();
        this.tmpLine.direction.set((Tuple3f)this.tmpVector1);
        this.tmpSize = this.ilist.size;
        if (n != 0 && this.tmpVector1.dot(environment2.normal) == 0.0f) {
            return false;
        }
        Intersection intersection3 = null;
        this.scene.computeIntersections(this.tmpLine, 1, this.ilist, intersection3, null);
        if (this.ilist.size > this.tmpSize) {
            Intersection intersection4 = this.ilist.elements[this.tmpSize];
            this.tmpPoint1.set((Tuple3f)environment.point);
            double d = intersection4.getPoint().distance(this.tmpPoint1);
            if (d <= 1.0E-4) {
                return true;
            }
        }
        return false;
    }

    Tuple3d combine2Paths(int n, int n2) {
        Spectrum3d spectrum3d;
        this.combinedBSDFSpectrum.set(0.0, 0.0, 0.0);
        Scattering scattering = this.eyePathValues.shaderList.get(n2);
        Scattering scattering2 = this.lightPathValues[this.lightIndex].shaderList.get(n);
        Environment environment = this.eyePathValues.envList.get(n2);
        Environment environment2 = this.lightPathValues[this.lightIndex].envList.get(n);
        Spectrum3d spectrum3d2 = n > 0 ? this.lightPathValues[this.lightIndex].weightListBE.get(n - 1) : this.lightPathValues[this.lightIndex].initialSpectrum;
        Spectrum spectrum = spectrum3d = n2 > 0 ? this.eyePathValues.weightListBE.get(n2 - 1) : this.eyePathValues.initialSpectrum;
        if (n2 > 0) {
            this.tmpVector3.set((Tuple3d)this.eyePathValues.rayListBE.get((int)(n2 - 1)).direction);
        } else {
            this.tmpVector3.set(0.0f, 0.0f, 0.0f);
        }
        this.tmpVector3.negate();
        if (n > 0) {
            this.tmpVector4.set((Tuple3d)this.lightPathValues[this.lightIndex].rayListBE.get((int)(n - 1)).direction);
        } else {
            this.tmpVector4.set(0.0f, 0.0f, 0.0f);
        }
        this.tmpVector4.negate();
        this.tmpVector1.sub((Tuple3f)environment2.point, (Tuple3f)environment.point);
        this.tmpVector1.normalize();
        this.tmpVector2.sub((Tuple3f)environment.point, (Tuple3f)environment2.point);
        this.tmpVector2.normalize();
        this.combinedProbDensLE = scattering2.computeBSDF(environment2, this.tmpVector4, spectrum3d2, this.tmpVector2, false, this.bsdfL_Spec);
        this.combinedBSDFSpec_Distsq = Math.max(1.0f, environment.point.distanceSquared(environment2.point));
        try {
            this.combinedProbDensEL = scattering.computeBSDF(environment, this.tmpVector3, spectrum3d, this.tmpVector1, true, this.bsdfE_Spec);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.bsdfE_Spec.set(spectrum3d);
        }
        this.bsdfE_Spec.dot(this.bsdfL_Spec, (Tuple3d)this.combinedBSDFSpectrum);
        this.combinedBSDFSpectrum.scale((double)(1.0f / this.combinedBSDFSpec_Distsq));
        if (this.eyePathValues.isSpecular(n2)) {
            this.combinedBSDFSpectrum.scale((double)1.0E-10f);
        }
        if (this.lightPathValues[this.lightIndex].isSpecular(n)) {
            this.combinedBSDFSpectrum.scale((double)1.0E-10f);
        }
        return this.combinedBSDFSpectrum;
    }

    float calcWeighteningFactor(int n, int n2) {
        this.probDensArray[n + 1] = this.p_pre = 1.0;
        this.loopIndex1 = n + 1;
        while (this.loopIndex1 <= n + n2 + 1) {
            this.p_pre = this.probDensArray[this.loopIndex1];
            this.probDensArray[this.loopIndex1 + 1] = (double)this.getEnumerator(this.loopIndex1, n, n2) * this.p_pre / (double)this.getDenomirator(this.loopIndex1, n, n2);
            ++this.loopIndex1;
        }
        this.loopIndex1 = n;
        while (this.loopIndex1 >= 0) {
            this.p_pre = this.probDensArray[this.loopIndex1 + 1];
            this.probDensArray[this.loopIndex1] = (double)this.getDenomirator(this.loopIndex1, n, n2) * this.p_pre / (double)this.getEnumerator(this.loopIndex1, n, n2);
            --this.loopIndex1;
        }
        float f = 0.0f;
        this.loopIndex1 = 1;
        while (this.loopIndex1 < n + n2 + 2) {
            if (this.debugOutput) {
                System.err.println("BiDiProcessor:calcWeightFac:    pD[" + this.loopIndex1 + "]=" + this.probDensArray[this.loopIndex1] + "   heuristicFac=" + this.heuristicExponent);
            }
            this.next = Math.pow(this.probDensArray[this.loopIndex1], this.heuristicExponent);
            f = (float)((double)f + this.next);
            ++this.loopIndex1;
        }
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            // empty if block
        }
        return 1.0f / f;
    }

    float getEnumerator(int n, int n2, int n3) {
        if (n == 0) {
            this.prob = 1.0E10f;
            this.geomFac = 1.0f;
        } else {
            this.prob = ((Line)this.combinedPath.rayListBE.get((int)(n - 1))).directionDensity;
            this.geomFac = ((Float)this.combinedPath.geometryFactorsBE.get(n - 1)).floatValue();
        }
        if (this.debugOutput) {
            System.err.println("BiDiPoc_ver2:getEnumerator() index = " + n + " ProbDens=" + this.prob + "  GeomFac=" + this.geomFac);
        }
        if (this.prob * this.geomFac == 0.0f) {
            // empty if block
        }
        return this.prob * this.geomFac;
    }

    float getDenomirator(int n, int n2, int n3) {
        if (n == n2 + n3 + 1) {
            this.prob = 1.0E10f;
            this.geomFac = 1.0f;
        } else {
            this.prob = this.combinedPath.rayListEB.get((int)n).directionDensity;
            this.geomFac = this.combinedPath.geometryFactorsEB.get(n).floatValue();
        }
        if (this.debugOutput) {
            System.err.println("BiDiPoc_ver2:getDenomirator() index = " + n + " ProbDens=" + this.prob + "  GeomFac=" + this.geomFac);
        }
        return this.prob * this.geomFac;
    }

    Point3d lightSourceWasDirectlyHit(int n, Light light) {
        Environment environment = this.eyePathValues.envList.get(n);
        Spectrum spectrum = this.eyePathValues.weightListBE.get(n - 1);
        int n2 = -1;
        for (int i = 0; i < this.scene.getLights().length; ++i) {
            if (light != this.scene.getLights()[i]) continue;
            n2 = i;
        }
        environment.localToGlobal.set(this.scene.getLightTransformation(n2));
        environment.globalToLocal.set(this.scene.getInverseLightTransformation(n2));
        light.computeExitance(environment, this.bsdfE_Spec);
        this.tmpVector1.set((Tuple3d)this.eyePathValues.rayListBE.get((int)(n - 1)).direction);
        this.tmpVector1.negate();
        light.computeBSDF(environment, null, this.bsdfE_Spec, this.tmpVector1, true, this.bsdfL_Spec);
        this.tmpPoint1.set(0.0, 0.0, 0.0);
        this.bsdfL_Spec.dot(spectrum, (Tuple3d)this.tmpPoint1);
        return this.tmpPoint1;
    }

    int determinePathLengthRandomly(int n) {
        return n;
    }

    void correctSpecularReflection(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < n + n2 + 2; ++i) {
            bl = false;
            bl = this.combinedPath.isSpecular(i);
            if (!bl) continue;
            this.probDensArray[i] = 0.0;
            this.probDensArray[i + 1] = 0.0;
        }
    }

    public void chooseBestPathCombination(int n, int n2, int n3, Tuple3d tuple3d) {
        double d = this.maxWeight.x + this.maxWeight.y + this.maxWeight.z;
        double d2 = tuple3d.x + tuple3d.y + tuple3d.z;
        if (d < d2) {
            this.bestS = n;
            this.bestT = n2;
            this.bestLight = n3;
            this.maxWeight.set(tuple3d);
        }
    }

    protected void appendStatisticsImpl(StringBuffer stringBuffer) {
        stringBuffer.append("Bidirectional Path Tracing Statistics:\n");
    }
}

