/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.radiosity;

import de.grogra.ray2.radiosity.FormFactor;
import de.grogra.ray2.radiosity.MyMeshVolume;
import de.grogra.ray2.radiosity.Vector3d;
import de.grogra.vecmath.geom.Mesh;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubPatch
implements Mesh {
    private static final double oneThird = 0.3333333333333333;
    private Vector3d[] vertices;
    private Map<SubPatch, FormFactor> ffMap = null;
    private Color3f radiosity = new Color3f();

    public SubPatch(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.vertices = new Vector3d[3];
        this.vertices[0] = vector3d;
        this.vertices[1] = vector3d2;
        this.vertices[2] = vector3d3;
        this.ffMap = new HashMap<SubPatch, FormFactor>();
    }

    public SubPatch(SubPatch subPatch) {
        this.vertices = new Vector3d[3];
        this.vertices[0] = (Vector3d)((Object)subPatch.vertices[0].clone());
        this.vertices[1] = (Vector3d)((Object)subPatch.vertices[1].clone());
        this.vertices[2] = (Vector3d)((Object)subPatch.vertices[2].clone());
        this.radiosity = subPatch.radiosity;
    }

    public Map<SubPatch, FormFactor> getFFMap() {
        return this.ffMap;
    }

    public void clearFFMap() {
        this.ffMap.clear();
    }

    public void setRadiosity(Color3f color3f) {
        this.radiosity.x = color3f.x;
        this.radiosity.y = color3f.y;
        this.radiosity.z = color3f.z;
    }

    public void setRadiosity(float f, float f2, float f3) {
        this.radiosity.x = f;
        this.radiosity.y = f2;
        this.radiosity.z = f3;
    }

    public Color3f getRadiosity() {
        return this.radiosity;
    }

    public void set(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        this.vertices[0] = vector3d;
        this.vertices[1] = vector3d2;
        this.vertices[2] = vector3d3;
    }

    public Vector3d getCenter() {
        Vector3d vector3d = new Vector3d();
        vector3d.add((Tuple3d)this.vertices[0]);
        vector3d.add((Tuple3d)this.vertices[1]);
        vector3d.add((Tuple3d)this.vertices[2]);
        vector3d.scale(0.3333333333333333);
        return vector3d;
    }

    public Vector3d getNormal() {
        Vector3d vector3d = new Vector3d((Tuple3d)this.vertices[2]);
        vector3d.sub((Tuple3d)this.vertices[0]);
        Vector3d vector3d2 = new Vector3d((Tuple3d)this.vertices[1]);
        vector3d2.sub((Tuple3d)this.vertices[0]);
        vector3d.cross(vector3d, vector3d2);
        vector3d.scale(1.0 / vector3d.length());
        return vector3d;
    }

    public boolean isTriangle() {
        return true;
    }

    public Vector3d[] getVertices() {
        return this.vertices;
    }

    public void move(Vector3d vector3d) {
        for (int i = 0; i < 3; ++i) {
            this.vertices[i].add((Tuple3d)vector3d);
        }
    }

    public void rotateX(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int i = 0; i < 3; ++i) {
            this.vertices[i].rotateX(d2, d3);
        }
    }

    public void rotateY(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int i = 0; i < 3; ++i) {
            this.vertices[i].rotateY(d2, d3);
        }
    }

    public void rotateZ(double d) {
        double d2 = Math.sin(d);
        double d3 = Math.cos(d);
        for (int i = 0; i < 3; ++i) {
            this.vertices[i].rotateZ(d2, d3);
        }
    }

    public float getMaxRadDifference(SubPatch subPatch) {
        float f = Math.abs(this.radiosity.x - subPatch.getRadiosity().x);
        float f2 = Math.abs(this.radiosity.y - subPatch.getRadiosity().y);
        float f3 = Math.abs(this.radiosity.z - subPatch.getRadiosity().z);
        return Math.max(Math.max(f, f2), f3);
    }

    public String toString() {
        String string = "a=" + (Object)((Object)this.vertices[0]) + "\n" + "b=" + (Object)((Object)this.vertices[1]) + "\n" + "c=" + (Object)((Object)this.vertices[2]);
        return string;
    }

    public MyMeshVolume createMesh() {
        MyMeshVolume myMeshVolume = new MyMeshVolume();
        myMeshVolume.setMesh(this);
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        myMeshVolume.setTransformation(matrix4d);
        return myMeshVolume;
    }

    public boolean ffMapContains(List<SubPatch> list) {
        for (SubPatch subPatch : list) {
            if (!this.ffMap.containsKey(subPatch)) continue;
            return true;
        }
        return false;
    }

    public int getMaxEdgeCount() {
        return 3;
    }

    public void getNormal(int n, Tuple3d tuple3d) {
        Vector3d vector3d = this.getNormal();
        tuple3d.x = vector3d.x;
        tuple3d.y = vector3d.y;
        tuple3d.z = vector3d.z;
    }

    public int getNormalCount() {
        return 1;
    }

    public int getPolygon(int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < 3; ++i) {
            nArray[i] = i;
        }
        nArray2[0] = 0;
        return 3;
    }

    public int getPolygonCount() {
        return 1;
    }

    public void getUV(int n, Tuple2d tuple2d) {
    }

    public void getVertex(int n, Tuple3d tuple3d) {
        tuple3d.x = this.vertices[n].x;
        tuple3d.y = this.vertices[n].y;
        tuple3d.z = this.vertices[n].z;
    }

    public int getVertexCount() {
        return 3;
    }

    public boolean isPolygonPlanar(int n) {
        return true;
    }

    public boolean isClosed() {
        return false;
    }
}

