/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.photonmap;

import de.grogra.ray2.Scene;
import de.grogra.ray2.tracing.PixelwiseRenderer;

public class OptionReader {
    private static final String GLOBALPHOTONCOUNT = "photonmapping/globalcount";
    private static final String CAUSTICPHOTONCOUNT = "photonmapping/causticcount";
    private static final String PHOTONAREA = "photonmapping/area";
    private static final String PHOTONDEPTH = "photonmapping/depth";
    private static int oldGlobalPhotonCount = -1;
    private static int oldCausticPhotonCount = -1;
    private static String oldUniqueName = null;
    private static int oldStamp = -1;
    private static int oldDepth = -1;
    private int globalPhotonCount;
    private int causticPhotonCount;
    private int photonDepth;
    private double photonArea;

    public OptionReader(PixelwiseRenderer pixelwiseRenderer) {
        this.globalPhotonCount = pixelwiseRenderer.getNumericOption(GLOBALPHOTONCOUNT, 200000).intValue();
        assert (this.globalPhotonCount >= 0);
        this.causticPhotonCount = pixelwiseRenderer.getNumericOption(CAUSTICPHOTONCOUNT, 100000).intValue();
        assert (this.causticPhotonCount >= 0);
        this.photonArea = pixelwiseRenderer.getNumericOption(PHOTONAREA, 0.08).doubleValue();
        assert (this.photonArea > 0.0);
        this.photonDepth = pixelwiseRenderer.getNumericOption(PHOTONDEPTH, 5).intValue();
        assert (this.photonDepth > 0);
    }

    public boolean isPhotonMapCalcNeeded(Scene scene) {
        return scene.getStamp() != oldStamp || scene.getUniqueName() != oldUniqueName || this.globalPhotonCount != oldGlobalPhotonCount || this.causticPhotonCount != oldCausticPhotonCount || this.photonDepth != oldDepth;
    }

    public void calcFinished(Scene scene) {
        oldGlobalPhotonCount = this.globalPhotonCount;
        oldCausticPhotonCount = this.causticPhotonCount;
        oldUniqueName = scene.getUniqueName();
        oldStamp = scene.getStamp();
        oldDepth = this.photonDepth;
    }

    public int getGlobalPhotonCount() {
        return this.globalPhotonCount;
    }

    public int getCausticPhotonCount() {
        return this.causticPhotonCount;
    }

    public double getPhotonArea() {
        return this.photonArea;
    }

    public int getPhotonDepth() {
        return this.photonDepth;
    }
}

