/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.metropolis.strategy;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray.physics.Scattering;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import de.grogra.ray.util.RayList;
import de.grogra.ray2.Scene;
import de.grogra.ray2.antialiasing.MetropolisAntiAliasing;
import de.grogra.ray2.metropolis.MetropolisStrategy;
import de.grogra.ray2.tracing.MetropolisProcessor;
import de.grogra.ray2.tracing.MetropolisRenderer;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.ray2.tracing.modular.ComplementTracer;
import de.grogra.ray2.tracing.modular.ConditionObject;
import de.grogra.ray2.tracing.modular.LineTracer;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.ray2.tracing.modular.TracingMediator;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.goui.util.MTRandom;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MutationStrategy
implements MetropolisStrategy {
    protected static final float MIN_WEIGHT = 1.0E-5f;
    protected TracingMediator tracingMediator;
    protected MetropolisAntiAliasing antialiser;
    protected LineTracer tracer;
    protected ComplementTracer complTracer;
    protected MTRandom rnd;
    protected CombinedPathValues srcPath;
    protected CombinedPathValues mutatedPath;
    public ConditionObject condition = null;
    static final double EPSILON = 1.0E-4;
    public static final String EYEPATH_DEPTH = "BidirectionalPathTracer/eyeDepth";
    public static final String LIGHTPATH_DEPTH = "BidirectionalPathTracer/lightDepth";
    public int abbortCode;
    public static final int NOT_IMPLEMENTED_YET = -1;
    public static final int SUCCESSFUL_MUTATIONRUN = 0;
    public static final int NOT_VISIBLE = 1;
    public static final int NO_VALID_COMBINEDPATH = 2;
    public static final int BSDF_WAS_ZERO = 3;
    public static final int NO_CHANGES_HAPPENED = 4;
    public static final int PATH_SPECTRA_WERE_TOO_WEAK = 5;
    public static final int CANVAS_WASNT_HIT = 6;
    public static final int CALCULATION_ERROR = 99;
    public static final int TRACINGGOAL_WASNT_REACHED = 7;
    protected static int MAXVAL = 10;
    protected int sig = -1;
    protected PathValues eyePath;
    protected PathValues lightPath;
    protected Spectrum3d tmpSpec1;
    protected Spectrum3d tmpSpec2;
    protected Spectrum3d tmpSpec3;
    protected Vector3f tmpVec1;
    protected Vector3f tmpVec2;
    protected Point3d tmpPoint1;
    protected Point3d tmpPoint2;
    protected Line tmpLine;
    protected IntersectionList ilist = new IntersectionList();
    protected RayList tmpRayList = new RayList();
    protected Environment tmpEnv;
    protected int eyePathDepth;
    protected int lightPathDepth;

    public MutationStrategy(MetropolisProcessor metropolisProcessor) {
        this.ilist.setSize(1);
        this.tracingMediator = metropolisProcessor.tracingMediator;
        this.antialiser = this.tracingMediator.getMetropolisAntialiser();
        this.tracer = this.tracingMediator.getLinetracer();
        this.complTracer = this.tracingMediator.getComplementTracer();
        this.rnd = new MTRandom(this.tracingMediator.getRenderer().getSeed());
        this.eyePathDepth = this.tracingMediator.getRenderer().getNumericOption(EYEPATH_DEPTH, 10).intValue();
        assert (this.eyePathDepth > 1);
        this.lightPathDepth = this.tracingMediator.getRenderer().getNumericOption(LIGHTPATH_DEPTH, 10).intValue();
        assert (this.lightPathDepth > 1);
        Scene scene = this.tracingMediator.getRenderer().getScene();
        this.tmpEnv = new Environment(scene.getBoundingBox(), scene.createSpectrum(), 1);
        this.tmpSpec1 = new Spectrum3d();
        this.tmpSpec2 = new Spectrum3d();
        this.tmpSpec3 = new Spectrum3d();
        this.tmpVec1 = new Vector3f();
        this.tmpVec2 = new Vector3f();
        this.tmpLine = new Line();
        this.tmpPoint1 = new Point3d();
        this.tmpPoint2 = new Point3d();
    }

    public abstract void initialize(double[] var1);

    @Override
    public float mutatePath(CombinedPathValues combinedPathValues, CombinedPathValues combinedPathValues2) {
        this.srcPath = combinedPathValues;
        this.mutatedPath = combinedPathValues2;
        combinedPathValues2.pathLength = 0;
        this.abbortCode = 0;
        return -1.0f;
    }

    public float getDeleteProbability(int n, int n2) {
        int n3 = n2 - n;
        float f = n3 == 1 ? 0.25f : (n3 == 2 ? 0.5f : (float)Math.pow(2.0, -n3));
        float f2 = 1.0f;
        return f * f2;
    }

    public float getAddProbability(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        int n6 = n4 + n3 + 1;
        int n7 = n5 - n6;
        float f = n7 == 0 ? 0.5f : (n7 == -1 || n7 == 1 ? 0.15f : 0.2f * (float)Math.pow(2.0, -Math.abs(n7)));
        float f2 = 1.0f / (float)n6;
        return f * f2;
    }

    public int getDeletionPathLength() {
        float f = this.rnd.nextFloat();
        if ((double)f >= 0.5) {
            return 2;
        }
        if ((double)f >= 0.25) {
            return 1;
        }
        for (int i = 3; i < this.srcPath.pathLength; ++i) {
            if (!((double)f >= Math.pow(2.0, -i))) continue;
            return i;
        }
        return this.srcPath.pathLength - 1;
    }

    public int getAddiationPathLength(int n) {
        int n2 = this.eyePathDepth + this.lightPathDepth - 1 - (this.srcPath.pathLength - n - 1);
        while (n2 > 0) {
            float f = this.rnd.nextFloat();
            this.sig = -this.sig;
            if ((double)f >= 0.5) {
                return n;
            }
            if ((double)f >= 0.15) {
                return n + this.sig <= n2 ? n + this.sig : n2;
            }
            int n3 = 2;
            while (n3 + n <= n2) {
                if ((double)f >= 0.2 * Math.pow(2.0, -n3) && n + this.sig * n3 >= 0) {
                    return n + this.sig * n3;
                }
                ++n3;
            }
        }
        return 0;
    }

    public int[] getDeleteVertice(int n) {
        int n2 = this.rnd.nextInt(this.srcPath.pathLength - n);
        int n3 = n2 + n;
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    public int[] getAddVertice(int n) {
        int n2 = n > 0 ? this.rnd.nextInt(n) : 0;
        int n3 = n > 0 ? n - 1 - n2 : 0;
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    public void traceLightSubPath(int n, int n2) {
        if (n <= 0) {
            Line line = this.generateNewStartLine(true);
            Spectrum3d spectrum3d = new Spectrum3d();
            spectrum3d.set((Tuple3f)line.spectrum);
            this.tracer.traceLine(n2 + 1, this.lightPath, line, spectrum3d, this.lightPath.creatorID, true, this.rnd);
        } else if (n2 > 0) {
            this.tracer.traceSubPath(this.lightPath, n, n2, true, null);
        }
        this.tracer.condition = null;
    }

    public void traceEyeSubPath(int n, int n2) {
        if (n <= 0) {
            Line line = this.generateNewStartLine(false);
            if (line == null) {
                return;
            }
            Spectrum3d spectrum3d = new Spectrum3d();
            spectrum3d.set((Tuple3f)line.spectrum);
            this.tracer.traceLine(n2 + 1, this.eyePath, line, spectrum3d, this.eyePath.creatorID, false, this.rnd);
        } else if (n2 > 0) {
            this.tracer.traceSubPath(this.eyePath, n, n2, false, null);
        }
        this.tracer.condition = null;
    }

    public Line generateNewStartLine(boolean bl) {
        Line line = null;
        if (bl) {
            this.tmpRayList.clear();
            this.tmpRayList.setSize(1);
            int n = this.lightPath.creatorID;
            Scene scene = this.tracingMediator.getProcessor().scene;
            this.tmpEnv.localToGlobal.set(scene.getLightTransformation(n));
            this.tmpEnv.globalToLocal.set(scene.getInverseLightTransformation(n));
            Light light = scene.getLights()[this.lightPath.creatorID];
            light.generateRandomOrigins(this.tmpEnv, this.tmpRayList, this.rnd);
            light.generateRandomRays(this.tmpEnv, null, this.tmpRayList.rays[0].spectrum, this.tmpRayList, false, this.rnd);
            line = this.tmpRayList.rays[0].convert2Line();
        } else {
            line = this.tracingMediator.getMetropolisAntialiser().getStratifiedLensEdge();
        }
        return line;
    }

    public float calculateAcceptanceProbality(int n, int n2, int n3, int n4) {
        if (this.mutatedPath.rayListBE.size() < this.mutatedPath.pathLength - 1 || this.mutatedPath.rayListEB.size() < this.mutatedPath.pathLength - 1) {
            return this.registerError(99);
        }
        if (((Spectrum)this.mutatedPath.weightListBE.get(this.mutatedPath.pathLength - 2)).integrate() < (double)1.0E-5f || this.mutatedPath.weightListEB.get(0).integrate() < (double)1.0E-5f) {
            return this.registerError(5);
        }
        Spectrum3d spectrum3d = new Spectrum3d();
        spectrum3d = this.getCombinedBSDF(n + n3, this.mutatedPath);
        float f = this.mutatedPath.pathResultList;
        this.mutatedPath.color.set((float)spectrum3d.x, (float)spectrum3d.y, (float)spectrum3d.z, f < 1.0f ? 1.0f - f : 0.0f);
        float f2 = this.luminance(spectrum3d);
        if (f2 == 0.0f) {
            return this.registerError(3);
        }
        int n5 = n2 - n;
        int n6 = this.mutatedPath.pathLength - (this.srcPath.pathLength - n5);
        float f3 = this.getI_0(this.mutatedPath);
        float f4 = this.calculateQ(n, n2, n3, n4, this.srcPath, this.mutatedPath, true) * f3;
        if (f4 > 0.0f) {
            float f5 = this.getI_0(this.srcPath);
            float f6 = this.calculateQ(n, n + n6, 0, n5 - 1, this.mutatedPath, this.srcPath, false) * f5;
            if (f6 > 0.0f) {
                if (f6 == f4) {
                    return this.registerError(4);
                }
                float f7 = Math.min(1.0f, f6 / f4);
                if (f7 <= 0.0f || Float.isInfinite(f7) || Float.isNaN(f7)) {
                    return this.registerError(99);
                }
                Spectrum3d spectrum3d2 = new Spectrum3d(this.mutatedPath.color.x, this.mutatedPath.color.y, this.mutatedPath.color.z);
                if (this.luminance(this.mutatedPath.initialSpectrum) * 10.0f < this.luminance(spectrum3d2)) {
                    System.err.println(" MutStrat: calcQ:      l=" + n + " m=" + n2 + " l_=" + n3 + " m_=" + n4 + "\n    mutatedPath=" + this.mutatedPath + "\n    srcPath=" + this.srcPath + "\n    acceptance = " + Math.min(1.0f, f6 / f4));
                }
                return f7;
            }
        }
        return this.registerError(99);
    }

    public float getI_0(CombinedPathValues combinedPathValues) {
        MetropolisRenderer metropolisRenderer = (MetropolisRenderer)this.tracingMediator.getRenderer();
        if (MetropolisRenderer.twoStage_Ref) {
            if (MetropolisRenderer.actRenderingStage == 1) {
                int n = (int)combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).x;
                int n2 = (int)combinedPathValues.rayListEB.get((int)(combinedPathValues.pathLength - 2)).y;
                float f = metropolisRenderer.getFirstStageImageValue(n, n2);
                if (f == 0.0f) {
                    System.err.println("  MutationStrat: getI0:     return=" + f);
                }
                return f;
            }
        }
        return 1.0f;
    }

    public float calculateQ(int n, int n2, int n3, int n4, CombinedPathValues combinedPathValues, CombinedPathValues combinedPathValues2, boolean bl) {
        int n5 = n2 - n;
        int n6 = combinedPathValues2.pathLength - (combinedPathValues.pathLength - n5);
        float[] fArray = new float[n6];
        float f = 1.0f;
        for (int i = 1; i <= n6; ++i) {
            Spectrum3d spectrum3d = this.getCombinedBSDF(n + i - 1, combinedPathValues2);
            fArray[i - 1] = this.luminance(spectrum3d);
            f += this.getAddProbability(n, n2, i - 1, n6 - i) / fArray[i - 1];
        }
        if (Double.isInfinite(f) || Double.isNaN(f) || f <= 0.0f) {
            return this.registerError(99);
        }
        return this.getDeleteProbability(n, n2) * f;
    }

    public float luminance(Spectrum3d spectrum3d) {
        return (float)((double)0.299f * spectrum3d.x + (double)0.587f * spectrum3d.y + (double)0.114f * spectrum3d.z);
    }

    public Spectrum3d getCombinedBSDF(int n, CombinedPathValues combinedPathValues) {
        Spectrum spectrum;
        Spectrum spectrum2;
        int n2 = n;
        int n3 = n2 + 1;
        Scattering scattering = n2 < 0 ? null : (Scattering)combinedPathValues.shaderList.get(n2);
        Scattering scattering2 = n3 == combinedPathValues.pathLength ? null : (Scattering)combinedPathValues.shaderList.get(n3);
        Environment environment = (Environment)combinedPathValues.envList.get(n2);
        Environment environment2 = (Environment)combinedPathValues.envList.get(n3);
        if (n2 > 0) {
            this.tmpVec1.set((Tuple3d)((Line)combinedPathValues.rayListBE.get((int)(n2 - 1))).direction);
            spectrum2 = (Spectrum)combinedPathValues.weightListBE.get(n2 - 1);
        } else {
            this.tmpVec1.set(0.0f, 0.0f, 0.0f);
            spectrum2 = combinedPathValues.initialSpectrum;
        }
        this.tmpVec1.negate();
        this.tmpVec1.normalize();
        this.tmpVec2.sub((Tuple3f)environment2.point, (Tuple3f)environment.point);
        this.tmpVec2.normalize();
        float f = scattering.computeBSDF(environment, this.tmpVec1, spectrum2, this.tmpVec2, false, this.tmpSpec1);
        if (n3 < combinedPathValues.pathLength - 1) {
            this.tmpVec1.set((Tuple3d)combinedPathValues.rayListEB.get((int)n3).direction);
            spectrum = combinedPathValues.weightListEB.get(n3);
        } else {
            this.tmpVec1.set(0.0f, 0.0f, 0.0f);
            spectrum = combinedPathValues.initialSpectrumEnd;
        }
        this.tmpVec1.negate();
        this.tmpVec1.normalize();
        this.tmpVec2.negate();
        try {
            float f2 = 1.0f;
            if (scattering2 != null && n3 != combinedPathValues.pathLength - 1) {
                f2 = scattering2.computeBSDF(environment2, this.tmpVec1, spectrum, this.tmpVec2, true, this.tmpSpec2);
            } else {
                this.tmpSpec2.set(spectrum);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.tmpSpec2.set(spectrum);
        }
        float f3 = Math.max(1.0f, environment2.point.distanceSquared(environment.point));
        this.tmpSpec1.dot(this.tmpSpec2, this.tmpSpec3);
        this.tmpSpec3.scale(1.0f / f3);
        if (combinedPathValues.isSpecular(n3)) {
            this.tmpSpec3.scale(1.0E-10f);
        }
        if (combinedPathValues.isSpecular(n2)) {
            this.tmpSpec3.scale(1.0E-10f);
        }
        return this.tmpSpec3;
    }

    public boolean isVisble(Environment environment, Environment environment2, Intersection intersection) {
        this.tmpPoint1.set((Tuple3f)environment.point);
        this.tmpPoint2.set((Tuple3f)environment2.point);
        this.tmpLine.origin.set((Tuple3f)environment.point);
        this.tmpLine.direction.sub((Tuple3d)this.tmpPoint2, (Tuple3d)this.tmpPoint1);
        this.tmpLine.direction.normalize();
        int n = this.ilist.size;
        this.tracer.scene.computeIntersections(this.tmpLine, 1, this.ilist, intersection, null);
        if (n < this.ilist.size) {
            Intersection intersection2 = this.ilist.elements[n];
            double d = intersection2.getPoint().distance(this.tmpPoint2);
            this.ilist.setSize(n);
            if (d <= 1.0E-4) {
                return true;
            }
        }
        return false;
    }

    public boolean hitsCanvas(CombinedPathValues combinedPathValues) {
        Environment environment = (Environment)combinedPathValues.envList.get(combinedPathValues.pathLength - 1);
        Point3d point3d = new Point3d(((Environment)combinedPathValues.envList.get((int)(combinedPathValues.pathLength - 2))).point);
        float[] fArray = ((MetropolisRenderer)this.tracingMediator.getRenderer()).getPixelsForLine2Vertex(environment, point3d);
        if (fArray[0] > -1.0f && fArray[1] > -1.0f) {
            Line line = combinedPathValues.rayListEB.get(combinedPathValues.pathLength - 2);
            line.x = fArray[0];
            line.y = fArray[1];
            return true;
        }
        combinedPathValues.setValidFlag(false);
        return false;
    }

    @Override
    public String getAcceptanceAbbortDescription() {
        switch (this.abbortCode) {
            case -1: {
                return "This strategy isn't implemented yet!";
            }
            case 1: {
                return "Visibilitytest on combining new eye and light subpath failed!";
            }
            case 0: {
                return "Acceptance probalility was successfully calculated!";
            }
            case 3: {
                return "Combining BSDF-Spectrum was Zero!";
            }
            case 4: {
                return "No changes happend to the source path!";
            }
            case 2: {
                return "Recombination auf new traced light and eye path couldn't be acomplished!";
            }
            case 5: {
                return "The complementing of the paths produced too weak spectra";
            }
            case 6: {
                return "The resulting lesnEdge, doesn't hit the canvas!";
            }
        }
        return "Something wrong abborted the strategy";
    }

    public int registerError(int n) {
        this.abbortCode = n;
        return -1;
    }

    @Override
    public void pathChanged() {
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public abstract void resetAll();

    @Override
    public abstract ArrayList<String> getStatistics();
}

