/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray2.metropolis.strategy;

import de.grogra.ray.physics.Environment;
import de.grogra.ray.physics.Light;
import de.grogra.ray2.Scene;
import de.grogra.ray2.metropolis.strategy.MutationStrategy;
import de.grogra.ray2.tracing.MetropolisProcessor;
import de.grogra.ray2.tracing.modular.CombinedPathValues;
import de.grogra.ray2.tracing.modular.ConditionObject;
import de.grogra.ray2.tracing.modular.LineTracer;
import de.grogra.ray2.tracing.modular.PathValues;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.Line;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LensPerturbationStrat
extends MutationStrategy {
    static final int NO_DIFFUSE_FOUND = 101;
    static int countOfLensEdgeMutations;
    static int countOfFirstLightRayMutations;
    static int countOfMiddlePathMutations;
    static int countOfLensEdgeMutationsError;
    static int countOfFirstLightRayMutationsError;
    static int countOfMiddlePathMutationsError;
    static int count_NoError;
    static int count_notImplemented;
    static int count_notVisible;
    static int count_ZeroBSDF;
    static int count_noChanges;
    static int count_notValidPath;
    static int count_weakSpec;
    static int count_notCanvasHit;
    static int count_CalculationError;
    static int count_totalError;
    static int count_tracing;
    static int count_no_diffuse;
    public int kd;
    public int ka;
    public int l;
    public int m;
    public int l_;
    public int m_;
    public int real_m_;
    public int real_l_;
    public float acceptance;

    public LensPerturbationStrat(MetropolisProcessor metropolisProcessor) {
        super(metropolisProcessor);
        this.eyePath = new PathValues();
        this.eyePath.initialize(this.eyePathDepth + this.lightPathDepth);
        this.lightPath = new PathValues();
        this.lightPath.initialize(this.eyePathDepth + this.lightPathDepth);
    }

    @Override
    public void initialize(double[] dArray) {
    }

    @Override
    public void resetAll() {
        countOfLensEdgeMutations = 0;
        countOfFirstLightRayMutations = 0;
        countOfMiddlePathMutations = 0;
        count_NoError = 0;
        countOfLensEdgeMutationsError = 0;
        countOfFirstLightRayMutationsError = 0;
        countOfMiddlePathMutationsError = 0;
        count_notImplemented = 0;
        count_notVisible = 0;
        count_ZeroBSDF = 0;
        count_noChanges = 0;
        count_notValidPath = 0;
        count_weakSpec = 0;
        count_notCanvasHit = 0;
        count_CalculationError = 0;
        count_totalError = 0;
        count_tracing = 0;
        count_no_diffuse = 0;
    }

    @Override
    public float mutatePath(CombinedPathValues combinedPathValues, CombinedPathValues combinedPathValues2) {
        super.mutatePath(combinedPathValues, combinedPathValues2);
        this.real_l_ = -1;
        this.real_m_ = -1;
        this.m_ = -1;
        this.l_ = -1;
        this.m = -1;
        this.l = -1;
        this.ka = -1;
        this.kd = -1;
        int n = this.searchForDoubleDiffuse();
        if (n < 0) {
            return this.registerError(101);
        }
        this.l = n;
        this.m = this.srcPath.pathLength - 1;
        this.l_ = 0;
        this.m_ = this.m - this.l - 1;
        this.srcPath.splitInto2Paths(this.l, this.lightPath, this.eyePath);
        this.eyePath.pathResultList = this.srcPath.pathResultList;
        this.eyePath.creatorID = this.srcPath.sensorID;
        this.lightPath.creatorID = this.srcPath.lightID;
        this.eyePath.pathLength = 1;
        this.tracer.condition = this.condition = new StratificationCondition(this.eyePath, this.tracer);
        int n2 = this.eyePath.pathLength;
        this.traceEyeSubPath(0, this.m_);
        this.real_l_ = 0;
        this.real_m_ = this.eyePath.pathLength - n2;
        if (this.m_ != this.real_m_) {
            return this.registerError(7);
        }
        int n3 = 0;
        for (int i = this.srcPath.pathLength - 1; i > this.l; --i) {
            if (this.srcPath.isSpecular(i) != this.eyePath.isSpecular(n3)) {
                return this.registerError(7);
            }
            ++n3;
        }
        Environment environment = this.lightPath.envList.get(this.lightPath.pathLength - 1);
        Environment environment2 = this.eyePath.envList.get(this.eyePath.pathLength - 1);
        Intersection intersection = this.lightPath.intersecList.get(this.lightPath.pathLength - 1);
        if (this.eyePath.pathLength == 1 ? !this.isVisble(environment2, environment, null) : !this.isVisble(environment, environment2, intersection)) {
            return this.registerError(1);
        }
        this.complTracer.complement2Paths(this.lightPath, this.lightPath.pathLength - 1, this.eyePath, this.eyePath.pathLength - 1, false, this.mutatedPath);
        this.mutatedPath.pathResultList = this.eyePath.pathResultList;
        if (!this.hitsCanvas(combinedPathValues2)) {
            this.abbortCode = 6;
            return -1.0f;
        }
        if (!combinedPathValues2.isValid()) {
            return this.registerError(2);
        }
        this.acceptance = this.calculateAcceptanceProbality(this.l, this.m, this.real_l_, this.real_m_);
        if (this.abbortCode == 0) {
            ++count_NoError;
            if (this.m == combinedPathValues.pathLength - 1) {
                ++countOfLensEdgeMutations;
            }
            if (this.l == 0) {
                ++countOfFirstLightRayMutations;
            }
            if (this.m != combinedPathValues.pathLength - 1 && this.l != 0) {
                ++countOfMiddlePathMutations;
            }
        }
        return this.acceptance;
    }

    @Override
    public Line generateNewStartLine(boolean bl) {
        Line line = null;
        if (bl) {
            this.tmpRayList.clear();
            this.tmpRayList.setSize(1);
            int n = this.lightPath.creatorID;
            Scene scene = this.tracingMediator.getProcessor().scene;
            this.tmpEnv.localToGlobal.set(scene.getLightTransformation(n));
            this.tmpEnv.globalToLocal.set(scene.getInverseLightTransformation(n));
            Light light = scene.getLights()[this.lightPath.creatorID];
            light.generateRandomOrigins(this.tmpEnv, this.tmpRayList, this.rnd);
            light.generateRandomRays(this.tmpEnv, null, this.tmpRayList.rays[0].spectrum, this.tmpRayList, false, this.rnd);
            line = this.tmpRayList.rays[0].convert2Line();
        } else {
            line = this.tracingMediator.getMetropolisAntialiser().getPerturbedLensEdge(this.eyePath.rayListBE.get(0));
        }
        return line;
    }

    @Override
    public int registerError(int n) {
        switch (n) {
            case -1: {
                ++count_notImplemented;
                break;
            }
            case 1: {
                ++count_notVisible;
                break;
            }
            case 0: {
                ++count_NoError;
                break;
            }
            case 3: {
                ++count_ZeroBSDF;
                break;
            }
            case 4: {
                ++count_noChanges;
                break;
            }
            case 2: {
                ++count_notValidPath;
                break;
            }
            case 5: {
                ++count_weakSpec;
                break;
            }
            case 6: {
                ++count_notCanvasHit;
                break;
            }
            case 7: {
                ++count_tracing;
                break;
            }
            case 101: {
                ++count_no_diffuse;
                break;
            }
            default: {
                ++count_CalculationError;
            }
        }
        if (n != 0) {
            ++count_totalError;
            if (this.m >= this.srcPath.pathLength - 1) {
                ++countOfLensEdgeMutationsError;
            }
            if (this.l <= 0) {
                ++countOfFirstLightRayMutationsError;
            }
            if (this.m < this.srcPath.pathLength - 1 && this.l > 0) {
                ++countOfMiddlePathMutationsError;
            }
        }
        return super.registerError(n);
    }

    @Override
    public ArrayList<String> getStatistics() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("total Count of successfull strategy runs: " + count_NoError + "\n");
        arrayList.add(" * successfull lens edge mutation runs:" + countOfLensEdgeMutations + "(" + (float)countOfLensEdgeMutations / (float)count_NoError + ")\n");
        arrayList.add(" * successfull first light ray mutation runs:" + countOfFirstLightRayMutations + "(" + (float)countOfFirstLightRayMutations / (float)count_NoError + ")\n");
        arrayList.add(" * successfull path centered mutation runs:" + countOfMiddlePathMutations + "(" + (float)countOfMiddlePathMutations / (float)count_NoError + ")\n\n");
        arrayList.add("total count of failure: " + count_totalError + "\n");
        arrayList.add(" * error on lens edge mutation:" + countOfLensEdgeMutationsError + "(" + (float)countOfLensEdgeMutationsError / (float)count_totalError + ")\n");
        arrayList.add(" * error on first light ray mutation:" + countOfFirstLightRayMutationsError + "(" + (float)countOfFirstLightRayMutationsError / (float)count_totalError + ")\n");
        arrayList.add(" * error on path centered mutation:" + countOfMiddlePathMutationsError + "(" + (float)countOfMiddlePathMutationsError / (float)count_totalError + ")\n\n");
        arrayList.add(" * count_no_diffuse: " + count_no_diffuse + " (" + (float)count_no_diffuse / (float)count_totalError + ")\n");
        arrayList.add(" * count_notImplemented: " + count_notImplemented + " (" + (float)count_notImplemented / (float)count_totalError + ")\n");
        arrayList.add(" * count_notVisible: " + count_notVisible + " (" + (float)count_notVisible / (float)count_totalError + ")\n");
        arrayList.add(" * count_ZeroBSDF: " + count_ZeroBSDF + " (" + (float)count_ZeroBSDF / (float)count_totalError + ")\n");
        arrayList.add(" * count_noChanges: " + count_noChanges + " (" + (float)count_noChanges / (float)count_totalError + ")\n");
        arrayList.add(" * count_notValidPath: " + count_notValidPath + " (" + (float)count_notValidPath / (float)count_totalError + ")\n");
        arrayList.add(" * count_weakSpec: " + count_weakSpec + " (" + (float)count_weakSpec / (float)count_totalError + "\n");
        arrayList.add(" * count_notCanvasHit: " + count_notCanvasHit + " (" + (float)count_notCanvasHit / (float)count_totalError + ")\n");
        arrayList.add(" * count_CalculationError: " + count_CalculationError + " (" + (float)count_CalculationError / (float)count_totalError + ")\n\n");
        arrayList.add(" * count_tracingError: " + count_tracing + " (" + (float)count_tracing / (float)count_totalError + ")\n\n");
        return arrayList;
    }

    int searchForDoubleDiffuse() {
        boolean bl = false;
        for (int i = this.srcPath.pathLength - 2; i >= 0; --i) {
            if (!this.srcPath.isSpecular(i) && bl) {
                return i;
            }
            if (this.srcPath.isSpecular(i)) continue;
            bl = true;
        }
        return -1;
    }

    static {
        countOfLensEdgeMutationsError = 0;
        countOfFirstLightRayMutationsError = 0;
        countOfMiddlePathMutationsError = 0;
        count_notImplemented = 0;
        count_notVisible = 0;
        count_ZeroBSDF = 0;
        count_noChanges = 0;
        count_notValidPath = 0;
        count_weakSpec = 0;
        count_notCanvasHit = 0;
        count_CalculationError = 0;
        count_totalError = 0;
        count_tracing = 0;
        count_no_diffuse = 0;
    }

    class StratificationCondition
    extends ConditionObject {
        public StratificationCondition(PathValues pathValues, LineTracer lineTracer) {
            super(pathValues, lineTracer);
        }

        public boolean stopOnCondition() {
            int n = this.path.pathLength - 1;
            if (n == 0) {
                return false;
            }
            return !this.path.isSpecular(n);
        }
    }
}

