/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.tracing;

import de.grogra.ray.RTFakeObject;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.debug3d.Debug3d;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.light.DefaultLightProcessor;
import de.grogra.ray.light.LightProcessor;
import de.grogra.ray.memory.MemoryPool;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PathTracerMT
implements RayProcessor {
    private static final boolean USE_MEMORY_POOL = true;
    private int m_depthLimit = 4;
    private IntersectionProcessor m_intersectionProcessor = null;
    private LightProcessor m_lightProcessor = null;
    private MemoryPool m_memoryPool;
    private IntersectionDescription m_desc = new IntersectionDescription();
    private final Color3f m_rayColor = new Color3f();
    private PathtracingStrategy m_strategy = new PathtracingStrategy5();
    private final RayContext m_rayContext = new RayContext();
    private ShadingEnvironment m_curEnvironment = new ShadingEnvironment();
    private int m_pathCount = 20;

    public PathTracerMT() {
        this.setLightProcessor(new DefaultLightProcessor());
    }

    public boolean hasFixedLightProcessor() {
        return false;
    }

    public void setLightProcessor(LightProcessor lightProcessor) {
        this.m_lightProcessor = lightProcessor;
    }

    public LightProcessor getLightProcessor() {
        return this.m_lightProcessor;
    }

    public void setRecursionDepth(int n) {
        if (n >= 0) {
            this.m_depthLimit = n;
        }
    }

    public int getRecursionDepth() {
        return this.m_depthLimit;
    }

    public void setPathCount(int n) {
        if (n >= 1 && n < 10000) {
            this.m_pathCount = n;
        }
    }

    public int getPathCount() {
        return this.m_pathCount;
    }

    public void prepareRayProcessor(RTScene rTScene, IntersectionProcessor intersectionProcessor) {
        this.m_memoryPool = MemoryPool.getPool();
        this.m_intersectionProcessor = intersectionProcessor;
        this.m_lightProcessor.prepareLightProcessor(rTScene, this.m_intersectionProcessor);
    }

    public void getColorFromRay(Ray ray, Color4f color4f) {
        this.m_strategy.getColorFromRay(ray, color4f);
    }

    private void refreshEnvironment(ShadingEnvironment shadingEnvironment, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription) {
        if (intersectionDescription == null) {
            return;
        }
        shadingEnvironment.localPoint.set((Tuple3f)intersectionDescription.getLocalPoint());
        shadingEnvironment.point.set((Tuple3f)intersectionDescription.getPoint());
        shadingEnvironment.normal.set((Tuple3f)intersectionDescription.getNormal());
        shadingEnvironment.view.set((Tuple3f)ray.getDirection());
        shadingEnvironment.view.negate();
        shadingEnvironment.photonDirection = false;
        shadingEnvironment.solid = intersectionDescription.getRTObject().isSolid();
        if (intersectionDescription.getRTObject().getUserData().isInside) {
            if (rayContext.isLastMaterial(intersectionDescription.getRTObject())) {
                shadingEnvironment.iorRatio = rayContext.getExitingIORRation();
            }
        } else {
            shadingEnvironment.iorRatio = intersectionDescription.getRTObject().getMedium() == null ? 1.0f : rayContext.getCurrentIOR() / intersectionDescription.getRTObject().getMedium().getIndexOfRefraction();
        }
        shadingEnvironment.uv.set((Tuple2f)intersectionDescription.getUVCoordinate());
        shadingEnvironment.dpdu.set((Tuple3f)intersectionDescription.getTangenteU());
        shadingEnvironment.dpdv.set((Tuple3f)intersectionDescription.getTangenteV());
    }

    private class PathtracingStrategy5
    implements PathtracingStrategy {
        private static final float WEIGHT_SUM_MIN = 0.0f;
        private float m_scalar1;
        private float m_scalar2;
        private Vector3f m_weight = new Vector3f();
        private final Vector3f m_density = new Vector3f();
        private final Vector3f m_densitySum = new Vector3f();
        private final Ray m_randomRay = new Ray();
        private final Color3f m_pathColor = new Color3f();
        private final Color3f m_diffuseColor = new Color3f();
        private final IntersectionDescription m_localDesc = new IntersectionDescription();
        private ShadingEnvironment m_firstEnvironment = new ShadingEnvironment();
        private float m_weightAverage;

        private PathtracingStrategy5() {
        }

        public void getColorFromRay(Ray ray, Color4f color4f) {
            int n;
            if (PathTracerMT.this.m_intersectionProcessor == null) {
                System.err.println("ERROR in Raytracer: no intersection processor defined for DefaultRayTracer");
                color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
                return;
            }
            PathTracerMT.this.m_rayContext.initializeContext();
            if (!PathTracerMT.this.m_intersectionProcessor.getFirstIntersectionDescription(ray, PathTracerMT.this.m_rayContext, PathTracerMT.this.m_desc)) {
                color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
                return;
            }
            if (PathTracerMT.this.m_desc.getRTObject() instanceof RTFakeObject) {
                ((RTFakeObject)PathTracerMT.this.m_desc.getRTObject()).getColor(ray, PathTracerMT.this.m_desc, this.m_diffuseColor);
                color4f.x = this.m_diffuseColor.x;
                color4f.y = this.m_diffuseColor.y;
                color4f.z = this.m_diffuseColor.z;
                color4f.w = 1.0f;
                return;
            }
            Debug3d.logFiniteRay(ray, PathTracerMT.this.m_desc.getT(), 1.0f);
            Debug3d.logNormal((Tuple3f)PathTracerMT.this.m_desc.getPoint(), (Tuple3f)PathTracerMT.this.m_desc.getNormal());
            this.m_firstEnvironment.rays.clear();
            if (!((PathTracerMT)PathTracerMT.this).m_desc.getRTObject().getUserData().isInside) {
                PathTracerMT.this.m_lightProcessor.getLightRays(ray, PathTracerMT.this.m_desc, this.m_firstEnvironment.rays);
            }
            PathTracerMT.this.refreshEnvironment(this.m_firstEnvironment, ray, PathTracerMT.this.m_rayContext, PathTracerMT.this.m_desc);
            for (n = 0; n < this.m_firstEnvironment.rays.size(); ++n) {
                Debug3d.logDirectLightRay(this.m_firstEnvironment.rays.rays[n]);
            }
            PathTracerMT.this.m_desc.getRTObject().getShader().getShadingColor(this.m_firstEnvironment, this.m_diffuseColor);
            PathTracerMT.this.m_rayColor.set(0.0f, 0.0f, 0.0f);
            this.m_densitySum.set(1.0f, 1.0f, 1.0f);
            n = PathTracerMT.this.getPathCount();
            if (PathTracerMT.this.getRecursionDepth() > 0) {
                this.m_densitySum.set(0.0f, 0.0f, 0.0f);
                for (int i = 0; i < n; ++i) {
                    PathTracerMT.this.m_desc.getRTObject().getShader().generateRandomRay(this.m_firstEnvironment, this.m_randomRay);
                    this.m_weight.set((Tuple3f)this.m_randomRay.color);
                    this.m_density.set(this.m_randomRay.directionDensity, this.m_randomRay.directionDensity, this.m_randomRay.directionDensity);
                    this.m_pathColor.set(0.0f, 0.0f, 0.0f);
                    if (this.m_weight.x + this.m_weight.y + this.m_weight.z < 0.0f) {
                        --i;
                        continue;
                    }
                    this.m_scalar1 = ((PathTracerMT)PathTracerMT.this).m_desc.getNormal().x * ray.getDirection().x + ((PathTracerMT)PathTracerMT.this).m_desc.getNormal().y * ray.getDirection().y + ((PathTracerMT)PathTracerMT.this).m_desc.getNormal().z * ray.getDirection().z;
                    this.m_scalar2 = ((PathTracerMT)PathTracerMT.this).m_desc.getNormal().x * this.m_randomRay.getDirection().x + ((PathTracerMT)PathTracerMT.this).m_desc.getNormal().y * this.m_randomRay.getDirection().y + ((PathTracerMT)PathTracerMT.this).m_desc.getNormal().z * this.m_randomRay.getDirection().z;
                    if (this.m_scalar1 * this.m_scalar2 <= 0.0f) {
                        ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = PathTracerMT.this.m_desc.getRTObject();
                        if (!PathTracerMT.this.m_intersectionProcessor.getFirstIntersectionDescription(this.m_randomRay, PathTracerMT.this.m_rayContext, this.m_localDesc)) {
                            this.m_weightAverage = (this.m_weight.x + this.m_weight.y + this.m_weight.z) / 3.0f;
                            Debug3d.logInfiniteRay(this.m_randomRay, this.m_weightAverage);
                        } else {
                            this.tracePath(2, this.m_randomRay, PathTracerMT.this.m_rayContext, this.m_localDesc, this.m_pathColor, this.m_weight);
                        }
                    } else {
                        RTObject rTObject = PathTracerMT.this.m_desc.getRTObject();
                        int n2 = -1;
                        if (rTObject.isSolid()) {
                            boolean bl = rTObject.getUserData().isInside = !rTObject.getUserData().isInside;
                            if (!rTObject.getUserData().isInside) {
                                ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = rTObject;
                                if (PathTracerMT.this.m_rayContext.isLastMaterial(rTObject)) {
                                    PathTracerMT.this.m_rayContext.popMaterial();
                                } else {
                                    n2 = PathTracerMT.this.m_rayContext.deleteMaterial(rTObject);
                                }
                            } else {
                                ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = null;
                                PathTracerMT.this.m_rayContext.pushMaterial(rTObject);
                            }
                        } else {
                            ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = rTObject;
                        }
                        if (!PathTracerMT.this.m_intersectionProcessor.getFirstIntersectionDescription(this.m_randomRay, PathTracerMT.this.m_rayContext, this.m_localDesc)) {
                            this.m_weightAverage = (this.m_weight.x + this.m_weight.y + this.m_weight.z) / 3.0f;
                            Debug3d.logInfiniteRay(this.m_randomRay, this.m_weightAverage);
                        } else {
                            this.tracePath(2, this.m_randomRay, PathTracerMT.this.m_rayContext, this.m_localDesc, this.m_pathColor, this.m_weight);
                        }
                        if (rTObject.isSolid()) {
                            if (!rTObject.getUserData().isInside) {
                                if (n2 == -1) {
                                    PathTracerMT.this.m_rayContext.pushMaterial(rTObject);
                                } else {
                                    PathTracerMT.this.m_rayContext.insertMaterial(rTObject, n2);
                                }
                            } else {
                                PathTracerMT.this.m_rayContext.popMaterial();
                            }
                            rTObject.getUserData().isInside = !rTObject.getUserData().isInside;
                        }
                    }
                    this.m_densitySum.add((Tuple3f)this.m_density);
                    ((PathTracerMT)PathTracerMT.this).m_rayColor.x += this.m_pathColor.x * this.m_weight.x;
                    ((PathTracerMT)PathTracerMT.this).m_rayColor.y += this.m_pathColor.y * this.m_weight.y;
                    ((PathTracerMT)PathTracerMT.this).m_rayColor.z += this.m_pathColor.z * this.m_weight.z;
                }
            }
            ((PathTracerMT)PathTracerMT.this).m_rayColor.x /= (float)n;
            ((PathTracerMT)PathTracerMT.this).m_rayColor.y /= (float)n;
            ((PathTracerMT)PathTracerMT.this).m_rayColor.z /= (float)n;
            color4f.x = this.m_diffuseColor.x + ((PathTracerMT)PathTracerMT.this).m_rayColor.x;
            color4f.y = this.m_diffuseColor.y + ((PathTracerMT)PathTracerMT.this).m_rayColor.y;
            color4f.z = this.m_diffuseColor.z + ((PathTracerMT)PathTracerMT.this).m_rayColor.z;
            color4f.w = 1.0f;
        }

        private void tracePath(int n, Ray ray, RayContext rayContext, IntersectionDescription intersectionDescription, Color3f color3f, Vector3f vector3f) {
            if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
                ((RTFakeObject)intersectionDescription.getRTObject()).getColor(ray, intersectionDescription, color3f);
                this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                Debug3d.logInfiniteRay(ray, this.m_weightAverage);
                return;
            }
            this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
            Debug3d.logFiniteRay(ray, intersectionDescription.getT(), this.m_weightAverage);
            Debug3d.logNormal((Tuple3f)intersectionDescription.getPoint(), (Tuple3f)intersectionDescription.getNormal());
            ((PathTracerMT)PathTracerMT.this).m_curEnvironment.rays.clear();
            if (!intersectionDescription.getRTObject().getUserData().isInside) {
                PathTracerMT.this.m_lightProcessor.getLightRays(ray, intersectionDescription, ((PathTracerMT)PathTracerMT.this).m_curEnvironment.rays);
            }
            PathTracerMT.this.refreshEnvironment(PathTracerMT.this.m_curEnvironment, ray, rayContext, intersectionDescription);
            for (int i = 0; i < ((PathTracerMT)PathTracerMT.this).m_curEnvironment.rays.size(); ++i) {
                Debug3d.logDirectLightRay(((PathTracerMT)PathTracerMT.this).m_curEnvironment.rays.rays[i]);
            }
            intersectionDescription.getRTObject().getShader().getShadingColor(PathTracerMT.this.m_curEnvironment, color3f);
            if (n <= PathTracerMT.this.getRecursionDepth()) {
                Ray ray2 = PathTracerMT.this.m_memoryPool.newRay();
                Vector3f vector3f2 = PathTracerMT.this.m_memoryPool.newVector3f();
                intersectionDescription.getRTObject().getShader().generateRandomRay(PathTracerMT.this.m_curEnvironment, ray2);
                vector3f2.set((Tuple3f)ray2.color);
                if (ray2.color.x * vector3f.x + ray2.color.y * vector3f.y + ray2.color.z * vector3f.z > 0.0f) {
                    Color3f color3f2 = PathTracerMT.this.m_memoryPool.newColor3f();
                    color3f2.set(0.0f, 0.0f, 0.0f);
                    Vector3f vector3f3 = PathTracerMT.this.m_memoryPool.newVector3f();
                    this.m_scalar1 = intersectionDescription.getNormal().x * ray.getDirection().x + intersectionDescription.getNormal().y * ray.getDirection().y + intersectionDescription.getNormal().z * ray.getDirection().z;
                    this.m_scalar2 = intersectionDescription.getNormal().x * ray2.getDirection().x + intersectionDescription.getNormal().y * ray2.getDirection().y + intersectionDescription.getNormal().z * ray2.getDirection().z;
                    vector3f3.set((Tuple3f)vector3f);
                    vector3f.x *= ray2.color.x;
                    vector3f.y *= ray2.color.y;
                    vector3f.z *= ray2.color.z;
                    if (this.m_scalar1 * this.m_scalar2 <= 0.0f) {
                        rayContext.excludeObject = !intersectionDescription.getRTObject().getUserData().isInside ? intersectionDescription.getRTObject() : null;
                        if (!PathTracerMT.this.m_intersectionProcessor.getFirstIntersectionDescription(ray2, rayContext, intersectionDescription)) {
                            this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                            Debug3d.logInfiniteRay(ray2, this.m_weightAverage);
                        } else {
                            this.tracePath(n + 1, ray2, rayContext, intersectionDescription, color3f2, vector3f);
                        }
                    } else {
                        RTObject rTObject = intersectionDescription.getRTObject();
                        int n2 = -1;
                        if (rTObject.isSolid()) {
                            boolean bl = rTObject.getUserData().isInside = !rTObject.getUserData().isInside;
                            if (!rTObject.getUserData().isInside) {
                                ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = rTObject;
                                if (PathTracerMT.this.m_rayContext.isLastMaterial(rTObject)) {
                                    PathTracerMT.this.m_rayContext.popMaterial();
                                } else {
                                    n2 = PathTracerMT.this.m_rayContext.deleteMaterial(rTObject);
                                }
                            } else {
                                ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = null;
                                PathTracerMT.this.m_rayContext.pushMaterial(rTObject);
                            }
                        } else {
                            ((PathTracerMT)PathTracerMT.this).m_rayContext.excludeObject = rTObject;
                        }
                        if (!PathTracerMT.this.m_intersectionProcessor.getFirstIntersectionDescription(ray2, rayContext, intersectionDescription)) {
                            this.m_weightAverage = (vector3f.x + vector3f.y + vector3f.z) / 3.0f;
                            Debug3d.logInfiniteRay(ray2, this.m_weightAverage);
                        } else {
                            this.tracePath(n + 1, ray2, rayContext, intersectionDescription, color3f2, vector3f);
                        }
                        if (rTObject.isSolid()) {
                            if (!rTObject.getUserData().isInside) {
                                if (n2 == -1) {
                                    PathTracerMT.this.m_rayContext.pushMaterial(rTObject);
                                } else {
                                    PathTracerMT.this.m_rayContext.insertMaterial(rTObject, n2);
                                }
                            } else {
                                PathTracerMT.this.m_rayContext.popMaterial();
                            }
                            rTObject.getUserData().isInside = !rTObject.getUserData().isInside;
                        }
                    }
                    vector3f.set((Tuple3f)vector3f3);
                    color3f.x += color3f2.x * vector3f2.x;
                    color3f.y += color3f2.y * vector3f2.y;
                    color3f.z += color3f2.z * vector3f2.z;
                    PathTracerMT.this.m_memoryPool.freeVector3f(vector3f3);
                    PathTracerMT.this.m_memoryPool.freeColor3f(color3f2);
                }
                PathTracerMT.this.m_memoryPool.freeVector3f(vector3f2);
                PathTracerMT.this.m_memoryPool.freeRay(ray2);
            }
        }
    }

    private static interface PathtracingStrategy {
        public void getColorFromRay(Ray var1, Color4f var2);
    }
}

