/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.tracing;

import de.grogra.ray.RTFakeObject;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.light.DefaultLightProcessor;
import de.grogra.ray.light.LightProcessor;
import de.grogra.ray.memory.MemoryPool;
import de.grogra.ray.shader.RTShader;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayList;
import de.grogra.vecmath.Math2;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class PathTracerHS
implements RayProcessor {
    private static final int LISTSIZE = 1;
    boolean test_Started = false;
    private int depthLimit = 0;
    private static final float LIGHT_WEIGHT_MIN = 0.02f;
    private IntersectionProcessor m_intersectionProcessor = null;
    private LightProcessor m_lightModel = null;
    private MemoryPool m_memoryPool;
    private IntersectionDescription desc = new IntersectionDescription();
    private final Color3f m_rayColor = new Color3f();
    private float m_lastIOR = 1.0f;
    private char seed;
    private float totalDensity = 0.0f;
    private int count = 0;
    private RayList tempRayList = new RayList(1);
    private boolean physValid = false;
    private int rayCount = 0;
    private char tempChar;
    private float tempFloat;
    private int tempInt;
    private Vector3f tempVec = new Vector3f();
    private boolean tempBool = true;
    private float searchedDensity;
    private float tempDensity;
    private static final int INTERSECTION_EVALUATION_PARAMS = 94;

    public PathTracerHS() {
        this.setLightProcessor(new DefaultLightProcessor());
    }

    public PathTracerHS(int n) {
        this.setLightProcessor(new DefaultLightProcessor());
        this.depthLimit = n;
    }

    public void setIntersectionProcessor(IntersectionProcessor intersectionProcessor) {
        this.m_intersectionProcessor = intersectionProcessor;
    }

    public void prepareRayProcessor(RTScene rTScene, IntersectionProcessor intersectionProcessor) {
        this.m_memoryPool = MemoryPool.getPool();
        this.setIntersectionProcessor(intersectionProcessor);
        this.m_lightModel.prepareLightProcessor(rTScene, intersectionProcessor);
        this.seed = Math2.random((char)'\u0000');
    }

    public Ray getMostProbableRay(RayList rayList, int n) {
        if (rayList.getSize() == 0) {
            return null;
        }
        if (rayList.getSize() == 1) {
            return rayList.rays[0];
        }
        this.totalDensity = 0.0f;
        this.tempDensity = 0.0f;
        this.tempInt = rayList.getSize();
        this.count = 0;
        while (this.count < this.tempInt) {
            this.totalDensity += rayList.rays[this.count].directionDensity;
            ++this.count;
        }
        this.tempChar = Math2.random((char)((char)n));
        this.tempFloat = (float)this.tempChar / 65535.0f;
        this.searchedDensity = this.tempFloat * this.totalDensity;
        this.count = 0;
        while (this.count < this.tempInt) {
            this.tempDensity += rayList.rays[this.count].directionDensity;
            if (this.tempDensity >= this.searchedDensity) {
                return rayList.rays[this.count];
            }
            ++this.count;
        }
        return null;
    }

    public void getColorFromRay(Ray ray, Color4f color4f) {
        if (this.m_intersectionProcessor == null) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray, null, this.desc)) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        float f = this.traceImportanceRay(1, ray, this.desc, null, this.m_rayColor);
        color4f.x = this.m_rayColor.x;
        color4f.y = this.m_rayColor.y;
        color4f.z = this.m_rayColor.z;
        color4f.w = 1.0f;
    }

    private float traceImportanceRay(int n, Ray ray, IntersectionDescription intersectionDescription, RTObject rTObject, Color3f color3f) {
        if (!this.m_intersectionProcessor.getFirstIntersectionDescription(ray, null, intersectionDescription)) {
            color3f.set(0.0f, 0.0f, 0.0f);
            return 1.0f;
        }
        if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
            ((RTFakeObject)intersectionDescription.getRTObject()).getColor(ray, intersectionDescription, color3f);
            return 1.0f;
        }
        ShadingEnvironment shadingEnvironment = new ShadingEnvironment();
        this.refreshInput(shadingEnvironment, ray, intersectionDescription);
        RTShader rTShader = null;
        float f = 1.0f;
        if (!this.physValid) {
            this.m_lightModel.getLightRays(ray, intersectionDescription, shadingEnvironment.rays);
            rTShader.getShadingColor(shadingEnvironment, color3f);
        }
        if (n < this.depthLimit) {
            this.tempVec.set((Tuple3f)shadingEnvironment.view);
            this.seed = (char)(this.seed + '\u0001');
            rTShader.generateRandomRays(shadingEnvironment, this.tempVec, this.tempRayList, true, Math2.random((char)this.seed));
            this.seed = (char)(this.seed + '\u0001');
            Ray ray2 = this.getMostProbableRay(this.tempRayList, Math2.random((char)this.seed));
            if (ray2 == null) {
                return 1.0f;
            }
            ++this.rayCount;
            f = ray2.directionDensity;
            if (ray2.directionDensity < 0.0f) {
                System.err.println("rayProb: " + ray2.directionDensity);
                f = 0.0f;
            }
            Color3f color3f2 = new Color3f(ray2.getColor());
            Color3f color3f3 = new Color3f();
            this.tempFloat = color3f2.x + color3f2.y + color3f2.z;
            if (this.tempFloat > 0.02f) {
                if (intersectionDescription.getNormal().dot(ray2.direction) > 0.0f) {
                    f *= this.traceImportanceRay(n + 1, ray2, intersectionDescription, intersectionDescription.getRTObject(), color3f3);
                    ray2.getColor().x = color3f3.x * color3f2.x;
                    ray2.getColor().y = color3f3.y * color3f2.y;
                    ray2.getColor().z = color3f3.z * color3f2.z;
                    color3f.add((Tuple3f)ray2.getColor());
                } else if (rTShader.isTransparent()) {
                    f *= this.traceImportanceRay(n + 1, ray2, intersectionDescription, null, color3f3);
                    ray2.getColor().x = color3f3.x * color3f2.x;
                    ray2.getColor().y = color3f3.y * color3f2.y;
                    ray2.getColor().z = color3f3.z * color3f2.z;
                    color3f.add((Tuple3f)ray2.getColor());
                }
            }
        }
        return f;
    }

    private void refreshInput(ShadingEnvironment shadingEnvironment, Ray ray, IntersectionDescription intersectionDescription) {
        if (intersectionDescription == null) {
            return;
        }
        shadingEnvironment.localPoint.set((Tuple3f)intersectionDescription.getLocalPoint());
        shadingEnvironment.point.set((Tuple3f)intersectionDescription.getPoint());
        shadingEnvironment.normal.set((Tuple3f)intersectionDescription.getNormal());
        shadingEnvironment.view.set((Tuple3f)ray.getDirection());
        shadingEnvironment.view.negate();
        shadingEnvironment.view.normalize();
        shadingEnvironment.photonDirection = false;
        shadingEnvironment.solid = true;
        shadingEnvironment.uv.set((Tuple2f)intersectionDescription.getUVCoordinate());
        shadingEnvironment.dpdu.set((Tuple3f)intersectionDescription.getTangenteU());
        shadingEnvironment.dpdv.set((Tuple3f)intersectionDescription.getTangenteV());
    }

    public boolean hasFixedLightProcessor() {
        return false;
    }

    public void setLightProcessor(LightProcessor lightProcessor) {
        this.m_lightModel = lightProcessor;
    }

    public LightProcessor getLightProcessor() {
        return this.m_lightModel;
    }

    public void setRecursionDepth(int n) {
        this.depthLimit = n;
    }

    public int getRecursionDepth() {
        return this.depthLimit;
    }

    public void setPhysicalValid(boolean bl) {
    }

    public boolean isPhysicalValid() {
        return this.physValid;
    }
}

