/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.tracing;

import de.grogra.ray.RTFakeObject;
import de.grogra.ray.RTLight;
import de.grogra.ray.RTObject;
import de.grogra.ray.RTScene;
import de.grogra.ray.RTSceneVisitor;
import de.grogra.ray.Raytracer;
import de.grogra.ray.intersection.BoundingVolume;
import de.grogra.ray.intersection.IntersectionDescription;
import de.grogra.ray.intersection.IntersectionProcessor;
import de.grogra.ray.light.LightProcessor;
import de.grogra.ray.light.ShadowProcessor;
import de.grogra.ray.memory.MemoryPool;
import de.grogra.ray.shader.RTMedium;
import de.grogra.ray.shader.RTShader;
import de.grogra.ray.shader.ShadingEnvironment;
import de.grogra.ray.tracing.BidirectionalPathTracer;
import de.grogra.ray.tracing.PathTracerHS;
import de.grogra.ray.tracing.RayProcessor;
import de.grogra.ray.util.Ray;
import de.grogra.ray.util.RayContext;
import de.grogra.ray.util.RayList;
import de.grogra.vecmath.Math2;
import javax.vecmath.Color3f;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;

public class HagensBiDiStrategie1
implements BidirectionalPathTracer.PathingStrategies {
    private static final boolean SHOW_ADDITION_COLOR = false;
    private static final float LIGHT_VARIANCE_MAX = 1.7608814f;
    private static final float LIGHT_WEIGHT_MIN = 0.02f;
    private final Color3f m_rayColor = new Color3f();
    private final Color4f m_testColor = new Color4f();
    private float m_varianceSum;
    private float m_weightSum;
    private float m_lastIOR = 1.0f;
    private RayProcessor eyePathRayProcessor = null;
    private int lightPathLength = 5;
    private int eyePathLength = 5;
    private int pathLength = 10;
    private static final int LISTSIZE = 1;
    private MemoryPool m_memoryPool;
    private RTScene scene = null;
    private char seed;
    private IntersectionProcessor intersectionProcessor = null;
    private IntersectionDescription desc = new IntersectionDescription();
    private float totalDensity = 0.0f;
    private int count = 0;
    private RayList tempRayList = new RayList(1);
    private char tempChar;
    private float tempFloat;
    private int tempInt;
    private Vector3f tempVec = new Vector3f();
    private boolean tempBool = true;
    private float searchedDensity;
    private float tempDensity;

    public HagensBiDiStrategie1() {
        this.eyePathRayProcessor = new PathTracerHS(this.pathLength);
    }

    public Ray getMostProbableRay(RayList rayList, int n) {
        if (rayList.getSize() == 0) {
            return null;
        }
        if (rayList.getSize() == 1) {
            return rayList.rays[0];
        }
        this.totalDensity = 0.0f;
        this.tempDensity = 0.0f;
        this.tempInt = rayList.getSize();
        this.count = 0;
        while (this.count < this.tempInt) {
            this.totalDensity += rayList.rays[this.count].directionDensity;
            ++this.count;
        }
        this.tempChar = Math2.random((char)((char)n));
        this.tempFloat = (float)this.tempChar / 65535.0f;
        this.searchedDensity = this.tempFloat * this.totalDensity;
        this.count = 0;
        while (this.count < this.tempInt) {
            this.tempDensity += rayList.rays[this.count].directionDensity;
            if (this.tempDensity >= this.searchedDensity) {
                return rayList.rays[this.count];
            }
            ++this.count;
        }
        return null;
    }

    public void getColorFromRay(Ray ray, Color4f color4f) {
        if (this.intersectionProcessor == null) {
            color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
            return;
        }
        RTLight[] rTLightArray = null;
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 0.0f;
        Color4f[] color4fArray = new Color4f[this.pathLength + 1];
        float[] fArray = new float[this.pathLength + 1];
        for (int i = 0; i < this.pathLength + 1; ++i) {
            f = this.startLightRay(i, rTLightArray);
            color4fArray[i] = new Color4f();
            this.startImportanceRay(this.pathLength - i, ray, color4fArray[i]);
            fArray[i] = f2 * f * f2 * f;
            f3 += fArray[i];
        }
        this.calculateWeightedContribution(color4fArray, fArray, f3, color4f);
    }

    private void calculateWeightedContribution(Color4f[] color4fArray, float[] fArray, float f, Color4f color4f) {
        color4f.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = 0; i < color4fArray.length; ++i) {
            color4fArray[i].scale(fArray[i] / f);
            color4f.add((Tuple4f)color4fArray[i]);
        }
    }

    private float startLightRay(int n, RTLight[] rTLightArray) {
        if (n == 0) {
            return 1.0f;
        }
        this.lightPathLength = n;
        RayList rayList = new RayList(1);
        float f = 1.0f;
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < rTLightArray.length; ++i) {
            this.seed = (char)(this.seed + '\u0001');
            rTLightArray[i].generateRandomRays(vector3f, rayList, true, Math2.random((char)this.seed));
            this.seed = (char)(this.seed + '\u0001');
            rTLightArray[i].generateRandomOrigins(rayList, Math2.random((char)this.seed));
            this.seed = (char)(this.seed + '\u0001');
            Ray ray = this.getMostProbableRay(rayList, Math2.random((char)this.seed));
            if (ray == null) break;
            f = ray.originDensity;
            Color3f color3f = ray.getColor();
            f *= this.traceLightRay(1, ray, this.desc, null, color3f);
        }
        return f;
    }

    private void startImportanceRay(int n, Ray ray, Color4f color4f) {
        this.eyePathRayProcessor.setRecursionDepth(n);
        this.eyePathRayProcessor.getColorFromRay(ray, color4f);
    }

    private float traceLightRay(int n, Ray ray, IntersectionDescription intersectionDescription, RTObject rTObject, Color3f color3f) {
        if (!this.intersectionProcessor.getFirstIntersectionDescription(ray, null, intersectionDescription)) {
            return 1.0f;
        }
        if (intersectionDescription.getRTObject() instanceof RTFakeObject) {
            ((RTFakeObject)intersectionDescription.getRTObject()).getColor(ray, intersectionDescription, color3f);
            return 1.0f;
        }
        ShadingEnvironment shadingEnvironment = new ShadingEnvironment();
        this.refreshInput(shadingEnvironment, ray, intersectionDescription);
        RTShader rTShader = null;
        float f = 1.0f;
        if (n < this.lightPathLength) {
            Vector3f vector3f = new Vector3f(shadingEnvironment.view);
            vector3f.normalize();
            this.seed = (char)(this.seed + '\u0001');
            rTShader.generateRandomRays(shadingEnvironment, vector3f, this.tempRayList, false, Math2.random((char)this.seed));
            this.seed = (char)(this.seed + '\u0001');
            Ray ray2 = this.getMostProbableRay(this.tempRayList, Math2.random((char)this.seed));
            if (ray2 == null) {
                return 1.0f;
            }
            f = ray2.directionDensity;
            Color3f color3f2 = new Color3f(ray2.getColor());
            color3f2.x *= color3f.x;
            color3f2.y *= color3f.y;
            color3f2.z *= color3f.z;
            float f2 = color3f2.x + color3f2.y + color3f2.z;
            if (f2 > 0.02f) {
                if (intersectionDescription.getNormal().dot(ray2.direction) > 0.0f) {
                    RTPseudoLight rTPseudoLight = this.generatePseudoLight(ray, ray2, shadingEnvironment, rTShader, color3f2);
                    f *= this.traceLightRay(n + 1, ray2, intersectionDescription, intersectionDescription.getRTObject(), rTPseudoLight.color);
                } else if (rTShader.isTransparent()) {
                    f *= this.traceLightRay(n + 1, ray2, intersectionDescription, null, color3f2);
                }
            }
        }
        return f;
    }

    public RTPseudoLight generatePseudoLight(Ray ray, Ray ray2, ShadingEnvironment shadingEnvironment, RTShader rTShader, Color3f color3f) {
        Color3f color3f2 = new Color3f(color3f);
        Vector3f vector3f = new Vector3f((Tuple3f)shadingEnvironment.point);
        Color3f color3f3 = new Color3f(color3f2);
        Vector3f vector3f2 = new Vector3f(ray.direction);
        vector3f2.normalize();
        vector3f2.negate();
        Vector3f vector3f3 = new Vector3f(ray2.direction);
        vector3f3.normalize();
        rTShader.computeBSDF(shadingEnvironment, vector3f2, vector3f3, false, color3f3);
        color3f2.x *= color3f3.x;
        color3f2.y *= color3f3.y;
        color3f2.z *= color3f3.z;
        return new RTPseudoLight((Tuple3f)vector3f, color3f2);
    }

    private void refreshInput(ShadingEnvironment shadingEnvironment, Ray ray, IntersectionDescription intersectionDescription) {
        if (intersectionDescription == null) {
            return;
        }
        shadingEnvironment.localPoint.set((Tuple3f)intersectionDescription.getLocalPoint());
        shadingEnvironment.point.set((Tuple3f)intersectionDescription.getPoint());
        shadingEnvironment.normal.set((Tuple3f)intersectionDescription.getNormal());
        shadingEnvironment.view.set((Tuple3f)ray.getDirection());
        shadingEnvironment.view.negate();
        shadingEnvironment.view.normalize();
        shadingEnvironment.photonDirection = false;
        shadingEnvironment.solid = true;
        shadingEnvironment.uv.set((Tuple2f)intersectionDescription.getUVCoordinate());
        shadingEnvironment.dpdu.set((Tuple3f)intersectionDescription.getTangenteU());
        shadingEnvironment.dpdv.set((Tuple3f)intersectionDescription.getTangenteV());
    }

    public static RTLight[] getLights(RTScene rTScene) {
        RTLight[] rTLightArray = new RTLight[rTScene.getLightsCount()];
        GetLightsVisitor getLightsVisitor = new GetLightsVisitor(rTLightArray);
        rTScene.traversSceneLights(getLightsVisitor);
        return rTLightArray;
    }

    public void prepareRayProcessor(RTScene rTScene, IntersectionProcessor intersectionProcessor) {
        this.scene = rTScene;
        this.m_memoryPool = MemoryPool.getPool();
        this.seed = Math2.random((char)'\u0000');
    }

    public void setIntersectionProcessor(IntersectionProcessor intersectionProcessor) {
        this.intersectionProcessor = intersectionProcessor;
    }

    public void setLightProcessor(LightProcessor lightProcessor) {
    }

    public LightProcessor getLightProcessor() {
        return null;
    }

    public int getRecursionDepth() {
        return this.pathLength;
    }

    public void setRecursionDepth(int n) {
        this.pathLength = n;
    }

    public class RTPseudoLight
    implements RTLight {
        private boolean shadowless = false;
        private final Ray tmpRay1 = new Ray();
        private Ray tmpRay2 = null;
        private float rayLength;
        private final Point3f globalOrigin = new Point3f();
        public Color3f color = new Color3f();

        public RTPseudoLight(Tuple3f tuple3f, Color3f color3f) {
            this.globalOrigin.set(tuple3f);
            this.color.set((Tuple3f)color3f);
            this.tmpRay1.getColor().set((Tuple3f)color3f);
        }

        public boolean isShadowless() {
            return this.shadowless;
        }

        public int getLightRays(IntersectionDescription intersectionDescription, RayList rayList) {
            this.tmpRay1.getOrigin().set((Tuple3f)this.globalOrigin);
            this.tmpRay1.getDirection().set(intersectionDescription.getPoint().x - this.globalOrigin.x, intersectionDescription.getPoint().y - this.globalOrigin.y, intersectionDescription.getPoint().z - this.globalOrigin.z);
            this.tmpRay1.getDirection().normalize();
            this.rayLength = Raytracer.getT(this.tmpRay1, intersectionDescription.getPoint());
            return 0;
        }

        public void generateRandomOrigins(RayList rayList, int n) {
        }

        public void generateRandomRays(Vector3f vector3f, RayList rayList, boolean bl, int n) {
        }

        public float getDistance(Ray ray) {
            return 0.0f;
        }

        public void getIntersectionDescription(int n, IntersectionDescription intersectionDescription) {
        }

        public boolean isShadeable() {
            return false;
        }

        public BoundingVolume getBoundingVolume() {
            return null;
        }

        public float computeBSDF(ShadingEnvironment shadingEnvironment, Vector3f vector3f, Vector3f vector3f2, boolean bl, Color3f color3f) {
            return 0.0f;
        }

        public boolean isSolid() {
            return false;
        }

        public void getIntersectionDescription(IntersectionDescription intersectionDescription) {
            intersectionDescription = null;
        }

        public Point3f getGloabalOrigin() {
            return this.globalOrigin;
        }

        public Point3f getGlobalOrigin() {
            return null;
        }

        public int getLightRays(Ray ray, IntersectionDescription intersectionDescription, ShadowProcessor shadowProcessor, RayList rayList) {
            return 0;
        }

        public float getDistance(Ray ray, RayContext rayContext) {
            return 0.0f;
        }

        public RTMedium getMedium() {
            return null;
        }

        public RTShader getShader() {
            return null;
        }

        public RTObject.RTObjectUserData getUserData() {
            return null;
        }

        public boolean isConvex() {
            return false;
        }
    }

    private static class GetLightsVisitor
    implements RTSceneVisitor {
        private RTLight[] m_lights = null;
        private int m_lightsOffset = 0;

        public GetLightsVisitor(RTLight[] rTLightArray) {
            this.initialize(rTLightArray);
        }

        public void initialize(RTLight[] rTLightArray) {
            this.m_lights = rTLightArray;
            this.m_lightsOffset = 0;
        }

        public void visitObject(RTObject rTObject) {
            if (!(rTObject instanceof RTLight)) {
                return;
            }
            this.m_lights[this.m_lightsOffset++] = (RTLight)rTObject;
        }
    }
}

