/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ray.physics;

import de.grogra.ray.physics.Collector;
import de.grogra.ray.physics.Collector3d;
import de.grogra.ray.physics.Spectrum;
import de.grogra.ray.physics.Spectrum3d;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class CollectorW3d
extends Spectrum3d
implements Collector,
Serializable {
    protected long rayCount;
    protected boolean asCollector = false;
    protected double TDirectionX = 0.0;
    protected double TDirectionY = 0.0;
    protected double TDirectionZ = 0.0;
    protected double MDirectionX = 0.0;
    protected double MDirectionY = 0.0;
    protected double MDirectionZ = 0.0;
    protected double TSpectrumX = 0.0;
    protected double TSpectrumY = 0.0;
    protected double TSpectrumZ = 0.0;
    protected double MSpectrumX = 0.0;
    protected double MSpectrumY = 0.0;
    protected double MSpectrumZ = 0.0;
    private double tempQX;
    private double tempQY;
    private double tempQZ;
    private double tempRX;
    private double tempRY;
    private double tempRZ;

    public CollectorW3d() {
    }

    public CollectorW3d(double d, double d2, double d3) {
        super(d, d2, d3);
        this.add((Spectrum)this);
    }

    public CollectorW3d(Spectrum spectrum) {
        this.add(spectrum);
    }

    public Collector3d newInstance() {
        return new Collector3d();
    }

    public void setAsCollector() {
        this.asCollector = true;
    }

    public boolean isCollector() {
        return this.asCollector;
    }

    public void add(Spectrum spectrum) {
        if (!(spectrum instanceof Collector) || !((Collector)spectrum).isCollector()) {
            super.add(spectrum);
        } else {
            this.add((Collector)spectrum);
        }
    }

    public void addToStatistic(Tuple3d tuple3d, Spectrum spectrum, double d, boolean bl) {
        this.addToStatistic(tuple3d, (Spectrum3d)spectrum, d, bl);
    }

    public void addToStatistic(Tuple3d tuple3d, Spectrum3d spectrum3d, double d, boolean bl) {
        ++this.rayCount;
        double d2 = spectrum3d.integrate() * d;
        CollectorW3d.normalize(tuple3d);
        tuple3d.negate();
        this.tempQX = d2 * tuple3d.x - this.MDirectionX;
        this.tempQY = d2 * tuple3d.y - this.MDirectionY;
        this.tempQZ = d2 * tuple3d.z - this.MDirectionZ;
        this.tempRX = this.tempQX / (double)this.rayCount;
        this.tempRY = this.tempQY / (double)this.rayCount;
        this.tempRZ = this.tempQZ / (double)this.rayCount;
        this.MDirectionX += this.tempRX;
        this.MDirectionY += this.tempRY;
        this.MDirectionZ += this.tempRZ;
        this.TDirectionX += (double)(this.rayCount - 1L) * this.tempQX * this.tempRX;
        this.TDirectionY += (double)(this.rayCount - 1L) * this.tempQY * this.tempRY;
        this.TDirectionZ += (double)(this.rayCount - 1L) * this.tempQZ * this.tempRZ;
        this.tempQX = spectrum3d.x - this.MSpectrumX;
        this.tempQY = spectrum3d.y - this.MSpectrumY;
        this.tempQZ = spectrum3d.z - this.MSpectrumZ;
        this.tempRX = this.tempQX / (double)this.rayCount;
        this.tempRY = this.tempQY / (double)this.rayCount;
        this.tempRZ = this.tempQZ / (double)this.rayCount;
        this.MSpectrumX += this.tempRX;
        this.MSpectrumY += this.tempRY;
        this.MSpectrumZ += this.tempRZ;
        this.TSpectrumX += (double)(this.rayCount - 1L) * this.tempQX * this.tempRX;
        this.TSpectrumY += (double)(this.rayCount - 1L) * this.tempQY * this.tempRY;
        this.TSpectrumZ += (double)(this.rayCount - 1L) * this.tempQZ * this.tempRZ;
    }

    public void getSpectrumVariance(Spectrum spectrum) {
        spectrum.set((Tuple3d)new Vector3d(this.TSpectrumX / (double)(this.rayCount - 1L), this.TSpectrumY / (double)(this.rayCount - 1L), this.TSpectrumZ / (double)(this.rayCount - 1L)));
    }

    public void getDirectionVariance(Tuple3d tuple3d) {
        tuple3d.x = this.TDirectionX / (double)(this.rayCount - 1L);
        tuple3d.y = this.TDirectionY / (double)(this.rayCount - 1L);
        tuple3d.z = this.TDirectionZ / (double)(this.rayCount - 1L);
    }

    public void getDirectionVariance(Tuple3f tuple3f) {
        tuple3f.x = (float)(this.TDirectionX / (double)(this.rayCount - 1L));
        tuple3f.y = (float)(this.TDirectionY / (double)(this.rayCount - 1L));
        tuple3f.z = (float)(this.TDirectionZ / (double)(this.rayCount - 1L));
    }

    public void getDirectionArithmeticMean(Tuple3d tuple3d) {
        tuple3d.x = this.MDirectionX;
        tuple3d.y = this.MDirectionY;
        tuple3d.z = this.MDirectionZ;
    }

    public void getDirectionArithmeticMean(Tuple3f tuple3f) {
        tuple3f.x = (float)this.MDirectionX;
        tuple3f.y = (float)this.MDirectionY;
        tuple3f.z = (float)this.MDirectionZ;
    }

    public void getSpectrumArithmeticMean(Spectrum spectrum) {
        spectrum.set((Tuple3d)new Vector3d(this.MSpectrumX, this.MSpectrumY, this.MSpectrumZ));
    }

    public long getRayCount() {
        return this.rayCount;
    }

    public void setZero() {
        this.rayCount = 0L;
        super.setZero();
        this.TDirectionX = 0.0;
        this.TDirectionY = 0.0;
        this.TDirectionZ = 0.0;
        this.MDirectionX = 0.0;
        this.MDirectionY = 0.0;
        this.MDirectionZ = 0.0;
        this.TSpectrumX = 0.0;
        this.TSpectrumY = 0.0;
        this.TSpectrumZ = 0.0;
        this.MSpectrumX = 0.0;
        this.MSpectrumY = 0.0;
        this.MSpectrumZ = 0.0;
    }

    public static void normalize(Tuple3d tuple3d) {
        double d = Math.sqrt(tuple3d.x * tuple3d.x + tuple3d.y * tuple3d.y + tuple3d.z * tuple3d.z);
        tuple3d.scale(1.0 / d);
    }

    public static void normalize(Tuple3f tuple3f) {
        float f = (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
        tuple3f.scale(1.0f / f);
    }

    public void add(Collector collector) {
        super.add(collector);
        this.rayCount += collector.getRayCount();
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        collector.getCollectedValues((Tuple3d)point3d, (Tuple3d)point3d2, (Tuple3d)point3d3, (Tuple3d)point3d4);
        this.MDirectionX += point3d.x;
        this.MDirectionY += point3d.y;
        this.MDirectionZ += point3d.z;
        this.TDirectionX += point3d2.x;
        this.TDirectionY += point3d2.y;
        this.TDirectionZ += point3d2.z;
        this.MSpectrumX += point3d3.x;
        this.MSpectrumY += point3d3.y;
        this.MSpectrumZ += point3d3.z;
        this.TSpectrumX += point3d4.x;
        this.TSpectrumY += point3d4.y;
        this.TSpectrumZ += point3d4.z;
    }

    public void getCollectedValues(Tuple3d tuple3d, Tuple3d tuple3d2, Tuple3d tuple3d3, Tuple3d tuple3d4) {
        tuple3d.x = this.MDirectionX;
        tuple3d.y = this.MDirectionY;
        tuple3d.z = this.MDirectionZ;
        tuple3d2.x = this.TDirectionX;
        tuple3d2.y = this.TDirectionY;
        tuple3d2.z = this.TDirectionZ;
        tuple3d3.x = this.MSpectrumX;
        tuple3d3.y = this.MSpectrumY;
        tuple3d3.z = this.MSpectrumZ;
        tuple3d4.x = this.TSpectrumX;
        tuple3d4.y = this.TSpectrumY;
        tuple3d4.z = this.TSpectrumZ;
    }

    public Collector3d clone() {
        Collector3d collector3d = new Collector3d();
        if (!this.asCollector) {
            collector3d.add((Spectrum)this);
        } else {
            collector3d.x = this.x;
            collector3d.y = this.y;
            collector3d.z = this.z;
            collector3d.rayCount = this.rayCount;
            collector3d.squareSumDirectionX = this.TDirectionX;
            collector3d.squareSumDirectionY = this.TDirectionY;
            collector3d.squareSumDirectionZ = this.TDirectionZ;
            collector3d.sumDirectionX = this.MDirectionX;
            collector3d.sumDirectionY = this.MDirectionY;
            collector3d.sumDirectionZ = this.MDirectionZ;
            collector3d.squareSumSpectrumX = this.TSpectrumX;
            collector3d.squareSumSpectrumY = this.TSpectrumY;
            collector3d.squareSumSpectrumZ = this.TSpectrumZ;
            collector3d.sumSpectrumX = this.MSpectrumX;
            collector3d.sumSpectrumY = this.MSpectrumY;
            collector3d.sumSpectrumZ = this.MSpectrumZ;
        }
        return collector3d;
    }
}

