/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;

public class Vector3f
extends Tuple3f
implements Serializable {
    public Vector3f(float f, float f2, float f3) {
        super(f, f2, f3);
    }

    public Vector3f(float[] fArray) {
        super(fArray);
    }

    public Vector3f(Vector3f vector3f) {
        super(vector3f);
    }

    public Vector3f(Vector3d vector3d) {
        super(vector3d);
    }

    public Vector3f(Tuple3d tuple3d) {
        super(tuple3d);
    }

    public Vector3f(Tuple3f tuple3f) {
        super(tuple3f);
    }

    public Vector3f() {
    }

    public final float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public final float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public final void cross(Vector3f vector3f, Vector3f vector3f2) {
        this.set(vector3f.y * vector3f2.z - vector3f.z * vector3f2.y, vector3f.z * vector3f2.x - vector3f.x * vector3f2.z, vector3f.x * vector3f2.y - vector3f.y * vector3f2.x);
    }

    public final float dot(Vector3f vector3f) {
        return this.x * vector3f.x + this.y * vector3f.y + this.z * vector3f.z;
    }

    public final void normalize(Vector3f vector3f) {
        this.set(vector3f);
        this.normalize();
    }

    public final void normalize() {
        double d = this.length();
        this.x = (float)((double)this.x / d);
        this.y = (float)((double)this.y / d);
        this.z = (float)((double)this.z / d);
    }

    public final float angle(Vector3f vector3f) {
        double d = this.y * vector3f.z - this.z * vector3f.y;
        double d2 = this.z * vector3f.x - this.x * vector3f.z;
        double d3 = this.x * vector3f.y - this.y * vector3f.x;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return (float)Math.abs(Math.atan2(d4, this.dot(vector3f)));
    }

    public Object clone() {
        return new Vector3f(this);
    }
}

