/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.Tuple3f;

public abstract class Tuple3d
implements Serializable,
Cloneable {
    public double x;
    public double y;
    public double z;

    public Tuple3d(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public Tuple3d(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public Tuple3d(Tuple3d tuple3d) {
        this.x = tuple3d.x;
        this.y = tuple3d.y;
        this.z = tuple3d.z;
    }

    public Tuple3d(Tuple3f tuple3f) {
        this.x = tuple3f.x;
        this.y = tuple3f.y;
        this.z = tuple3f.z;
    }

    public Tuple3d() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public final void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public final void set(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public final void set(Tuple3d tuple3d) {
        this.x = tuple3d.x;
        this.y = tuple3d.y;
        this.z = tuple3d.z;
    }

    public final void set(Tuple3f tuple3f) {
        this.x = tuple3f.x;
        this.y = tuple3f.y;
        this.z = tuple3f.z;
    }

    public final void get(double[] dArray) {
        dArray[0] = this.x;
        dArray[1] = this.y;
        dArray[2] = this.z;
    }

    public final void get(Tuple3d tuple3d) {
        tuple3d.x = this.x;
        tuple3d.y = this.y;
        tuple3d.z = this.z;
    }

    public final void add(Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.x = tuple3d.x + tuple3d2.x;
        this.y = tuple3d.y + tuple3d2.y;
        this.z = tuple3d.z + tuple3d2.z;
    }

    public final void add(Tuple3d tuple3d) {
        this.x += tuple3d.x;
        this.y += tuple3d.y;
        this.z += tuple3d.z;
    }

    public final void sub(Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.x = tuple3d.x - tuple3d2.x;
        this.y = tuple3d.y - tuple3d2.y;
        this.z = tuple3d.z - tuple3d2.z;
    }

    public final void sub(Tuple3d tuple3d) {
        this.x -= tuple3d.x;
        this.y -= tuple3d.y;
        this.z -= tuple3d.z;
    }

    public final void negate(Tuple3d tuple3d) {
        this.x = -tuple3d.x;
        this.y = -tuple3d.y;
        this.z = -tuple3d.z;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void scale(double d, Tuple3d tuple3d) {
        this.x = d * tuple3d.x;
        this.y = d * tuple3d.y;
        this.z = d * tuple3d.z;
    }

    public final void scale(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public final void scaleAdd(double d, Tuple3d tuple3d, Tuple3d tuple3d2) {
        this.x = d * tuple3d.x + tuple3d2.x;
        this.y = d * tuple3d.y + tuple3d2.y;
        this.z = d * tuple3d.z + tuple3d2.z;
    }

    public final void scaleAdd(double d, Tuple3d tuple3d) {
        this.x = d * this.x + tuple3d.x;
        this.y = d * this.y + tuple3d.y;
        this.z = d * this.z + tuple3d.z;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        long l2 = Double.doubleToLongBits(this.y);
        long l3 = Double.doubleToLongBits(this.z);
        return (int)(l ^ l >> 32 ^ l2 ^ l2 >> 32 ^ l3 ^ l3 >> 32);
    }

    public boolean equals(Tuple3d tuple3d) {
        return tuple3d != null && this.x == tuple3d.x && this.y == tuple3d.y && this.z == tuple3d.z;
    }

    public boolean equals(Object object) {
        return object instanceof Tuple3d && this.equals((Tuple3d)object);
    }

    public boolean epsilonEquals(Tuple3d tuple3d, double d) {
        return Math.abs(tuple3d.x - this.x) <= d && Math.abs(tuple3d.y - this.y) <= d && Math.abs(tuple3d.z - this.z) <= d;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public final void absolute(Tuple3d tuple3d) {
        this.set(tuple3d);
        this.absolute();
    }

    public final void absolute() {
        if (this.x < 0.0) {
            this.x = -this.x;
        }
        if (this.y < 0.0) {
            this.y = -this.y;
        }
        if (this.z < 0.0) {
            this.z = -this.z;
        }
    }

    public final void clamp(float f, float f2) {
        this.clampMin(f);
        this.clampMax(f2);
    }

    public final void clamp(float f, float f2, Tuple3d tuple3d) {
        this.set(tuple3d);
        this.clamp(f, f2);
    }

    public final void clampMin(float f) {
        if (this.x < (double)f) {
            this.x = f;
        }
        if (this.y < (double)f) {
            this.y = f;
        }
        if (this.z < (double)f) {
            this.z = f;
        }
    }

    public final void clampMin(float f, Tuple3d tuple3d) {
        this.set(tuple3d);
        this.clampMin(f);
    }

    public final void clampMax(float f, Tuple3d tuple3d) {
        this.set(tuple3d);
        this.clampMax(f);
    }

    public final void clampMax(float f) {
        if (this.x > (double)f) {
            this.x = f;
        }
        if (this.y > (double)f) {
            this.y = f;
        }
        if (this.z > (double)f) {
            this.z = f;
        }
    }

    public final void clamp(double d, double d2) {
        this.clampMin(d);
        this.clampMax(d2);
    }

    public final void clamp(double d, double d2, Tuple3d tuple3d) {
        this.set(tuple3d);
        this.clamp(d, d2);
    }

    public final void clampMin(double d) {
        if (this.x < d) {
            this.x = d;
        }
        if (this.y < d) {
            this.y = d;
        }
        if (this.z < d) {
            this.z = d;
        }
    }

    public final void clampMin(double d, Tuple3d tuple3d) {
        this.set(tuple3d);
        this.clampMin(d);
    }

    public final void clampMax(double d, Tuple3d tuple3d) {
        this.set(tuple3d);
        this.clampMax(d);
    }

    public final void clampMax(double d) {
        if (this.x > d) {
            this.x = d;
        }
        if (this.y > d) {
            this.y = d;
        }
        if (this.z > d) {
            this.z = d;
        }
    }

    public final void interpolate(Tuple3d tuple3d, Tuple3d tuple3d2, float f) {
        float f2 = 1.0f - f;
        this.x = (double)f2 * tuple3d.x + (double)f * tuple3d2.x;
        this.y = (double)f2 * tuple3d.y + (double)f * tuple3d2.y;
        this.z = (double)f2 * tuple3d.z + (double)f * tuple3d2.z;
    }

    public final void interpolate(Tuple3d tuple3d, float f) {
        float f2 = 1.0f - f;
        this.x = (double)f2 * this.x + (double)f * tuple3d.x;
        this.y = (double)f2 * this.y + (double)f * tuple3d.y;
        this.z = (double)f2 * this.z + (double)f * tuple3d.z;
    }

    public final void interpolate(Tuple3d tuple3d, Tuple3d tuple3d2, double d) {
        double d2 = 1.0 - d;
        this.x = d2 * tuple3d.x + d * tuple3d2.x;
        this.y = d2 * tuple3d.y + d * tuple3d2.y;
        this.z = d2 * tuple3d.z + d * tuple3d2.z;
    }

    public final void interpolate(Tuple3d tuple3d, double d) {
        double d2 = 1.0 - d;
        this.x = d2 * this.x + d * tuple3d.x;
        this.y = d2 * this.y + d * tuple3d.y;
        this.z = d2 * this.z + d * tuple3d.z;
    }

    public final void max(Tuple3d tuple3d) {
        this.x = Math.max(tuple3d.x, this.x);
        this.y = Math.max(tuple3d.y, this.y);
        this.z = Math.max(tuple3d.z, this.z);
    }

    public final void min(Tuple3d tuple3d) {
        this.x = Math.min(tuple3d.x, this.x);
        this.y = Math.min(tuple3d.y, this.y);
        this.z = Math.min(tuple3d.z, this.z);
    }

    public abstract Object clone();
}

