/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Range;
import de.grogra.vecmath.geom.ImplicitVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Tuple3d;

public class Supershape
extends ImplicitVolume {
    protected double a;
    protected double b;
    protected double m1;
    protected double n11;
    protected double n12;
    protected double n13;
    protected double m2;
    protected double n21;
    protected double n22;
    protected double n23;
    protected final ThreadLocal<ImplicitVolume.Locals> locals2 = new ThreadLocal<ImplicitVolume.Locals>(){

        @Override
        protected ImplicitVolume.Locals initialValue() {
            return new ImplicitVolume.Locals();
        }
    };

    public Supershape(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.a = f;
        this.b = f2;
        this.m1 = f3;
        this.n11 = f4;
        this.n12 = f5;
        this.n13 = f6;
        this.m2 = f7;
        this.n21 = f8;
        this.n22 = f9;
        this.n23 = f10;
    }

    protected Range f(Range range, Range range2, Range range3) {
        ImplicitVolume.Locals locals = (ImplicitVolume.Locals)this.locals.get();
        Range.atan2(locals.r0, range2, range);
        this.sample_r1(locals.r1, locals.r0, 8);
        Range.sqr(locals.r2, locals.r1);
        Range.add(locals.r3, Range.sqr(locals.tr0, range), Range.sqr(locals.tr1, range2));
        Range.atan(locals.r4, Range.div(locals.tr0, range3, Range.sqrt(locals.tr1, locals.r3)));
        this.sample_r2(locals.r5, locals.r4, 8);
        Range.sqr(locals.r6, locals.r5);
        locals.r7.set(1.0);
        Range.sub(locals.r0, Range.div(locals.tr0, Range.add(locals.tr1, locals.r3, Range.mul(locals.tr5, locals.r2, Range.sqr(locals.tr6, range3))), Range.mul(locals.tr7, locals.r2, locals.r6)), locals.r7);
        return locals.r0;
    }

    protected double f(double d, double d2, double d3) {
        double d4 = Math.atan2(d2, d);
        double d5 = this.r1(d4);
        double d6 = d5 * d5;
        double d7 = Math.atan(d3 / Math.sqrt(d * d + d2 * d2));
        double d8 = this.r2(d7);
        double d9 = d8 * d8;
        return (d * d + d2 * d2 + d6 * d3 * d3) / (d6 * d9) - 1.0;
    }

    private Range sample_r1(Range range, Range range2, int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        ImplicitVolume.Locals locals = this.locals2.get();
        locals.r0.set(this.m1 / 4.0);
        Range.mul(locals.r1, locals.r0, range2);
        double d3 = locals.r1.a;
        double d4 = Math.min(locals.r1.b, locals.r1.a + Math.PI * 2);
        for (int i = 0; i < n; ++i) {
            double d5 = (d4 - d3) * (double)(i + 0) / (double)n + d3;
            double d6 = (d4 - d3) * (double)(i + 1) / (double)n + d3;
            locals.r1.set(d5, d6);
            locals.r4.set(this.a);
            Range.abs(locals.r2, Range.div(locals.tr1, Range.cos(locals.tr0, locals.r1), locals.r4));
            locals.r4.set(this.b);
            Range.abs(locals.r3, Range.div(locals.tr1, Range.sin(locals.tr0, locals.r1), locals.r4));
            Range.pow(locals.r4, locals.r2, this.n12);
            Range.pow(locals.r5, locals.r3, this.n13);
            Range.add(locals.r6, locals.r4, locals.r5);
            Range.pow(range, locals.r6, -1.0 / this.n11);
            d = Math.min(d, range.a);
            d2 = Math.max(d2, range.b);
        }
        range.set(d, d2);
        return range;
    }

    private Range sample_r2(Range range, Range range2, int n) {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        ImplicitVolume.Locals locals = this.locals2.get();
        locals.r0.set(this.m2 / 4.0);
        Range.mul(locals.r1, locals.r0, range2);
        double d3 = locals.r1.a;
        double d4 = Math.min(locals.r1.b, locals.r1.a + Math.PI * 2);
        for (int i = 0; i < n; ++i) {
            double d5 = (d4 - d3) * (double)(i + 0) / (double)n + d3;
            double d6 = (d4 - d3) * (double)(i + 1) / (double)n + d3;
            locals.r1.set(d5, d6);
            locals.r4.set(this.a);
            Range.abs(locals.r2, Range.div(locals.tr1, Range.cos(locals.tr0, locals.r1), locals.r4));
            locals.r4.set(this.b);
            Range.abs(locals.r3, Range.div(locals.tr1, Range.sin(locals.tr0, locals.r1), locals.r4));
            Range.pow(locals.r4, locals.r2, this.n22);
            Range.pow(locals.r5, locals.r3, this.n23);
            Range.add(locals.r6, locals.r4, locals.r5);
            Range.pow(range, locals.r6, -1.0 / this.n21);
            d = Math.min(d, range.a);
            d2 = Math.max(d2, range.b);
        }
        range.set(d, d2);
        return range;
    }

    private Range r1(Range range, Range range2) {
        ImplicitVolume.Locals locals = this.locals2.get();
        locals.r0.set(this.m1 / 4.0);
        Range.mul(locals.r1, locals.r0, range2);
        locals.r4.set(this.a);
        Range.abs(locals.r2, Range.div(locals.tr1, Range.cos(locals.tr0, locals.r1), locals.r4));
        locals.r4.set(this.b);
        Range.abs(locals.r3, Range.div(locals.tr1, Range.sin(locals.tr0, locals.r1), locals.r4));
        Range.pow(locals.r4, locals.r2, this.n12);
        Range.pow(locals.r5, locals.r3, this.n13);
        Range.add(locals.r6, locals.r4, locals.r5);
        Range.pow(range, locals.r6, -1.0 / this.n11);
        return range;
    }

    private Range r2(Range range, Range range2) {
        ImplicitVolume.Locals locals = this.locals2.get();
        locals.r0.set(this.m2 / 4.0);
        Range.mul(locals.r1, locals.r0, range2);
        locals.r4.set(this.a);
        Range.abs(locals.r2, Range.div(locals.tr1, Range.cos(locals.tr0, locals.r1), locals.r4));
        locals.r4.set(this.b);
        Range.abs(locals.r3, Range.div(locals.tr1, Range.sin(locals.tr0, locals.r1), locals.r4));
        Range.pow(locals.r4, locals.r2, this.n22);
        Range.pow(locals.r5, locals.r3, this.n23);
        Range.add(locals.r6, locals.r4, locals.r5);
        Range.pow(range, locals.r6, -1.0 / this.n21);
        return range;
    }

    private double r1(double d) {
        double d2 = Math.pow(Math.abs(Math.cos(this.m1 * d / 4.0) / this.a), this.n12) + Math.pow(Math.abs(Math.sin(this.m1 * d / 4.0) / this.b), this.n13);
        return Math.pow(d2, -1.0 / this.n11);
    }

    private double r2(double d) {
        double d2 = Math.pow(Math.abs(Math.cos(this.m2 * d / 4.0) / this.a), this.n22) + Math.pow(Math.abs(Math.sin(this.m2 * d / 4.0) / this.b), this.n23);
        return Math.pow(d2, -1.0 / this.n21);
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        tuple3d.set(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
        tuple3d2.set(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        ImplicitVolume.Locals locals = (ImplicitVolume.Locals)this.locals.get();
        for (int i = 0; i < 32; ++i) {
            double d = Math.PI * 2 * (double)(i + 0) / 32.0 - Math.PI;
            double d2 = Math.PI * 2 * (double)(i + 1) / 32.0 - Math.PI;
            locals.r0.set(d, d2);
            this.r1(locals.r2, locals.r0);
            for (int j = 0; j < 32; ++j) {
                double d3 = Math.PI * (double)(j + 0) / 32.0 - 1.5707963267948966;
                double d4 = Math.PI * (double)(j + 1) / 32.0 - 1.5707963267948966;
                locals.r1.set(d3, d4);
                this.r2(locals.r3, locals.r1);
                Range.abs(locals.r4, Range.mul(locals.tr0, locals.r2, locals.r3));
                Range.abs(locals.r5, locals.r3);
                Range.abs(locals.x, Range.mul(locals.tr0, Range.mul(locals.tr1, Range.cos(locals.tr2, locals.r0), Range.cos(locals.tr3, locals.r1)), locals.r4));
                Range.abs(locals.y, Range.mul(locals.tr0, Range.mul(locals.tr1, Range.sin(locals.tr2, locals.r0), Range.cos(locals.tr3, locals.r1)), locals.r4));
                Range.abs(locals.z, Range.mul(locals.tr0, locals.r3, Range.sin(locals.tr1, locals.r1)));
                tuple3d.x = Math.min(tuple3d.x, -locals.x.b);
                tuple3d.y = Math.min(tuple3d.y, -locals.y.b);
                tuple3d.z = Math.min(tuple3d.z, -locals.z.b);
                tuple3d2.x = Math.max(tuple3d2.x, locals.x.b);
                tuple3d2.y = Math.max(tuple3d2.y, locals.y.b);
                tuple3d2.z = Math.max(tuple3d2.z, locals.z.b);
            }
        }
        tuple3d.scale(1.0001);
        tuple3d2.scale(1.0001);
    }
}

