/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath.geom;

import de.grogra.vecmath.Math2;
import de.grogra.vecmath.geom.BoundingBox;
import de.grogra.vecmath.geom.Intersection;
import de.grogra.vecmath.geom.IntersectionList;
import de.grogra.vecmath.geom.Line;
import de.grogra.vecmath.geom.TransformableVolume;
import de.grogra.vecmath.geom.Variables;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;

public class SensorDisc
extends TransformableVolume {
    public boolean computeIntersections(Line line, int n, IntersectionList intersectionList, Intersection intersection, Intersection intersection2) {
        if (intersection != null && intersection.volume == this) {
            return false;
        }
        if (intersection2 != null && intersection2.volume == this) {
            return false;
        }
        Vector3d vector3d = intersectionList.tmpVector1;
        this.transformPoint(line.origin, vector3d);
        Vector3d vector3d2 = intersectionList.tmpVector0;
        this.transformVector(line.direction, vector3d2);
        double d = -Math2.dot(vector3d, (Tuple3d)vector3d2) / vector3d2.lengthSquared();
        if (line.start <= d && d <= line.end) {
            vector3d2.scaleAdd(d, vector3d);
            if (vector3d2.lengthSquared() <= 1.0) {
                intersectionList.add(this, line, d, 0);
            }
        }
        return false;
    }

    public boolean contains(Tuple3d tuple3d, boolean bl) {
        return false;
    }

    public void getExtent(Tuple3d tuple3d, Tuple3d tuple3d2, Variables variables) {
        Matrix3d matrix3d = this.getObjectToWorldRotationScale();
        tuple3d2.set(Math.sqrt(matrix3d.m00 * matrix3d.m00 + matrix3d.m01 * matrix3d.m01 + matrix3d.m02 * matrix3d.m02), Math.sqrt(matrix3d.m10 * matrix3d.m10 + matrix3d.m11 * matrix3d.m11 + matrix3d.m12 * matrix3d.m12), Math.sqrt(matrix3d.m20 * matrix3d.m20 + matrix3d.m21 * matrix3d.m21 + matrix3d.m22 * matrix3d.m22));
        Vector3d vector3d = variables.tmpVector0;
        vector3d.x = this.t0;
        vector3d.y = this.t1;
        vector3d.z = this.t2;
        tuple3d.sub(vector3d, tuple3d2);
        tuple3d2.add(vector3d);
    }

    public boolean boxContainsBoundary(BoundingBox boundingBox, Tuple3d tuple3d, double d, Variables variables) {
        Vector3d vector3d = variables.tmpVector1;
        Vector3d vector3d2 = variables.tmpVector2;
        this.getExtent(vector3d, vector3d2, variables);
        return Math2.lessThanOrEqual(boundingBox.min, vector3d2) && Math2.lessThanOrEqual(vector3d, boundingBox.max);
    }

    public void computeNormal(Intersection intersection, Vector3d vector3d) {
        vector3d.x = this.m20;
        vector3d.y = this.m21;
        vector3d.z = this.m22;
        vector3d.normalize();
    }

    public void computeUV(Intersection intersection, Vector2d vector2d) {
    }

    public void computeTangents(Intersection intersection, Vector3d vector3d, Vector3d vector3d2) {
    }
}

