/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.vecmath;

import de.grogra.vecmath.CutConeParameter;
import de.grogra.vecmath.CutRay2Parameter;
import de.grogra.vecmath.Matrix34d;
import java.awt.geom.AffineTransform;
import java.util.Random;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public final class Math2 {
    public static float M_PI;
    public static float M_PI_2;
    public static float M_2PI;
    public static float M_1_PI;
    public static float M_1_2PI;
    public static final float EPSILON = 1.0E-9f;
    public static final float EPS = 1.0E-5f;
    public static int nbSkySegments;
    public static final Vector3d[] turtsky;
    private static final float[] sin;
    private static final int RANDOM_SIZE = 512;
    private static final int RANDOM_MASK = 511;
    private static final float[] random;
    private static final char[] randomPermutation;

    private Math2() {
    }

    public static char random(char c) {
        return randomPermutation[c];
    }

    private static char random1d(int n, int n2) {
        return randomPermutation[(char)(n ^ n2)];
    }

    private static char random2d(int n, int n2) {
        return randomPermutation[randomPermutation[(char)n] ^ (char)n2];
    }

    public static float noise(float f, float f2, float f3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (f < 0.0f) {
            n6 = 1 - (int)f;
            n5 = (int)((float)n6 + f) - n6;
        } else {
            n5 = n6 = (int)f;
        }
        if (f2 < 0.0f) {
            n4 = 1 - (int)f2;
            n3 = (int)((float)n4 + f2) - n4;
        } else {
            n3 = n4 = (int)f2;
        }
        if (f3 < 0.0f) {
            n2 = 1 - (int)f3;
            n = (int)((float)n2 + f3) - n2;
        } else {
            n = (int)f3;
        }
        n2 = n;
        float f4 = f - (float)n6;
        float f5 = f2 - (float)n4;
        float f6 = f3 - (float)n2;
        float f7 = f4 * f4 * (3.0f - 2.0f * f4);
        float f8 = f5 * f5 * (3.0f - 2.0f * f5);
        float f9 = f6 * f6 * (3.0f - 2.0f * f6);
        float f10 = 1.0f - f7;
        float f11 = 1.0f - f8;
        float f12 = f10 * f11;
        float f13 = f7 * f11;
        float f14 = f10 * f8;
        float f15 = f7 * f8;
        char c = Math2.random2d(n6, n4);
        char c2 = Math2.random2d(n6 + 1, n4);
        char c3 = Math2.random2d(n6, n4 + 1);
        char c4 = Math2.random2d(n6 + 1, n4 + 1);
        f = ((1.0f - f9) * (f12 * Math2.incrSum(Math2.random1d(c, n2), f4, f5, f6) + f13 * Math2.incrSum(Math2.random1d(c2, n2), f4 - 1.0f, f5, f6) + f14 * Math2.incrSum(Math2.random1d(c3, n2), f4, f5 - 1.0f, f6) + f15 * Math2.incrSum(Math2.random1d(c4, n2), f4 - 1.0f, f5 - 1.0f, f6)) + f9 * (f12 * Math2.incrSum(Math2.random1d(c, n2 + 1), f4, f5, f6 -= 1.0f) + f13 * Math2.incrSum(Math2.random1d(c2, n2 + 1), f4 - 1.0f, f5, f6) + f14 * Math2.incrSum(Math2.random1d(c3, n2 + 1), f4, f5 - 1.0f, f6) + f15 * Math2.incrSum(Math2.random1d(c4, n2 + 1), f4 - 1.0f, f5 - 1.0f, f6))) * 2.0f;
        return f <= -1.0f ? -1.0f : (f >= 1.0f ? 1.0f : f);
    }

    private static float incrSum(int n, float f, float f2, float f3) {
        return random[n & 0x1FF] * 0.5f + random[n + 1 & 0x1FF] * f + random[n + 2 & 0x1FF] * f2 + random[n + 3 & 0x1FF] * f3;
    }

    public static void dNoise(Tuple3f tuple3f, float f, float f2, float f3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (f < 0.0f) {
            n6 = 1 - (int)f;
            n5 = (int)((float)n6 + f) - n6;
        } else {
            n5 = n6 = (int)f;
        }
        if (f2 < 0.0f) {
            n4 = 1 - (int)f2;
            n3 = (int)((float)n4 + f2) - n4;
        } else {
            n3 = n4 = (int)f2;
        }
        if (f3 < 0.0f) {
            n2 = 1 - (int)f3;
            n = (int)((float)n2 + f3) - n2;
        } else {
            n = (int)f3;
        }
        n2 = n;
        float f4 = f - (float)n6;
        float f5 = f2 - (float)n4;
        float f6 = f3 - (float)n2;
        float f7 = f4 * f4 * (3.0f - 2.0f * f4);
        float f8 = f5 * f5 * (3.0f - 2.0f * f5);
        float f9 = f6 * f6 * (3.0f - 2.0f * f6);
        float f10 = 1.0f - f7;
        float f11 = 1.0f - f8;
        float f12 = 1.0f - f9;
        float f13 = f4 - 1.0f;
        float f14 = f5 - 1.0f;
        float f15 = f10 * f11;
        float f16 = f7 * f11;
        float f17 = f10 * f8;
        float f18 = f7 * f8;
        char c = Math2.random2d(n6, n4);
        char c2 = Math2.random2d(n6 + 1, n4);
        char c3 = Math2.random2d(n6, n4 + 1);
        char c4 = Math2.random2d(n6 + 1, n4 + 1);
        char c5 = Math2.random1d(c, n2);
        float f19 = f12 * f15;
        tuple3f.x = f19 * Math2.incrSum(c5, f4, f5, f6);
        tuple3f.y = f19 * Math2.incrSum(c5 + 8, f4, f5, f6);
        tuple3f.z = f19 * Math2.incrSum(c5 + 16, f4, f5, f6);
        c5 = Math2.random1d(c2, n2);
        f19 = f12 * f16;
        tuple3f.x += f19 * Math2.incrSum(c5, f13, f5, f6);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f13, f5, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f13, f5, f6);
        c5 = Math2.random1d(c3, n2);
        f19 = f12 * f17;
        tuple3f.x += f19 * Math2.incrSum(c5, f4, f14, f6);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f4, f14, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f4, f14, f6);
        c5 = Math2.random1d(c4, n2);
        f19 = f12 * f18;
        tuple3f.x += f19 * Math2.incrSum(c5, f13, f14, f6);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f13, f14, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f13, f14, f6);
        c5 = Math2.random1d(c, ++n2);
        f19 = f9 * f15;
        tuple3f.x += f19 * Math2.incrSum(c5, f4, f5, f6 -= 1.0f);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f4, f5, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f4, f5, f6);
        c5 = Math2.random1d(c2, n2);
        f19 = f9 * f16;
        tuple3f.x += f19 * Math2.incrSum(c5, f13, f5, f6);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f13, f5, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f13, f5, f6);
        c5 = Math2.random1d(c3, n2);
        f19 = f9 * f17;
        tuple3f.x += f19 * Math2.incrSum(c5, f4, f14, f6);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f4, f14, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f4, f14, f6);
        c5 = Math2.random1d(c4, n2);
        f19 = f9 * f18;
        tuple3f.x += f19 * Math2.incrSum(c5, f13, f14, f6);
        tuple3f.y += f19 * Math2.incrSum(c5 + 8, f13, f14, f6);
        tuple3f.z += f19 * Math2.incrSum(c5 + 16, f13, f14, f6);
    }

    public static void dTurbulence(Tuple3f tuple3f, float f, float f2, float f3, int n, float f4, float f5) {
        Math2.dNoise(tuple3f, f, f2, f3);
        float f6 = tuple3f.x;
        float f7 = tuple3f.y;
        float f8 = tuple3f.z;
        float f9 = f4;
        float f10 = f5;
        while (--n > 0) {
            Math2.dNoise(tuple3f, f * f9, f2 * f9, f3 * f9);
            f6 += tuple3f.x * f10;
            f7 += tuple3f.y * f10;
            f8 += tuple3f.z * f10;
            if (n <= 1) continue;
            f9 *= f4;
            f10 *= f5;
        }
        tuple3f.x = f6;
        tuple3f.y = f7;
        tuple3f.z = f8;
    }

    public static float turbulence(float f, float f2, float f3, int n, float f4, float f5) {
        float f6 = Math2.noise(f, f2, f3);
        float f7 = f4;
        float f8 = f5;
        while (--n > 0) {
            f6 += f8 * Math2.noise(f * f7, f2 * f7, f3 * f7);
            if (n <= 1) continue;
            f7 *= f4;
            f8 *= f5;
        }
        return f6;
    }

    public static float csin(char c) {
        return c <= '\u8000' ? (c <= '\u4000' ? sin[c] : sin[32768 - c]) : (c <= '\uc000' ? -sin[c - 32768] : -sin[65536 - c]);
    }

    public static float ccos(char c) {
        return Math2.csin((char)(c + 16384));
    }

    public static float sin(float f) {
        f *= M_1_2PI;
        return Math2.csin((f -= (float)((int)f)) >= 0.0f ? (char)(f * 65536.0f) : (char)((f + 1.0f) * 65536.0f));
    }

    public static float sin01(float f) {
        return Math2.csin((f -= (float)((int)f)) >= 0.0f ? (char)(f * 65536.0f) : (char)((f + 1.0f) * 65536.0f));
    }

    public static long nextRandom(long l) {
        return l * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
    }

    public static int floor(double d) {
        int n = (int)d;
        return d >= 0.0 || (double)n == d ? n : n - 1;
    }

    public static float gamma(float f) {
        float f2 = 1.0f;
        while (f > 3.0f) {
            f2 *= (f -= 1.0f);
        }
        while (f < 2.0f) {
            f2 /= f;
            f += 1.0f;
        }
        return f2 * (1.0f + (f -= 2.0f) * (0.422784f + f * (0.41184f + f * (0.0815769f + f * (0.074249f + f * (-2.66982E-4f + f * (0.011154f + f * (-0.00285265f + f * (0.00210393f - f * 9.19574E-4f)))))))));
    }

    public static boolean quadricIntersection(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, Point3d point3d, Vector3d vector3d, double[] dArray) {
        double d11 = d7 * vector3d.x + d8 * vector3d.y + d9 * vector3d.z + d * point3d.x * vector3d.x + d4 * point3d.y * vector3d.y + d6 * point3d.z * vector3d.z + d2 * (point3d.x * vector3d.y + point3d.y * vector3d.x) + d3 * (point3d.x * vector3d.z + point3d.z * vector3d.x) + d5 * (point3d.y * vector3d.z + point3d.z * vector3d.y);
        double d12 = d * vector3d.x * vector3d.x + d4 * vector3d.y * vector3d.y + d6 * vector3d.z * vector3d.z + 2.0 * (d2 * vector3d.x * vector3d.y + d3 * vector3d.x * vector3d.z + d5 * vector3d.y * vector3d.z);
        if ((d10 = d11 * d11 - d12 * (d10 + d * point3d.x * point3d.x + d4 * point3d.y * point3d.y + d6 * point3d.z * point3d.z + 2.0 * (d2 * point3d.x * point3d.y + d3 * point3d.x * point3d.z + d5 * point3d.y * point3d.z + d7 * point3d.x + d8 * point3d.y + d9 * point3d.z))) < 0.0 || d12 == 0.0) {
            return false;
        }
        if (d10 > 0.0) {
            d10 = Math.sqrt(d10);
        }
        dArray[0] = -(d11 + d10) / d12;
        dArray[1] = (-d11 + d10) / d12;
        return true;
    }

    public static double distance(Tuple3d tuple3d, Vector3d vector3d, Tuple3d tuple3d2) {
        double d = tuple3d.x - tuple3d2.x;
        double d2 = tuple3d.y - tuple3d2.y;
        double d3 = tuple3d.z - tuple3d2.z;
        double d4 = d * vector3d.x + d2 * vector3d.y + d3 * vector3d.z;
        return (d4 = d * d + d2 * d2 + d3 * d3 - d4 * d4 / vector3d.lengthSquared()) <= 0.0 ? 0.0 : Math.sqrt(d4);
    }

    public static double closestConnection(Tuple3d tuple3d, Vector3d vector3d, Tuple3d tuple3d2) {
        double d = tuple3d2.x - tuple3d.x;
        double d2 = tuple3d2.y - tuple3d.y;
        double d3 = tuple3d2.z - tuple3d.z;
        return (d * vector3d.x + d2 * vector3d.y + d3 * vector3d.z) / vector3d.lengthSquared();
    }

    public static double shortestConnection(Tuple3d tuple3d, Vector3d vector3d, Tuple3d tuple3d2, Vector3d vector3d2, double[] dArray) {
        double d = tuple3d.x - tuple3d2.x;
        double d2 = tuple3d.y - tuple3d2.y;
        double d3 = tuple3d.z - tuple3d2.z;
        double d4 = vector3d.lengthSquared();
        double d5 = vector3d2.lengthSquared();
        double d6 = vector3d.dot(vector3d2);
        double d7 = vector3d.x * d + vector3d.y * d2 + vector3d.z * d3;
        double d8 = vector3d2.x * d + vector3d2.y * d2 + vector3d2.z * d3;
        d = d * d + d2 * d2 + d3 * d3;
        d2 = d6 * d8 - d7 * d5;
        dArray[0] = d3 = d2 / (d4 * d5 - d6 * d6);
        dArray[1] = (d8 + d3 * d6) / d5;
        return (d -= (d8 * d8 + d2 * d3) / d5) > 0.0 ? Math.sqrt(d) : 0.0;
    }

    public static double shortestConnection(Tuple3d tuple3d, Vector3d vector3d, Tuple3f tuple3f, Vector3f vector3f, double[] dArray) {
        double d = tuple3d.x - (double)tuple3f.x;
        double d2 = tuple3d.y - (double)tuple3f.y;
        double d3 = tuple3d.z - (double)tuple3f.z;
        double d4 = vector3d.lengthSquared();
        double d5 = vector3f.lengthSquared();
        double d6 = vector3d.x * (double)vector3f.x + vector3d.y * (double)vector3f.y + vector3d.z * (double)vector3f.z;
        double d7 = vector3d.x * d + vector3d.y * d2 + vector3d.z * d3;
        double d8 = (double)vector3f.x * d + (double)vector3f.y * d2 + (double)vector3f.z * d3;
        d = d * d + d2 * d2 + d3 * d3;
        d2 = d6 * d8 - d7 * d5;
        dArray[0] = d3 = d2 / (d4 * d5 - d6 * d6);
        dArray[1] = (d8 + d3 * d6) / d5;
        return (d -= (d8 * d8 + d2 * d3) / d5) > 0.0 ? Math.sqrt(d) : 0.0;
    }

    public static float shortestConnection(Tuple3f tuple3f, Vector3f vector3f, Tuple3f tuple3f2, Vector3f vector3f2, float[] fArray) {
        float f = tuple3f.x - tuple3f2.x;
        float f2 = tuple3f.y - tuple3f2.y;
        float f3 = tuple3f.z - tuple3f2.z;
        float f4 = vector3f.lengthSquared();
        float f5 = vector3f2.lengthSquared();
        float f6 = vector3f.dot(vector3f2);
        float f7 = vector3f.x * f + vector3f.y * f2 + vector3f.z * f3;
        float f8 = vector3f2.x * f + vector3f2.y * f2 + vector3f2.z * f3;
        f = f * f + f2 * f2 + f3 * f3;
        f2 = f6 * f8 - f7 * f5;
        fArray[0] = f3 = f2 / (f4 * f5 - f6 * f6);
        fArray[1] = (f8 + f3 * f6) / f5;
        return (f -= (f8 * f8 + f2 * f3) / f5) > 0.0f ? (float)Math.sqrt(f) : 0.0f;
    }

    public static void mulAffine(Matrix3d matrix3d, Matrix3d matrix3d2, Matrix3d matrix3d3) {
        double d = matrix3d2.m00;
        double d2 = matrix3d3.m02;
        double d3 = matrix3d2.m01;
        double d4 = matrix3d3.m12;
        matrix3d.m02 = d * d2 + d3 * d4 + matrix3d2.m02;
        double d5 = matrix3d2.m10;
        double d6 = matrix3d2.m11;
        matrix3d.m12 = d5 * d2 + d6 * d4 + matrix3d2.m12;
        d2 = matrix3d3.m00;
        d4 = matrix3d3.m10;
        matrix3d.m00 = d * d2 + d3 * d4;
        matrix3d.m10 = d5 * d2 + d6 * d4;
        d2 = matrix3d3.m01;
        d4 = matrix3d3.m11;
        matrix3d.m01 = d * d2 + d3 * d4;
        matrix3d.m11 = d5 * d2 + d6 * d4;
    }

    public static void invertAffine(Matrix3f matrix3f, Matrix3f matrix3f2) {
        float f = matrix3f.m02;
        float f2 = matrix3f.m12;
        float f3 = matrix3f.m00;
        float f4 = matrix3f.m11;
        float f5 = matrix3f.m01;
        float f6 = matrix3f.m10;
        float f7 = 1.0f / (f3 * f4 - f5 * f6);
        matrix3f2.m00 = f4 * f7;
        matrix3f2.m01 = -f5 * f7;
        matrix3f2.m02 = -(matrix3f2.m00 * f + matrix3f2.m01 * f2);
        matrix3f2.m10 = -f6 * f7;
        matrix3f2.m11 = f3 * f7;
        matrix3f2.m12 = -(matrix3f2.m10 * f + matrix3f2.m11 * f2);
    }

    public static void invertAffine(Matrix3d matrix3d, Matrix3d matrix3d2) {
        double d = matrix3d.m02;
        double d2 = matrix3d.m12;
        double d3 = matrix3d.m00;
        double d4 = matrix3d.m11;
        double d5 = matrix3d.m01;
        double d6 = matrix3d.m10;
        double d7 = 1.0 / (d3 * d4 - d5 * d6);
        matrix3d2.m00 = d4 * d7;
        matrix3d2.m01 = -d5 * d7;
        matrix3d2.m02 = -(matrix3d2.m00 * d + matrix3d2.m01 * d2);
        matrix3d2.m10 = -d6 * d7;
        matrix3d2.m11 = d3 * d7;
        matrix3d2.m12 = -(matrix3d2.m10 * d + matrix3d2.m11 * d2);
    }

    public static void invTransformVector(Matrix3f matrix3f, Tuple2f tuple2f) {
        float f = tuple2f.x;
        float f2 = tuple2f.y;
        float f3 = matrix3f.m00;
        float f4 = matrix3f.m11;
        float f5 = matrix3f.m01;
        float f6 = matrix3f.m10;
        float f7 = 1.0f / (f3 * f4 - f5 * f6);
        tuple2f.x = (f4 * f - f5 * f2) * f7;
        tuple2f.y = (f3 * f2 - f6 * f) * f7;
    }

    public static void invTransformPoint(Matrix3f matrix3f, Tuple2f tuple2f) {
        tuple2f.x -= matrix3f.m02;
        tuple2f.y -= matrix3f.m12;
        Math2.invTransformVector(matrix3f, tuple2f);
    }

    public static void invTransformVector(Matrix3d matrix3d, Tuple2d tuple2d) {
        double d = tuple2d.x;
        double d2 = tuple2d.y;
        double d3 = matrix3d.m00;
        double d4 = matrix3d.m11;
        double d5 = matrix3d.m01;
        double d6 = matrix3d.m10;
        double d7 = 1.0 / (d3 * d4 - d5 * d6);
        tuple2d.x = (d4 * d - d5 * d2) * d7;
        tuple2d.y = (d3 * d2 - d6 * d) * d7;
    }

    public static void invTransformPoint(Matrix3d matrix3d, Tuple2d tuple2d) {
        tuple2d.x -= matrix3d.m02;
        tuple2d.y -= matrix3d.m12;
        Math2.invTransformVector(matrix3d, tuple2d);
    }

    public static void transformVector(Matrix3d matrix3d, Tuple2d tuple2d) {
        tuple2d.set(matrix3d.m00 * tuple2d.x + matrix3d.m01 * tuple2d.y, matrix3d.m10 * tuple2d.x + matrix3d.m11 * tuple2d.y);
    }

    public static void transformPoint(Matrix3d matrix3d, Tuple2d tuple2d) {
        tuple2d.set(matrix3d.m00 * tuple2d.x + matrix3d.m01 * tuple2d.y + matrix3d.m02, matrix3d.m10 * tuple2d.x + matrix3d.m11 * tuple2d.y + matrix3d.m12);
    }

    public static void setAffineTransform(AffineTransform affineTransform, Matrix3d matrix3d) {
        affineTransform.setTransform(matrix3d.m00, matrix3d.m10, matrix3d.m01, matrix3d.m11, matrix3d.m02, matrix3d.m12);
    }

    public static void setMatrix3d(Matrix3d matrix3d, AffineTransform affineTransform) {
        matrix3d.m00 = affineTransform.getScaleX();
        matrix3d.m01 = affineTransform.getShearX();
        matrix3d.m02 = affineTransform.getTranslateX();
        matrix3d.m10 = affineTransform.getShearY();
        matrix3d.m11 = affineTransform.getScaleY();
        matrix3d.m12 = affineTransform.getTranslateY();
        matrix3d.m20 = 0.0;
        matrix3d.m21 = 0.0;
        matrix3d.m22 = 1.0;
    }

    public static void invertAffine(Matrix4f matrix4f, Matrix4f matrix4f2) {
        float f = matrix4f.m03;
        float f2 = matrix4f.m13;
        float f3 = matrix4f.m23;
        float f4 = matrix4f.m11;
        float f5 = matrix4f.m22;
        float f6 = matrix4f.m12;
        float f7 = matrix4f.m21;
        float f8 = f4 * f5 - f6 * f7;
        float f9 = matrix4f.m20;
        float f10 = matrix4f.m10;
        float f11 = f6 * f9 - f10 * f5;
        float f12 = f10 * f7 - f4 * f9;
        float f13 = matrix4f.m00;
        float f14 = matrix4f.m01;
        float f15 = matrix4f.m02;
        float f16 = 1.0f / (f13 * f8 + f14 * f11 + f15 * f12);
        matrix4f2.m00 = f8 * f16;
        matrix4f2.m01 = (f7 * f15 - f14 * f5) * f16;
        matrix4f2.m02 = (f14 * f6 - f15 * f4) * f16;
        matrix4f2.m03 = -(matrix4f2.m00 * f + matrix4f2.m01 * f2 + matrix4f2.m02 * f3);
        matrix4f2.m10 = f11 * f16;
        matrix4f2.m11 = (f13 * f5 - f15 * f9) * f16;
        matrix4f2.m12 = (f10 * f15 - f13 * f6) * f16;
        matrix4f2.m13 = -(matrix4f2.m10 * f + matrix4f2.m11 * f2 + matrix4f2.m12 * f3);
        matrix4f2.m20 = f12 * f16;
        matrix4f2.m21 = (f9 * f14 - f13 * f7) * f16;
        matrix4f2.m22 = (f13 * f4 - f14 * f10) * f16;
        matrix4f2.m23 = -(matrix4f2.m20 * f + matrix4f2.m21 * f2 + matrix4f2.m22 * f3);
    }

    public static void invertAffine(Matrix4d matrix4d, Matrix4d matrix4d2) {
        double d = matrix4d.m03;
        double d2 = matrix4d.m13;
        double d3 = matrix4d.m23;
        double d4 = matrix4d.m11;
        double d5 = matrix4d.m22;
        double d6 = matrix4d.m12;
        double d7 = matrix4d.m21;
        double d8 = d4 * d5 - d6 * d7;
        double d9 = matrix4d.m20;
        double d10 = matrix4d.m10;
        double d11 = d6 * d9 - d10 * d5;
        double d12 = d10 * d7 - d4 * d9;
        double d13 = matrix4d.m00;
        double d14 = matrix4d.m01;
        double d15 = matrix4d.m02;
        double d16 = 1.0 / (d13 * d8 + d14 * d11 + d15 * d12);
        matrix4d2.m00 = d8 * d16;
        matrix4d2.m01 = (d7 * d15 - d14 * d5) * d16;
        matrix4d2.m02 = (d14 * d6 - d15 * d4) * d16;
        matrix4d2.m03 = -(matrix4d2.m00 * d + matrix4d2.m01 * d2 + matrix4d2.m02 * d3);
        matrix4d2.m10 = d11 * d16;
        matrix4d2.m11 = (d13 * d5 - d15 * d9) * d16;
        matrix4d2.m12 = (d10 * d15 - d13 * d6) * d16;
        matrix4d2.m13 = -(matrix4d2.m10 * d + matrix4d2.m11 * d2 + matrix4d2.m12 * d3);
        matrix4d2.m20 = d12 * d16;
        matrix4d2.m21 = (d9 * d14 - d13 * d7) * d16;
        matrix4d2.m22 = (d13 * d4 - d14 * d10) * d16;
        matrix4d2.m23 = -(matrix4d2.m20 * d + matrix4d2.m21 * d2 + matrix4d2.m22 * d3);
    }

    public static void invertAffine(Matrix34d matrix34d, Matrix4d matrix4d) {
        double d = matrix34d.m03;
        double d2 = matrix34d.m13;
        double d3 = matrix34d.m23;
        double d4 = matrix34d.m11;
        double d5 = matrix34d.m22;
        double d6 = matrix34d.m12;
        double d7 = matrix34d.m21;
        double d8 = d4 * d5 - d6 * d7;
        double d9 = matrix34d.m20;
        double d10 = matrix34d.m10;
        double d11 = d6 * d9 - d10 * d5;
        double d12 = d10 * d7 - d4 * d9;
        double d13 = matrix34d.m00;
        double d14 = matrix34d.m01;
        double d15 = matrix34d.m02;
        double d16 = 1.0 / (d13 * d8 + d14 * d11 + d15 * d12);
        matrix4d.m00 = d8 * d16;
        matrix4d.m01 = (d7 * d15 - d14 * d5) * d16;
        matrix4d.m02 = (d14 * d6 - d15 * d4) * d16;
        matrix4d.m03 = -(matrix4d.m00 * d + matrix4d.m01 * d2 + matrix4d.m02 * d3);
        matrix4d.m10 = d11 * d16;
        matrix4d.m11 = (d13 * d5 - d15 * d9) * d16;
        matrix4d.m12 = (d10 * d15 - d13 * d6) * d16;
        matrix4d.m13 = -(matrix4d.m10 * d + matrix4d.m11 * d2 + matrix4d.m12 * d3);
        matrix4d.m20 = d12 * d16;
        matrix4d.m21 = (d9 * d14 - d13 * d7) * d16;
        matrix4d.m22 = (d13 * d4 - d14 * d10) * d16;
        matrix4d.m23 = -(matrix4d.m20 * d + matrix4d.m21 * d2 + matrix4d.m22 * d3);
    }

    public static void makeAffine(Matrix3d matrix3d) {
        matrix3d.m21 = 0.0;
        matrix3d.m20 = 0.0;
        matrix3d.m22 = 1.0;
    }

    public static void makeAffine(Matrix4d matrix4d) {
        matrix4d.m32 = 0.0;
        matrix4d.m31 = 0.0;
        matrix4d.m30 = 0.0;
        matrix4d.m33 = 1.0;
    }

    public static void makeAffine(Matrix3f matrix3f) {
        matrix3f.m21 = 0.0f;
        matrix3f.m20 = 0.0f;
        matrix3f.m22 = 1.0f;
    }

    public static void makeAffine(Matrix4f matrix4f) {
        matrix4f.m32 = 0.0f;
        matrix4f.m31 = 0.0f;
        matrix4f.m30 = 0.0f;
        matrix4f.m33 = 1.0f;
    }

    public static void mulAffine(Matrix4d matrix4d, Matrix4d matrix4d2, Matrix4d matrix4d3) {
        double d = matrix4d2.m00;
        double d2 = matrix4d3.m03;
        double d3 = matrix4d2.m01;
        double d4 = matrix4d3.m13;
        double d5 = matrix4d2.m02;
        double d6 = matrix4d3.m23;
        matrix4d.m03 = d * d2 + d3 * d4 + d5 * d6 + matrix4d2.m03;
        double d7 = matrix4d2.m10;
        double d8 = matrix4d2.m11;
        double d9 = matrix4d2.m12;
        matrix4d.m13 = d7 * d2 + d8 * d4 + d9 * d6 + matrix4d2.m13;
        double d10 = matrix4d2.m20;
        double d11 = matrix4d2.m21;
        double d12 = matrix4d2.m22;
        matrix4d.m23 = d10 * d2 + d11 * d4 + d12 * d6 + matrix4d2.m23;
        d2 = matrix4d3.m00;
        d4 = matrix4d3.m10;
        d6 = matrix4d3.m20;
        matrix4d.m00 = d * d2 + d3 * d4 + d5 * d6;
        matrix4d.m10 = d7 * d2 + d8 * d4 + d9 * d6;
        matrix4d.m20 = d10 * d2 + d11 * d4 + d12 * d6;
        d2 = matrix4d3.m01;
        d4 = matrix4d3.m11;
        d6 = matrix4d3.m21;
        matrix4d.m01 = d * d2 + d3 * d4 + d5 * d6;
        matrix4d.m11 = d7 * d2 + d8 * d4 + d9 * d6;
        matrix4d.m21 = d10 * d2 + d11 * d4 + d12 * d6;
        d2 = matrix4d3.m02;
        d4 = matrix4d3.m12;
        d6 = matrix4d3.m22;
        matrix4d.m02 = d * d2 + d3 * d4 + d5 * d6;
        matrix4d.m12 = d7 * d2 + d8 * d4 + d9 * d6;
        matrix4d.m22 = d10 * d2 + d11 * d4 + d12 * d6;
    }

    public static void setAffine(Matrix4d matrix4d, Matrix4d matrix4d2) {
        if (matrix4d2 != matrix4d) {
            matrix4d.m00 = matrix4d2.m00;
            matrix4d.m01 = matrix4d2.m01;
            matrix4d.m02 = matrix4d2.m02;
            matrix4d.m03 = matrix4d2.m03;
            matrix4d.m10 = matrix4d2.m10;
            matrix4d.m11 = matrix4d2.m11;
            matrix4d.m12 = matrix4d2.m12;
            matrix4d.m13 = matrix4d2.m13;
            matrix4d.m20 = matrix4d2.m20;
            matrix4d.m21 = matrix4d2.m21;
            matrix4d.m22 = matrix4d2.m22;
            matrix4d.m23 = matrix4d2.m23;
        }
    }

    public static void invMul(Matrix3d matrix3d, Tuple3d tuple3d) {
        double d = tuple3d.x;
        double d2 = tuple3d.y;
        double d3 = matrix3d.m11;
        double d4 = matrix3d.m22;
        double d5 = matrix3d.m12;
        double d6 = matrix3d.m21;
        double d7 = d3 * d4 - d5 * d6;
        double d8 = matrix3d.m20;
        double d9 = matrix3d.m10;
        double d10 = d5 * d8 - d9 * d4;
        double d11 = d9 * d6 - d3 * d8;
        double d12 = matrix3d.m00;
        double d13 = matrix3d.m01;
        double d14 = matrix3d.m02;
        double d15 = 1.0 / (d12 * d7 + d13 * d10 + d14 * d11);
        tuple3d.x = d7 * d15 * d + (d6 * d14 - d13 * d4) * d15 * d2 + (d13 * d5 - d14 * d3) * d15 * tuple3d.z;
        tuple3d.y = d10 * d15 * d + (d12 * d4 - d14 * d8) * d15 * d2 + (d9 * d14 - d12 * d5) * d15 * tuple3d.z;
        tuple3d.z = d11 * d15 * d + (d8 * d13 - d12 * d6) * d15 * d2 + (d12 * d3 - d13 * d9) * d15 * tuple3d.z;
    }

    public static void invTransformVector(Matrix4d matrix4d, Tuple3d tuple3d) {
        double d = tuple3d.x;
        double d2 = tuple3d.y;
        double d3 = matrix4d.m11;
        double d4 = matrix4d.m22;
        double d5 = matrix4d.m12;
        double d6 = matrix4d.m21;
        double d7 = d3 * d4 - d5 * d6;
        double d8 = matrix4d.m20;
        double d9 = matrix4d.m10;
        double d10 = d5 * d8 - d9 * d4;
        double d11 = d9 * d6 - d3 * d8;
        double d12 = matrix4d.m00;
        double d13 = matrix4d.m01;
        double d14 = matrix4d.m02;
        double d15 = 1.0 / (d12 * d7 + d13 * d10 + d14 * d11);
        tuple3d.x = d7 * d15 * d + (d6 * d14 - d13 * d4) * d15 * d2 + (d13 * d5 - d14 * d3) * d15 * tuple3d.z;
        tuple3d.y = d10 * d15 * d + (d12 * d4 - d14 * d8) * d15 * d2 + (d9 * d14 - d12 * d5) * d15 * tuple3d.z;
        tuple3d.z = d11 * d15 * d + (d8 * d13 - d12 * d6) * d15 * d2 + (d12 * d3 - d13 * d9) * d15 * tuple3d.z;
    }

    public static void invTransformVector(Matrix34d matrix34d, Tuple3d tuple3d) {
        double d = tuple3d.x;
        double d2 = tuple3d.y;
        double d3 = matrix34d.m11;
        double d4 = matrix34d.m22;
        double d5 = matrix34d.m12;
        double d6 = matrix34d.m21;
        double d7 = d3 * d4 - d5 * d6;
        double d8 = matrix34d.m20;
        double d9 = matrix34d.m10;
        double d10 = d5 * d8 - d9 * d4;
        double d11 = d9 * d6 - d3 * d8;
        double d12 = matrix34d.m00;
        double d13 = matrix34d.m01;
        double d14 = matrix34d.m02;
        double d15 = 1.0 / (d12 * d7 + d13 * d10 + d14 * d11);
        tuple3d.x = d7 * d15 * d + (d6 * d14 - d13 * d4) * d15 * d2 + (d13 * d5 - d14 * d3) * d15 * tuple3d.z;
        tuple3d.y = d10 * d15 * d + (d12 * d4 - d14 * d8) * d15 * d2 + (d9 * d14 - d12 * d5) * d15 * tuple3d.z;
        tuple3d.z = d11 * d15 * d + (d8 * d13 - d12 * d6) * d15 * d2 + (d12 * d3 - d13 * d9) * d15 * tuple3d.z;
    }

    public static void invTransformPoint(Matrix4d matrix4d, Tuple3d tuple3d) {
        tuple3d.x -= matrix4d.m03;
        tuple3d.y -= matrix4d.m13;
        tuple3d.z -= matrix4d.m23;
        Math2.invTransformVector(matrix4d, tuple3d);
    }

    public static void invTransformPoint(Matrix34d matrix34d, Tuple3d tuple3d) {
        tuple3d.x -= matrix34d.m03;
        tuple3d.y -= matrix34d.m13;
        tuple3d.z -= matrix34d.m23;
        Math2.invTransformVector(matrix34d, tuple3d);
    }

    public static void invTransformPointAndVector(Matrix4d matrix4d, Tuple3d tuple3d, Tuple3d tuple3d2) {
        double d = tuple3d2.x;
        double d2 = tuple3d2.y;
        double d3 = tuple3d2.z;
        double d4 = matrix4d.m11;
        double d5 = matrix4d.m22;
        double d6 = matrix4d.m12;
        double d7 = matrix4d.m21;
        double d8 = d4 * d5 - d6 * d7;
        double d9 = matrix4d.m20;
        double d10 = matrix4d.m10;
        double d11 = d6 * d9 - d10 * d5;
        double d12 = d10 * d7 - d4 * d9;
        double d13 = matrix4d.m00;
        double d14 = matrix4d.m01;
        double d15 = matrix4d.m02;
        double d16 = 1.0 / (d13 * d8 + d14 * d11 + d15 * d12);
        tuple3d2.x = d8 * d16 * d + (d7 * d15 - d14 * d5) * d16 * d2 + (d14 * d6 - d15 * d4) * d16 * d3;
        tuple3d2.y = d11 * d16 * d + (d13 * d5 - d15 * d9) * d16 * d2 + (d10 * d15 - d13 * d6) * d16 * d3;
        tuple3d2.z = d12 * d16 * d + (d9 * d14 - d13 * d7) * d16 * d2 + (d13 * d4 - d14 * d10) * d16 * d3;
        d = tuple3d.x - matrix4d.m03;
        d2 = tuple3d.y - matrix4d.m13;
        d3 = tuple3d.z - matrix4d.m23;
        tuple3d.x = d8 * d16 * d + (d7 * d15 - d14 * d5) * d16 * d2 + (d14 * d6 - d15 * d4) * d16 * d3;
        tuple3d.y = d11 * d16 * d + (d13 * d5 - d15 * d9) * d16 * d2 + (d10 * d15 - d13 * d6) * d16 * d3;
        tuple3d.z = d12 * d16 * d + (d9 * d14 - d13 * d7) * d16 * d2 + (d13 * d4 - d14 * d10) * d16 * d3;
    }

    public static void transformVector(Matrix4d matrix4d, Tuple3d tuple3d) {
        tuple3d.set(matrix4d.m00 * tuple3d.x + matrix4d.m01 * tuple3d.y + matrix4d.m02 * tuple3d.z, matrix4d.m10 * tuple3d.x + matrix4d.m11 * tuple3d.y + matrix4d.m12 * tuple3d.z, matrix4d.m20 * tuple3d.x + matrix4d.m21 * tuple3d.y + matrix4d.m22 * tuple3d.z);
    }

    public static void transformPoint(Matrix4d matrix4d, Tuple3d tuple3d) {
        tuple3d.set(matrix4d.m00 * tuple3d.x + matrix4d.m01 * tuple3d.y + matrix4d.m02 * tuple3d.z + matrix4d.m03, matrix4d.m10 * tuple3d.x + matrix4d.m11 * tuple3d.y + matrix4d.m12 * tuple3d.z + matrix4d.m13, matrix4d.m20 * tuple3d.x + matrix4d.m21 * tuple3d.y + matrix4d.m22 * tuple3d.z + matrix4d.m23);
    }

    public static void transformPoint(Matrix4d matrix4d, Tuple3d tuple3d, Tuple3d tuple3d2) {
        tuple3d2.set(matrix4d.m00 * tuple3d.x + matrix4d.m01 * tuple3d.y + matrix4d.m02 * tuple3d.z + matrix4d.m03, matrix4d.m10 * tuple3d.x + matrix4d.m11 * tuple3d.y + matrix4d.m12 * tuple3d.z + matrix4d.m13, matrix4d.m20 * tuple3d.x + matrix4d.m21 * tuple3d.y + matrix4d.m22 * tuple3d.z + matrix4d.m23);
    }

    public static void transformTranspose(Matrix3d matrix3d, Tuple3d tuple3d) {
        tuple3d.set(matrix3d.m00 * tuple3d.x + matrix3d.m10 * tuple3d.y + matrix3d.m20 * tuple3d.z, matrix3d.m01 * tuple3d.x + matrix3d.m11 * tuple3d.y + matrix3d.m21 * tuple3d.z, matrix3d.m02 * tuple3d.x + matrix3d.m12 * tuple3d.y + matrix3d.m22 * tuple3d.z);
    }

    public static void transformVector(Matrix4f matrix4f, Tuple3f tuple3f) {
        tuple3f.set(matrix4f.m00 * tuple3f.x + matrix4f.m01 * tuple3f.y + matrix4f.m02 * tuple3f.z, matrix4f.m10 * tuple3f.x + matrix4f.m11 * tuple3f.y + matrix4f.m12 * tuple3f.z, matrix4f.m20 * tuple3f.x + matrix4f.m21 * tuple3f.y + matrix4f.m22 * tuple3f.z);
    }

    public static void transformPoint(Matrix4f matrix4f, Tuple3f tuple3f) {
        tuple3f.set(matrix4f.m00 * tuple3f.x + matrix4f.m01 * tuple3f.y + matrix4f.m02 * tuple3f.z + matrix4f.m03, matrix4f.m10 * tuple3f.x + matrix4f.m11 * tuple3f.y + matrix4f.m12 * tuple3f.z + matrix4f.m13, matrix4f.m20 * tuple3f.x + matrix4f.m21 * tuple3f.y + matrix4f.m22 * tuple3f.z + matrix4f.m23);
    }

    public static void lmul(Matrix3d matrix3d, Matrix34d matrix34d) {
        double d = matrix34d.m00 * matrix3d.m00 + matrix34d.m01 * matrix3d.m10 + matrix34d.m02 * matrix3d.m20;
        double d2 = matrix34d.m10 * matrix3d.m00 + matrix34d.m11 * matrix3d.m10 + matrix34d.m12 * matrix3d.m20;
        double d3 = matrix34d.m20 * matrix3d.m00 + matrix34d.m21 * matrix3d.m10 + matrix34d.m22 * matrix3d.m20;
        double d4 = matrix34d.m00 * matrix3d.m01 + matrix34d.m01 * matrix3d.m11 + matrix34d.m02 * matrix3d.m21;
        double d5 = matrix34d.m10 * matrix3d.m01 + matrix34d.m11 * matrix3d.m11 + matrix34d.m12 * matrix3d.m21;
        double d6 = matrix34d.m20 * matrix3d.m01 + matrix34d.m21 * matrix3d.m11 + matrix34d.m22 * matrix3d.m21;
        double d7 = matrix34d.m00 * matrix3d.m02 + matrix34d.m01 * matrix3d.m12 + matrix34d.m02 * matrix3d.m22;
        double d8 = matrix34d.m10 * matrix3d.m02 + matrix34d.m11 * matrix3d.m12 + matrix34d.m12 * matrix3d.m22;
        double d9 = matrix34d.m20 * matrix3d.m02 + matrix34d.m21 * matrix3d.m12 + matrix34d.m22 * matrix3d.m22;
        matrix3d.m00 = d;
        matrix3d.m10 = d2;
        matrix3d.m20 = d3;
        matrix3d.m01 = d4;
        matrix3d.m11 = d5;
        matrix3d.m21 = d6;
        matrix3d.m02 = d7;
        matrix3d.m12 = d8;
        matrix3d.m22 = d9;
    }

    public static void getOrthogonal(Tuple3d tuple3d, Tuple3d tuple3d2) {
        if (Math.abs(tuple3d.x) > Math.abs(tuple3d.y)) {
            tuple3d2.set(tuple3d.z, 0.0, -tuple3d.x);
        } else {
            tuple3d2.set(0.0, tuple3d.z, -tuple3d.y);
        }
    }

    public static void getOrthogonal(Tuple3f tuple3f, Tuple3f tuple3f2) {
        if (Math.abs(tuple3f.x) > Math.abs(tuple3f.y)) {
            tuple3f2.set(tuple3f.z, 0.0f, -tuple3f.x);
        } else {
            tuple3f2.set(0.0f, tuple3f.z, -tuple3f.y);
        }
    }

    public static void getOrthogonalBasis(Tuple3f tuple3f, Matrix3f matrix3f, boolean bl) {
        float f = 1.0f / (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
        if (bl) {
            matrix3f.m02 = tuple3f.x * f;
            matrix3f.m12 = tuple3f.y * f;
            matrix3f.m22 = tuple3f.z * f;
        } else {
            matrix3f.m02 = tuple3f.x;
            matrix3f.m12 = tuple3f.y;
            matrix3f.m22 = tuple3f.z;
        }
        if (Math.abs(tuple3f.x) > Math.abs(tuple3f.y)) {
            float f2 = 1.0f / (float)Math.sqrt(tuple3f.x * tuple3f.x + tuple3f.z * tuple3f.z);
            matrix3f.m00 = tuple3f.z * f2;
            matrix3f.m10 = 0.0f;
            matrix3f.m20 = -tuple3f.x * f2;
        } else {
            float f3 = 1.0f / (float)Math.sqrt(tuple3f.y * tuple3f.y + tuple3f.z * tuple3f.z);
            matrix3f.m00 = 0.0f;
            matrix3f.m10 = tuple3f.z * f3;
            matrix3f.m20 = -tuple3f.y * f3;
        }
        if (bl) {
            matrix3f.m01 = matrix3f.m12 * matrix3f.m20 - matrix3f.m22 * matrix3f.m10;
            matrix3f.m11 = matrix3f.m22 * matrix3f.m00 - matrix3f.m02 * matrix3f.m20;
            matrix3f.m21 = matrix3f.m02 * matrix3f.m10 - matrix3f.m12 * matrix3f.m00;
        } else {
            matrix3f.m01 = f * (matrix3f.m12 * matrix3f.m20 - matrix3f.m22 * matrix3f.m10);
            matrix3f.m11 = f * (matrix3f.m22 * matrix3f.m00 - matrix3f.m02 * matrix3f.m20);
            matrix3f.m21 = f * (matrix3f.m02 * matrix3f.m10 - matrix3f.m12 * matrix3f.m00);
        }
    }

    public static void getOrthogonalBasis(Tuple3d tuple3d, Matrix3d matrix3d, boolean bl) {
        double d = 1.0 / Math.sqrt(tuple3d.x * tuple3d.x + tuple3d.y * tuple3d.y + tuple3d.z * tuple3d.z);
        if (bl) {
            matrix3d.m02 = tuple3d.x * d;
            matrix3d.m12 = tuple3d.y * d;
            matrix3d.m22 = tuple3d.z * d;
        } else {
            matrix3d.m02 = tuple3d.x;
            matrix3d.m12 = tuple3d.y;
            matrix3d.m22 = tuple3d.z;
        }
        if (Math.abs(tuple3d.x) > Math.abs(tuple3d.y)) {
            double d2 = 1.0 / Math.sqrt(tuple3d.x * tuple3d.x + tuple3d.z * tuple3d.z);
            matrix3d.m00 = tuple3d.z * d2;
            matrix3d.m10 = 0.0;
            matrix3d.m20 = -tuple3d.x * d2;
        } else {
            double d3 = 1.0 / Math.sqrt(tuple3d.y * tuple3d.y + tuple3d.z * tuple3d.z);
            matrix3d.m00 = 0.0;
            matrix3d.m10 = tuple3d.z * d3;
            matrix3d.m20 = -tuple3d.y * d3;
        }
        if (bl) {
            matrix3d.m01 = matrix3d.m12 * matrix3d.m20 - matrix3d.m22 * matrix3d.m10;
            matrix3d.m11 = matrix3d.m22 * matrix3d.m00 - matrix3d.m02 * matrix3d.m20;
            matrix3d.m21 = matrix3d.m02 * matrix3d.m10 - matrix3d.m12 * matrix3d.m00;
        } else {
            matrix3d.m01 = d * (matrix3d.m12 * matrix3d.m20 - matrix3d.m22 * matrix3d.m10);
            matrix3d.m11 = d * (matrix3d.m22 * matrix3d.m00 - matrix3d.m02 * matrix3d.m20);
            matrix3d.m21 = d * (matrix3d.m02 * matrix3d.m10 - matrix3d.m12 * matrix3d.m00);
        }
    }

    public static void decomposeQR(Matrix3d matrix3d, Matrix3d matrix3d2) {
        double d;
        int n;
        double d2 = Math.sqrt(matrix3d.m00 * matrix3d.m00 + matrix3d.m10 * matrix3d.m10 + matrix3d.m20 * matrix3d.m20);
        if (matrix3d.m00 < 0.0) {
            n = -1;
            d = 1.0;
        } else {
            n = 1;
            d = -1.0;
            d2 = -d2;
        }
        double d3 = matrix3d.m00 - d2;
        double d4 = matrix3d.m10;
        double d5 = matrix3d.m20;
        double d6 = d / (d2 * d3);
        matrix3d2.m00 = d + d3 * d3 * d6;
        matrix3d2.m01 = matrix3d2.m10 = d3 * d4 * d6;
        matrix3d2.m02 = matrix3d2.m20 = d3 * d5 * d6;
        matrix3d2.m11 = d + d4 * d4 * d6;
        matrix3d2.m12 = matrix3d2.m21 = d4 * d5 * d6;
        matrix3d2.m22 = d + d5 * d5 * d6;
        matrix3d.mul(matrix3d2, matrix3d);
        matrix3d.m20 = 0.0;
        matrix3d.m10 = 0.0;
        d2 = Math.sqrt(matrix3d.m11 * matrix3d.m11 + matrix3d.m21 * matrix3d.m21);
        if (matrix3d.m11 < 0.0) {
            d = 1.0;
        } else {
            d = -1.0;
            d2 = -d2;
        }
        n = -n;
        d4 = matrix3d.m11 - d2;
        d5 = matrix3d.m21;
        d6 = d / (d2 * (matrix3d.m11 - d2));
        double d7 = d + d4 * d4 * d6;
        double d8 = d4 * d5 * d6;
        double d9 = d + d5 * d5 * d6;
        double d10 = matrix3d.m12;
        matrix3d.m11 = d2 * d;
        matrix3d.m21 = 0.0;
        matrix3d.m12 = d7 * d10 + d8 * matrix3d.m22;
        matrix3d.m22 = d8 * d10 + d9 * matrix3d.m22;
        double d11 = matrix3d2.m01;
        double d12 = matrix3d2.m11;
        double d13 = matrix3d2.m21;
        matrix3d2.m01 = d11 * d7 + matrix3d2.m02 * d8;
        matrix3d2.m02 = d11 * d8 + matrix3d2.m02 * d9;
        matrix3d2.m11 = d12 * d7 + matrix3d2.m12 * d8;
        matrix3d2.m12 = d12 * d8 + matrix3d2.m12 * d9;
        matrix3d2.m21 = d13 * d7 + matrix3d2.m22 * d8;
        matrix3d2.m22 = d13 * d8 + matrix3d2.m22 * d9;
        if (n < 0) {
            matrix3d.m22 = -matrix3d.m22;
            matrix3d2.m02 = -matrix3d2.m02;
            matrix3d2.m12 = -matrix3d2.m12;
            matrix3d2.m22 = -matrix3d2.m22;
        }
    }

    public static boolean isInsideConeT(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        return Math2.isInsideConeT(d - d4, d2 - d5, d3 - d6, d7, d8, d9, d10, d11, d12);
    }

    public static boolean isInsideConeT(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d * d4 + d2 * d5 + d3 * d6;
        double d11 = d4 * d4 + d5 * d5 + d6 * d6;
        if (d10 < d11 * d7 || d10 > d11 * d8) {
            return false;
        }
        return d11 * (d * d + d2 * d2 + d3 * d3) <= d10 * d10 * (1.0 + d9 * d9);
    }

    public static double intersectLineWithFrustum(Point3d point3d, Vector3d vector3d, Point3d point3d2, Vector3d vector3d2, double d, double d2, double d3) {
        return Math2.intersectLineWithFrustum(point3d.x - point3d2.x, point3d.y - point3d2.y, point3d.z - point3d2.z, vector3d.x, vector3d.y, vector3d.z, vector3d2.x, vector3d2.y, vector3d2.z, d, d2, d3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double intersectLineWithFrustum(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12) {
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18 = d7 * d4 + d8 * d5 + d9 * d6;
        double d19 = d7 * d + d8 * d2 + d9 * d3;
        double d20 = d7 * d7 + d8 * d8 + d9 * d9;
        if (d18 == 0.0) {
            if (d19 > d11 * d20) {
                return 0.0;
            }
            if (d19 < d10 * d20) {
                return 0.0;
            }
            d17 = Double.NEGATIVE_INFINITY;
            d16 = Double.POSITIVE_INFINITY;
        } else {
            d16 = (d10 * d20 - d19) / d18;
            d17 = (d11 * d20 - d19) / d18;
            if (d16 < d17) {
                d15 = d17;
                d17 = d16;
                d16 = d15;
            }
        }
        d12 = 1.0 + d12 * d12;
        d15 = d4 * d + d5 * d2 + d6 * d3;
        double d21 = d4 * d4 + d5 * d5 + d6 * d6;
        double d22 = d * d + d2 * d2 + d3 * d3;
        double d23 = d20 * d21 - d12 * d18 * d18;
        double d24 = d20 * d15 - d12 * d18 * d19;
        double d25 = d20 * d22 - d12 * d19 * d19;
        if (d23 == 0.0) {
            if (d24 == 0.0) {
                if (d25 != 0.0) return 0.0;
                d14 = Double.NEGATIVE_INFINITY;
                d13 = Double.POSITIVE_INFINITY;
            } else {
                d14 = d13 = d25 / (-2.0 * d24);
            }
        } else {
            d = d24 * d24 - d23 * d25;
            if (d < 0.0) {
                return 0.0;
            }
            d = d <= 0.0 ? 0.0 : Math.sqrt(d);
            d14 = d18 > 0.0 == d23 > 0.0 ? (d - d24) / d23 : (-d - d24) / d23;
            d13 = Double.POSITIVE_INFINITY;
        }
        if (d14 > d17) {
            d17 = d14;
        }
        if (d13 < d16) {
            d16 = d13;
        }
        if (d17 > d16) {
            return 0.0;
        }
        if (d16 < 0.0) {
            return 0.0;
        }
        if (d17 > 1.0) {
            return 0.0;
        }
        if (d17 <= 0.0) {
            d17 = 0.0;
        }
        if (!(d16 >= 1.0)) return d16 - d17;
        d16 = 1.0;
        return d16 - d17;
    }

    public static long pow(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        long l = 1L;
        while (--n2 >= 0) {
            l *= (long)n;
        }
        return l;
    }

    public static int factorial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        int n2 = 1;
        while (n > 1) {
            n2 *= n--;
        }
        return n2;
    }

    public static int binomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException(Integer.toString(n));
        }
        if (n2 < 0 || n2 > n) {
            throw new IllegalArgumentException(Integer.toString(n2));
        }
        if (2 * n2 > n) {
            n2 = n - n2;
        }
        int n3 = 1;
        for (int i = n - n2 + 1; i <= n; ++i) {
            n3 *= i;
        }
        return n3 / Math2.factorial(n2);
    }

    public static void min(Tuple2d tuple2d, Tuple2d tuple2d2) {
        tuple2d.x = Math.min(tuple2d.x, tuple2d2.x);
        tuple2d.y = Math.min(tuple2d.y, tuple2d2.y);
    }

    public static void max(Tuple2d tuple2d, Tuple2d tuple2d2) {
        tuple2d.x = Math.max(tuple2d.x, tuple2d2.x);
        tuple2d.y = Math.max(tuple2d.y, tuple2d2.y);
    }

    public static void min(Tuple2f tuple2f, Tuple2f tuple2f2) {
        tuple2f.x = Math.min(tuple2f.x, tuple2f2.x);
        tuple2f.y = Math.min(tuple2f.y, tuple2f2.y);
    }

    public static void max(Tuple2f tuple2f, Tuple2f tuple2f2) {
        tuple2f.x = Math.max(tuple2f.x, tuple2f2.x);
        tuple2f.y = Math.max(tuple2f.y, tuple2f2.y);
    }

    public static void min(Tuple3d tuple3d, Tuple3d tuple3d2) {
        tuple3d.x = Math.min(tuple3d.x, tuple3d2.x);
        tuple3d.y = Math.min(tuple3d.y, tuple3d2.y);
        tuple3d.z = Math.min(tuple3d.z, tuple3d2.z);
    }

    public static void max(Tuple3d tuple3d, Tuple3d tuple3d2) {
        tuple3d.x = Math.max(tuple3d.x, tuple3d2.x);
        tuple3d.y = Math.max(tuple3d.y, tuple3d2.y);
        tuple3d.z = Math.max(tuple3d.z, tuple3d2.z);
    }

    public static void min(Tuple3f tuple3f, Tuple3f tuple3f2) {
        tuple3f.x = Math.min(tuple3f.x, tuple3f2.x);
        tuple3f.y = Math.min(tuple3f.y, tuple3f2.y);
        tuple3f.z = Math.min(tuple3f.z, tuple3f2.z);
    }

    public static void max(Tuple3f tuple3f, Tuple3f tuple3f2) {
        tuple3f.x = Math.max(tuple3f.x, tuple3f2.x);
        tuple3f.y = Math.max(tuple3f.y, tuple3f2.y);
        tuple3f.z = Math.max(tuple3f.z, tuple3f2.z);
    }

    public static double dot(Tuple3d tuple3d, Tuple3d tuple3d2, Tuple3d tuple3d3) {
        return (tuple3d.x - tuple3d2.x) * tuple3d3.x + (tuple3d.y - tuple3d2.y) * tuple3d3.y + (tuple3d.z - tuple3d2.z) * tuple3d3.z;
    }

    public static double estimateScaleSquared(Matrix4d matrix4d) {
        return (matrix4d.m00 * matrix4d.m00 + matrix4d.m01 * matrix4d.m01 + matrix4d.m02 * matrix4d.m02 + matrix4d.m10 * matrix4d.m10 + matrix4d.m11 * matrix4d.m11 + matrix4d.m12 * matrix4d.m12 + matrix4d.m20 * matrix4d.m20 + matrix4d.m21 * matrix4d.m21 + matrix4d.m22 * matrix4d.m22) * 0.57735;
    }

    public static float fresnel(Vector3f vector3f, Vector3f vector3f2, float f, Vector3f vector3f3, Vector3f vector3f4) {
        int n;
        vector3f4.negate(vector3f2);
        float f2 = vector3f.dot(vector3f2);
        vector3f3.scaleAdd(2.0f * f2, vector3f, vector3f4);
        if (f2 < 0.0f) {
            f2 = -f2;
            n = -1;
            f = 1.0f / f;
        } else {
            n = 1;
        }
        float f3 = f * f2;
        f3 = 1.0f - f * f + f3 * f3;
        if (f3 <= 0.0f) {
            return 1.0f;
        }
        vector3f4.scale(-f, vector3f2);
        float f4 = (float)Math.sqrt(f3);
        vector3f4.scaleAdd((float)n * (f * f2 - f4), vector3f, vector3f4);
        f3 = (f4 - f * f2) / (f4 + f * f2);
        float f5 = f3 * f3;
        f3 = (f2 - f * f4) / (f2 + f * f4);
        return (f5 + f3 * f3) * 0.5f;
    }

    public static float dot(Tuple3f tuple3f, Tuple3f tuple3f2) {
        return tuple3f.x * tuple3f2.x + tuple3f.y * tuple3f2.y + tuple3f.z * tuple3f2.z;
    }

    public static float dot(Tuple3f tuple3f, Tuple3d tuple3d) {
        return (float)((double)tuple3f.x * tuple3d.x + (double)tuple3f.y * tuple3d.y + (double)tuple3f.z * tuple3d.z);
    }

    public static double dot(Tuple3d tuple3d, Tuple3d tuple3d2) {
        return tuple3d.x * tuple3d2.x + tuple3d.y * tuple3d2.y + tuple3d.z * tuple3d2.z;
    }

    public static void mul(Tuple3f tuple3f, Tuple3f tuple3f2, Tuple3f tuple3f3) {
        tuple3f.x = tuple3f2.x * tuple3f3.x;
        tuple3f.y = tuple3f2.y * tuple3f3.y;
        tuple3f.z = tuple3f2.z * tuple3f3.z;
    }

    public static void mul(Tuple3d tuple3d, Tuple3d tuple3d2, Tuple3d tuple3d3) {
        tuple3d.x = tuple3d2.x * tuple3d3.x;
        tuple3d.y = tuple3d2.y * tuple3d3.y;
        tuple3d.z = tuple3d2.z * tuple3d3.z;
    }

    public static boolean lessThan(Tuple3d tuple3d, Tuple3d tuple3d2) {
        return tuple3d.x < tuple3d2.x && tuple3d.y < tuple3d2.y && tuple3d.z < tuple3d2.z;
    }

    public static boolean lessThanOrEqual(Tuple3d tuple3d, Tuple3d tuple3d2) {
        return tuple3d.x <= tuple3d2.x && tuple3d.y <= tuple3d2.y && tuple3d.z <= tuple3d2.z;
    }

    public static int roundUpNextPowerOfTwo(int n) {
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return ++n;
    }

    public static float[] toFloatArray(Tuple3d tuple3d) {
        float[] fArray = new float[]{(float)tuple3d.x, (float)tuple3d.y, (float)tuple3d.z};
        return fArray;
    }

    public static float[] toFloatArray(Tuple4d tuple4d) {
        float[] fArray = new float[]{(float)tuple4d.x, (float)tuple4d.y, (float)tuple4d.z, (float)tuple4d.w};
        return fArray;
    }

    public static float[] toFloatArray(Tuple4f tuple4f) {
        float[] fArray = new float[]{tuple4f.x, tuple4f.y, tuple4f.z, tuple4f.w};
        return fArray;
    }

    public static void normalize(Vector3d vector3d) {
        if (vector3d.length() == 0.0) {
            vector3d.z = 0.0;
            vector3d.y = 0.0;
            vector3d.x = 0.0;
        } else {
            vector3d.normalize();
        }
    }

    public static void normalize(Vector3f vector3f) {
        if (vector3f.length() == 0.0f) {
            vector3f.z = 0.0f;
            vector3f.y = 0.0f;
            vector3f.x = 0.0f;
        } else {
            vector3f.normalize();
        }
    }

    public static float abstpp(Vector3d vector3d, Vector3d vector3d2) {
        double d = vector3d2.x - vector3d.x;
        double d2 = vector3d2.y - vector3d.y;
        double d3 = vector3d2.z - vector3d.z;
        return (float)Math.sqrt(Math.pow(d, 2.0) + Math.pow(d2, 2.0) + Math.pow(d3, 2.0));
    }

    public static boolean isNullVector(Vector3d vector3d) {
        double d = 1.0E-9f;
        return vector3d.x < d && vector3d.y < d && vector3d.z < d;
    }

    public static float abstps(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        vector3d4.sub(vector3d2, vector3d3);
        if (Math2.isNullVector(vector3d4)) {
            return Math2.abstpp(vector3d2, vector3d);
        }
        Vector3d vector3d6 = (Vector3d)vector3d2.clone();
        Vector3d vector3d7 = (Vector3d)vector3d3.clone();
        vector3d6.sub(vector3d);
        vector3d7.sub(vector3d);
        if (Math2.isNullVector(vector3d6) || Math2.isNullVector(vector3d7)) {
            return 0.0f;
        }
        vector3d5.sub(vector3d3, vector3d2);
        Vector3d vector3d8 = (Vector3d)vector3d.clone();
        Vector3d vector3d9 = (Vector3d)vector3d.clone();
        vector3d8.sub(vector3d2);
        vector3d9.sub(vector3d3);
        double d = vector3d8.dot(vector3d5);
        double d2 = vector3d8.dot(vector3d4);
        if (d < (double)-1.0E-9f && d2 < (double)-1.0E-9f) {
            System.out.println("Alert: Error in function abstps!");
            return 0.0f;
        }
        if (d < (double)-1.0E-9f && d2 >= (double)-1.0E-9f) {
            return Math2.abstpp(vector3d2, vector3d);
        }
        if (d >= (double)-1.0E-9f && d2 < 0.0) {
            return Math2.abstpp(vector3d3, vector3d);
        }
        if (d >= (double)-1.0E-9f && d2 >= 0.0) {
            Vector3d vector3d10 = (Vector3d)vector3d5.clone();
            Math2.normalize(vector3d10);
            vector3d10.scale(d / vector3d5.length());
            vector3d.sub(vector3d2);
            vector3d10.sub(vector3d, vector3d10);
            return (float)vector3d10.length();
        }
        System.out.println("This can't happen! (VectorMath.abstps)");
        return 0.0f;
    }

    public static void cutCone(Vector3d vector3d, float f, Vector3d vector3d2, Vector3d vector3d3, CutConeParameter cutConeParameter) {
        Vector3d vector3d4 = (Vector3d)vector3d3.clone();
        int n = 0;
        int n2 = 0;
        vector3d4.sub(vector3d2);
        double d = vector3d2.z - vector3d.z;
        double d2 = vector3d3.z - vector3d.z;
        double d3 = Math.cos((double)f * Math.PI / 180.0);
        Vector3d vector3d5 = (Vector3d)vector3d2.clone();
        vector3d5.sub(vector3d);
        Vector3d vector3d6 = (Vector3d)vector3d3.clone();
        vector3d6.sub(vector3d);
        double d4 = vector3d5.length();
        double d5 = d3 * d4;
        double d6 = vector3d6.length();
        double d7 = d3 * d6;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        if ((double)f < (double)-1.0E-9f || (double)f > 90.000000001 || Math2.isNullVector(vector3d4)) {
            cutConeParameter.setCorrect(false);
            n2 = 1;
            n = 4;
        } else {
            cutConeParameter.setCorrect(true);
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 90.0f) {
                f = 90.0f;
            }
            double d12 = Math.sin((double)f * Math.PI / 180.0);
            double d13 = vector3d2.z - vector3d3.z;
            double d14 = vector3d4.length();
            double d15 = Math.pow(d12, 2.0) * Math.pow(d13, 2.0) - Math.pow(d3, 2.0) * Math.pow(vector3d2.x - vector3d3.x, 2.0) - Math.pow(d3, 2.0) * Math.pow(vector3d2.y - vector3d3.y, 2.0);
            double d16 = Math.pow(d12, 2.0) * d13 * d2 - Math.pow(d3, 2.0) * (vector3d2.x - vector3d3.x) * (vector3d3.x - vector3d.x) - Math.pow(d3, 2.0) * (vector3d2.y - vector3d3.y) * (vector3d3.y - vector3d.y);
            double d17 = Math.pow(d12, 2.0) * Math.pow(d2, 2.0) - Math.pow(d3, 2.0) * Math.pow(vector3d3.x - vector3d.x, 2.0) - Math.pow(d3, 2.0) * Math.pow(vector3d3.y - vector3d.y, 2.0);
            if (Math.abs(Math.abs(vector3d3.z - vector3d2.z) - d3 * d14) < (double)1.0E-9f) {
                if (Math.abs(d15) > 0.01) {
                    cutConeParameter.setCorrect(false);
                    n2 = 2;
                    System.out.println("< u = " + d15 + " >");
                    d15 = 0.0;
                }
                Vector3d vector3d7 = new Vector3d();
                vector3d7.cross(vector3d6, vector3d4);
                if (Math2.isNullVector(vector3d7)) {
                    d10 = d9 = d6 / d14;
                } else if (Math.abs(10.0 * d16) < (double)1.0E-9f) {
                    cutConeParameter.setCorrect(false);
                    n2 = 3;
                } else {
                    d10 = d9 = -d17 / (2.0 * d16);
                }
            } else {
                double d18 = Math.pow(d16, 2.0);
                if (Math.abs(10.0 * d15) < (double)1.0E-9f) {
                    if (d15 <= 0.0) {
                        cutConeParameter.setCorrect(false);
                        n2 = 5;
                    }
                    if (d18 < d17 * d15) {
                        if (d18 < d17 * d15 - 0.2 * Math.abs(d18) * (double)1.0E-5f) {
                            cutConeParameter.setCorrect(false);
                            n2 = 6;
                        } else {
                            d8 = 0.0;
                            d10 = d9 = -d16 / d15;
                        }
                    } else {
                        d8 = Math.sqrt(d18 - d17 * d15) / d15;
                        d10 = -d16 / d15 - d8;
                        d9 = -d16 / d15 + d8;
                    }
                } else {
                    if (d15 >= 0.0) {
                        if (d15 >= (double)1.0E-9f) {
                            cutConeParameter.setCorrect(false);
                            n2 = 7;
                        } else {
                            d15 = 0.0;
                        }
                    }
                    if (d18 < d17 * d15) {
                        n = 4;
                    } else {
                        d8 = Math.sqrt(d18 - d17 * d15) / d15;
                        d10 = -d16 / d15 - d8;
                        d9 = -d16 / d15 + d8;
                        if (d10 * d13 < -d2) {
                            if (d9 * d13 > -d2 + 0.001 * Math.abs(d13)) {
                                cutConeParameter.setCorrect(false);
                                n2 = 8;
                                System.out.println("lam1=" + d10 + ", lam2=" + d9 + ", pz-qz=" + d13 + ", qqzmssz=" + d2);
                            }
                            n = 4;
                        } else {
                            if (d9 * d13 < -d2 - 50.0 * Math.abs(d9) * (double)1.0E-5f) {
                                cutConeParameter.setCorrect(false);
                                n2 = 9;
                            }
                            d11 = 1.0;
                        }
                    }
                }
            }
        }
        if (cutConeParameter.isCorrect()) {
            System.out.println("Warning: Error occured in function cutCone (VectorMathExt)");
            System.out.println("Inconsistency number: " + n2);
        }
        if (n != 4) {
            n = d >= d5 ? (d2 >= d7 ? 1 : 2) : (d2 >= d7 ? 3 : (d11 == 1.0 && d9 > 0.0 && d10 < 1.0 ? 5 : 4));
        }
        switch (n) {
            case 1: {
                cutConeParameter.setLowLim(0.0f);
                cutConeParameter.setUpLim(1.0f);
                cutConeParameter.setA(1.0f);
                cutConeParameter.setExists(true);
                break;
            }
            case 2: {
                cutConeParameter.setLowLim((float)d9);
                cutConeParameter.setUpLim(1.0f);
                cutConeParameter.setA((float)(1.0 - d9));
                cutConeParameter.setExists(true);
                break;
            }
            case 3: {
                cutConeParameter.setLowLim(0.0f);
                cutConeParameter.setUpLim((float)d10);
                cutConeParameter.setA((float)d10);
                cutConeParameter.setExists(true);
                break;
            }
            case 4: {
                cutConeParameter.setLowLim(1.0f);
                cutConeParameter.setUpLim(0.0f);
                cutConeParameter.setA(0.0f);
                cutConeParameter.setExists(false);
                break;
            }
            case 5: {
                cutConeParameter.setLowLim((float)d9);
                cutConeParameter.setUpLim((float)d10);
                cutConeParameter.setA((float)(-2.0 * d8));
                cutConeParameter.setExists(true);
            }
        }
    }

    public static void cutRay2(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, CutRay2Parameter cutRay2Parameter) {
        double d = f7 - f5;
        double d2 = f8 - f6;
        if (Math.pow(d, 2.0) + Math.pow(d2, 2.0) < (double)1.0E-9f || Math.pow(f3, 2.0) + Math.pow(f4, 2.0) < (double)1.0E-9f) {
            cutRay2Parameter.setCorrect(false);
            cutRay2Parameter.setExists(false);
            cutRay2Parameter.setS1(0.0f);
            cutRay2Parameter.setS2(0.0f);
        } else {
            cutRay2Parameter.setCorrect(true);
            double d3 = d * (double)f4 - d2 * (double)f3;
            double d4 = f3 * (f6 - f2) - f4 * (f5 - f);
            if (d3 > (double)1.0E-9f || d3 < (double)-1.0E-9f) {
                double d5 = (d * (double)(f6 - f2) - d2 * (double)(f5 - f)) / d3;
                double d6 = d4 / d3;
                if (d5 > (double)1.0E-9f && d6 > (double)1.0E-9f && d6 < 0.999999999) {
                    cutRay2Parameter.setExists(true);
                    cutRay2Parameter.setS1((float)(d5 * (double)f3 + (double)f));
                    cutRay2Parameter.setS2((float)(d5 * (double)f4 + (double)f2));
                } else {
                    cutRay2Parameter.setExists(false);
                    cutRay2Parameter.setS1(0.0f);
                    cutRay2Parameter.setS2(0.0f);
                }
            } else if (d4 > (double)1.0E-9f || d4 < (double)-1.0E-9f) {
                cutRay2Parameter.setExists(false);
                cutRay2Parameter.setS1(0.0f);
                cutRay2Parameter.setS2(0.0f);
            } else if (f3 * (f5 - f) + f4 * (f6 - f2) > 1.0E-9f) {
                cutRay2Parameter.setExists(true);
                cutRay2Parameter.setS1(f5);
                cutRay2Parameter.setS2(f6);
            } else if (f3 * (f7 - f) + f4 * (f8 - f2) > 1.0E-9f) {
                cutRay2Parameter.setExists(true);
                cutRay2Parameter.setS1(f7);
                cutRay2Parameter.setS2(f8);
            } else {
                cutRay2Parameter.setExists(false);
                cutRay2Parameter.setS1(0.0f);
                cutRay2Parameter.setS2(0.0f);
            }
        }
    }

    public static int skySegment(Vector3d vector3d) {
        if (vector3d.z < 0.0 || Math2.isNullVector(vector3d)) {
            return -1;
        }
        Vector3d vector3d2 = (Vector3d)vector3d.clone();
        Math2.normalize(vector3d2);
        int n = -1;
        float f = 3.0f;
        for (int i = 0; i < nbSkySegments; ++i) {
            float f2 = Math2.abstpp(vector3d2, turtsky[i]);
            if (!(f2 < f)) continue;
            f = f2;
            n = i;
        }
        return n;
    }

    public static float absthgs(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        float f;
        Vector3d vector3d5 = (Vector3d)vector3d4.clone();
        Vector3d vector3d6 = (Vector3d)vector3d.clone();
        vector3d5.sub(vector3d3);
        if (Math2.isNullVector(vector3d5)) {
            return Math2.abstphg(vector3d4, vector3d, vector3d2);
        }
        vector3d6.sub(vector3d3);
        if (Math2.parallelVector(vector3d5, vector3d2)) {
            Vector3d vector3d7 = (Vector3d)vector3d5.clone();
            Math2.normalize(vector3d7);
            float f2 = (float)vector3d6.dot(vector3d7);
            vector3d7.scale(f2);
            Vector3d vector3d8 = (Vector3d)vector3d6.clone();
            vector3d8.sub(vector3d7);
            Vector3d vector3d9 = (Vector3d)vector3d4.clone();
            vector3d9.add(vector3d8);
            vector3d9.sub(vector3d);
            Vector3d vector3d10 = (Vector3d)vector3d3.clone();
            vector3d10.add(vector3d8);
            vector3d10.sub(vector3d);
            if (vector3d2.dot(vector3d9) < 0.0 && vector3d2.dot(vector3d10) < 0.0) {
                return Math2.abstps(vector3d, vector3d3, vector3d4);
            }
            return (float)vector3d8.length();
        }
        Vector3d vector3d11 = (Vector3d)vector3d2.clone();
        vector3d11.cross(vector3d11, vector3d5);
        Math2.normalize(vector3d11);
        float f3 = Math2.determinate3(vector3d5, vector3d2, vector3d11);
        if (f3 < 1.0E-9f && f3 > -1.0E-9f) {
            return 0.0f;
        }
        float f4 = -Math2.determinate3(vector3d5, vector3d6, vector3d11) / f3;
        Vector3d vector3d12 = (Vector3d)vector3d2.clone();
        vector3d12.scale(f4);
        vector3d12.add(vector3d);
        Vector3d vector3d13 = (Vector3d)vector3d12.clone();
        vector3d13.sub(vector3d);
        if (vector3d2.dot(vector3d13) < 0.0) {
            float f5 = Math2.abstps(vector3d, vector3d3, vector3d4);
            float f6 = Math2.abstphg(vector3d3, vector3d, vector3d2);
            float f7 = Math2.abstphg(vector3d4, vector3d, vector3d2);
            if (f5 < f6) {
                if (f5 < f7) {
                    return f5;
                }
                return f7;
            }
            if (f6 < f7) {
                return f6;
            }
            return f7;
        }
        float f8 = Math2.determinate3(vector3d6, vector3d2, vector3d11) / f3;
        Vector3d vector3d14 = (Vector3d)vector3d5.clone();
        vector3d14.scale(f8);
        vector3d14.add(vector3d3);
        vector3d13 = (Vector3d)vector3d14.clone();
        vector3d13.sub(vector3d3);
        Vector3d vector3d15 = (Vector3d)vector3d14.clone();
        vector3d15.sub(vector3d4);
        if (vector3d13.dot(vector3d5) > 0.0 && vector3d15.dot(vector3d5) < 0.0) {
            vector3d12.sub(vector3d14);
            return (float)vector3d12.length();
        }
        float f9 = Math2.abstphg(vector3d3, vector3d, vector3d2);
        if (f9 < (f = Math2.abstphg(vector3d4, vector3d, vector3d2))) {
            return f9;
        }
        return f;
    }

    public static float determinate3(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        return (float)(vector3d.x * (vector3d2.y * vector3d3.z - vector3d2.z * vector3d3.y) - vector3d.y * (vector3d2.x * vector3d3.z - vector3d2.z * vector3d3.x) + vector3d.z * (vector3d2.x * vector3d3.y - vector3d2.y * vector3d3.x));
    }

    public static boolean parallelVector(Vector3d vector3d, Vector3d vector3d2) {
        Math2.normalize(vector3d);
        Math2.normalize(vector3d2);
        vector3d.cross(vector3d, vector3d2);
        return Math2.isNullVector(vector3d);
    }

    public static float abstphg(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) {
        Vector3d vector3d4 = (Vector3d)vector3d.clone();
        if (Math2.isNullVector(vector3d3)) {
            return 0.0f;
        }
        vector3d4.sub(vector3d2);
        if (Math2.isNullVector(vector3d4)) {
            return 0.0f;
        }
        float f = (float)vector3d3.dot(vector3d4);
        if ((double)f < 0.0) {
            return Math2.abstpp(vector3d2, vector3d);
        }
        Vector3d vector3d5 = (Vector3d)vector3d3.clone();
        Math2.normalize(vector3d5);
        vector3d5.scale(vector3d5.dot(vector3d4));
        vector3d4.sub(vector3d5);
        return (float)vector3d4.length();
    }

    public static void onbco(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4, Vector3d vector3d5) {
        vector3d.x = vector3d2.dot(vector3d3);
        vector3d.y = vector3d2.dot(vector3d4);
        vector3d.z = vector3d2.dot(vector3d5);
    }

    public static void getBeginAndEndOfShoot(Matrix4d matrix4d, double d, Vector3d vector3d, Vector3d vector3d2) {
        vector3d.x = matrix4d.m03;
        vector3d.y = matrix4d.m13;
        vector3d.z = matrix4d.m23;
        vector3d2.x = vector3d.x + d * matrix4d.m02;
        vector3d2.y = vector3d.y + d * matrix4d.m12;
        vector3d2.z = vector3d.z + d * matrix4d.m22;
    }

    public static void getBeginOfShoot(Matrix4d matrix4d, Vector3d vector3d) {
        vector3d.x = matrix4d.m03;
        vector3d.y = matrix4d.m13;
        vector3d.z = matrix4d.m23;
    }

    public static void getEndOfShoot(Matrix4d matrix4d, double d, Vector3d vector3d) {
        vector3d.x = matrix4d.m03 + d * matrix4d.m02;
        vector3d.y = matrix4d.m13 + d * matrix4d.m12;
        vector3d.z = matrix4d.m23 + d * matrix4d.m22;
    }

    public static int clamp(int n, int n2, int n3) {
        return Math.min(Math.max(n, n2), n3);
    }

    public static long clamp(long l, long l2, long l3) {
        return Math.min(Math.max(l, l2), l3);
    }

    public static float clamp(float f, float f2, float f3) {
        return Math.min(Math.max(f, f2), f3);
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), d3);
    }

    static {
        int n;
        M_PI = (float)Math.PI;
        M_PI_2 = 1.5707964f;
        M_2PI = (float)Math.PI * 2;
        M_1_PI = 0.31830987f;
        M_1_2PI = 0.15915494f;
        nbSkySegments = 46;
        turtsky = new Vector3d[]{new Vector3d(-0.0, 0.0, 1.0), new Vector3d(0.10994, 0.33835, 0.93458), new Vector3d(-0.28782, 0.20911, 0.93458), new Vector3d(-0.28782, -0.20911, 0.93458), new Vector3d(0.10994, -0.33835, 0.93458), new Vector3d(0.35576, 0.0, 0.93458), new Vector3d(0.49115, 0.35684, 0.79463), new Vector3d(-0.1876, 0.57739, 0.79463), new Vector3d(-0.6071, 0.0, 0.79463), new Vector3d(-0.1876, -0.57739, 0.79463), new Vector3d(0.49115, -0.35684, 0.79463), new Vector3d(0.20913, 0.64363, 0.73622), new Vector3d(-0.5475, 0.39778, 0.73622), new Vector3d(-0.5475, -0.39778, 0.73622), new Vector3d(0.20913, -0.64363, 0.73622), new Vector3d(0.67675, 0.0, 0.73622), new Vector3d(0.78678, 0.33835, 0.51623), new Vector3d(0.56492, 0.64371, 0.51623), new Vector3d(-0.07866, 0.85283, 0.51623), new Vector3d(-0.43764, 0.73619, 0.51623), new Vector3d(-0.8354, 0.18872, 0.51623), new Vector3d(-0.8354, -0.18872, 0.51623), new Vector3d(-0.43764, -0.73619, 0.51623), new Vector3d(-0.07866, -0.85283, 0.51623), new Vector3d(0.56492, -0.64371, 0.51623), new Vector3d(0.78678, -0.33835, 0.51623), new Vector3d(0.27638, 0.85061, 0.44729), new Vector3d(-0.72358, 0.52571, 0.44729), new Vector3d(-0.72358, -0.52571, 0.44729), new Vector3d(0.27638, -0.85061, 0.44729), new Vector3d(0.89439, 0.0, 0.44729), new Vector3d(0.79466, 0.57735, 0.18755), new Vector3d(-0.30353, 0.93418, 0.18755), new Vector3d(-0.98225, 0.0, 0.18755), new Vector3d(-0.30353, -0.93418, 0.18755), new Vector3d(0.79466, -0.57735, 0.18755), new Vector3d(0.96465, 0.20909, 0.1604), new Vector3d(0.49695, 0.85282, 0.1604), new Vector3d(0.09923, 0.98205, 0.1604), new Vector3d(-0.65752, 0.73617, 0.1604), new Vector3d(-0.90332, 0.39785, 0.1604), new Vector3d(-0.90332, -0.39785, 0.1604), new Vector3d(-0.65752, -0.73617, 0.1604), new Vector3d(0.09923, -0.98205, 0.1604), new Vector3d(0.49695, -0.85282, 0.1604), new Vector3d(0.96465, -0.20909, 0.1604)};
        sin = new float[16385];
        random = new float[512];
        randomPermutation = new char[65536];
        for (int i = 0; i <= 65535; ++i) {
            Math2.randomPermutation[i] = (char)i;
        }
        Random random = new Random(123456789L);
        for (n = 0; n <= 65535; ++n) {
            int n2 = random.nextInt(65536);
            char c = randomPermutation[n];
            Math2.randomPermutation[n] = randomPermutation[n2];
            Math2.randomPermutation[n2] = c;
        }
        for (n = 0; n < 512; ++n) {
            Math2.random[n] = 2.0f * random.nextFloat() - 1.0f;
        }
        for (n = 0; n <= 16384; ++n) {
            Math2.sin[n] = (float)Math.sin((double)n * 9.587379924285257E-5);
        }
    }
}

