/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.billboard;

import de.grogra.billboard.Billboarder;
import de.grogra.billboard.RotationCamera;
import de.grogra.graph.Graph;
import de.grogra.graph.GraphState;
import de.grogra.graph.impl.Edge;
import de.grogra.graph.impl.Node;
import de.grogra.imp3d.VolumeAttribute;
import de.grogra.imp3d.objects.Null;
import de.grogra.imp3d.objects.Parallelogram;
import de.grogra.imp3d.objects.ShadedNull;
import de.grogra.imp3d.shading.Light;
import de.grogra.math.TVector3d;
import de.grogra.util.MimeType;
import de.grogra.vecmath.geom.HalfSpace;
import de.grogra.vecmath.geom.SimpleUnion;
import de.grogra.vecmath.geom.Variables;
import de.grogra.xl.util.ObjectList;
import java.io.File;
import java.io.IOException;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

public class GridBillboarder
extends Billboarder {
    private int visibleLayer = 0;
    private int invisibleLayer = 15;
    protected int steps = 0;
    private int stepCount = 0;
    private double stepWidthX = 0.0;
    private double stepWidthY = 0.0;
    private int oldSides = 0;
    public Point3d min;
    public Point3d max;
    private double xWidth;
    private double yWidth;

    public GridBillboarder(File file, MimeType mimeType) {
        this.camera = new RotationCamera();
        this.view3d = this.camera.getView3D();
        try {
            super.setDestination(file, mimeType);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void beginAt(int n, int n2) {
        this.currentSide = n;
        this.stepCount = n2 - 1;
        this.makeNames(this.currentSide, this.stepCount);
        this.nextSide(n - 1);
        this.griding();
    }

    public void initialize(double d, double d2, boolean bl, int n) {
        this.getExtent();
        this.steps = n % 2 == 0 ? n - 1 : n;
        this.stepWidthX = this.xWidth / (double)this.steps;
        this.stepWidthY = this.yWidth / (double)this.steps;
        this.oldSides = bl ? 4 : 2;
        this.countZero = (int)Math.floor(Math.log10(n));
        super.initialize(d, d2, bl ? 4 : 2);
        ++this.sides;
        this.griding();
    }

    public void setLayer(int n, int n2) {
        if (n < 16 && n >= 0) {
            this.visibleLayer = n;
        }
        if (n2 < 16 && n2 >= 0) {
            this.invisibleLayer = n2;
        }
    }

    public void griding(int n) {
        this.stepCount = n % this.steps;
        this.griding();
    }

    private void griding() {
        HalfSpace halfSpace = new HalfSpace();
        HalfSpace halfSpace2 = new HalfSpace();
        double d = 0.0;
        double d2 = 0.0;
        Point3d point3d = new Point3d(0.0, 0.0, 0.0);
        Point3d point3d2 = new Point3d(0.0, 0.0, 0.0);
        TVector3d tVector3d = new TVector3d(0.0, 0.0, 0.0);
        int n = this.currentSide == 0 ? 0 : this.currentSide - 1;
        switch (n) {
            case 0: {
                d = this.max.y - (double)(++this.stepCount) * this.stepWidthY;
                d2 = d + this.stepWidthY;
                point3d = new Point3d(0.0, d, 0.0);
                point3d2 = new Point3d(0.0, d2, 0.0);
                tVector3d = new TVector3d(0.0, -1.0, 0.0);
                break;
            }
            case 1: {
                d = this.max.x - (double)(++this.stepCount) * this.stepWidthX;
                d2 = d + this.stepWidthX;
                point3d = new Point3d(d, 0.0, 0.0);
                point3d2 = new Point3d(d2, 0.0, 0.0);
                tVector3d = new TVector3d(-1.0, 0.0, 0.0);
                break;
            }
            case 2: {
                d = this.min.y + (double)(++this.stepCount) * this.stepWidthY;
                d2 = d - this.stepWidthY;
                point3d = new Point3d(0.0, d, 0.0);
                point3d2 = new Point3d(0.0, d2, 0.0);
                tVector3d = new TVector3d(0.0, 1.0, 0.0);
                break;
            }
            case 3: {
                d = this.min.x + (double)(++this.stepCount) * this.stepWidthX;
                d2 = d - this.stepWidthX;
                point3d = new Point3d(d, 0.0, 0.0);
                point3d2 = new Point3d(d2, 0.0, 0.0);
                tVector3d = new TVector3d(1.0, 0.0, 0.0);
            }
        }
        halfSpace.setTransformation((Tuple3d)point3d, (Tuple3d)tVector3d);
        halfSpace2.setTransformation((Tuple3d)point3d2, (Tuple3d)tVector3d);
        ObjectList objectList = new ObjectList(100);
        objectList.push((Object)GridBillboarder.graph().getRoot());
        Point3d point3d3 = new Point3d();
        while (!objectList.isEmpty()) {
            Node node = (Node)objectList.pop();
            if (node instanceof ShadedNull && (!(node instanceof Light) || node instanceof Parallelogram)) {
                point3d3 = GridBillboarder.location((Node)((Null)node));
                if (halfSpace.contains((Tuple3d)point3d3, true) && !halfSpace2.contains((Tuple3d)point3d3, true)) {
                    ((Null)node).setLayer(this.visibleLayer);
                } else {
                    ((Null)node).setLayer(this.invisibleLayer);
                }
            }
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                Node node2 = edge.getTarget();
                if (node2 == node || !edge.testEdgeBits(768)) continue;
                objectList.push((Object)node2);
            }
        }
    }

    private void getExtent() {
        ObjectList objectList = new ObjectList(100);
        objectList.push((Object)GridBillboarder.graph().getRoot());
        SimpleUnion simpleUnion = new SimpleUnion(){};
        this.min = new Point3d();
        this.max = new Point3d();
        while (!objectList.isEmpty()) {
            Node node = (Node)objectList.pop();
            if (node instanceof ShadedNull && (!(node instanceof Light) || node instanceof Parallelogram)) {
                simpleUnion.volumes.add(VolumeAttribute.getVolume((Object)node, (boolean)true, (GraphState)GraphState.current((Graph)GridBillboarder.graph())));
            }
            for (Edge edge = node.getFirstEdge(); edge != null; edge = edge.getNext(node)) {
                Node node2 = edge.getTarget();
                if (node2 == node || !edge.testEdgeBits(768)) continue;
                objectList.push((Object)node2);
            }
        }
        simpleUnion.getExtent((Tuple3d)this.min, (Tuple3d)this.max, new Variables());
        this.xWidth = Math.abs(this.max.x - this.min.x);
        this.yWidth = Math.abs(this.max.y - this.min.y);
    }

    protected void makeNames(int n, int n2) {
        for (int i = 1; i <= n; ++i) {
            int n3 = i < n ? this.steps : n2;
            for (int j = 1; j <= n3; ++j) {
                String string = "_" + this.getLeadingZeros(this.steps, j) + j;
                String string2 = this.prefix + i + string + "." + this.suffix;
                this.insertName((this.imageFolder != "" ? this.imageFolder + "/" : "") + string2);
            }
        }
    }

    public void makeAllNames() {
        this.makeNames(this.oldSides, this.steps);
    }

    public void billboarding() {
        this.appendfix = "_" + this.getLeadingZeros(this.steps, this.stepCount) + this.stepCount;
        super.billboarding();
        if (this.currentSide > 0) {
            --this.currentSide;
        }
    }

    protected void setRunLater() {
        if (this.stepCount + 1 == this.steps && this.currentSide == this.oldSides) {
            --this.sides;
        }
        if (this.stepCount >= this.steps) {
            if (this.currentSide >= this.oldSides) {
                return;
            }
            this.nextSide();
            ++this.currentSide;
            this.stepCount = 0;
        }
        this.griding();
        this.billboarding();
    }
}

