/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.table.JTableHeader;
import org.jfree.ui.SortButtonRenderer;
import org.jfree.ui.SortableTableModel;

public class SortableTableHeaderListener
implements MouseListener,
MouseMotionListener {
    private SortableTableModel model;
    private SortButtonRenderer renderer;
    private int sortColumnIndex;

    public SortableTableHeaderListener(SortableTableModel sortableTableModel, SortButtonRenderer sortButtonRenderer) {
        this.model = sortableTableModel;
        this.renderer = sortButtonRenderer;
    }

    public void setTableModel(SortableTableModel sortableTableModel) {
        this.model = sortableTableModel;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
        if (jTableHeader.getResizingColumn() == null && jTableHeader.getDraggedDistance() < 1) {
            int n = jTableHeader.columnAtPoint(mouseEvent.getPoint());
            int n2 = jTableHeader.getTable().convertColumnIndexToModel(n);
            if (this.model.isSortable(n2)) {
                this.sortColumnIndex = jTableHeader.getTable().convertColumnIndexToModel(n);
                this.renderer.setPressedColumn(this.sortColumnIndex);
                jTableHeader.repaint();
                if (jTableHeader.getTable().isEditing()) {
                    jTableHeader.getTable().getCellEditor().stopCellEditing();
                }
            } else {
                this.sortColumnIndex = -1;
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
        if (jTableHeader.getDraggedDistance() > 0 || jTableHeader.getResizingColumn() != null) {
            this.renderer.setPressedColumn(-1);
            this.sortColumnIndex = -1;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getComponent();
        if (jTableHeader.getResizingColumn() == null && this.sortColumnIndex != -1) {
            SortableTableModel sortableTableModel = (SortableTableModel)jTableHeader.getTable().getModel();
            boolean bl = !sortableTableModel.isAscending();
            sortableTableModel.setAscending(bl);
            sortableTableModel.sortByColumn(this.sortColumnIndex, bl);
            this.renderer.setPressedColumn(-1);
            jTableHeader.repaint();
        }
    }
}

