/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.util.UnitType;

public class RectangleInsets
implements Serializable {
    private static final long serialVersionUID = 1902273207559319996L;
    public static final RectangleInsets ZERO_INSETS = new RectangleInsets(UnitType.ABSOLUTE, 0.0, 0.0, 0.0, 0.0);
    private UnitType unitType;
    private double top;
    private double left;
    private double bottom;
    private double right;

    public RectangleInsets(double d, double d2, double d3, double d4) {
        this(UnitType.ABSOLUTE, d, d2, d3, d4);
    }

    public RectangleInsets(UnitType unitType, double d, double d2, double d3, double d4) {
        if (unitType == null) {
            throw new IllegalArgumentException("Null 'unitType' argument.");
        }
        this.unitType = unitType;
        this.top = d;
        this.bottom = d3;
        this.left = d2;
        this.right = d4;
    }

    public UnitType getUnitType() {
        return this.unitType;
    }

    public double getTop() {
        return this.top;
    }

    public double getBottom() {
        return this.bottom;
    }

    public double getLeft() {
        return this.left;
    }

    public double getRight() {
        return this.right;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RectangleInsets)) {
            return false;
        }
        RectangleInsets rectangleInsets = (RectangleInsets)object;
        if (rectangleInsets.unitType != this.unitType) {
            return false;
        }
        if (this.left != rectangleInsets.left) {
            return false;
        }
        if (this.right != rectangleInsets.right) {
            return false;
        }
        if (this.top != rectangleInsets.top) {
            return false;
        }
        return this.bottom == rectangleInsets.bottom;
    }

    public int hashCode() {
        int n = this.unitType != null ? this.unitType.hashCode() : 0;
        long l = this.top != 0.0 ? Double.doubleToLongBits(this.top) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.bottom != 0.0 ? Double.doubleToLongBits(this.bottom) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.left != 0.0 ? Double.doubleToLongBits(this.left) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        l = this.right != 0.0 ? Double.doubleToLongBits(this.right) : 0L;
        n = 29 * n + (int)(l ^ l >>> 32);
        return n;
    }

    public String toString() {
        return "RectangleInsets[t=" + this.top + ",l=" + this.left + ",b=" + this.bottom + ",r=" + this.right + "]";
    }

    public Rectangle2D createAdjustedRectangle(Rectangle2D rectangle2D, LengthAdjustmentType lengthAdjustmentType, LengthAdjustmentType lengthAdjustmentType2) {
        double d;
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        if (lengthAdjustmentType == LengthAdjustmentType.EXPAND) {
            d = this.calculateLeftOutset(d4);
            d2 -= d;
            d4 = d4 + d + this.calculateRightOutset(d4);
        } else if (lengthAdjustmentType == LengthAdjustmentType.CONTRACT) {
            d = this.calculateLeftInset(d4);
            d2 += d;
            d4 = d4 - d - this.calculateRightInset(d4);
        }
        if (lengthAdjustmentType2 == LengthAdjustmentType.EXPAND) {
            d = this.calculateTopOutset(d5);
            d3 -= d;
            d5 = d5 + d + this.calculateBottomOutset(d5);
        } else if (lengthAdjustmentType2 == LengthAdjustmentType.CONTRACT) {
            d = this.calculateTopInset(d5);
            d3 += d;
            d5 = d5 - d - this.calculateBottomInset(d5);
        }
        return new Rectangle2D.Double(d2, d3, d4, d5);
    }

    public Rectangle2D createInsetRectangle(Rectangle2D rectangle2D) {
        return this.createInsetRectangle(rectangle2D, true, true);
    }

    public Rectangle2D createInsetRectangle(Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl2) {
            d = this.calculateTopInset(rectangle2D.getHeight());
            d2 = this.calculateBottomInset(rectangle2D.getHeight());
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            d3 = this.calculateLeftInset(rectangle2D.getWidth());
            d4 = this.calculateRightInset(rectangle2D.getWidth());
        }
        return new Rectangle2D.Double(rectangle2D.getX() + d3, rectangle2D.getY() + d, rectangle2D.getWidth() - d3 - d4, rectangle2D.getHeight() - d - d2);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D rectangle2D) {
        return this.createOutsetRectangle(rectangle2D, true, true);
    }

    public Rectangle2D createOutsetRectangle(Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        if (rectangle2D == null) {
            throw new IllegalArgumentException("Null 'base' argument.");
        }
        double d = 0.0;
        double d2 = 0.0;
        if (bl2) {
            d = this.calculateTopOutset(rectangle2D.getHeight());
            d2 = this.calculateBottomOutset(rectangle2D.getHeight());
        }
        double d3 = 0.0;
        double d4 = 0.0;
        if (bl) {
            d3 = this.calculateLeftOutset(rectangle2D.getWidth());
            d4 = this.calculateRightOutset(rectangle2D.getWidth());
        }
        return new Rectangle2D.Double(rectangle2D.getX() - d3, rectangle2D.getY() - d, rectangle2D.getWidth() + d3 + d4, rectangle2D.getHeight() + d + d2);
    }

    public double calculateTopInset(double d) {
        double d2 = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.top * d;
        }
        return d2;
    }

    public double calculateTopOutset(double d) {
        double d2 = this.top;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = d / (1.0 - this.top - this.bottom) * this.top;
        }
        return d2;
    }

    public double calculateBottomInset(double d) {
        double d2 = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.bottom * d;
        }
        return d2;
    }

    public double calculateBottomOutset(double d) {
        double d2 = this.bottom;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = d / (1.0 - this.top - this.bottom) * this.bottom;
        }
        return d2;
    }

    public double calculateLeftInset(double d) {
        double d2 = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.left * d;
        }
        return d2;
    }

    public double calculateLeftOutset(double d) {
        double d2 = this.left;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = d / (1.0 - this.left - this.right) * this.left;
        }
        return d2;
    }

    public double calculateRightInset(double d) {
        double d2 = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = this.right * d;
        }
        return d2;
    }

    public double calculateRightOutset(double d) {
        double d2 = this.right;
        if (this.unitType == UnitType.RELATIVE) {
            d2 = d / (1.0 - this.left - this.right) * this.right;
        }
        return d2;
    }

    public double trimWidth(double d) {
        return d - this.calculateLeftInset(d) - this.calculateRightInset(d);
    }

    public double extendWidth(double d) {
        return d + this.calculateLeftOutset(d) + this.calculateRightOutset(d);
    }

    public double trimHeight(double d) {
        return d - this.calculateTopInset(d) - this.calculateBottomInset(d);
    }

    public double extendHeight(double d) {
        return d + this.calculateTopOutset(d) + this.calculateBottomOutset(d);
    }

    public void trim(Rectangle2D rectangle2D) {
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        double d3 = this.calculateLeftInset(d);
        double d4 = this.calculateRightInset(d);
        double d5 = this.calculateTopInset(d2);
        double d6 = this.calculateBottomInset(d2);
        rectangle2D.setRect(rectangle2D.getX() + d3, rectangle2D.getY() + d5, d - d3 - d4, d2 - d5 - d6);
    }
}

