/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import org.jfree.data.general.Series;

public class MatrixSeries
extends Series
implements Serializable {
    private static final long serialVersionUID = 7934188527308315704L;
    protected double[][] data;

    public MatrixSeries(String string, int n, int n2) {
        super((Comparable)((Object)string));
        this.data = new double[n][n2];
        this.zeroAll();
    }

    public int getColumnsCount() {
        return this.data[0].length;
    }

    public Number getItem(int n) {
        int n2 = this.getItemRow(n);
        int n3 = this.getItemColumn(n);
        Double d = new Double(this.get(n2, n3));
        return d;
    }

    public int getItemColumn(int n) {
        return n % this.getColumnsCount();
    }

    public int getItemCount() {
        return this.getRowCount() * this.getColumnsCount();
    }

    public int getItemRow(int n) {
        return n / this.getColumnsCount();
    }

    public int getRowCount() {
        return this.data.length;
    }

    public double get(int n, int n2) {
        return this.data[n][n2];
    }

    public void update(int n, int n2, double d) {
        this.data[n][n2] = d;
        this.fireSeriesChanged();
    }

    public void zeroAll() {
        int n = this.getRowCount();
        int n2 = this.getColumnsCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.data[i][j] = 0.0;
            }
        }
        this.fireSeriesChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof MatrixSeries && super.equals(object)) {
            MatrixSeries matrixSeries = (MatrixSeries)object;
            if (this.getRowCount() != matrixSeries.getRowCount()) {
                return false;
            }
            return this.getColumnsCount() == matrixSeries.getColumnsCount();
        }
        return false;
    }
}

