/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.util.Calendar;
import java.util.TimeZone;
import org.jfree.data.DomainInfo;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class DynamicTimeSeriesCollection
extends AbstractIntervalXYDataset
implements IntervalXYDataset,
DomainInfo,
RangeInfo {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private int maximumItemCount = 2000;
    protected int historyCount;
    private Comparable[] seriesKeys;
    private Class timePeriodClass = Minute.class;
    protected RegularTimePeriod[] pointsInTime;
    private int seriesCount;
    protected ValueSequence[] valueHistory;
    protected Calendar workingCalendar;
    private int position;
    private boolean domainIsPointsInTime;
    private int oldestAt;
    private int newestAt;
    private long deltaTime;
    private Long domainStart;
    private Long domainEnd;
    private Range domainRange;
    private Float minValue = new Float(0.0f);
    private Float maxValue = null;
    private Range valueRange;

    public DynamicTimeSeriesCollection(int n, int n2) {
        this(n, n2, new Millisecond(), TimeZone.getDefault());
        this.newestAt = n2 - 1;
    }

    public DynamicTimeSeriesCollection(int n, int n2, TimeZone timeZone) {
        this(n, n2, new Millisecond(), timeZone);
        this.newestAt = n2 - 1;
    }

    public DynamicTimeSeriesCollection(int n, int n2, RegularTimePeriod regularTimePeriod) {
        this(n, n2, regularTimePeriod, TimeZone.getDefault());
    }

    public DynamicTimeSeriesCollection(int n, int n2, RegularTimePeriod regularTimePeriod, TimeZone timeZone) {
        this.maximumItemCount = n2;
        this.historyCount = n2;
        this.seriesKeys = new Comparable[n];
        for (int i = 0; i < n; ++i) {
            this.seriesKeys[i] = "";
        }
        this.newestAt = n2 - 1;
        this.valueHistory = new ValueSequence[n];
        this.timePeriodClass = regularTimePeriod.getClass();
        if (this.timePeriodClass == Second.class) {
            this.pointsInTime = new Second[n2];
        } else if (this.timePeriodClass == Minute.class) {
            this.pointsInTime = new Minute[n2];
        } else if (this.timePeriodClass == Hour.class) {
            this.pointsInTime = new Hour[n2];
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.position = 0;
        this.domainIsPointsInTime = true;
    }

    public synchronized long setTimeBase(RegularTimePeriod regularTimePeriod) {
        if (this.pointsInTime[0] == null) {
            this.pointsInTime[0] = regularTimePeriod;
            for (int i = 1; i < this.historyCount; ++i) {
                this.pointsInTime[i] = this.pointsInTime[i - 1].next();
            }
        }
        long l = this.pointsInTime[0].getFirstMillisecond(this.workingCalendar);
        long l2 = this.pointsInTime[1].getFirstMillisecond(this.workingCalendar);
        this.deltaTime = l2 - l;
        this.oldestAt = 0;
        this.newestAt = this.historyCount - 1;
        this.findDomainLimits();
        return this.deltaTime;
    }

    protected void findDomainLimits() {
        long l = this.getOldestTime().getFirstMillisecond(this.workingCalendar);
        long l2 = this.domainIsPointsInTime ? this.getNewestTime().getFirstMillisecond(this.workingCalendar) : this.getNewestTime().getLastMillisecond(this.workingCalendar);
        this.domainStart = new Long(l);
        this.domainEnd = new Long(l2);
        this.domainRange = new Range(l, l2);
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public void addSeries(float[] fArray, int n, Comparable comparable) {
        int n2;
        this.invalidateRangeInfo();
        if (fArray == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(): cannot add null array of values.");
        }
        if (n >= this.valueHistory.length) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(): cannot add more series than specified in c'tor");
        }
        if (this.valueHistory[n] == null) {
            this.valueHistory[n] = new ValueSequence(this.historyCount);
            ++this.seriesCount;
        }
        int n3 = fArray.length;
        int n4 = this.historyCount;
        boolean bl = false;
        if (n3 < this.historyCount) {
            bl = true;
            n4 = n3;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.valueHistory[n].enterData(n2, fArray[n2]);
        }
        if (bl) {
            for (n2 = n4; n2 < this.historyCount; ++n2) {
                this.valueHistory[n].enterData(n2, 0.0f);
            }
        }
        if (comparable != null) {
            this.seriesKeys[n] = comparable;
        }
        this.fireSeriesChanged();
    }

    public void setSeriesKey(int n, Comparable comparable) {
        this.seriesKeys[n] = comparable;
    }

    public void addValue(int n, int n2, float f) {
        this.invalidateRangeInfo();
        if (n >= this.valueHistory.length) {
            throw new IllegalArgumentException("TimeSeriesDataset.addValue(): series #" + n + "unspecified in c'tor");
        }
        if (this.valueHistory[n] == null) {
            this.valueHistory[n] = new ValueSequence(this.historyCount);
            ++this.seriesCount;
        }
        this.valueHistory[n].enterData(n2, f);
        this.fireSeriesChanged();
    }

    public int getSeriesCount() {
        return this.seriesCount;
    }

    public int getItemCount(int n) {
        return this.historyCount;
    }

    protected int translateGet(int n) {
        if (this.oldestAt == 0) {
            return n;
        }
        int n2 = n + this.oldestAt;
        if (n2 >= this.historyCount) {
            n2 -= this.historyCount;
        }
        return n2;
    }

    public int offsetFromNewest(int n) {
        return this.wrapOffset(this.newestAt + n);
    }

    public int offsetFromOldest(int n) {
        return this.wrapOffset(this.oldestAt + n);
    }

    protected int wrapOffset(int n) {
        int n2 = n;
        if (n2 >= this.historyCount) {
            n2 -= this.historyCount;
        } else if (n2 < 0) {
            n2 += this.historyCount;
        }
        return n2;
    }

    public synchronized RegularTimePeriod advanceTime() {
        RegularTimePeriod regularTimePeriod = this.pointsInTime[this.newestAt].next();
        this.newestAt = this.oldestAt;
        boolean bl = false;
        float f = 0.0f;
        if (this.maxValue != null) {
            f = this.maxValue.floatValue();
        }
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            if (this.valueHistory[i].getData(this.oldestAt) == f) {
                bl = true;
            }
            if (bl) break;
        }
        if (bl) {
            this.invalidateRangeInfo();
        }
        float f2 = 0.0f;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            this.valueHistory[i].enterData(this.newestAt, f2);
        }
        this.pointsInTime[this.newestAt] = regularTimePeriod;
        ++this.oldestAt;
        if (this.oldestAt >= this.historyCount) {
            this.oldestAt = 0;
        }
        long l = this.domainStart;
        this.domainStart = new Long(l + this.deltaTime);
        long l2 = this.domainEnd;
        this.domainEnd = new Long(l2 + this.deltaTime);
        this.domainRange = new Range(l, l2);
        this.fireSeriesChanged();
        return regularTimePeriod;
    }

    public void invalidateRangeInfo() {
        this.maxValue = null;
        this.valueRange = null;
    }

    protected double findMaxValue() {
        double d = 0.0;
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            for (int j = 0; j < this.historyCount; ++j) {
                double d2 = this.getYValue(i, j);
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public int getOldestIndex() {
        return this.oldestAt;
    }

    public int getNewestIndex() {
        return this.newestAt;
    }

    public void appendData(float[] fArray) {
        int n = fArray.length;
        if (n > this.valueHistory.length) {
            throw new IllegalArgumentException("More data than series to put them in");
        }
        for (int i = 0; i < n; ++i) {
            if (this.valueHistory[i] == null) {
                this.valueHistory[i] = new ValueSequence(this.historyCount);
            }
            this.valueHistory[i].enterData(this.newestAt, fArray[i]);
        }
        this.fireSeriesChanged();
    }

    public void appendData(float[] fArray, int n, int n2) {
        int n3 = fArray.length;
        if (n3 > this.valueHistory.length) {
            throw new IllegalArgumentException("More data than series to put them in");
        }
        for (int i = 0; i < n3; ++i) {
            if (this.valueHistory[i] == null) {
                this.valueHistory[i] = new ValueSequence(this.historyCount);
            }
            this.valueHistory[i].enterData(n, fArray[i]);
        }
        if (n2 > 0 && ++n % n2 == 0) {
            this.fireSeriesChanged();
        }
    }

    public RegularTimePeriod getNewestTime() {
        return this.pointsInTime[this.newestAt];
    }

    public RegularTimePeriod getOldestTime() {
        return this.pointsInTime[this.oldestAt];
    }

    public Number getX(int n, int n2) {
        RegularTimePeriod regularTimePeriod = this.pointsInTime[this.translateGet(n2)];
        return new Long(this.getX(regularTimePeriod));
    }

    public double getYValue(int n, int n2) {
        ValueSequence valueSequence = this.valueHistory[n];
        return valueSequence.getData(this.translateGet(n2));
    }

    public Number getY(int n, int n2) {
        return new Float(this.getYValue(n, n2));
    }

    public Number getStartX(int n, int n2) {
        RegularTimePeriod regularTimePeriod = this.pointsInTime[this.translateGet(n2)];
        return new Long(regularTimePeriod.getFirstMillisecond(this.workingCalendar));
    }

    public Number getEndX(int n, int n2) {
        RegularTimePeriod regularTimePeriod = this.pointsInTime[this.translateGet(n2)];
        return new Long(regularTimePeriod.getLastMillisecond(this.workingCalendar));
    }

    public Number getStartY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        return this.getY(n, n2);
    }

    public Comparable getSeriesKey(int n) {
        return this.seriesKeys[n];
    }

    protected void fireSeriesChanged() {
        this.seriesChanged(new SeriesChangeEvent(this));
    }

    public double getDomainLowerBound(boolean bl) {
        return this.domainStart.doubleValue();
    }

    public double getDomainUpperBound(boolean bl) {
        return this.domainEnd.doubleValue();
    }

    public Range getDomainBounds(boolean bl) {
        if (this.domainRange == null) {
            this.findDomainLimits();
        }
        return this.domainRange;
    }

    private long getX(RegularTimePeriod regularTimePeriod) {
        switch (this.position) {
            case 0: {
                return regularTimePeriod.getFirstMillisecond(this.workingCalendar);
            }
            case 1: {
                return regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
            }
            case 2: {
                return regularTimePeriod.getLastMillisecond(this.workingCalendar);
            }
        }
        return regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
    }

    public double getRangeLowerBound(boolean bl) {
        double d = Double.NaN;
        if (this.minValue != null) {
            d = this.minValue.doubleValue();
        }
        return d;
    }

    public double getRangeUpperBound(boolean bl) {
        double d = Double.NaN;
        if (this.maxValue != null) {
            d = this.maxValue.doubleValue();
        }
        return d;
    }

    public Range getRangeBounds(boolean bl) {
        if (this.valueRange == null) {
            double d = this.getRangeUpperBound(bl);
            this.valueRange = new Range(0.0, d);
        }
        return this.valueRange;
    }

    protected class ValueSequence {
        float[] dataPoints;

        public ValueSequence() {
            this(dynamicTimeSeriesCollection.maximumItemCount);
        }

        public ValueSequence(int n) {
            this.dataPoints = new float[n];
            for (int i = 0; i < n; ++i) {
                this.dataPoints[i] = 0.0f;
            }
        }

        public void enterData(int n, float f) {
            this.dataPoints[n] = f;
        }

        public float getData(int n) {
            return this.dataPoints[n];
        }
    }
}

