/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class CSV {
    private char fieldDelimiter;
    private char textDelimiter;

    public CSV() {
        this(',', '\"');
    }

    public CSV(char c, char c2) {
        this.fieldDelimiter = c;
        this.textDelimiter = c2;
    }

    public CategoryDataset readCategoryDataset(Reader reader) throws IOException {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        BufferedReader bufferedReader = new BufferedReader(reader);
        List list = null;
        int n = 0;
        String string = bufferedReader.readLine();
        while (string != null) {
            if (n == 0) {
                list = this.extractColumnKeys(string);
            } else {
                this.extractRowKeyAndData(string, defaultCategoryDataset, list);
            }
            string = bufferedReader.readLine();
            ++n;
        }
        return defaultCategoryDataset;
    }

    private List extractColumnKeys(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != this.fieldDelimiter) continue;
            if (n > 0) {
                String string2 = string.substring(n2, i);
                arrayList.add(this.removeStringDelimiters(string2));
            }
            n2 = i + 1;
            ++n;
        }
        String string3 = string.substring(n2, string.length());
        arrayList.add(this.removeStringDelimiters(string3));
        return arrayList;
    }

    private void extractRowKeyAndData(String string, DefaultCategoryDataset defaultCategoryDataset, List list) {
        String string2 = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            Object object;
            if (string.charAt(i) != this.fieldDelimiter) continue;
            if (n == 0) {
                object = string.substring(n2, i);
                string2 = this.removeStringDelimiters((String)object);
            } else {
                object = Double.valueOf(this.removeStringDelimiters(string.substring(n2, i)));
                defaultCategoryDataset.addValue((Number)object, (Comparable)((Object)string2), (Comparable)list.get(n - 1));
            }
            n2 = i + 1;
            ++n;
        }
        Double d = Double.valueOf(this.removeStringDelimiters(string.substring(n2, string.length())));
        defaultCategoryDataset.addValue(d, (Comparable)((Object)string2), (Comparable)list.get(n - 1));
    }

    private String removeStringDelimiters(String string) {
        String string2 = string.trim();
        if (string2.charAt(0) == this.textDelimiter) {
            string2 = string2.substring(1);
        }
        if (string2.charAt(string2.length() - 1) == this.textDelimiter) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }
}

