/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base.log;

import org.jfree.base.log.DefaultLog;
import org.jfree.base.log.LogConfiguration;
import org.jfree.base.modules.AbstractModule;
import org.jfree.base.modules.ModuleInitializeException;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Log;
import org.jfree.util.LogTarget;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PrintStreamLogTarget;

public class DefaultLogModule
extends AbstractModule {
    public DefaultLogModule() throws ModuleInitializeException {
        this.loadModuleInfo();
    }

    public void initialize(SubSystem subSystem) throws ModuleInitializeException {
        if (LogConfiguration.isDisableLogging()) {
            return;
        }
        if (LogConfiguration.getLogTarget().equals(PrintStreamLogTarget.class.getName())) {
            DefaultLog.installDefaultLog();
            Log.getInstance().addTarget(new PrintStreamLogTarget());
            Log.info("Default log target started ... previous log messages could have been ignored.");
        } else if ("true".equals(subSystem.getGlobalConfig().getConfigProperty("org.jfree.base.LogAutoInit"))) {
            DefaultLog.installDefaultLog();
            LogTarget logTarget = (LogTarget)ObjectUtilities.loadAndInstantiate(LogConfiguration.getLogTarget(), this.getClass());
            Log.getInstance().addTarget(logTarget);
        }
    }
}

