/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.lang.reflect.Method;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.Library;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.config.SystemPropertyConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Configuration;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.ExtendedConfigurationWrapper;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractBoot
implements SubSystem {
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    protected AbstractBoot() {
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
            this.start();
        }
        return this.globalConfig;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract Configuration loadConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object = this;
        synchronized (this) {
            BootableProjectInfo[] bootableProjectInfoArray;
            if (this.isBootInProgress() || this.isBootDone()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.bootInProgress = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = this.getProjectInfo();
            if (object != null) {
                Log.info(((Library)object).getName() + " " + ((Library)object).getVersion());
                bootableProjectInfoArray = ((BootableProjectInfo)object).getDependencies();
                for (int i = 0; i < bootableProjectInfoArray.length; ++i) {
                    AbstractBoot abstractBoot = this.loadBooter(bootableProjectInfoArray[i].getBootClass());
                    if (abstractBoot == null) continue;
                    abstractBoot.start();
                }
            }
            this.performBoot();
            bootableProjectInfoArray = this;
            synchronized (this) {
                this.bootInProgress = false;
                this.bootDone = true;
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }

    protected abstract void performBoot();

    protected abstract BootableProjectInfo getProjectInfo();

    protected AbstractBoot loadBooter(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            Method method = clazz.getMethod("getInstance", null);
            return (AbstractBoot)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + string);
            return null;
        }
    }

    protected Configuration createDefaultHierarchicalConfiguration(String string, String string2, boolean bl) {
        HierarchicalConfiguration hierarchicalConfiguration;
        HierarchicalConfiguration hierarchicalConfiguration2 = new HierarchicalConfiguration();
        if (string != null) {
            hierarchicalConfiguration = new PropertyFileConfiguration();
            ((PropertyFileConfiguration)hierarchicalConfiguration).load(string);
            hierarchicalConfiguration2.insertConfiguration(hierarchicalConfiguration);
            hierarchicalConfiguration2.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (string2 != null) {
            hierarchicalConfiguration = new PropertyFileConfiguration();
            ((PropertyFileConfiguration)hierarchicalConfiguration).load(string2);
            hierarchicalConfiguration2.insertConfiguration(hierarchicalConfiguration);
        }
        hierarchicalConfiguration = new SystemPropertyConfiguration();
        hierarchicalConfiguration2.insertConfiguration(hierarchicalConfiguration);
        return hierarchicalConfiguration2;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }
}

