/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.util;

import de.grogra.pf.ui.util.WidgetConversion;
import de.grogra.reflect.Reflection;
import de.grogra.reflect.Type;
import de.grogra.util.Quantity;
import de.grogra.util.Unit;

public class Numeric2String
implements WidgetConversion {
    public final Quantity quantity;
    private final Type type;
    private final boolean allowNull;
    private Unit lastUnit = null;
    private String lastString;

    public Numeric2String(Type type, Quantity quantity) {
        this.allowNull = Reflection.isSuperclassOrSame((Type)Type.NUMBER, (Type)type);
        if (this.allowNull) {
            for (int i = 3; i <= 9; ++i) {
                if (type.getSimpleName().indexOf(Reflection.getTypeSuffix((int)i)) < 0) continue;
                type = Reflection.getType((int)i);
                break;
            }
        }
        this.type = type;
        this.quantity = quantity;
    }

    public Object toWidget(Object object) {
        if (object == null) {
            if (this.quantity != null && this.lastUnit == null) {
                this.lastUnit = this.quantity.getPreferredUnit();
            }
            return null;
        }
        switch (this.type.getTypeId()) {
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                int n = 10;
                String string = "";
                if (this.lastString != null) {
                    if (this.lastString.startsWith("0x")) {
                        n = 16;
                        string = "0x";
                    } else if (this.lastString.startsWith("0X")) {
                        n = 16;
                        string = "0X";
                    } else if (this.lastString.startsWith("#")) {
                        n = 16;
                        string = "#";
                    }
                }
                return string + Long.toString(((Number)object).longValue(), n);
            }
            case 5: {
                return String.valueOf(object);
            }
            case 8: {
                float f = ((Number)object).floatValue();
                if (this.quantity != null) {
                    if (this.lastUnit == null) {
                        this.lastUnit = this.quantity.chooseUnit(f);
                    }
                    return this.lastUnit.toString(f);
                }
                return String.valueOf(f);
            }
            case 9: {
                double d = ((Number)object).doubleValue();
                if (this.quantity != null) {
                    if (this.lastUnit == null) {
                        this.lastUnit = this.quantity.chooseUnit((float)d);
                    }
                    return d == (double)((float)d) ? this.lastUnit.toString((float)d) : this.lastUnit.toString(d);
                }
                return d == (double)((float)d) ? String.valueOf((float)d) : String.valueOf(d);
            }
        }
        throw new IllegalStateException(this.type.getName());
    }

    public Object fromWidget(Object object) {
        String string;
        String string2 = string = object instanceof String ? ((String)object).trim() : null;
        if (this.allowNull && (string == null || string.length() == 0)) {
            return null;
        }
        this.lastString = string;
        switch (this.type.getTypeId()) {
            case 3: {
                return Byte.decode(string);
            }
            case 4: {
                return Short.decode(string);
            }
            case 6: {
                return Integer.decode(string);
            }
            case 7: {
                return Long.decode(string);
            }
            case 8: {
                if (this.quantity != null) {
                    this.lastUnit = this.quantity.parseUnit(string, this.lastUnit);
                }
                return this.lastUnit == null ? new Float(string) : new Float(this.lastUnit.parse(string));
            }
            case 9: {
                if (this.quantity != null) {
                    this.lastUnit = this.quantity.parseUnit(string, this.lastUnit);
                }
                return this.lastUnit == null ? new Double(string) : new Double(this.lastUnit.parse(string));
            }
            case 5: {
                return new Character(string == null || string.length() == 0 ? (char)'\u0000' : string.charAt(0));
            }
        }
        throw new IllegalStateException(this.type.getName());
    }
}

