/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.registry;

import de.grogra.graph.impl.Node;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.registry.LazyObjectItem;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Workbench;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import java.io.IOException;
import java.util.Collection;

public class FileObjectItem
extends LazyObjectItem {
    MimeType mimeType;
    String systemId;
    public static final Node.NType $TYPE = new Node.NType((Node)new FileObjectItem());
    public static final Node.NType.Field mimeType$FIELD = new _Field("mimeType", 0x200000, (Type)ClassAdapter.wrap(MimeType.class), null, 0);
    public static final Node.NType.Field systemId$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new FileObjectItem();
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public String getSystemId() {
        return this.systemId;
    }

    private FileObjectItem() {
        super(null, true);
    }

    public FileObjectItem(String string, MimeType mimeType, Object object, String string2) {
        super(IO.toSimpleName((String)string), true);
        this.systemId = string;
        this.mimeType = mimeType;
        this.setBaseObject(object);
        this.setType(string2);
    }

    public FileObjectItem(FileSource fileSource, Object object, String string) {
        this(fileSource.getSystemId(), fileSource.getFlavor().getMimeType(), object, string);
    }

    public FileSource createFileSource() {
        String string = this.systemId;
        if (this.getRegistry().isRootRegistry()) {
            string = "pluginfs:" + this.getPluginDescriptor().getName() + '/' + string;
        }
        return FileSource.createFileSource((String)string, (MimeType)this.mimeType, (RegistryContext)this, (ModifiableMap)new StringMap((Map)this));
    }

    protected void activateImpl() {
        Object object = this.getRegistry().getProjectFile(this.systemId);
        if (object != null) {
            this.getRegistry().getFileSystem().setMimeType(object, this.mimeType);
        }
    }

    protected boolean hasNullValue() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object fetchBaseObject() {
        FilterSource filterSource = IO.createPipeline((FilterSource)this.createFileSource(), (IOFlavor)IOFlavor.valueOf((Class)this.getObjectType().getImplementationClass()));
        if (!(filterSource instanceof ObjectSource)) {
            Workbench.current().logGUIInfo(IO.I18N.msg("openfile.unsupported", (Object)this.systemId, (Object)IO.getDescription((MimeType)this.mimeType)));
            return null;
        }
        filterSource.initProgressMonitor(UI.createProgressAdapter(Workbench.current()));
        try {
            Object object = ((ObjectSource)filterSource).getObject();
            return object;
        }
        catch (IOException iOException) {
            Workbench.current().logGUIInfo(IO.I18N.msg("openfile.failed", (Object)this.systemId), iOException);
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            filterSource.setProgress(null, 2.0f);
        }
    }

    public void addRequiredFiles(Collection collection) {
        Object object = this.getRegistry().getProjectFile(this.systemId);
        if (object != null) {
            collection.add(object);
        }
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)mimeType$FIELD);
        systemId$FIELD = new _Field("systemId", 0x200000, (Type)ClassAdapter.wrap(String.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)systemId$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((FileObjectItem)((Object)object)).mimeType = (MimeType)object2;
                    return;
                }
                case 1: {
                    ((FileObjectItem)((Object)object)).systemId = (String)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((FileObjectItem)((Object)object)).getMimeType();
                }
                case 1: {
                    return ((FileObjectItem)((Object)object)).getSystemId();
                }
            }
            return super.getObject(object);
        }
    }
}

