/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui.registry;

import de.grogra.graph.impl.Node;
import de.grogra.persistence.Manageable;
import de.grogra.persistence.ManageableType;
import de.grogra.pf.io.FileSource;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IO;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.InputStreamSourceImpl;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.FileChooserResult;
import de.grogra.pf.ui.UI;
import de.grogra.pf.ui.Window;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.registry.FileObjectItem;
import de.grogra.pf.ui.registry.ObjectItemFactory;
import de.grogra.pf.ui.registry.ResourceDirectory;
import de.grogra.reflect.ClassAdapter;
import de.grogra.reflect.Type;
import de.grogra.util.Map;
import de.grogra.util.MimeType;
import de.grogra.util.ModifiableMap;
import de.grogra.util.StringMap;
import de.grogra.util.Utils;
import de.grogra.vfs.FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class FileFactory
extends ObjectItemFactory {
    String directory;
    String mimeType;
    public static final Node.NType $TYPE = new Node.NType((Node)new FileFactory());
    public static final Node.NType.Field directory$FIELD = new _Field("directory", 0x200000, (Type)ClassAdapter.wrap(String.class), null, 0);
    public static final Node.NType.Field mimeType$FIELD;

    protected Node.NType getNTypeImpl() {
        return $TYPE;
    }

    protected Node newInstance() {
        return new FileFactory();
    }

    protected Item createItemImpl(Context context) {
        Object[] objectArray = this.read(context.getWorkbench().getRegistry(), null, true, context.getWorkbench());
        return objectArray == null ? null : (Item)objectArray[1];
    }

    private Object[] read(Registry registry, FilterSource filterSource, boolean bl, Workbench workbench) {
        Object object;
        boolean bl2;
        Object object2;
        boolean bl3;
        IOFlavor iOFlavor = IOFlavor.valueOf((Class)this.getObjectType().getImplementationClass());
        boolean bl4 = bl3 = filterSource != null;
        if (filterSource == null) {
            object2 = workbench.chooseFileToOpen(null, iOFlavor);
            if (object2 == null) {
                return null;
            }
            filterSource = ((FileChooserResult)object2).createFileSource(registry, (ModifiableMap)new StringMap((Map)this));
        }
        if ((object2 = workbench.readObject(filterSource, iOFlavor)) == null) {
            return null;
        }
        Object[] objectArray = new Object[]{object2, null};
        boolean bl5 = bl2 = object2 instanceof Manageable && ((Manageable)object2).getManageableType().isSerializable();
        if (!bl && bl2) {
            return objectArray;
        }
        if (filterSource instanceof FileSource) {
            int n;
            File file = ((FileSource)filterSource).getInputFile();
            if (bl3) {
                n = 0;
            } else {
                String[] stringArray;
                Window window = workbench.getWindow();
                String string = IO.toName((String)filterSource.getSystemId());
                if (bl2) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "add";
                    stringArray2[1] = "link";
                    stringArray = stringArray2;
                    stringArray2[2] = "embed";
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = "add";
                    stringArray = stringArray3;
                    stringArray3[1] = "link";
                }
                n = window.showChoiceDialog(string, UI.I18N, "addfiledialog", stringArray);
            }
            switch (n) {
                case 0: {
                    Object object3;
                    FileSystem fileSystem = registry.getFileSystem();
                    Object object4 = fileSystem.getRoot();
                    if (this.directory != null) {
                        try {
                            object4 = fileSystem.create(object4, this.directory, true);
                        }
                        catch (IOException iOException) {
                            workbench.logGUIInfo(IO.I18N.msg("mkdir.failed", (Object)this.directory), iOException);
                            return null;
                        }
                    }
                    try {
                        object3 = fileSystem.create(object4, file.getName(), false, true);
                        fileSystem.addLocalFile(file, object4, fileSystem.getName(object3));
                    }
                    catch (IOException iOException) {
                        workbench.logGUIInfo(IO.I18N.msg("addfile.failed", (Object)this.directory), iOException);
                        return null;
                    }
                    object = new FileObjectItem(IO.toSystemId((FileSystem)fileSystem, (Object)object3), filterSource.getFlavor().getMimeType(), object2, this.getTypeAsString());
                    break;
                }
                case 1: {
                    object = new FileObjectItem((FileSource)filterSource, object2, this.getTypeAsString());
                    break;
                }
                case 2: {
                    object = ObjectItem.createReference((RegistryContext)registry, (Object)object2, (String)IO.toSimpleName((String)filterSource.getSystemId()));
                    break;
                }
                default: {
                    return null;
                }
            }
        } else {
            object = ObjectItem.createReference((RegistryContext)registry, (Object)object2, (String)IO.toSimpleName((String)filterSource.getSystemId()));
        }
        objectArray[1] = object;
        return objectArray;
    }

    public Object evaluate(RegistryContext registryContext, StringMap stringMap) {
        Object[] objectArray;
        URL uRL = null;
        if (this.getBranch() != null && (objectArray = FileFactory.getArgs((Item)((Item)this.getBranch()), (RegistryContext)registryContext, (StringMap)stringMap, (Item)this)).length > 0 && objectArray[0] instanceof URL) {
            uRL = (URL)objectArray[0];
        }
        return this.addFromURL(registryContext.getRegistry(), uRL, (ModifiableMap)stringMap, ((Context)stringMap.get("context")).getWorkbench());
    }

    public Object addFromURL(Registry registry, URL uRL, ModifiableMap modifiableMap, Workbench workbench) {
        File file;
        MimeType mimeType;
        Object object = null;
        if (uRL != null) {
            try {
                mimeType = this.mimeType != null ? MimeType.valueOf((String)this.mimeType) : IO.getMimeType((String)uRL.toString());
                file = Utils.urlToFile((URL)uRL);
                object = file.exists() ? new FileSource(file, mimeType, registry, modifiableMap) : new InputStreamSourceImpl(uRL.openStream(), uRL.toString(), mimeType, registry, modifiableMap);
            }
            catch (IOException iOException) {
                workbench.logGUIInfo(IO.I18N.msg("openfile.failed", (Object)uRL.getFile()), iOException);
                return null;
            }
        }
        if ((mimeType = this.read(registry, (FilterSource)object, false, workbench)) == null) {
            return null;
        }
        file = (ObjectItem)mimeType[1];
        if (file != null) {
            file.setObjDescribes(true);
            ResourceDirectory resourceDirectory = ResourceDirectory.get((Item)this);
            resourceDirectory.getProjectDirectory((RegistryContext)registry).addUserItemWithUniqueName((Item)file, resourceDirectory.getBaseName());
        }
        return mimeType[0];
    }

    static {
        $TYPE.addManagedField((ManageableType.Field)directory$FIELD);
        mimeType$FIELD = new _Field("mimeType", 0x200000, (Type)ClassAdapter.wrap(String.class), null, 1);
        $TYPE.addManagedField((ManageableType.Field)mimeType$FIELD);
        $TYPE.validate();
    }

    private static final class _Field
    extends Node.NType.Field {
        private final int id;

        _Field(String string, int n, Type type, Type type2, int n2) {
            super($TYPE, string, n, type, type2);
            this.id = n2;
        }

        protected void setObjectImpl(Object object, Object object2) {
            switch (this.id) {
                case 0: {
                    ((FileFactory)object).directory = (String)object2;
                    return;
                }
                case 1: {
                    ((FileFactory)object).mimeType = (String)object2;
                    return;
                }
            }
            super.setObjectImpl(object, object2);
        }

        public Object getObject(Object object) {
            switch (this.id) {
                case 0: {
                    return ((FileFactory)object).directory;
                }
                case 1: {
                    return ((FileFactory)object).mimeType;
                }
            }
            return super.getObject(object);
        }
    }
}

