/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.ui;

import de.grogra.graph.impl.Node;
import de.grogra.icon.IconOverlay;
import de.grogra.icon.IconSource;
import de.grogra.icon.IconTheme;
import de.grogra.persistence.PersistenceField;
import de.grogra.pf.io.MimeTypeItem;
import de.grogra.pf.io.ProgressMonitor;
import de.grogra.pf.registry.Item;
import de.grogra.pf.registry.ObjectItem;
import de.grogra.pf.registry.Plugin;
import de.grogra.pf.registry.PluginClassLoader;
import de.grogra.pf.registry.Registry;
import de.grogra.pf.registry.RegistryContext;
import de.grogra.pf.registry.expr.Expression;
import de.grogra.pf.ui.Command;
import de.grogra.pf.ui.Context;
import de.grogra.pf.ui.JobManager;
import de.grogra.pf.ui.Panel;
import de.grogra.pf.ui.TextEditor;
import de.grogra.pf.ui.UIProperty;
import de.grogra.pf.ui.Workbench;
import de.grogra.pf.ui.event.InputEditEvent;
import de.grogra.pf.ui.registry.SourceFile;
import de.grogra.pf.ui.tree.ChoiceGroupBuilder;
import de.grogra.pf.ui.tree.HierarchyFlattener;
import de.grogra.pf.ui.tree.LinkResolver;
import de.grogra.pf.ui.tree.RegistryAdapter;
import de.grogra.pf.ui.tree.UINodeHandler;
import de.grogra.pf.ui.tree.UITree;
import de.grogra.pf.ui.tree.UITreePipeline;
import de.grogra.util.Described;
import de.grogra.util.I18NBundle;
import de.grogra.util.Lock;
import de.grogra.util.LockProtectedRunnable;
import de.grogra.util.Lockable;
import de.grogra.util.Map;
import de.grogra.util.ModifiableMap;
import de.grogra.util.ResourceConverter;
import de.grogra.util.StringMap;
import de.grogra.util.ThreadContext;
import de.grogra.util.Utils;
import de.grogra.xl.util.ObjectList;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.net.URL;
import java.util.EventObject;

public final class UI
extends Plugin
implements ResourceConverter {
    public static final I18NBundle I18N = I18NBundle.getInstance(UI.class);
    private static UI PLUGIN;

    public UI() {
        assert (PLUGIN == null);
        PLUGIN = this;
    }

    public static IconSource getIcon(String string) {
        return (IconSource)PLUGIN.convert("icon", string, null);
    }

    public void startup() {
        super.startup();
        I18NBundle.addResourceConverter((ResourceConverter)this);
    }

    public boolean canHandleConversion(String string) {
        return "icon".equals(string);
    }

    public Object convert(String string, String string2, I18NBundle i18NBundle) {
        if ("icon".equals(string)) {
            Item item = this.getRegistry().getItem("/ui/iconthemes");
            if (item != null) {
                for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
                    IconSource iconSource;
                    Object object;
                    if (!(item instanceof ObjectItem) || !((object = ((ObjectItem)item).getObject()) instanceof IconTheme) || (iconSource = ((IconTheme)object).getSource(string2)) == null) continue;
                    return iconSource;
                }
            }
            return null;
        }
        throw new IllegalArgumentException(string);
    }

    public static JobManager getJobManager(Context context) {
        return context.getWorkbench().getJobManager();
    }

    public static ThreadContext getThreadContext(Context context) {
        return context.getWorkbench().getJobManager().getThreadContext();
    }

    public static Node getRootOfProjectGraph(Context context) {
        return context.getWorkbench().getRegistry().getProjectGraph().getRoot();
    }

    public static Registry getRegistry(Context context) {
        return context.getWorkbench().getRegistry();
    }

    public static StringMap getArgs(Context context, Map map) {
        return new StringMap(map).putObject("registry", (Object)context.getWorkbench().getRegistry()).putObject("context", (Object)context);
    }

    public static UITree getUITreeForMenu(Context context, Item item, Map map) {
        if (item == null) {
            return null;
        }
        UITreePipeline uITreePipeline = new UITreePipeline();
        Item item2 = item.getItem((CharSequence)"src");
        if (item2 != null) {
            Item item3 = item.getItem((CharSequence)"xf");
            item = item2;
            if (item3 != null) {
                StringMap stringMap = UI.getArgs(context, map);
                for (item2 = (Item)item3.getBranch(); item2 != null; item2 = (Item)item2.getSuccessor()) {
                    if (!(item2 instanceof Expression)) continue;
                    stringMap.put("item", (Object)item2);
                    uITreePipeline.add((UITreePipeline.Transformer)((Expression)item2).evaluate((RegistryContext)context.getWorkbench(), stringMap));
                }
            }
        }
        uITreePipeline.add(new LinkResolver());
        uITreePipeline.add(new ChoiceGroupBuilder());
        uITreePipeline.add(new HierarchyFlattener());
        uITreePipeline.initialize(new RegistryAdapter(context), item, map);
        return uITreePipeline;
    }

    public static void setMenu(Panel panel, Item item, Map map) {
        UITree uITree = UI.getUITreeForMenu(panel, item, map);
        if (uITree != null) {
            panel.setMenu(uITree);
        }
    }

    public static boolean isAvailable(Item item, Context context) {
        return UI.isAvailable(item, context, ".available");
    }

    public static boolean isEnabled(Item item, Context context) {
        return UI.isAvailable(item, context, ".enabled");
    }

    private static boolean isAvailable(Item item, Context context, String string) {
        StringMap stringMap = null;
        for (item = (Item)item.getBranch(); item != null; item = (Item)item.getSuccessor()) {
            if (!(item instanceof Expression) || !item.getName().startsWith(string)) continue;
            if (stringMap == null) {
                stringMap = new StringMap((Map)item).putObject("context", (Object)context);
            }
            if (Expression.evaluateBoolean((Item)item, (RegistryContext)context.getWorkbench(), stringMap)) continue;
            return false;
        }
        return true;
    }

    public static boolean isConsumed(EventObject eventObject) {
        return eventObject instanceof InputEditEvent ? ((InputEditEvent)eventObject).isConsumed() : (eventObject instanceof InputEvent ? ((InputEvent)eventObject).isConsumed() : false);
    }

    public static void consume(Object object) {
        if (object instanceof InputEditEvent) {
            ((InputEditEvent)object).consume();
        } else if (object instanceof InputEvent) {
            ((InputEvent)object).consume();
        }
    }

    public static void dumpCommand(Item item, Object object, Context context) {
        System.err.println("Item: " + item);
        System.err.println("Info: " + object);
        System.err.println("Ctx : " + context);
    }

    public static ProgressMonitor createProgressAdapter(Context context) {
        final Workbench workbench = context.getWorkbench();
        if (workbench == null || !workbench.isWorkbenchThread()) {
            return null;
        }
        return new ProgressMonitor(){

            public void setProgress(String string, float f) {
                workbench.beginStatus(this);
                if (f == -1.0f) {
                    workbench.setIndeterminateProgress(this);
                } else if (f == 2.0f) {
                    workbench.clearProgress(this);
                } else {
                    workbench.setProgress((Object)this, f);
                }
                workbench.setStatus(this, string);
            }
        };
    }

    public static String getClassDescription(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return clazz.getClassLoader() instanceof PluginClassLoader ? ((PluginClassLoader)clazz.getClassLoader()).getPluginDescriptor().getI18NBundle().getString(clazz.getName(), string) : string;
    }

    public static Described nodeToDescribed(final UINodeHandler uINodeHandler, final Object object) {
        return new Described(){

            public Object getDescription(String string) {
                return uINodeHandler.getDescription(object, string);
            }
        };
    }

    public static Map configureViewerParams(Map map, URL uRL, String string, RegistryContext registryContext) {
        String string2;
        Map map2 = null;
        if (string != null && (string2 = UI.getIcon(null, string, null, registryContext, false)) != null) {
            if (map2 == null) {
                map2 = new StringMap(map);
            }
            map2.put(UIProperty.ICON.getName(), (Object)string2);
        }
        if (uRL != null) {
            string2 = uRL.getPath();
            string2 = string2.substring(string2.lastIndexOf(47) + 1);
            if (map2 == null) {
                map2 = new StringMap(map);
            }
            map2.put(UIProperty.PANEL_TITLE.getName(), (Object)string2);
        }
        return map2 != null ? map2 : map;
    }

    public static void executeHyperlinkURL(String string, Context context) {
        if (string == null || context == null) {
            return;
        }
        if (string.startsWith("command:")) {
            Item item;
            String string2;
            int n = string.indexOf(63);
            String string3 = string2 = n >= 0 ? string.substring("command:".length(), n) : string.substring("command:".length());
            if (!string2.startsWith("/")) {
                string2 = "/ui/commands/" + string2;
            }
            if ((item = Item.resolveItem((RegistryContext)context.getWorkbench(), (String)string2)) instanceof Command) {
                UI.getJobManager(context).execute((Command)item, n >= 0 ? string.substring(n + 1) : null, context, 10000);
            }
            return;
        }
        int n = string.indexOf(35);
        String string4 = n >= 0 ? string.substring(0, n) : string;
        SourceFile sourceFile = SourceFile.get(context.getWorkbench(), string4);
        if (sourceFile != null) {
            sourceFile.show(context, n >= 0 ? string.substring(n + 1) : null);
        }
    }

    public static Point[] parsePlainTextRange(String string) {
        Point[] pointArray;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(45);
        if (n < 0) {
            Point[] pointArray2;
            Point point = UI.parsePlainTextLocation(string);
            if (point == null) {
                pointArray2 = null;
            } else {
                Point[] pointArray3 = new Point[2];
                pointArray3[0] = point;
                pointArray2 = pointArray3;
                pointArray3[1] = null;
            }
            return pointArray2;
        }
        Point point = UI.parsePlainTextLocation(string.substring(0, n));
        Point point2 = UI.parsePlainTextLocation(string.substring(n + 1));
        if (point != null) {
            Point[] pointArray4 = new Point[2];
            pointArray4[0] = point;
            pointArray = pointArray4;
            pointArray4[1] = point2;
        } else if (point2 != null) {
            Point[] pointArray5 = new Point[2];
            pointArray5[0] = point2;
            pointArray = pointArray5;
            pointArray5[1] = null;
        } else {
            pointArray = null;
        }
        return pointArray;
    }

    public static Point parsePlainTextLocation(String string) {
        if (string == null) {
            return null;
        }
        try {
            int n = string.indexOf(58);
            if (n < 0) {
                n = Integer.parseInt(string.trim());
                return new Point(-1, n);
            }
            int n2 = Integer.parseInt(string.substring(0, n).trim());
            n = Integer.parseInt(string.substring(n + 1));
            return new Point(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static void putDocuments(TextEditor textEditor, ModifiableMap modifiableMap) {
        String[] stringArray = textEditor.getDocuments();
        if (stringArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(Utils.quote((CharSequence)stringArray[i]));
        }
        modifiableMap.put((Object)"documents", (Object)stringBuffer.toString());
    }

    public static String[] getDocuments(Map map) {
        String string = (String)map.get((Object)"documents", null);
        if (string == null) {
            return Utils.STRING_0;
        }
        ObjectList objectList = new ObjectList();
        int n = 0;
        int[] nArray = new int[1];
        while (n < string.length()) {
            objectList.add((Object)Utils.unquote((CharSequence)string, (int)n, (int)-1, (int[])nArray));
            n = nArray[0];
            if (n >= string.length() || string.charAt(n) != ',') continue;
            ++n;
        }
        return (String[])objectList.toArray((Object[])new String[objectList.size()]);
    }

    public static IconSource getIcon(String string, String string2, IconSource iconSource, RegistryContext registryContext, boolean bl) {
        MimeTypeItem mimeTypeItem;
        if (iconSource == null && (mimeTypeItem = MimeTypeItem.get((RegistryContext)registryContext, (String)string2)) != null) {
            iconSource = (IconSource)mimeTypeItem.getDescription("Icon");
        }
        if (iconSource == null) {
            if (bl) {
                iconSource = (IconSource)I18N.getObject("registry.file.Icon");
            } else {
                return null;
            }
        }
        if (string != null && !string.startsWith("pfs:") && (mimeTypeItem = (IconSource)I18N.getObject("registry.link.Icon")) != null) {
            return new IconOverlay(iconSource, (IconSource)mimeTypeItem);
        }
        return iconSource;
    }

    public static ModifiableMap getOptions(Context context) {
        final Item item = Item.resolveItem((RegistryContext)context.getWorkbench(), (String)"/ui/options");
        return new ModifiableMap(){

            public Object get(Object object, Object object2) {
                return item != null ? item.get(object, object2) : object2;
            }

            public Object put(Object object, Object object2) {
                if (item != null) {
                    Object object3 = item.get(object, null);
                    item.setOption((String)object, object2);
                    return object3;
                }
                return null;
            }
        };
    }

    public static void executeLockedly(final Lockable lockable, final boolean bl, final Command command, final Object object, final Context context, final int n, final boolean bl2) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Task
        implements LockProtectedRunnable,
        Command {
            private boolean executed;
            private Object monitor;
            private Lock retainedLock;

            Task() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(boolean bl3, Lock lock) {
                JobManager jobManager = UI.getJobManager(context);
                if (jobManager.getThreadContext().isCurrent()) {
                    this.executed = true;
                    command.run(bl2 ? lock : object, context);
                } else if (this.monitor == null) {
                    jobManager.runLater(this, null, context, n);
                } else {
                    lock.retain();
                    this.retainedLock = lock;
                    Object object2 = this.monitor;
                    synchronized (object2) {
                        this.monitor.notifyAll();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(Object object3, Context context2) {
                Object object2 = this.monitor = new Object();
                synchronized (object2) {
                    lockable.execute((LockProtectedRunnable)this, bl);
                    if (this.executed) {
                        return;
                    }
                    while (this.retainedLock == null) {
                        try {
                            this.monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                Utils.executeForcedlyAndUninterruptibly((Lockable)lockable, (LockProtectedRunnable)this, (Lock)this.retainedLock);
            }

            @Override
            public String getCommandName() {
                return command.getCommandName();
            }
        }
        lockable.execute((LockProtectedRunnable)new Task(), bl);
    }

    public static void executeLockedly(Lockable lockable, boolean bl, Command command, Object object, Context context, int n) {
        UI.executeLockedly(lockable, bl, command, object, context, n, false);
    }

    public static void setField(final Node node, final PersistenceField persistenceField, Object object, Context context) {
        UI.executeLockedly((Lockable)node.getGraph(), true, new Command(){

            public String getCommandName() {
                return null;
            }

            public void run(Object object, Context context) {
                persistenceField.set((Object)node, null, object, node.getGraph().getActiveTransaction());
            }
        }, object, context, 10000);
    }
}

