/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Dataset;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.WriterSource;
import de.grogra.util.MimeType;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class PlainTextWriter
extends FilterBase
implements WriterSource {
    public static final IOFlavor FLAVOR = new IOFlavor(MimeType.TEXT_PLAIN, 8, null);

    public PlainTextWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public void write(Writer writer) throws IOException {
        int n;
        Dataset dataset = (Dataset)((ObjectSource)this.source).getObject();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println(dataset.getTitle());
        printWriter.println("Created by GroIMP");
        int n2 = dataset.getColumnCount();
        int n3 = dataset.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (n == n2 - 1) {
                printWriter.println(dataset.getColumnKey(n));
                continue;
            }
            printWriter.print(dataset.getColumnKey(n) + "\t");
        }
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < n2; ++i) {
                if (i == n2 - 1) {
                    printWriter.println(dataset.getCell(n, i).getX());
                    continue;
                }
                printWriter.print(dataset.getCell(n, i).getX() + "\t");
            }
        }
    }
}

