/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.pf.data;

import de.grogra.pf.data.Dataset;
import de.grogra.pf.io.FilterBase;
import de.grogra.pf.io.FilterItem;
import de.grogra.pf.io.FilterSource;
import de.grogra.pf.io.IOFlavor;
import de.grogra.pf.io.ObjectSource;
import de.grogra.pf.io.WriterSource;
import de.grogra.util.MimeType;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class HTMLWriter
extends FilterBase
implements WriterSource {
    public static final IOFlavor FLAVOR = new IOFlavor(MimeType.TEXT_HTML, 8, null);

    public HTMLWriter(FilterItem filterItem, FilterSource filterSource) {
        super(filterItem, filterSource);
        this.setFlavor(FLAVOR);
    }

    public void write(Writer writer) throws IOException {
        int n;
        Dataset dataset = (Dataset)((ObjectSource)this.source).getObject();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        printWriter.println("<html>");
        printWriter.println("<head>");
        printWriter.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">");
        printWriter.println("<title>" + dataset.getTitle() + "</title>");
        printWriter.println("<style type=\"text/css\">");
        printWriter.println("<!--");
        printWriter.println(".Stil1 {font-family: Arial, Helvetica, sans-serif}");
        printWriter.println(".Stil2 {font-family: Arial, Helvetica, sans-serif; font-size: 24px; }");
        printWriter.println("-->");
        printWriter.println("</style>");
        printWriter.println("</head>");
        printWriter.println("<body>");
        printWriter.println("<p class=\"Stil2\">" + dataset.getTitle() + "</p>");
        printWriter.println("<p class=\"Stil1\">Created  by GroIMP</p>");
        int n2 = dataset.getColumnCount();
        int n3 = dataset.getRowCount();
        printWriter.println("<table width=\"" + 200 * n2 + "\" border=\"1\">");
        printWriter.println("<tr>");
        for (n = 0; n < n2; ++n) {
            printWriter.println("<td bgcolor=\"#99FF00\" class=\"Stil1\"><div align=\"center\">" + dataset.getColumnKey(n) + "</div></td>");
        }
        printWriter.println("</tr>");
        for (n = 0; n < n3; ++n) {
            printWriter.println("<tr>");
            for (int i = 0; i < n2; ++i) {
                printWriter.println("<td class=\"Stil1\"><div align=\"right\">" + dataset.getCell(n, i).getX() + "</div></td>");
            }
            printWriter.println("</tr>");
        }
        printWriter.println("</table>");
        printWriter.println("</body>");
        printWriter.println("</html>");
    }
}

