/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.query;

import de.grogra.xl.lang.BooleanConsumer;
import de.grogra.xl.lang.ByteConsumer;
import de.grogra.xl.lang.CharConsumer;
import de.grogra.xl.lang.DoubleConsumer;
import de.grogra.xl.lang.FloatConsumer;
import de.grogra.xl.lang.IntConsumer;
import de.grogra.xl.lang.LongConsumer;
import de.grogra.xl.lang.ObjectConsumer;
import de.grogra.xl.lang.ShortConsumer;
import de.grogra.xl.lang.VoidConsumer;
import de.grogra.xl.query.BytecodeSerialization;
import de.grogra.xl.query.CompoundPattern;
import de.grogra.xl.query.Frame;
import de.grogra.xl.query.Graph;
import de.grogra.xl.query.Pattern;
import de.grogra.xl.query.QueryState;
import de.grogra.xl.query.RuntimeModel;
import de.grogra.xl.query.Utils;
import de.grogra.xl.query.Variable;
import de.grogra.xl.util.IntList;
import de.grogra.xl.util.XBitSet;
import java.io.IOException;

public final class Query
implements BytecodeSerialization.Serializable {
    private final CompoundPattern predicate;
    private final boolean forProduction;
    private final Variable queryState;
    private final Variable[] variables;
    private transient Pattern.Matcher matcher;

    public Query(CompoundPattern compoundPattern, boolean bl, Variable variable, Variable[] variableArray) {
        this.predicate = compoundPattern;
        this.forProduction = bl;
        this.queryState = variable;
        this.variables = variableArray;
    }

    public void write(BytecodeSerialization bytecodeSerialization) throws IOException {
        bytecodeSerialization.beginMethod(Utils.getConstructor(this));
        this.predicate.write(bytecodeSerialization);
        bytecodeSerialization.visitBoolean(this.forProduction);
        bytecodeSerialization.visitObject(this.queryState);
        Utils.writeArray(bytecodeSerialization, this.variables);
        bytecodeSerialization.endMethod();
    }

    private synchronized Pattern.Matcher getMatcher(Graph graph) {
        if (this.matcher == null) {
            this.matcher = graph.createMatcher(this.predicate, new XBitSet(), new IntList());
            if (this.matcher == null) {
                throw new RuntimeException("No predicate matcher computable");
            }
        }
        return this.matcher;
    }

    private void findMatches(Object object, Frame frame, QueryState queryState) {
        this.queryState.aset(frame, queryState);
        queryState.findMatches(this.predicate, this.getMatcher(queryState.getGraph()), frame, this.variables, object, this.forProduction);
    }

    public static Graph currentGraph(RuntimeModel runtimeModel) {
        Graph graph = runtimeModel.currentGraph();
        if (graph == null) {
            throw new RuntimeException("No current extent for " + runtimeModel);
        }
        return graph;
    }

    public void findBooleanMatches(BooleanConsumer booleanConsumer, Frame frame, QueryState queryState) {
        this.findMatches(booleanConsumer, frame, queryState);
    }

    public void findByteMatches(ByteConsumer byteConsumer, Frame frame, QueryState queryState) {
        this.findMatches(byteConsumer, frame, queryState);
    }

    public void findShortMatches(ShortConsumer shortConsumer, Frame frame, QueryState queryState) {
        this.findMatches(shortConsumer, frame, queryState);
    }

    public void findCharMatches(CharConsumer charConsumer, Frame frame, QueryState queryState) {
        this.findMatches(charConsumer, frame, queryState);
    }

    public void findIntMatches(IntConsumer intConsumer, Frame frame, QueryState queryState) {
        this.findMatches(intConsumer, frame, queryState);
    }

    public void findLongMatches(LongConsumer longConsumer, Frame frame, QueryState queryState) {
        this.findMatches(longConsumer, frame, queryState);
    }

    public void findFloatMatches(FloatConsumer floatConsumer, Frame frame, QueryState queryState) {
        this.findMatches(floatConsumer, frame, queryState);
    }

    public void findDoubleMatches(DoubleConsumer doubleConsumer, Frame frame, QueryState queryState) {
        this.findMatches(doubleConsumer, frame, queryState);
    }

    public void findObjectMatches(ObjectConsumer objectConsumer, Frame frame, QueryState queryState) {
        this.findMatches(objectConsumer, frame, queryState);
    }

    public void findVoidMatches(VoidConsumer voidConsumer, Frame frame, QueryState queryState) {
        this.findMatches(voidConsumer, frame, queryState);
    }
}

