/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.xl.query;

public class EdgeDirection {
    public static final int FORWARD_INT = 0;
    public static final int BACKWARD_INT = 1;
    public static final int UNDIRECTED_INT = 2;
    public static final int BOTH_INT = 3;
    public static final Forward FORWARD = new Forward();
    public static final Backward BACKWARD = new Backward();
    public static final Undirected UNDIRECTED = new Undirected();
    public static final Both BOTH = new Both();
    private final int value;

    private EdgeDirection(int n) {
        this.value = n;
    }

    public int getCode() {
        return this.value;
    }

    public boolean contains(EdgeDirection edgeDirection) {
        return this.value == edgeDirection.value || edgeDirection.value == 3 || this.value == 2;
    }

    public String toString() {
        switch (this.value) {
            case 0: {
                return "FORWARD";
            }
            case 1: {
                return "BACKWARD";
            }
            case 2: {
                return "UNDIRECTED";
            }
            case 3: {
                return "BOTH";
            }
        }
        throw new AssertionError();
    }

    public static final class Backward
    extends Directed {
        private Backward() {
            super(1);
        }
    }

    public static final class Forward
    extends Directed {
        private Forward() {
            super(0);
        }
    }

    public static abstract class Directed
    extends EdgeDirection {
        private Directed(int n) {
            super(n);
        }
    }

    public static final class Both
    extends EdgeDirection {
        private Both() {
            super(3);
        }
    }

    public static final class Undirected
    extends EdgeDirection {
        private Undirected() {
            super(2);
        }
    }
}

