/*
 * Decompiled with CFR 0.152.
 */
package de.grogra.ext.povray;

import de.grogra.ext.povray.POVAttribute;
import de.grogra.ext.povray.POVExport;
import de.grogra.ext.povray.POVNode;
import de.grogra.ext.povray.POVWriter;
import de.grogra.imp3d.objects.SceneTree;
import de.grogra.imp3d.objects.SceneTreeWithShader;
import de.grogra.imp3d.shading.AffineUVTransformation;
import de.grogra.imp3d.shading.BumpMap;
import de.grogra.imp3d.shading.ChannelBlend;
import de.grogra.imp3d.shading.ChannelMapNode;
import de.grogra.imp3d.shading.Gradient;
import de.grogra.imp3d.shading.Granite;
import de.grogra.imp3d.shading.ImageMap;
import de.grogra.imp3d.shading.Leopard;
import de.grogra.imp3d.shading.Phong;
import de.grogra.imp3d.shading.Shader;
import de.grogra.imp3d.shading.SurfaceMap;
import de.grogra.imp3d.shading.Turbulence;
import de.grogra.imp3d.shading.VolumeFunction;
import de.grogra.imp3d.shading.VolumeTurbulence;
import de.grogra.imp3d.shading.Wood;
import de.grogra.imp3d.shading.XYZTransformation;
import de.grogra.math.ChannelMap;
import de.grogra.math.ColorMap;
import de.grogra.math.Cubic;
import de.grogra.math.Graytone;
import de.grogra.math.Scallop;
import de.grogra.math.Sin01;
import de.grogra.math.Transform3D;
import de.grogra.math.Triangle;
import de.grogra.pf.ui.registry.FileObjectItem;
import de.grogra.vecmath.Math2;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3f;

public class POVPhong
extends POVAttribute {
    public POVPhong() {
        super("texture");
    }

    public void export(Shader shader, ChannelMap channelMap, SceneTreeWithShader.Leaf leaf, String string, POVNode pOVNode, POVExport pOVExport) throws IOException {
        pOVExport.phongNode = pOVNode;
        pOVExport.phongMapping = channelMap;
        this.export(shader, leaf, null, string, pOVExport);
    }

    static boolean usesUVMapping(Phong phong) {
        return phong.getDiffuse() instanceof SurfaceMap || phong.getInput() instanceof BumpMap && ((BumpMap)phong.getInput()).getDisplacement() instanceof SurfaceMap;
    }

    static boolean exportChannelMap(ChannelMap channelMap, POVExport pOVExport, String string, String string2, int n, String string3) throws IOException {
        POVWriter pOVWriter = pOVExport.out;
        if (channelMap instanceof SurfaceMap) {
            Object object;
            BufferedImage bufferedImage;
            boolean bl;
            AffineUVTransformation affineUVTransformation;
            SurfaceMap surfaceMap = (SurfaceMap)channelMap;
            pOVWriter.print(string);
            pOVWriter.write(123);
            pOVWriter.println();
            pOVWriter.indent();
            pOVWriter.print(string2);
            pOVWriter.write(123);
            ChannelMap channelMap2 = surfaceMap.getInput();
            if (channelMap2 instanceof AffineUVTransformation) {
                affineUVTransformation = (AffineUVTransformation)channelMap2;
                if (affineUVTransformation.getInput() != null) {
                    affineUVTransformation = null;
                    bl = true;
                } else {
                    bl = false;
                }
            } else if (channelMap2 != null) {
                bl = true;
                affineUVTransformation = null;
            } else {
                bl = false;
                affineUVTransformation = null;
            }
            String string4 = null;
            String string5 = null;
            boolean bl2 = true;
            if (bl) {
                bufferedImage = new BufferedImage(256, 256, 2);
                surfaceMap.drawImage(bufferedImage, 1, true);
            } else if (surfaceMap instanceof ImageMap) {
                object = ((ImageMap)surfaceMap).getImageAdapter();
                bl2 = ((ImageMap)surfaceMap).hasBilinearFiltering();
                bufferedImage = object.getBufferedImage();
                if (object.getProvider() instanceof FileObjectItem) {
                    FileObjectItem fileObjectItem = (FileObjectItem)object.getProvider();
                    String string6 = fileObjectItem.getMimeType().getMediaType();
                    if (string6.equals("image/png") || string6.equals("image/x-png")) {
                        string4 = "png";
                    } else if (string6.equals("image/jpeg")) {
                        string4 = "jpeg";
                    } else if (string6.equals("image/tiff")) {
                        string4 = "tiff";
                    } else if (string6.equals("image/gif")) {
                        string4 = "gif";
                    }
                    if (string4 != null) {
                        string5 = pOVExport.getPath(fileObjectItem);
                        bufferedImage = null;
                    }
                }
            } else {
                bufferedImage = new BufferedImage(256, 256, 2);
                surfaceMap.drawImage(bufferedImage, 1, false);
            }
            if (bufferedImage != null) {
                object = (File)pOVExport.getFile("surfacemap.png");
                string4 = "png";
                string5 = pOVExport.getPath(object);
                ImageIO.write((RenderedImage)bufferedImage, "png", (File)object);
            }
            pOVWriter.write(string4);
            pOVWriter.write(" \"");
            pOVWriter.write(string5);
            pOVWriter.write("\" ");
            if (bl2) {
                pOVWriter.write("interpolate 2 ");
            }
            if (n > 0) {
                pOVWriter.write("map_type ");
                pOVWriter.print(n);
            }
            pOVWriter.write(125);
            pOVWriter.write(string3);
            pOVWriter.println();
            if (affineUVTransformation != null) {
                if (n == 2) {
                    pOVWriter.print("scale ");
                    float f = 1.0f / affineUVTransformation.getScaleU();
                    pOVWriter.print(f, 1.0f / affineUVTransformation.getScaleV(), f);
                    pOVWriter.println();
                } else {
                    pOVWriter.print(affineUVTransformation);
                }
            }
            pOVWriter.unindent();
            pOVWriter.print('}');
            pOVWriter.println();
            return true;
        }
        if (channelMap instanceof ChannelBlend) {
            pOVWriter.print(string);
            pOVWriter.write(123);
            pOVWriter.println();
            pOVWriter.indent();
            POVPhong.export((ChannelBlend)channelMap, pOVExport);
            pOVWriter.unindent();
            pOVWriter.print('}');
            pOVWriter.println();
            return true;
        }
        return false;
    }

    protected void exportImpl(Object object, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
        int n;
        POVWriter pOVWriter = pOVExport.out;
        Phong phong = (Phong)object;
        ChannelMap channelMap = phong.getDiffuse();
        if (channelMap == null) {
            channelMap = Phong.DEFAULT_DIFFUSE;
        }
        if (!POVPhong.exportChannelMap(channelMap, pOVExport, "pigment", "image_map", 0, "")) {
            pOVWriter.print("pigment{color rgb");
            n = channelMap instanceof ColorMap ? ((ColorMap)channelMap).getAverageColor() : -8355712;
            channelMap = phong.getTransparency();
            if (channelMap instanceof ColorMap) {
                pOVWriter.print(phong.isInterpolatedTransparency() ? "t<" : "f<");
                pOVWriter.printRGBValues(n);
                pOVWriter.print(',');
                int n2 = ((ColorMap)channelMap).getAverageColor();
                pOVWriter.print((float)((n2 & 0xFF) + (n2 >> 8 & 0xFF) + (n2 >> 16 & 0xFF)) * 0.0013071896f);
                pOVWriter.print('>');
            } else {
                pOVWriter.printRGB(n);
            }
            pOVWriter.print("}");
            pOVWriter.println();
        }
        if ((channelMap = phong.getInput()) instanceof BumpMap) {
            POVPhong.exportChannelMap(((BumpMap)channelMap).getDisplacement(), pOVExport, "normal", "bump_map", 0, " bump_size " + 2.0f * ((BumpMap)channelMap).getStrength());
        }
        pOVWriter.print("finish{diffuse 1");
        channelMap = phong.getSpecular();
        if (channelMap == null) {
            channelMap = Phong.DEFAULT_SPECULAR;
        }
        if (channelMap instanceof ColorMap) {
            n = ((ColorMap)channelMap).getAverageColor();
            pOVWriter.write(" phong ");
            pOVWriter.print((float)((n >> 16 & 0xFF) + (n >> 8 & 0xFF) + (n & 0xFF)) / 765.0f);
            pOVWriter.write(" phong_size ");
            channelMap = phong.getShininess();
            pOVWriter.print(channelMap instanceof Graytone ? Phong.convertShininess((float)((Graytone)channelMap).getValue()) : 10.0f);
        }
        pOVWriter.write(125);
        pOVWriter.println();
    }

    protected void exportHeader(Object object, SceneTreeWithShader.Leaf leaf, POVExport pOVExport) throws IOException {
        if (pOVExport.phongNode != null) {
            pOVExport.phongNode.exportTextureHeader((Phong)object, leaf, pOVExport);
        }
    }

    protected void exportFooter(Object object, SceneTreeWithShader.Leaf leaf, SceneTree.InnerNode innerNode, POVExport pOVExport) throws IOException {
        if (pOVExport.phongNode != null) {
            pOVExport.phongNode.exportTextureFooter((Phong)object, pOVExport.phongMapping, leaf, pOVExport);
            pOVExport.phongNode = null;
            pOVExport.phongMapping = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void export(ChannelBlend var0, POVExport var1_1) throws IOException {
        block16: {
            block15: {
                block14: {
                    block13: {
                        var2_2 = var1_1.out;
                        var3_3 = var0.getInput();
                        var4_4 = false;
                        if (!(var3_3 instanceof Gradient)) break block13;
                        var5_6 = var1_1.pool.v3f0;
                        var5_6.set((Tuple3f)((Gradient)var3_3).getDirection());
                        var6_7 = 1.0f / var5_6.length();
                        var5_6.scale(var6_7);
                        var2_2.print("gradient ");
                        var2_2.print((Tuple3f)var5_6);
                        var2_2.print(" scale ");
                        var2_2.print(var6_7);
                        ** GOTO lbl33
                    }
                    if (!(var3_3 instanceof Granite)) break block14;
                    var2_2.print("granite");
                    ** GOTO lbl33
                }
                if (!(var3_3 instanceof VolumeTurbulence)) break block15;
                var2_2.print("bumps");
                ** GOTO lbl33
            }
            if (!(var3_3 instanceof Leopard)) break block16;
            var2_2.print("leopard");
            var4_4 = true;
            ** GOTO lbl33
        }
        if (!(var3_3 instanceof Wood)) {
            var2_2.print("gradient x");
        } else {
            var2_2.print("wood");
            var4_4 = true;
lbl33:
            // 5 sources

            if (var4_4) {
                var5_6 = (VolumeFunction)var3_3;
                var2_2.print(" frequency ");
                var2_2.print(var5_6.getFrequency());
                var2_2.print(" phase ");
                var2_2.print(var5_6.getPhase());
                var6_8 = var5_6.getWaveForm();
                if (var6_8 instanceof Triangle) {
                    var2_2.print(" triangle_wave");
                } else if (var6_8 instanceof Sin01) {
                    var2_2.print(" sine_wave");
                } else if (var6_8 instanceof Scallop) {
                    var2_2.print(" scallop_wave");
                } else if (var6_8 instanceof Cubic) {
                    var2_2.print(" cubic_wave");
                } else {
                    var2_2.print(" ramp_wave");
                }
            }
        }
        var2_2.println();
        POVPhong.exportTransformations((ChannelMapNode)var0, var1_1);
        if (var4_5 != null) {
            var2_2.print("pigment_map{");
            var2_2.indent();
            var2_2.println();
            for (var4_5 = var0.getBlend(); var4_5 != null; var4_5 = var4_5.getNext()) {
                var2_2.print('[');
                var2_2.print((var4_5.getValue() + 1.0f) / 2.0f);
                var2_2.print(' ');
                POVPhong.exportPigment(var4_5.getInput(), var1_1);
                var2_2.print(']');
                var2_2.println();
            }
            var2_2.unindent();
            var2_2.print('}');
            var2_2.println();
        }
    }

    static void exportPigment(ChannelMap channelMap, POVExport pOVExport) throws IOException {
        if (channelMap instanceof ChannelBlend) {
            POVPhong.export((ChannelBlend)channelMap, pOVExport);
            POVPhong.exportTransformations((ChannelMapNode)((ChannelBlend)channelMap), pOVExport);
        } else if (channelMap instanceof ColorMap) {
            pOVExport.out.print("color rgbt");
            pOVExport.out.printRGBT(((ColorMap)channelMap).getAverageColor());
        } else {
            pOVExport.out.print("color rgb<1,1,1>");
        }
    }

    static void exportTransformations(ChannelMapNode channelMapNode, POVExport pOVExport) throws IOException {
        ChannelMap channelMap = channelMapNode.getInput();
        POVWriter pOVWriter = pOVExport.out;
        while (channelMap instanceof ChannelMapNode) {
            Transform3D transform3D;
            if (channelMap instanceof XYZTransformation) {
                transform3D = ((XYZTransformation)channelMap).getTransform();
                if (transform3D != null) {
                    Matrix4d matrix4d = pOVExport.pool.m4d0;
                    matrix4d.setIdentity();
                    transform3D.transform(matrix4d, matrix4d);
                    Math2.invertAffine((Matrix4d)matrix4d, (Matrix4d)matrix4d);
                    pOVWriter.print(matrix4d);
                    pOVWriter.println();
                }
            } else if (channelMap instanceof Turbulence) {
                transform3D = (Turbulence)channelMap;
                pOVWriter.print("warp{turbulence ");
                pOVWriter.print((Tuple3f)transform3D.getAmount());
                pOVWriter.print(" octaves ");
                pOVWriter.print(transform3D.getOctaves());
                pOVWriter.print(" omega ");
                pOVWriter.print(1.0f / transform3D.getFrequencyRatio());
                pOVWriter.print(" lambda ");
                pOVWriter.print(transform3D.getNoiseRatio());
                pOVWriter.print('}');
                pOVWriter.println();
            }
            channelMap = ((ChannelMapNode)channelMap).getInput();
        }
    }
}

