/*
 * Decompiled with CFR 0.152.
 */
package org.jagatoo.loaders.models.obj;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.jagatoo.loaders.models.obj.OBJFaceList;
import org.jagatoo.loaders.models.obj.OBJGroup;
import org.jagatoo.loaders.models.obj.OBJMaterial;
import org.jagatoo.loaders.models.obj.OBJModelPrototype;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OBJPrototypeLoader {
    protected static Boolean debug = false;

    private static float[] parseVector(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        float[] fArray = new float[]{Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken())};
        return fArray;
    }

    private static float[] parseTexCoord(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        stringTokenizer.nextToken();
        float[] fArray = new float[]{Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken())};
        return fArray;
    }

    private static float[] parseColor(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        float[] fArray = new float[]{Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken())};
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<OBJMaterial> parseMatLib(URL uRL, String string) throws IOException {
        ArrayList<OBJMaterial> arrayList = new ArrayList<OBJMaterial>(1);
        OBJMaterial oBJMaterial = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new URL(uRL, string).openStream()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    System.out.println("Base URL = " + uRL);
                    System.out.println("Resource name = " + string);
                    bufferedReader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                Object object;
                int n;
                for (n = 0; n < string2.length() && Character.isWhitespace(string2.charAt(n)); ++n) {
                }
                if ((string2 = string2.substring(n)).startsWith("#") || string2.trim().length() == 0) continue;
                if (string2.startsWith("newmtl")) {
                    object = string2.substring(string2.indexOf(" ") + 1);
                    oBJMaterial = new OBJMaterial((String)object);
                    arrayList.add(oBJMaterial);
                    continue;
                }
                if (string2.startsWith("Tf")) {
                    object = OBJPrototypeLoader.parseColor(string2.substring(string2.indexOf(" ") + 1));
                    oBJMaterial.setDiffuseColor((float[])object);
                    oBJMaterial.setAmbientColor((float[])object);
                    continue;
                }
                if (string2.startsWith("Ka")) {
                    object = OBJPrototypeLoader.parseColor(string2.substring(string2.indexOf(" ") + 1));
                    oBJMaterial.setAmbientColor((float[])object);
                    continue;
                }
                if (string2.startsWith("Kd")) {
                    object = OBJPrototypeLoader.parseColor(string2.substring(string2.indexOf(" ") + 1));
                    oBJMaterial.setColor((float[])object);
                    oBJMaterial.setDiffuseColor((float[])object);
                    continue;
                }
                if (string2.startsWith("Ks")) {
                    object = OBJPrototypeLoader.parseColor(string2.substring(string2.indexOf(" ") + 1));
                    oBJMaterial.setSpecularColor((float[])object);
                    continue;
                }
                if (string2.startsWith("Ns")) {
                    oBJMaterial.setShininess(Float.parseFloat(string2.substring(string2.indexOf(" ") + 1)));
                    continue;
                }
                if (string2.startsWith("map_Kd")) {
                    object = string2.substring(string2.indexOf(" ") + 1);
                    oBJMaterial.setTextureName((String)object);
                    continue;
                }
                if (debug == null || !debug.booleanValue()) continue;
                System.err.println(OBJPrototypeLoader.class.getName() + ":  ignoring unknown material tag:  \"" + string2 + "\"");
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OBJModelPrototype load(InputStream inputStream, URL uRL, float[] fArray) throws IOException {
        if (fArray != null && fArray.length != 3) {
            throw new IllegalArgumentException("geomOffset must be either null or length 3.");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        HashMap<String, OBJMaterial> hashMap = new HashMap<String, OBJMaterial>();
        ArrayList<float[]> arrayList = new ArrayList<float[]>();
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>();
        ArrayList<float[]> arrayList3 = new ArrayList<float[]>();
        OBJGroup oBJGroup = OBJGroup.createTopGroup(arrayList, arrayList2, arrayList3);
        try {
            OBJMaterial oBJMaterial = null;
            Object object = oBJGroup;
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                Object object2;
                Object object3;
                if (string.startsWith("#") || string.length() == 0) continue;
                if (string.startsWith("vn")) {
                    arrayList2.add(OBJPrototypeLoader.parseVector(string));
                    continue;
                }
                if (string.startsWith("vt")) {
                    arrayList3.add(OBJPrototypeLoader.parseTexCoord(string));
                    continue;
                }
                if (string.startsWith("v")) {
                    object3 = OBJPrototypeLoader.parseVector(string);
                    if (fArray != null) {
                        object3[0] = object3[0] + fArray[0];
                        object3[1] = object3[1] + fArray[1];
                        Object object4 = object3;
                        object4[2] = object4[2] + fArray[2];
                    }
                    arrayList.add((float[])object3);
                    continue;
                }
                if (string.startsWith("f")) {
                    ((OBJFaceList)object).add(string, oBJMaterial);
                    continue;
                }
                if (string.startsWith("g")) {
                    object3 = string.trim().length() >= 3 ? string.substring(2) : null;
                    object2 = new OBJGroup((String)object3, arrayList, arrayList2, arrayList3);
                    oBJGroup.addChild((OBJGroup)object2);
                    object = object2;
                    continue;
                }
                if (string.startsWith("o")) {
                    object3 = string.trim().length() >= 3 ? string.substring(2) : null;
                    object2 = new OBJGroup((String)object3, arrayList, arrayList2, arrayList3);
                    oBJGroup.addChild((OBJGroup)object2);
                    object = object2;
                    continue;
                }
                if (string.startsWith("mtllib")) {
                    object3 = new StringTokenizer(string);
                    ((StringTokenizer)object3).nextToken();
                    object2 = ((StringTokenizer)object3).nextToken();
                    continue;
                }
                if (string.startsWith("usemtl")) {
                    object3 = string.substring(string.indexOf(" ") + 1);
                    oBJMaterial = (OBJMaterial)hashMap.get(object3);
                    continue;
                }
                if (string.startsWith("s")) {
                    if (debug == null || !debug.booleanValue()) continue;
                    System.err.println(OBJPrototypeLoader.class.getName() + ":  smoothing groups not currently supported:  \"" + string + "\"");
                    continue;
                }
                if (debug == null || !debug.booleanValue()) continue;
                System.err.println(OBJPrototypeLoader.class.getName() + ":  ignoring unknown OBJ tag:  \"" + string + "\"");
            }
        }
        finally {
            bufferedReader.close();
        }
        return new OBJModelPrototype(hashMap, oBJGroup);
    }

    public static OBJModelPrototype load(InputStream inputStream, URL uRL) throws IOException {
        return OBJPrototypeLoader.load(inputStream, uRL, null);
    }

    private OBJPrototypeLoader() {
    }
}

